// content/common/render_message_filter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/render_message_filter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/render_message_filter.mojom-params-data.h"
#include "content/common/render_message_filter.mojom-shared-message-ids.h"

#include "content/common/render_message_filter.mojom-import-headers.h"


#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char RenderMessageFilter::Name_[] = "content.mojom.RenderMessageFilter";
bool RenderMessageFilter::GenerateRoutingID(int32_t* out_routing_id) {
  NOTREACHED();
  return false;
}
bool RenderMessageFilter::GenerateFrameRoutingID(int32_t* out_routing_id, ::blink::LocalFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  NOTREACHED();
  return false;
}
bool RenderMessageFilter::HasGpuProcess(bool* out_has_gpu_process) {
  NOTREACHED();
  return false;
}
class RenderMessageFilter_GenerateRoutingID_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderMessageFilter_GenerateRoutingID_HandleSyncResponse(
      bool* result, int32_t* out_routing_id)
      : result_(result), out_routing_id_(out_routing_id) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_routing_id_;DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_GenerateRoutingID_HandleSyncResponse);
};

class RenderMessageFilter_GenerateRoutingID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderMessageFilter_GenerateRoutingID_ForwardToCallback(
      RenderMessageFilter::GenerateRoutingIDCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RenderMessageFilter::GenerateRoutingIDCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_GenerateRoutingID_ForwardToCallback);
};
class RenderMessageFilter_GenerateFrameRoutingID_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderMessageFilter_GenerateFrameRoutingID_HandleSyncResponse(
      bool* result, int32_t* out_routing_id, ::blink::LocalFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token)
      : result_(result), out_routing_id_(out_routing_id), out_frame_token_(out_frame_token), out_devtools_frame_token_(out_devtools_frame_token) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_routing_id_;
  ::blink::LocalFrameToken* out_frame_token_;
  ::base::UnguessableToken* out_devtools_frame_token_;DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_GenerateFrameRoutingID_HandleSyncResponse);
};

class RenderMessageFilter_GenerateFrameRoutingID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderMessageFilter_GenerateFrameRoutingID_ForwardToCallback(
      RenderMessageFilter::GenerateFrameRoutingIDCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RenderMessageFilter::GenerateFrameRoutingIDCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_GenerateFrameRoutingID_ForwardToCallback);
};
class RenderMessageFilter_HasGpuProcess_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RenderMessageFilter_HasGpuProcess_HandleSyncResponse(
      bool* result, bool* out_has_gpu_process)
      : result_(result), out_has_gpu_process_(out_has_gpu_process) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_has_gpu_process_;DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_HasGpuProcess_HandleSyncResponse);
};

class RenderMessageFilter_HasGpuProcess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderMessageFilter_HasGpuProcess_ForwardToCallback(
      RenderMessageFilter::HasGpuProcessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RenderMessageFilter::HasGpuProcessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_HasGpuProcess_ForwardToCallback);
};

RenderMessageFilterProxy::RenderMessageFilterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool RenderMessageFilterProxy::GenerateRoutingID(
    int32_t* out_param_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "content::mojom::RenderMessageFilter::GenerateRoutingID");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_GenerateRoutingID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_GenerateRoutingID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("GenerateRoutingID");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderMessageFilter_GenerateRoutingID_HandleSyncResponse(
          &result, out_param_routing_id));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::RenderMessageFilter::GenerateRoutingID", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), out_param_routing_id,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void RenderMessageFilterProxy::GenerateRoutingID(
    GenerateRoutingIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderMessageFilter::GenerateRoutingID");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_GenerateRoutingID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_GenerateRoutingID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("GenerateRoutingID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderMessageFilter_GenerateRoutingID_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool RenderMessageFilterProxy::GenerateFrameRoutingID(
    int32_t* out_param_routing_id, ::blink::LocalFrameToken* out_param_frame_token, ::base::UnguessableToken* out_param_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "content::mojom::RenderMessageFilter::GenerateFrameRoutingID");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_GenerateFrameRoutingID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_GenerateFrameRoutingID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("GenerateFrameRoutingID");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderMessageFilter_GenerateFrameRoutingID_HandleSyncResponse(
          &result, out_param_routing_id, out_param_frame_token, out_param_devtools_frame_token));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::RenderMessageFilter::GenerateFrameRoutingID", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), out_param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), out_param_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), out_param_devtools_frame_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  return result;
}

void RenderMessageFilterProxy::GenerateFrameRoutingID(
    GenerateFrameRoutingIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderMessageFilter::GenerateFrameRoutingID");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_GenerateFrameRoutingID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_GenerateFrameRoutingID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("GenerateFrameRoutingID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderMessageFilter_GenerateFrameRoutingID_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool RenderMessageFilterProxy::HasGpuProcess(
    bool* out_param_has_gpu_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "content::mojom::RenderMessageFilter::HasGpuProcess");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_HasGpuProcess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_HasGpuProcess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("HasGpuProcess");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderMessageFilter_HasGpuProcess_HandleSyncResponse(
          &result, out_param_has_gpu_process));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::RenderMessageFilter::HasGpuProcess", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gpu_process"), out_param_has_gpu_process,
                        "<value of type bool>");
   });
#endif
  return result;
}

void RenderMessageFilterProxy::HasGpuProcess(
    HasGpuProcessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::RenderMessageFilter::HasGpuProcess");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_HasGpuProcess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_HasGpuProcess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("HasGpuProcess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderMessageFilter_HasGpuProcess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RenderMessageFilterProxy::SetThreadPriority(
    int32_t in_platform_thread_id, ::base::ThreadPriority in_thread_priority) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RenderMessageFilter::SetThreadPriority", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_thread_id"), in_platform_thread_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_priority"), in_thread_priority,
                        "<value of type ::base::ThreadPriority>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_SetThreadPriority_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_SetThreadPriority_Params_Data> params(
          message);
  params.Allocate();
  params->platform_thread_id = in_platform_thread_id;
  mojo::internal::Serialize<::mojo_base::mojom::ThreadPriority>(
      in_thread_priority, &params->thread_priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("SetThreadPriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RenderMessageFilter_GenerateRoutingID_ProxyToResponder {
 public:
  static RenderMessageFilter::GenerateRoutingIDCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RenderMessageFilter_GenerateRoutingID_ProxyToResponder> proxy(
        new RenderMessageFilter_GenerateRoutingID_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RenderMessageFilter_GenerateRoutingID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderMessageFilter_GenerateRoutingID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RenderMessageFilter_GenerateRoutingID_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RenderMessageFilter::GenerateRoutingIDCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_routing_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_GenerateRoutingID_ProxyToResponder);
};

bool RenderMessageFilter_GenerateRoutingID_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::RenderMessageFilter::GenerateRoutingIDCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_routing_id{};
  RenderMessageFilter_GenerateRoutingID_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderMessageFilter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_routing_id));
  return true;
}

void RenderMessageFilter_GenerateRoutingID_ProxyToResponder::Run(
    int32_t in_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::RenderMessageFilter::GenerateRoutingIDCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_GenerateRoutingID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->routing_id = in_routing_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::RenderMessageFilter::GenerateRoutingIDCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("GenerateRoutingID");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderMessageFilter_GenerateRoutingID_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int32_t p_routing_id{};
  RenderMessageFilter_GenerateRoutingID_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderMessageFilter::Name_, 0, true);
    return false;
  }
  *out_routing_id_ = std::move(p_routing_id);
  *result_ = true;
  return true;
}
class RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder {
 public:
  static RenderMessageFilter::GenerateFrameRoutingIDCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder> proxy(
        new RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RenderMessageFilter::GenerateFrameRoutingIDCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_routing_id, const ::blink::LocalFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder);
};

bool RenderMessageFilter_GenerateFrameRoutingID_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::RenderMessageFilter::GenerateFrameRoutingIDCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RenderMessageFilter_GenerateFrameRoutingID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderMessageFilter_GenerateFrameRoutingID_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_routing_id{};
  ::blink::LocalFrameToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  RenderMessageFilter_GenerateFrameRoutingID_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderMessageFilter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_routing_id), 
std::move(p_frame_token), 
std::move(p_devtools_frame_token));
  return true;
}

void RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder::Run(
    int32_t in_routing_id, const ::blink::LocalFrameToken& in_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::RenderMessageFilter::GenerateFrameRoutingIDCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_GenerateFrameRoutingID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_GenerateFrameRoutingID_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_frame_token, frame_token_fragment);
  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in ");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, devtools_frame_token_fragment);
  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::RenderMessageFilter::GenerateFrameRoutingIDCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("GenerateFrameRoutingID");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderMessageFilter_GenerateFrameRoutingID_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RenderMessageFilter_GenerateFrameRoutingID_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderMessageFilter_GenerateFrameRoutingID_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  int32_t p_routing_id{};
  ::blink::LocalFrameToken p_frame_token{};
  ::base::UnguessableToken p_devtools_frame_token{};
  RenderMessageFilter_GenerateFrameRoutingID_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_routing_id = input_data_view.routing_id();
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderMessageFilter::Name_, 1, true);
    return false;
  }
  *out_routing_id_ = std::move(p_routing_id);
  *out_frame_token_ = std::move(p_frame_token);
  *out_devtools_frame_token_ = std::move(p_devtools_frame_token);
  *result_ = true;
  return true;
}
class RenderMessageFilter_HasGpuProcess_ProxyToResponder {
 public:
  static RenderMessageFilter::HasGpuProcessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RenderMessageFilter_HasGpuProcess_ProxyToResponder> proxy(
        new RenderMessageFilter_HasGpuProcess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RenderMessageFilter_HasGpuProcess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderMessageFilter_HasGpuProcess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RenderMessageFilter_HasGpuProcess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RenderMessageFilter::HasGpuProcessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_gpu_process);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RenderMessageFilter_HasGpuProcess_ProxyToResponder);
};

bool RenderMessageFilter_HasGpuProcess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::RenderMessageFilter::HasGpuProcessCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_has_gpu_process{};
  RenderMessageFilter_HasGpuProcess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_gpu_process = input_data_view.has_gpu_process();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderMessageFilter::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_has_gpu_process));
  return true;
}

void RenderMessageFilter_HasGpuProcess_ProxyToResponder::Run(
    bool in_has_gpu_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::RenderMessageFilter::HasGpuProcessCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gpu_process"), in_has_gpu_process,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRenderMessageFilter_HasGpuProcess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->has_gpu_process = in_has_gpu_process;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::RenderMessageFilter::HasGpuProcessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderMessageFilter::Name_);
  message.set_method_name("HasGpuProcess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RenderMessageFilter_HasGpuProcess_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data* params =
      reinterpret_cast<internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_has_gpu_process{};
  RenderMessageFilter_HasGpuProcess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_gpu_process = input_data_view.has_gpu_process();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderMessageFilter::Name_, 2, true);
    return false;
  }
  *out_has_gpu_process_ = std::move(p_has_gpu_process);
  *result_ = true;
  return true;
}

// static
bool RenderMessageFilterStubDispatch::Accept(
    RenderMessageFilter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderMessageFilter_GenerateRoutingID_Name: {
      break;
    }
    case internal::kRenderMessageFilter_GenerateFrameRoutingID_Name: {
      break;
    }
    case internal::kRenderMessageFilter_HasGpuProcess_Name: {
      break;
    }
    case internal::kRenderMessageFilter_SetThreadPriority_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderMessageFilter::SetThreadPriority",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderMessageFilter::SetThreadPriority");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderMessageFilter_SetThreadPriority_Params_Data* params =
          reinterpret_cast<internal::RenderMessageFilter_SetThreadPriority_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_platform_thread_id{};
      ::base::ThreadPriority p_thread_priority{};
      RenderMessageFilter_SetThreadPriority_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_platform_thread_id = input_data_view.platform_thread_id();
      if (success && !input_data_view.ReadThreadPriority(&p_thread_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderMessageFilter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThreadPriority(
std::move(p_platform_thread_id), 
std::move(p_thread_priority));
      return true;
    }
  }
  return false;
}

// static
bool RenderMessageFilterStubDispatch::AcceptWithResponder(
    RenderMessageFilter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderMessageFilter_GenerateRoutingID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderMessageFilter::GenerateRoutingID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderMessageFilter::GenerateRoutingID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RenderMessageFilter_GenerateRoutingID_Params_Data* params =
          reinterpret_cast<
              internal::RenderMessageFilter_GenerateRoutingID_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RenderMessageFilter_GenerateRoutingID_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderMessageFilter::Name_, 0, false);
        return false;
      }
      RenderMessageFilter::GenerateRoutingIDCallback callback =
          RenderMessageFilter_GenerateRoutingID_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerateRoutingID(std::move(callback));
      return true;
    }
    case internal::kRenderMessageFilter_GenerateFrameRoutingID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderMessageFilter::GenerateFrameRoutingID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderMessageFilter::GenerateFrameRoutingID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RenderMessageFilter_GenerateFrameRoutingID_Params_Data* params =
          reinterpret_cast<
              internal::RenderMessageFilter_GenerateFrameRoutingID_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RenderMessageFilter_GenerateFrameRoutingID_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderMessageFilter::Name_, 1, false);
        return false;
      }
      RenderMessageFilter::GenerateFrameRoutingIDCallback callback =
          RenderMessageFilter_GenerateFrameRoutingID_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerateFrameRoutingID(std::move(callback));
      return true;
    }
    case internal::kRenderMessageFilter_HasGpuProcess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RenderMessageFilter::HasGpuProcess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RenderMessageFilter::HasGpuProcess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RenderMessageFilter_HasGpuProcess_Params_Data* params =
          reinterpret_cast<
              internal::RenderMessageFilter_HasGpuProcess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RenderMessageFilter_HasGpuProcess_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderMessageFilter::Name_, 2, false);
        return false;
      }
      RenderMessageFilter::HasGpuProcessCallback callback =
          RenderMessageFilter_HasGpuProcess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasGpuProcess(std::move(callback));
      return true;
    }
    case internal::kRenderMessageFilter_SetThreadPriority_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderMessageFilterValidationInfo[] = {
    {internal::kRenderMessageFilter_GenerateRoutingID_Name,
     {&internal::RenderMessageFilter_GenerateRoutingID_Params_Data::Validate,
      &internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data::Validate}},
    {internal::kRenderMessageFilter_GenerateFrameRoutingID_Name,
     {&internal::RenderMessageFilter_GenerateFrameRoutingID_Params_Data::Validate,
      &internal::RenderMessageFilter_GenerateFrameRoutingID_ResponseParams_Data::Validate}},
    {internal::kRenderMessageFilter_HasGpuProcess_Name,
     {&internal::RenderMessageFilter_HasGpuProcess_Params_Data::Validate,
      &internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data::Validate}},
    {internal::kRenderMessageFilter_SetThreadPriority_Name,
     {&internal::RenderMessageFilter_SetThreadPriority_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderMessageFilterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderMessageFilter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderMessageFilterValidationInfo);
}

bool RenderMessageFilterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RenderMessageFilter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRenderMessageFilterValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif