// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

namespace internal {


// static
bool BrowserSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BrowserSignals_Data* object = static_cast<const BrowserSignals_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seller, validation_context))
    return false;

  return true;
}

BrowserSignals_Data::BrowserSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data* object = static_cast<const AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->bidder_worklet, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->bidder_worklet,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bidding_interest_group, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bidding_interest_group, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams auction_signals_json_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->auction_signals_json, validation_context,
                                         &auction_signals_json_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams per_buyer_signals_json_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->per_buyer_signals_json, validation_context,
                                         &per_buyer_signals_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_top_window_origin, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_top_window_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_seller_origin, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_seller_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auction_start_time, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auction_start_time, validation_context))
    return false;

  return true;
}

AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data* object = static_cast<const AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->bid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_LoadSellerWorklet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuctionWorkletService_LoadSellerWorklet_Params_Data* object = static_cast<const AuctionWorkletService_LoadSellerWorklet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->seller_worklet, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->seller_worklet,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_source_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_source_url, validation_context))
    return false;

  return true;
}

AuctionWorkletService_LoadSellerWorklet_Params_Data::AuctionWorkletService_LoadSellerWorklet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data* object = static_cast<const AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data::AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet
