// device/gamepad/public/mojom/gamepad.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/gamepad/public/mojom/gamepad.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/gamepad/public/mojom/gamepad.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* GamepadMappingToStringHelper(GamepadMapping value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GamepadMapping::GamepadMappingNone:
      return "GamepadMappingNone";
    case GamepadMapping::GamepadMappingStandard:
      return "GamepadMappingStandard";
    case GamepadMapping::GamepadMappingXRStandard:
      return "GamepadMappingXRStandard";
    default:
      return nullptr;
  }
}

std::string GamepadMappingToString(GamepadMapping value) {
  const char *str = GamepadMappingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GamepadMapping value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GamepadMapping value) {
  return os << GamepadMappingToString(value);
}

static NOINLINE const char* GamepadHandToStringHelper(GamepadHand value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GamepadHand::GamepadHandNone:
      return "GamepadHandNone";
    case GamepadHand::GamepadHandLeft:
      return "GamepadHandLeft";
    case GamepadHand::GamepadHandRight:
      return "GamepadHandRight";
    default:
      return nullptr;
  }
}

std::string GamepadHandToString(GamepadHand value) {
  const char *str = GamepadHandToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GamepadHand value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GamepadHand value) {
  return os << GamepadHandToString(value);
}

static NOINLINE const char* GamepadHapticActuatorTypeToStringHelper(GamepadHapticActuatorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GamepadHapticActuatorType::GamepadHapticActuatorTypeVibration:
      return "GamepadHapticActuatorTypeVibration";
    case GamepadHapticActuatorType::GamepadHapticActuatorTypeDualRumble:
      return "GamepadHapticActuatorTypeDualRumble";
    default:
      return nullptr;
  }
}

std::string GamepadHapticActuatorTypeToString(GamepadHapticActuatorType value) {
  const char *str = GamepadHapticActuatorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GamepadHapticActuatorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GamepadHapticActuatorType value) {
  return os << GamepadHapticActuatorTypeToString(value);
}

static NOINLINE const char* GamepadHapticEffectTypeToStringHelper(GamepadHapticEffectType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GamepadHapticEffectType::GamepadHapticEffectTypeDualRumble:
      return "GamepadHapticEffectTypeDualRumble";
    default:
      return nullptr;
  }
}

std::string GamepadHapticEffectTypeToString(GamepadHapticEffectType value) {
  const char *str = GamepadHapticEffectTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GamepadHapticEffectType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GamepadHapticEffectType value) {
  return os << GamepadHapticEffectTypeToString(value);
}

static NOINLINE const char* GamepadHapticsResultToStringHelper(GamepadHapticsResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GamepadHapticsResult::GamepadHapticsResultError:
      return "GamepadHapticsResultError";
    case GamepadHapticsResult::GamepadHapticsResultComplete:
      return "GamepadHapticsResultComplete";
    case GamepadHapticsResult::GamepadHapticsResultPreempted:
      return "GamepadHapticsResultPreempted";
    case GamepadHapticsResult::GamepadHapticsResultInvalidParameter:
      return "GamepadHapticsResultInvalidParameter";
    case GamepadHapticsResult::GamepadHapticsResultNotSupported:
      return "GamepadHapticsResultNotSupported";
    default:
      return nullptr;
  }
}

std::string GamepadHapticsResultToString(GamepadHapticsResult value) {
  const char *str = GamepadHapticsResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GamepadHapticsResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GamepadHapticsResult value) {
  return os << GamepadHapticsResultToString(value);
}

namespace internal {


// static
bool GamepadQuaternion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadQuaternion_Data* object = static_cast<const GamepadQuaternion_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadQuaternion_Data::GamepadQuaternion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadVector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadVector_Data* object = static_cast<const GamepadVector_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadVector_Data::GamepadVector_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadButton_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadButton_Data* object = static_cast<const GamepadButton_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadButton_Data::GamepadButton_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ButtonChange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ButtonChange_Data* object = static_cast<const ButtonChange_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->button_snapshot, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->button_snapshot, validation_context))
    return false;

  return true;
}

ButtonChange_Data::ButtonChange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AxisChange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AxisChange_Data* object = static_cast<const AxisChange_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

AxisChange_Data::AxisChange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadChanges_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadChanges_Data* object = static_cast<const GamepadChanges_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->button_changes, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams button_changes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->button_changes, validation_context,
                                         &button_changes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axis_changes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams axis_changes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->axis_changes, validation_context,
                                         &axis_changes_validate_params)) {
    return false;
  }

  return true;
}

GamepadChanges_Data::GamepadChanges_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadPose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadPose_Data* object = static_cast<const GamepadPose_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->angular_velocity, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->linear_velocity, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->angular_acceleration, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->linear_acceleration, validation_context))
    return false;

  return true;
}

GamepadPose_Data::GamepadPose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadHapticActuator_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadHapticActuator_Data* object = static_cast<const GamepadHapticActuator_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::GamepadHapticActuatorType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

GamepadHapticActuator_Data::GamepadHapticActuator_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gamepad_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Gamepad_Data* object = static_cast<const Gamepad_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axes, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams axes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->axes, validation_context,
                                         &axes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buttons, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams buttons_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->buttons, validation_context,
                                         &buttons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->vibration_actuator, validation_context))
    return false;


  if (!::device::mojom::internal::GamepadMapping_Data
        ::Validate(object->mapping, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pose, validation_context))
    return false;


  if (!::device::mojom::internal::GamepadHand_Data
        ::Validate(object->hand, validation_context))
    return false;

  return true;
}

Gamepad_Data::Gamepad_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadEffectParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadEffectParameters_Data* object = static_cast<const GamepadEffectParameters_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadEffectParameters_Data::GamepadEffectParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadObserver_GamepadConnected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadObserver_GamepadConnected_Params_Data* object = static_cast<const GamepadObserver_GamepadConnected_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gamepad, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gamepad, validation_context))
    return false;

  return true;
}

GamepadObserver_GamepadConnected_Params_Data::GamepadObserver_GamepadConnected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadObserver_GamepadDisconnected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadObserver_GamepadDisconnected_Params_Data* object = static_cast<const GamepadObserver_GamepadDisconnected_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gamepad, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gamepad, validation_context))
    return false;

  return true;
}

GamepadObserver_GamepadDisconnected_Params_Data::GamepadObserver_GamepadDisconnected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadObserver_GamepadChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadObserver_GamepadChanged_Params_Data* object = static_cast<const GamepadObserver_GamepadChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->changes, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->changes, validation_context))
    return false;

  return true;
}

GamepadObserver_GamepadChanged_Params_Data::GamepadObserver_GamepadChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadMonitor_GamepadStartPolling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadMonitor_GamepadStartPolling_Params_Data* object = static_cast<const GamepadMonitor_GamepadStartPolling_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadMonitor_GamepadStartPolling_Params_Data::GamepadMonitor_GamepadStartPolling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadMonitor_GamepadStartPolling_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadMonitor_GamepadStartPolling_ResponseParams_Data* object = static_cast<const GamepadMonitor_GamepadStartPolling_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->memory_region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->memory_region, validation_context))
    return false;

  return true;
}

GamepadMonitor_GamepadStartPolling_ResponseParams_Data::GamepadMonitor_GamepadStartPolling_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadMonitor_GamepadStopPolling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadMonitor_GamepadStopPolling_Params_Data* object = static_cast<const GamepadMonitor_GamepadStopPolling_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadMonitor_GamepadStopPolling_Params_Data::GamepadMonitor_GamepadStopPolling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadMonitor_GamepadStopPolling_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadMonitor_GamepadStopPolling_ResponseParams_Data* object = static_cast<const GamepadMonitor_GamepadStopPolling_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadMonitor_GamepadStopPolling_ResponseParams_Data::GamepadMonitor_GamepadStopPolling_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadMonitor_SetObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadMonitor_SetObserver_Params_Data* object = static_cast<const GamepadMonitor_SetObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->gamepad_observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->gamepad_observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

GamepadMonitor_SetObserver_Params_Data::GamepadMonitor_SetObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data* object = static_cast<const GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::GamepadHapticEffectType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data* object = static_cast<const GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::GamepadHapticsResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadHapticsManager_ResetVibrationActuator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadHapticsManager_ResetVibrationActuator_Params_Data* object = static_cast<const GamepadHapticsManager_ResetVibrationActuator_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GamepadHapticsManager_ResetVibrationActuator_Params_Data::GamepadHapticsManager_ResetVibrationActuator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data* object = static_cast<const GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::GamepadHapticsResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GamepadMapping>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GamepadMapping value) {
  return std::move(context).WriteString(::device::mojom::GamepadMappingToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GamepadHand>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GamepadHand value) {
  return std::move(context).WriteString(::device::mojom::GamepadHandToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GamepadHapticActuatorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GamepadHapticActuatorType value) {
  return std::move(context).WriteString(::device::mojom::GamepadHapticActuatorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GamepadHapticEffectType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GamepadHapticEffectType value) {
  return std::move(context).WriteString(::device::mojom::GamepadHapticEffectTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GamepadHapticsResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GamepadHapticsResult value) {
  return std::move(context).WriteString(::device::mojom::GamepadHapticsResultToString(value));
}

} // namespace perfetto
