// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/alarms.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/alarms.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace alarms {
//
// Types
//

Alarm::Alarm()
: scheduled_time(0.0) {}

Alarm::~Alarm() = default;
Alarm::Alarm(Alarm&& rhs) = default;
Alarm& Alarm::operator=(Alarm&& rhs) = default;
// static
bool Alarm::Populate(
    const base::Value& value, Alarm* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* name_value = dict->FindKey("name");
  if (!name_value) {
    return false;
  }
  {
    auto* temp = name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->name = *temp;
  }

  const base::Value* scheduled_time_value = dict->FindKey("scheduledTime");
  if (!scheduled_time_value) {
    return false;
  }
  {
    auto temp = scheduled_time_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->scheduled_time = temp.value();
  }

  const base::Value* period_in_minutes_value = dict->FindKey("periodInMinutes");
  if (period_in_minutes_value) {
    {
      auto temp = period_in_minutes_value->GetIfDouble();
      if (!temp.has_value()) {
        out->period_in_minutes.reset();
        return false;
      }
      out->period_in_minutes = std::make_unique<double>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<Alarm> Alarm::FromValue(const base::Value& value) {
  auto out = std::make_unique<Alarm>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Alarm::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("scheduledTime", std::make_unique<base::Value>(this->scheduled_time));

  if (this->period_in_minutes.get()) {
    to_value_result->SetWithoutPathExpansion("periodInMinutes", std::make_unique<base::Value>(*this->period_in_minutes));

  }

  return to_value_result;
}


AlarmCreateInfo::AlarmCreateInfo()
 {}

AlarmCreateInfo::~AlarmCreateInfo() = default;
AlarmCreateInfo::AlarmCreateInfo(AlarmCreateInfo&& rhs) = default;
AlarmCreateInfo& AlarmCreateInfo::operator=(AlarmCreateInfo&& rhs) = default;
// static
bool AlarmCreateInfo::Populate(
    const base::Value& value, AlarmCreateInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* when_value = dict->FindKey("when");
  if (when_value) {
    {
      auto temp = when_value->GetIfDouble();
      if (!temp.has_value()) {
        out->when.reset();
        return false;
      }
      out->when = std::make_unique<double>(temp.value());
    }
  }

  const base::Value* delay_in_minutes_value = dict->FindKey("delayInMinutes");
  if (delay_in_minutes_value) {
    {
      auto temp = delay_in_minutes_value->GetIfDouble();
      if (!temp.has_value()) {
        out->delay_in_minutes.reset();
        return false;
      }
      out->delay_in_minutes = std::make_unique<double>(temp.value());
    }
  }

  const base::Value* period_in_minutes_value = dict->FindKey("periodInMinutes");
  if (period_in_minutes_value) {
    {
      auto temp = period_in_minutes_value->GetIfDouble();
      if (!temp.has_value()) {
        out->period_in_minutes.reset();
        return false;
      }
      out->period_in_minutes = std::make_unique<double>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<AlarmCreateInfo> AlarmCreateInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<AlarmCreateInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> AlarmCreateInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->when.get()) {
    to_value_result->SetWithoutPathExpansion("when", std::make_unique<base::Value>(*this->when));

  }
  if (this->delay_in_minutes.get()) {
    to_value_result->SetWithoutPathExpansion("delayInMinutes", std::make_unique<base::Value>(*this->delay_in_minutes));

  }
  if (this->period_in_minutes.get()) {
    to_value_result->SetWithoutPathExpansion("periodInMinutes", std::make_unique<base::Value>(*this->period_in_minutes));

  }

  return to_value_result;
}



//
// Functions
//

namespace Create {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        params->name.reset();
        return std::unique_ptr<Params>();
      }
      params->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* alarm_info_value = nullptr;
  if (args.Get(1, &alarm_info_value) &&
      !alarm_info_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!alarm_info_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!AlarmCreateInfo::Populate(*dictionary, &params->alarm_info)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Create

namespace Get {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        params->name.reset();
        return std::unique_ptr<Params>();
      }
      params->name = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const Alarm& alarm) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((alarm).ToValue()));

  return create_results;
}
}  // namespace Get

namespace GetAll {

std::vector<base::Value> Results::Create(const std::vector<Alarm>& alarms) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(alarms)));

  return create_results;
}
}  // namespace GetAll

namespace Clear {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* name_value = nullptr;
  if (args.Get(0, &name_value) &&
      !name_value->is_none()) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        params->name.reset();
        return std::unique_ptr<Params>();
      }
      params->name = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(bool was_cleared) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(was_cleared)));

  return create_results;
}
}  // namespace Clear

namespace ClearAll {

std::vector<base::Value> Results::Create(bool was_cleared) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(was_cleared)));

  return create_results;
}
}  // namespace ClearAll

//
// Events
//

namespace OnAlarm {

const char kEventName[] = "alarms.onAlarm";

std::vector<base::Value> Create(const Alarm& alarm) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((alarm).ToValue()));

  return create_results;
}

}  // namespace OnAlarm

}  // namespace alarms
}  // namespace api
}  // namespace extensions

