// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/events.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/events.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace events {
//
// Types
//

Rule::Rule()
 {}

Rule::~Rule() = default;
Rule::Rule(Rule&& rhs) = default;
Rule& Rule::operator=(Rule&& rhs) = default;
// static
bool Rule::Populate(
    const base::Value& value, Rule* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = dict->FindKey("id");
  if (id_value) {
    {
      auto* temp = id_value->GetIfString();
      if (!temp) {
        out->id.reset();
        return false;
      }
      out->id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tags_value = dict->FindKey("tags");
  if (tags_value) {
    {
      const base::ListValue* list = nullptr;
      if (!tags_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->tags)) {
          return false;
        }
      }
    }
  }

  const base::Value* conditions_value = dict->FindKey("conditions");
  if (!conditions_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!conditions_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->conditions)) {
        return false;
      }
    }
  }

  const base::Value* actions_value = dict->FindKey("actions");
  if (!actions_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!actions_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->actions)) {
        return false;
      }
    }
  }

  const base::Value* priority_value = dict->FindKey("priority");
  if (priority_value) {
    {
      auto temp = priority_value->GetIfInt();
      if (!temp.has_value()) {
        out->priority.reset();
        return false;
      }
      out->priority = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<Rule> Rule::FromValue(const base::Value& value) {
  auto out = std::make_unique<Rule>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Rule::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->id.get()) {
    to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(*this->id));

  }
  if (this->tags.get()) {
    to_value_result->SetWithoutPathExpansion("tags", json_schema_compiler::util::CreateValueFromArray(*this->tags));

  }
  to_value_result->SetWithoutPathExpansion("conditions", json_schema_compiler::util::CreateValueFromArray(this->conditions));

  to_value_result->SetWithoutPathExpansion("actions", json_schema_compiler::util::CreateValueFromArray(this->actions));

  if (this->priority.get()) {
    to_value_result->SetWithoutPathExpansion("priority", std::make_unique<base::Value>(*this->priority));

  }

  return to_value_result;
}


namespace Event {

namespace AddRules {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* event_name_value = nullptr;
  if (args.Get(0, &event_name_value) &&
      !event_name_value->is_none()) {
    {
      auto* temp = event_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->event_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* web_view_instance_id_value = nullptr;
  if (args.Get(1, &web_view_instance_id_value) &&
      !web_view_instance_id_value->is_none()) {
    {
      auto temp = web_view_instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->web_view_instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* rules_value = nullptr;
  if (args.Get(2, &rules_value) &&
      !rules_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!rules_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateArrayFromList(*list, &params->rules)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<Rule>& rules) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(rules)));

  return create_results;
}
}  // namespace AddRules

namespace GetRules {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 2 || args.GetSize() > 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* event_name_value = nullptr;
  if (args.Get(0, &event_name_value) &&
      !event_name_value->is_none()) {
    {
      auto* temp = event_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->event_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* web_view_instance_id_value = nullptr;
  if (args.Get(1, &web_view_instance_id_value) &&
      !web_view_instance_id_value->is_none()) {
    {
      auto temp = web_view_instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->web_view_instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* rule_identifiers_value = nullptr;
  if (args.Get(2, &rule_identifiers_value) &&
      !rule_identifiers_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!rule_identifiers_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &params->rule_identifiers)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<Rule>& rules) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(rules)));

  return create_results;
}
}  // namespace GetRules

namespace RemoveRules {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 2 || args.GetSize() > 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* event_name_value = nullptr;
  if (args.Get(0, &event_name_value) &&
      !event_name_value->is_none()) {
    {
      auto* temp = event_name_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->event_name = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* web_view_instance_id_value = nullptr;
  if (args.Get(1, &web_view_instance_id_value) &&
      !web_view_instance_id_value->is_none()) {
    {
      auto temp = web_view_instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->web_view_instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* rule_identifiers_value = nullptr;
  if (args.Get(2, &rule_identifiers_value) &&
      !rule_identifiers_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!rule_identifiers_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &params->rule_identifiers)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace RemoveRules

}  // namespace Event


}  // namespace events
}  // namespace api
}  // namespace extensions

