// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/extensions_manifest_types.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/extensions_manifest_types.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace extensions_manifest_types {
//
// Types
//

Automation::Object::Object()
 {}

Automation::Object::~Object() = default;
Automation::Object::Object(Object&& rhs) = default;
Automation::Object& Automation::Object::operator=(Object&& rhs) = default;
// static
bool Automation::Object::Populate(
    const base::Value& value, Object* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* desktop_value = dict->FindKey("desktop");
  if (desktop_value) {
    {
      auto temp = desktop_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'desktop': expected desktop, got " + UTF8ToUTF16(base::Value::GetTypeName(desktop_value->type()));
        out->desktop.reset();
        return false;
      }
      out->desktop = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* matches_value = dict->FindKey("matches");
  if (matches_value) {
    {
      const base::ListValue* list = nullptr;
      if (!matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'matches': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(matches_value->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->matches, &array_parse_error)) {
          array_parse_error = u"Error at key 'matches': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* interact_value = dict->FindKey("interact");
  if (interact_value) {
    {
      auto temp = interact_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'interact': expected interact, got " + UTF8ToUTF16(base::Value::GetTypeName(interact_value->type()));
        out->interact.reset();
        return false;
      }
      out->interact = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Automation::Object::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->desktop.get()) {
    to_value_result->SetWithoutPathExpansion("desktop", std::make_unique<base::Value>(*this->desktop));

  }
  if (this->matches.get()) {
    to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(*this->matches));

  }
  if (this->interact.get()) {
    to_value_result->SetWithoutPathExpansion("interact", std::make_unique<base::Value>(*this->interact));

  }

  return to_value_result;
}



Automation::Automation()
 {}

Automation::~Automation() = default;
Automation::Automation(Automation&& rhs) = default;
Automation& Automation::operator=(Automation&& rhs) = default;
// static
bool Automation::Populate(
    const base::Value& value, Automation* out, std::u16string* error) {
  DCHECK(error);
  if (value.type() == base::Value::Type::BOOLEAN) {
    {
      auto temp = (&value)->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'boolean': expected boolean, got " + UTF8ToUTF16(base::Value::GetTypeName((&value)->type()));
        out->as_boolean.reset();
        return false;
      }
      out->as_boolean = std::make_unique<bool>(temp.value());
    }
    return true;
  }
  if (value.type() == base::Value::Type::DICTIONARY) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!(&value)->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = u"'object': expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName((&value)->type()));
        return false;
      }
      else {
        auto temp = std::make_unique<Object>();
        if (!Object::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->as_object = std::move(temp);
      }
    }
    return true;
  }
  DCHECK(error->empty());
  *error = u"expected boolean or object, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
  return false;
}

// static
std::unique_ptr<Automation> Automation::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<Automation>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::Value> Automation::ToValue() const {
  std::unique_ptr<base::Value> result;
  if (as_boolean) {
    DCHECK(!result) << "Cannot set multiple choices for automation";
    result = std::make_unique<base::Value>(*as_boolean);

  }
  if (as_object) {
    DCHECK(!result) << "Cannot set multiple choices for automation";
    result = (as_object)->ToValue();

  }
  DCHECK(result) << "Must set at least one choice for automation";
  return result;
}


ContentCapabilities::ContentCapabilities()
 {}

ContentCapabilities::~ContentCapabilities() = default;
ContentCapabilities::ContentCapabilities(ContentCapabilities&& rhs) = default;
ContentCapabilities& ContentCapabilities::operator=(ContentCapabilities&& rhs) = default;
// static
bool ContentCapabilities::Populate(
    const base::Value& value, ContentCapabilities* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* matches_value = dict->FindKey("matches");
  if (!matches_value) {
    DCHECK(error->empty());
    *error = u"'matches' is required";
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!matches_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = u"'matches': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(matches_value->type()));
      return false;
    }
    else {
      std::u16string array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->matches, &array_parse_error)) {
        array_parse_error = u"Error at key 'matches': " + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  const base::Value* permissions_value = dict->FindKey("permissions");
  if (!permissions_value) {
    DCHECK(error->empty());
    *error = u"'permissions' is required";
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!permissions_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = u"'permissions': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(permissions_value->type()));
      return false;
    }
    else {
      std::u16string array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->permissions, &array_parse_error)) {
        array_parse_error = u"Error at key 'permissions': " + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ContentCapabilities> ContentCapabilities::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<ContentCapabilities>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ContentCapabilities::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(this->matches));

  to_value_result->SetWithoutPathExpansion("permissions", json_schema_compiler::util::CreateValueFromArray(this->permissions));


  return to_value_result;
}


ExternallyConnectable::ExternallyConnectable()
 {}

ExternallyConnectable::~ExternallyConnectable() = default;
ExternallyConnectable::ExternallyConnectable(ExternallyConnectable&& rhs) = default;
ExternallyConnectable& ExternallyConnectable::operator=(ExternallyConnectable&& rhs) = default;
// static
bool ExternallyConnectable::Populate(
    const base::Value& value, ExternallyConnectable* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* ids_value = dict->FindKey("ids");
  if (ids_value) {
    {
      const base::ListValue* list = nullptr;
      if (!ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'ids': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(ids_value->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->ids, &array_parse_error)) {
          array_parse_error = u"Error at key 'ids': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* matches_value = dict->FindKey("matches");
  if (matches_value) {
    {
      const base::ListValue* list = nullptr;
      if (!matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'matches': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(matches_value->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->matches, &array_parse_error)) {
          array_parse_error = u"Error at key 'matches': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* accepts_tls_channel_id_value = dict->FindKey("accepts_tls_channel_id");
  if (accepts_tls_channel_id_value) {
    {
      auto temp = accepts_tls_channel_id_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'accepts_tls_channel_id': expected accepts_tls_channel_id, got " + UTF8ToUTF16(base::Value::GetTypeName(accepts_tls_channel_id_value->type()));
        out->accepts_tls_channel_id.reset();
        return false;
      }
      out->accepts_tls_channel_id = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ExternallyConnectable> ExternallyConnectable::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<ExternallyConnectable>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ExternallyConnectable::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->ids.get()) {
    to_value_result->SetWithoutPathExpansion("ids", json_schema_compiler::util::CreateValueFromArray(*this->ids));

  }
  if (this->matches.get()) {
    to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(*this->matches));

  }
  if (this->accepts_tls_channel_id.get()) {
    to_value_result->SetWithoutPathExpansion("accepts_tls_channel_id", std::make_unique<base::Value>(*this->accepts_tls_channel_id));

  }

  return to_value_result;
}


OptionsUI::OptionsUI()
 {}

OptionsUI::~OptionsUI() = default;
OptionsUI::OptionsUI(OptionsUI&& rhs) = default;
OptionsUI& OptionsUI::operator=(OptionsUI&& rhs) = default;
// static
bool OptionsUI::Populate(
    const base::Value& value, OptionsUI* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* page_value = dict->FindKey("page");
  if (!page_value) {
    DCHECK(error->empty());
    *error = u"'page' is required";
    return false;
  }
  {
    auto* temp = page_value->GetIfString();
    if (!temp) {
      DCHECK(error->empty());
      *error = u"'page': expected page, got " + UTF8ToUTF16(base::Value::GetTypeName(page_value->type()));
      return false;
    }
    out->page = *temp;
  }

  const base::Value* chrome_style_value = dict->FindKey("chrome_style");
  if (chrome_style_value) {
    {
      auto temp = chrome_style_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'chrome_style': expected chrome_style, got " + UTF8ToUTF16(base::Value::GetTypeName(chrome_style_value->type()));
        out->chrome_style.reset();
        return false;
      }
      out->chrome_style = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* open_in_tab_value = dict->FindKey("open_in_tab");
  if (open_in_tab_value) {
    {
      auto temp = open_in_tab_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'open_in_tab': expected open_in_tab, got " + UTF8ToUTF16(base::Value::GetTypeName(open_in_tab_value->type()));
        out->open_in_tab.reset();
        return false;
      }
      out->open_in_tab = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<OptionsUI> OptionsUI::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<OptionsUI>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> OptionsUI::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("page", std::make_unique<base::Value>(this->page));

  if (this->chrome_style.get()) {
    to_value_result->SetWithoutPathExpansion("chrome_style", std::make_unique<base::Value>(*this->chrome_style));

  }
  if (this->open_in_tab.get()) {
    to_value_result->SetWithoutPathExpansion("open_in_tab", std::make_unique<base::Value>(*this->open_in_tab));

  }

  return to_value_result;
}


SocketHostPatterns::SocketHostPatterns()
 {}

SocketHostPatterns::~SocketHostPatterns() = default;
SocketHostPatterns::SocketHostPatterns(SocketHostPatterns&& rhs) = default;
SocketHostPatterns& SocketHostPatterns::operator=(SocketHostPatterns&& rhs) = default;
// static
bool SocketHostPatterns::Populate(
    const base::Value& value, SocketHostPatterns* out, std::u16string* error) {
  DCHECK(error);
  if (value.type() == base::Value::Type::STRING) {
    {
      auto* temp = (&value)->GetIfString();
      if (!temp) {
        DCHECK(error->empty());
        *error = u"'string': expected string, got " + UTF8ToUTF16(base::Value::GetTypeName((&value)->type()));
        out->as_string.reset();
        return false;
      }
      out->as_string = std::make_unique<std::string>(*temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::LIST) {
    {
      const base::ListValue* list = nullptr;
      if (!(&value)->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'strings': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName((&value)->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->as_strings, &array_parse_error)) {
          array_parse_error = u"Error at key 'strings': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
    return true;
  }
  DCHECK(error->empty());
  *error = u"expected string or strings, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
  return false;
}

// static
std::unique_ptr<SocketHostPatterns> SocketHostPatterns::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<SocketHostPatterns>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::Value> SocketHostPatterns::ToValue() const {
  std::unique_ptr<base::Value> result;
  if (as_string) {
    DCHECK(!result) << "Cannot set multiple choices for socket_host_patterns";
    result = std::make_unique<base::Value>(*as_string);

  }
  if (as_strings) {
    DCHECK(!result) << "Cannot set multiple choices for socket_host_patterns";
    result = json_schema_compiler::util::CreateValueFromArray(*as_strings);

  }
  DCHECK(result) << "Must set at least one choice for socket_host_patterns";
  return result;
}


Sockets::Udp::Udp()
 {}

Sockets::Udp::~Udp() = default;
Sockets::Udp::Udp(Udp&& rhs) = default;
Sockets::Udp& Sockets::Udp::operator=(Udp&& rhs) = default;
// static
bool Sockets::Udp::Populate(
    const base::Value& value, Udp* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* bind_value = dict->FindKey("bind");
  if (bind_value) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*bind_value, temp.get(), error))
        return false;
      out->bind = std::move(temp);
    }
  }

  const base::Value* send_value = dict->FindKey("send");
  if (send_value) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*send_value, temp.get(), error))
        return false;
      out->send = std::move(temp);
    }
  }

  const base::Value* multicast_membership_value = dict->FindKey("multicastMembership");
  if (multicast_membership_value) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*multicast_membership_value, temp.get(), error))
        return false;
      out->multicast_membership = std::move(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Sockets::Udp::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->bind.get()) {
    to_value_result->SetWithoutPathExpansion("bind", (this->bind)->ToValue());

  }
  if (this->send.get()) {
    to_value_result->SetWithoutPathExpansion("send", (this->send)->ToValue());

  }
  if (this->multicast_membership.get()) {
    to_value_result->SetWithoutPathExpansion("multicastMembership", (this->multicast_membership)->ToValue());

  }

  return to_value_result;
}


Sockets::Tcp::Tcp()
 {}

Sockets::Tcp::~Tcp() = default;
Sockets::Tcp::Tcp(Tcp&& rhs) = default;
Sockets::Tcp& Sockets::Tcp::operator=(Tcp&& rhs) = default;
// static
bool Sockets::Tcp::Populate(
    const base::Value& value, Tcp* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* connect_value = dict->FindKey("connect");
  if (connect_value) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*connect_value, temp.get(), error))
        return false;
      out->connect = std::move(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Sockets::Tcp::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->connect.get()) {
    to_value_result->SetWithoutPathExpansion("connect", (this->connect)->ToValue());

  }

  return to_value_result;
}


Sockets::TcpServer::TcpServer()
 {}

Sockets::TcpServer::~TcpServer() = default;
Sockets::TcpServer::TcpServer(TcpServer&& rhs) = default;
Sockets::TcpServer& Sockets::TcpServer::operator=(TcpServer&& rhs) = default;
// static
bool Sockets::TcpServer::Populate(
    const base::Value& value, TcpServer* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* listen_value = dict->FindKey("listen");
  if (listen_value) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*listen_value, temp.get(), error))
        return false;
      out->listen = std::move(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Sockets::TcpServer::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->listen.get()) {
    to_value_result->SetWithoutPathExpansion("listen", (this->listen)->ToValue());

  }

  return to_value_result;
}



Sockets::Sockets()
 {}

Sockets::~Sockets() = default;
Sockets::Sockets(Sockets&& rhs) = default;
Sockets& Sockets::operator=(Sockets&& rhs) = default;
// static
bool Sockets::Populate(
    const base::Value& value, Sockets* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* udp_value = dict->FindKey("udp");
  if (udp_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!udp_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = u"'udp': expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(udp_value->type()));
        return false;
      }
      else {
        auto temp = std::make_unique<Udp>();
        if (!Udp::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->udp = std::move(temp);
      }
    }
  }

  const base::Value* tcp_value = dict->FindKey("tcp");
  if (tcp_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tcp_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = u"'tcp': expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(tcp_value->type()));
        return false;
      }
      else {
        auto temp = std::make_unique<Tcp>();
        if (!Tcp::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->tcp = std::move(temp);
      }
    }
  }

  const base::Value* tcp_server_value = dict->FindKey("tcpServer");
  if (tcp_server_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tcp_server_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = u"'tcpServer': expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(tcp_server_value->type()));
        return false;
      }
      else {
        auto temp = std::make_unique<TcpServer>();
        if (!TcpServer::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->tcp_server = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<Sockets> Sockets::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<Sockets>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Sockets::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->udp.get()) {
    to_value_result->SetWithoutPathExpansion("udp", (this->udp)->ToValue());

  }
  if (this->tcp.get()) {
    to_value_result->SetWithoutPathExpansion("tcp", (this->tcp)->ToValue());

  }
  if (this->tcp_server.get()) {
    to_value_result->SetWithoutPathExpansion("tcpServer", (this->tcp_server)->ToValue());

  }

  return to_value_result;
}


Bluetooth::Bluetooth()
 {}

Bluetooth::~Bluetooth() = default;
Bluetooth::Bluetooth(Bluetooth&& rhs) = default;
Bluetooth& Bluetooth::operator=(Bluetooth&& rhs) = default;
// static
bool Bluetooth::Populate(
    const base::Value& value, Bluetooth* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* uuids_value = dict->FindKey("uuids");
  if (uuids_value) {
    {
      const base::ListValue* list = nullptr;
      if (!uuids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'uuids': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(uuids_value->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->uuids, &array_parse_error)) {
          array_parse_error = u"Error at key 'uuids': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* socket_value = dict->FindKey("socket");
  if (socket_value) {
    {
      auto temp = socket_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'socket': expected socket, got " + UTF8ToUTF16(base::Value::GetTypeName(socket_value->type()));
        out->socket.reset();
        return false;
      }
      out->socket = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* low_energy_value = dict->FindKey("low_energy");
  if (low_energy_value) {
    {
      auto temp = low_energy_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'low_energy': expected low_energy, got " + UTF8ToUTF16(base::Value::GetTypeName(low_energy_value->type()));
        out->low_energy.reset();
        return false;
      }
      out->low_energy = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* peripheral_value = dict->FindKey("peripheral");
  if (peripheral_value) {
    {
      auto temp = peripheral_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'peripheral': expected peripheral, got " + UTF8ToUTF16(base::Value::GetTypeName(peripheral_value->type()));
        out->peripheral.reset();
        return false;
      }
      out->peripheral = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<Bluetooth> Bluetooth::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<Bluetooth>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Bluetooth::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->uuids.get()) {
    to_value_result->SetWithoutPathExpansion("uuids", json_schema_compiler::util::CreateValueFromArray(*this->uuids));

  }
  if (this->socket.get()) {
    to_value_result->SetWithoutPathExpansion("socket", std::make_unique<base::Value>(*this->socket));

  }
  if (this->low_energy.get()) {
    to_value_result->SetWithoutPathExpansion("low_energy", std::make_unique<base::Value>(*this->low_energy));

  }
  if (this->peripheral.get()) {
    to_value_result->SetWithoutPathExpansion("peripheral", std::make_unique<base::Value>(*this->peripheral));

  }

  return to_value_result;
}


UsbPrinters::FiltersType::FiltersType()
: vendor_id(0) {}

UsbPrinters::FiltersType::~FiltersType() = default;
UsbPrinters::FiltersType::FiltersType(FiltersType&& rhs) = default;
UsbPrinters::FiltersType& UsbPrinters::FiltersType::operator=(FiltersType&& rhs) = default;
// static
bool UsbPrinters::FiltersType::Populate(
    const base::Value& value, FiltersType* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (!vendor_id_value) {
    DCHECK(error->empty());
    *error = u"'vendorId' is required";
    return false;
  }
  {
    auto temp = vendor_id_value->GetIfInt();
    if (!temp.has_value()) {
      DCHECK(error->empty());
      *error = u"'vendorId': expected vendorId, got " + UTF8ToUTF16(base::Value::GetTypeName(vendor_id_value->type()));
      return false;
    }
    out->vendor_id = temp.value();
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (product_id_value) {
    {
      auto temp = product_id_value->GetIfInt();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'productId': expected productId, got " + UTF8ToUTF16(base::Value::GetTypeName(product_id_value->type()));
        out->product_id.reset();
        return false;
      }
      out->product_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* interface_class_value = dict->FindKey("interfaceClass");
  if (interface_class_value) {
    {
      auto temp = interface_class_value->GetIfInt();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'interfaceClass': expected interfaceClass, got " + UTF8ToUTF16(base::Value::GetTypeName(interface_class_value->type()));
        out->interface_class.reset();
        return false;
      }
      out->interface_class = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* interface_subclass_value = dict->FindKey("interfaceSubclass");
  if (interface_subclass_value) {
    {
      auto temp = interface_subclass_value->GetIfInt();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'interfaceSubclass': expected interfaceSubclass, got " + UTF8ToUTF16(base::Value::GetTypeName(interface_subclass_value->type()));
        out->interface_subclass.reset();
        return false;
      }
      out->interface_subclass = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* interface_protocol_value = dict->FindKey("interfaceProtocol");
  if (interface_protocol_value) {
    {
      auto temp = interface_protocol_value->GetIfInt();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'interfaceProtocol': expected interfaceProtocol, got " + UTF8ToUTF16(base::Value::GetTypeName(interface_protocol_value->type()));
        out->interface_protocol.reset();
        return false;
      }
      out->interface_protocol = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> UsbPrinters::FiltersType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(this->vendor_id));

  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->interface_class.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceClass", std::make_unique<base::Value>(*this->interface_class));

  }
  if (this->interface_subclass.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceSubclass", std::make_unique<base::Value>(*this->interface_subclass));

  }
  if (this->interface_protocol.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceProtocol", std::make_unique<base::Value>(*this->interface_protocol));

  }

  return to_value_result;
}




UsbPrinters::UsbPrinters()
 {}

UsbPrinters::~UsbPrinters() = default;
UsbPrinters::UsbPrinters(UsbPrinters&& rhs) = default;
UsbPrinters& UsbPrinters::operator=(UsbPrinters&& rhs) = default;
// static
bool UsbPrinters::Populate(
    const base::Value& value, UsbPrinters* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* filters_value = dict->FindKey("filters");
  if (!filters_value) {
    DCHECK(error->empty());
    *error = u"'filters' is required";
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!filters_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = u"'filters': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(filters_value->type()));
      return false;
    }
    else {
      std::u16string array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->filters, &array_parse_error)) {
        array_parse_error = u"Error at key 'filters': " + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<UsbPrinters> UsbPrinters::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<UsbPrinters>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> UsbPrinters::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("filters", json_schema_compiler::util::CreateValueFromArray(this->filters));


  return to_value_result;
}


KioskSecondaryAppsType::KioskSecondaryAppsType()
 {}

KioskSecondaryAppsType::~KioskSecondaryAppsType() = default;
KioskSecondaryAppsType::KioskSecondaryAppsType(KioskSecondaryAppsType&& rhs) = default;
KioskSecondaryAppsType& KioskSecondaryAppsType::operator=(KioskSecondaryAppsType&& rhs) = default;
// static
bool KioskSecondaryAppsType::Populate(
    const base::Value& value, KioskSecondaryAppsType* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = dict->FindKey("id");
  if (!id_value) {
    DCHECK(error->empty());
    *error = u"'id' is required";
    return false;
  }
  {
    auto* temp = id_value->GetIfString();
    if (!temp) {
      DCHECK(error->empty());
      *error = u"'id': expected id, got " + UTF8ToUTF16(base::Value::GetTypeName(id_value->type()));
      return false;
    }
    out->id = *temp;
  }

  const base::Value* enabled_on_launch_value = dict->FindKey("enabled_on_launch");
  if (enabled_on_launch_value) {
    {
      auto temp = enabled_on_launch_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'enabled_on_launch': expected enabled_on_launch, got " + UTF8ToUTF16(base::Value::GetTypeName(enabled_on_launch_value->type()));
        out->enabled_on_launch.reset();
        return false;
      }
      out->enabled_on_launch = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<KioskSecondaryAppsType> KioskSecondaryAppsType::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<KioskSecondaryAppsType>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> KioskSecondaryAppsType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  if (this->enabled_on_launch.get()) {
    to_value_result->SetWithoutPathExpansion("enabled_on_launch", std::make_unique<base::Value>(*this->enabled_on_launch));

  }

  return to_value_result;
}




}  // namespace extensions_manifest_types
}  // namespace api
}  // namespace extensions

