// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/guest_view_internal.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/guest_view_internal.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace guest_view_internal {
//
// Types
//

Size::Size()
: width(0),
height(0) {}

Size::~Size() = default;
Size::Size(Size&& rhs) = default;
Size& Size::operator=(Size&& rhs) = default;
// static
bool Size::Populate(
    const base::Value& value, Size* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* width_value = dict->FindKey("width");
  if (!width_value) {
    return false;
  }
  {
    auto temp = width_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->width = temp.value();
  }

  const base::Value* height_value = dict->FindKey("height");
  if (!height_value) {
    return false;
  }
  {
    auto temp = height_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->height = temp.value();
  }

  return true;
}

// static
std::unique_ptr<Size> Size::FromValue(const base::Value& value) {
  auto out = std::make_unique<Size>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Size::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(this->width));

  to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(this->height));


  return to_value_result;
}


SizeParams::SizeParams()
 {}

SizeParams::~SizeParams() = default;
SizeParams::SizeParams(SizeParams&& rhs) = default;
SizeParams& SizeParams::operator=(SizeParams&& rhs) = default;
// static
bool SizeParams::Populate(
    const base::Value& value, SizeParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* enable_auto_size_value = dict->FindKey("enableAutoSize");
  if (enable_auto_size_value) {
    {
      auto temp = enable_auto_size_value->GetIfBool();
      if (!temp.has_value()) {
        out->enable_auto_size.reset();
        return false;
      }
      out->enable_auto_size = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* min_value = dict->FindKey("min");
  if (min_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!min_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<Size>();
        if (!Size::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->min = std::move(temp);
      }
    }
  }

  const base::Value* max_value = dict->FindKey("max");
  if (max_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!max_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<Size>();
        if (!Size::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->max = std::move(temp);
      }
    }
  }

  const base::Value* normal_value = dict->FindKey("normal");
  if (normal_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!normal_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<Size>();
        if (!Size::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->normal = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<SizeParams> SizeParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<SizeParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SizeParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->enable_auto_size.get()) {
    to_value_result->SetWithoutPathExpansion("enableAutoSize", std::make_unique<base::Value>(*this->enable_auto_size));

  }
  if (this->min.get()) {
    to_value_result->SetWithoutPathExpansion("min", (this->min)->ToValue());

  }
  if (this->max.get()) {
    to_value_result->SetWithoutPathExpansion("max", (this->max)->ToValue());

  }
  if (this->normal.get()) {
    to_value_result->SetWithoutPathExpansion("normal", (this->normal)->ToValue());

  }

  return to_value_result;
}



//
// Functions
//

namespace CreateGuest {

Params::CreateParams::CreateParams()
 {}

Params::CreateParams::~CreateParams() = default;
Params::CreateParams::CreateParams(CreateParams&& rhs) = default;
Params::CreateParams& Params::CreateParams::operator=(CreateParams&& rhs) = default;
// static
bool Params::CreateParams::Populate(
    const base::Value& value, CreateParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* view_type_value = nullptr;
  if (args.Get(0, &view_type_value) &&
      !view_type_value->is_none()) {
    {
      auto* temp = view_type_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->view_type = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* create_params_value = nullptr;
  if (args.Get(1, &create_params_value) &&
      !create_params_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!create_params_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!CreateParams::Populate(*dictionary, &params->create_params)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


Results::ReturnParams::ReturnParams()
 {}

Results::ReturnParams::~ReturnParams() = default;
Results::ReturnParams::ReturnParams(ReturnParams&& rhs) = default;
Results::ReturnParams& Results::ReturnParams::operator=(ReturnParams&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::ReturnParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}


std::vector<base::Value> Results::Create(const ReturnParams& return_params) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((return_params).ToValue()));

  return create_results;
}
}  // namespace CreateGuest

namespace DestroyGuest {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace DestroyGuest

namespace SetSize {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* instance_id_value = nullptr;
  if (args.Get(0, &instance_id_value) &&
      !instance_id_value->is_none()) {
    {
      auto temp = instance_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->instance_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* params_value = nullptr;
  if (args.Get(1, &params_value) &&
      !params_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!params_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!SizeParams::Populate(*dictionary, &params->params)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetSize

}  // namespace guest_view_internal
}  // namespace api
}  // namespace extensions

