// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/mime_handler_private.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/mime_handler_private.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace mime_handler_private {
//
// Types
//

StreamInfo::ResponseHeaders::ResponseHeaders()
 {}

StreamInfo::ResponseHeaders::~ResponseHeaders() = default;
StreamInfo::ResponseHeaders::ResponseHeaders(ResponseHeaders&& rhs) = default;
StreamInfo::ResponseHeaders& StreamInfo::ResponseHeaders::operator=(ResponseHeaders&& rhs) = default;
// static
bool StreamInfo::ResponseHeaders::Populate(
    const base::Value& value, ResponseHeaders* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}

std::unique_ptr<base::DictionaryValue> StreamInfo::ResponseHeaders::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}



StreamInfo::StreamInfo()
: tab_id(0),
embedded(false) {}

StreamInfo::~StreamInfo() = default;
StreamInfo::StreamInfo(StreamInfo&& rhs) = default;
StreamInfo& StreamInfo::operator=(StreamInfo&& rhs) = default;
// static
bool StreamInfo::Populate(
    const base::Value& value, StreamInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* mime_type_value = dict->FindKey("mimeType");
  if (!mime_type_value) {
    return false;
  }
  {
    auto* temp = mime_type_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->mime_type = *temp;
  }

  const base::Value* original_url_value = dict->FindKey("originalUrl");
  if (!original_url_value) {
    return false;
  }
  {
    auto* temp = original_url_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->original_url = *temp;
  }

  const base::Value* stream_url_value = dict->FindKey("streamUrl");
  if (!stream_url_value) {
    return false;
  }
  {
    auto* temp = stream_url_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->stream_url = *temp;
  }

  const base::Value* tab_id_value = dict->FindKey("tabId");
  if (!tab_id_value) {
    return false;
  }
  {
    auto temp = tab_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->tab_id = temp.value();
  }

  const base::Value* response_headers_value = dict->FindKey("responseHeaders");
  if (!response_headers_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!response_headers_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ResponseHeaders::Populate(*dictionary, &out->response_headers)) {
      return false;
    }
  }

  const base::Value* embedded_value = dict->FindKey("embedded");
  if (!embedded_value) {
    return false;
  }
  {
    auto temp = embedded_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->embedded = temp.value();
  }

  return true;
}

// static
std::unique_ptr<StreamInfo> StreamInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<StreamInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> StreamInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("mimeType", std::make_unique<base::Value>(this->mime_type));

  to_value_result->SetWithoutPathExpansion("originalUrl", std::make_unique<base::Value>(this->original_url));

  to_value_result->SetWithoutPathExpansion("streamUrl", std::make_unique<base::Value>(this->stream_url));

  to_value_result->SetWithoutPathExpansion("tabId", std::make_unique<base::Value>(this->tab_id));

  to_value_result->SetWithoutPathExpansion("responseHeaders", (this->response_headers).ToValue());

  to_value_result->SetWithoutPathExpansion("embedded", std::make_unique<base::Value>(this->embedded));


  return to_value_result;
}



//
// Events
//

namespace OnSave {

const char kEventName[] = "mimeHandlerPrivate.onSave";

std::vector<base::Value> Create(const std::string& stream_url) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(stream_url)));

  return create_results;
}

}  // namespace OnSave

}  // namespace mime_handler_private
}  // namespace api
}  // namespace extensions

