// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/serial.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/serial.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace serial {
//
// Types
//

DeviceInfo::DeviceInfo()
 {}

DeviceInfo::~DeviceInfo() = default;
DeviceInfo::DeviceInfo(DeviceInfo&& rhs) = default;
DeviceInfo& DeviceInfo::operator=(DeviceInfo&& rhs) = default;
// static
bool DeviceInfo::Populate(
    const base::Value& value, DeviceInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* path_value = dict->FindKey("path");
  if (!path_value) {
    return false;
  }
  {
    auto* temp = path_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->path = *temp;
  }

  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (vendor_id_value) {
    {
      auto temp = vendor_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->vendor_id.reset();
        return false;
      }
      out->vendor_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (product_id_value) {
    {
      auto temp = product_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->product_id.reset();
        return false;
      }
      out->product_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* display_name_value = dict->FindKey("displayName");
  if (display_name_value) {
    {
      auto* temp = display_name_value->GetIfString();
      if (!temp) {
        out->display_name.reset();
        return false;
      }
      out->display_name = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<DeviceInfo> DeviceInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<DeviceInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DeviceInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("path", std::make_unique<base::Value>(this->path));

  if (this->vendor_id.get()) {
    to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(*this->vendor_id));

  }
  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->display_name.get()) {
    to_value_result->SetWithoutPathExpansion("displayName", std::make_unique<base::Value>(*this->display_name));

  }

  return to_value_result;
}


const char* ToString(DataBits enum_param) {
  switch (enum_param) {
    case DATA_BITS_SEVEN:
      return "seven";
    case DATA_BITS_EIGHT:
      return "eight";
    case DATA_BITS_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

DataBits ParseDataBits(const std::string& enum_string) {
  if (enum_string == "seven")
    return DATA_BITS_SEVEN;
  if (enum_string == "eight")
    return DATA_BITS_EIGHT;
  return DATA_BITS_NONE;
}


const char* ToString(ParityBit enum_param) {
  switch (enum_param) {
    case PARITY_BIT_NO:
      return "no";
    case PARITY_BIT_ODD:
      return "odd";
    case PARITY_BIT_EVEN:
      return "even";
    case PARITY_BIT_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ParityBit ParseParityBit(const std::string& enum_string) {
  if (enum_string == "no")
    return PARITY_BIT_NO;
  if (enum_string == "odd")
    return PARITY_BIT_ODD;
  if (enum_string == "even")
    return PARITY_BIT_EVEN;
  return PARITY_BIT_NONE;
}


const char* ToString(StopBits enum_param) {
  switch (enum_param) {
    case STOP_BITS_ONE:
      return "one";
    case STOP_BITS_TWO:
      return "two";
    case STOP_BITS_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

StopBits ParseStopBits(const std::string& enum_string) {
  if (enum_string == "one")
    return STOP_BITS_ONE;
  if (enum_string == "two")
    return STOP_BITS_TWO;
  return STOP_BITS_NONE;
}


ConnectionOptions::ConnectionOptions()
: data_bits(DATA_BITS_NONE),
parity_bit(PARITY_BIT_NONE),
stop_bits(STOP_BITS_NONE) {}

ConnectionOptions::~ConnectionOptions() = default;
ConnectionOptions::ConnectionOptions(ConnectionOptions&& rhs) = default;
ConnectionOptions& ConnectionOptions::operator=(ConnectionOptions&& rhs) = default;
// static
bool ConnectionOptions::Populate(
    const base::Value& value, ConnectionOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->data_bits = DATA_BITS_NONE;
  out->parity_bit = PARITY_BIT_NONE;
  out->stop_bits = STOP_BITS_NONE;
  const base::Value* persistent_value = dict->FindKey("persistent");
  if (persistent_value) {
    {
      auto temp = persistent_value->GetIfBool();
      if (!temp.has_value()) {
        out->persistent.reset();
        return false;
      }
      out->persistent = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* name_value = dict->FindKey("name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* buffer_size_value = dict->FindKey("bufferSize");
  if (buffer_size_value) {
    {
      auto temp = buffer_size_value->GetIfInt();
      if (!temp.has_value()) {
        out->buffer_size.reset();
        return false;
      }
      out->buffer_size = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* bitrate_value = dict->FindKey("bitrate");
  if (bitrate_value) {
    {
      auto temp = bitrate_value->GetIfInt();
      if (!temp.has_value()) {
        out->bitrate.reset();
        return false;
      }
      out->bitrate = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* data_bits_value = dict->FindKey("dataBits");
  if (data_bits_value) {
    {
      std::string data_bits_as_string;
      if (!data_bits_value->GetAsString(&data_bits_as_string)) {
        return false;
      }
      out->data_bits = ParseDataBits(data_bits_as_string);
      if (out->data_bits == DATA_BITS_NONE) {
        return false;
      }
    }
    } else {
    out->data_bits = DATA_BITS_NONE;
  }

  const base::Value* parity_bit_value = dict->FindKey("parityBit");
  if (parity_bit_value) {
    {
      std::string parity_bit_as_string;
      if (!parity_bit_value->GetAsString(&parity_bit_as_string)) {
        return false;
      }
      out->parity_bit = ParseParityBit(parity_bit_as_string);
      if (out->parity_bit == PARITY_BIT_NONE) {
        return false;
      }
    }
    } else {
    out->parity_bit = PARITY_BIT_NONE;
  }

  const base::Value* stop_bits_value = dict->FindKey("stopBits");
  if (stop_bits_value) {
    {
      std::string stop_bits_as_string;
      if (!stop_bits_value->GetAsString(&stop_bits_as_string)) {
        return false;
      }
      out->stop_bits = ParseStopBits(stop_bits_as_string);
      if (out->stop_bits == STOP_BITS_NONE) {
        return false;
      }
    }
    } else {
    out->stop_bits = STOP_BITS_NONE;
  }

  const base::Value* cts_flow_control_value = dict->FindKey("ctsFlowControl");
  if (cts_flow_control_value) {
    {
      auto temp = cts_flow_control_value->GetIfBool();
      if (!temp.has_value()) {
        out->cts_flow_control.reset();
        return false;
      }
      out->cts_flow_control = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* receive_timeout_value = dict->FindKey("receiveTimeout");
  if (receive_timeout_value) {
    {
      auto temp = receive_timeout_value->GetIfInt();
      if (!temp.has_value()) {
        out->receive_timeout.reset();
        return false;
      }
      out->receive_timeout = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* send_timeout_value = dict->FindKey("sendTimeout");
  if (send_timeout_value) {
    {
      auto temp = send_timeout_value->GetIfInt();
      if (!temp.has_value()) {
        out->send_timeout.reset();
        return false;
      }
      out->send_timeout = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ConnectionOptions> ConnectionOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<ConnectionOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ConnectionOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->persistent.get()) {
    to_value_result->SetWithoutPathExpansion("persistent", std::make_unique<base::Value>(*this->persistent));

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(*this->name));

  }
  if (this->buffer_size.get()) {
    to_value_result->SetWithoutPathExpansion("bufferSize", std::make_unique<base::Value>(*this->buffer_size));

  }
  if (this->bitrate.get()) {
    to_value_result->SetWithoutPathExpansion("bitrate", std::make_unique<base::Value>(*this->bitrate));

  }
  if (this->data_bits != DATA_BITS_NONE) {
    to_value_result->SetWithoutPathExpansion("dataBits", std::make_unique<base::Value>(serial::ToString(this->data_bits)));

  }
  if (this->parity_bit != PARITY_BIT_NONE) {
    to_value_result->SetWithoutPathExpansion("parityBit", std::make_unique<base::Value>(serial::ToString(this->parity_bit)));

  }
  if (this->stop_bits != STOP_BITS_NONE) {
    to_value_result->SetWithoutPathExpansion("stopBits", std::make_unique<base::Value>(serial::ToString(this->stop_bits)));

  }
  if (this->cts_flow_control.get()) {
    to_value_result->SetWithoutPathExpansion("ctsFlowControl", std::make_unique<base::Value>(*this->cts_flow_control));

  }
  if (this->receive_timeout.get()) {
    to_value_result->SetWithoutPathExpansion("receiveTimeout", std::make_unique<base::Value>(*this->receive_timeout));

  }
  if (this->send_timeout.get()) {
    to_value_result->SetWithoutPathExpansion("sendTimeout", std::make_unique<base::Value>(*this->send_timeout));

  }

  return to_value_result;
}


ConnectionInfo::ConnectionInfo()
: connection_id(0),
paused(false),
persistent(false),
buffer_size(0),
receive_timeout(0),
send_timeout(0),
data_bits(DATA_BITS_NONE),
parity_bit(PARITY_BIT_NONE),
stop_bits(STOP_BITS_NONE) {}

ConnectionInfo::~ConnectionInfo() = default;
ConnectionInfo::ConnectionInfo(ConnectionInfo&& rhs) = default;
ConnectionInfo& ConnectionInfo::operator=(ConnectionInfo&& rhs) = default;
// static
bool ConnectionInfo::Populate(
    const base::Value& value, ConnectionInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->data_bits = DATA_BITS_NONE;
  out->parity_bit = PARITY_BIT_NONE;
  out->stop_bits = STOP_BITS_NONE;
  const base::Value* connection_id_value = dict->FindKey("connectionId");
  if (!connection_id_value) {
    return false;
  }
  {
    auto temp = connection_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->connection_id = temp.value();
  }

  const base::Value* paused_value = dict->FindKey("paused");
  if (!paused_value) {
    return false;
  }
  {
    auto temp = paused_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->paused = temp.value();
  }

  const base::Value* persistent_value = dict->FindKey("persistent");
  if (!persistent_value) {
    return false;
  }
  {
    auto temp = persistent_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->persistent = temp.value();
  }

  const base::Value* name_value = dict->FindKey("name");
  if (!name_value) {
    return false;
  }
  {
    auto* temp = name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->name = *temp;
  }

  const base::Value* buffer_size_value = dict->FindKey("bufferSize");
  if (!buffer_size_value) {
    return false;
  }
  {
    auto temp = buffer_size_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->buffer_size = temp.value();
  }

  const base::Value* receive_timeout_value = dict->FindKey("receiveTimeout");
  if (!receive_timeout_value) {
    return false;
  }
  {
    auto temp = receive_timeout_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->receive_timeout = temp.value();
  }

  const base::Value* send_timeout_value = dict->FindKey("sendTimeout");
  if (!send_timeout_value) {
    return false;
  }
  {
    auto temp = send_timeout_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->send_timeout = temp.value();
  }

  const base::Value* bitrate_value = dict->FindKey("bitrate");
  if (bitrate_value) {
    {
      auto temp = bitrate_value->GetIfInt();
      if (!temp.has_value()) {
        out->bitrate.reset();
        return false;
      }
      out->bitrate = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* data_bits_value = dict->FindKey("dataBits");
  if (data_bits_value) {
    {
      std::string data_bits_as_string;
      if (!data_bits_value->GetAsString(&data_bits_as_string)) {
        return false;
      }
      out->data_bits = ParseDataBits(data_bits_as_string);
      if (out->data_bits == DATA_BITS_NONE) {
        return false;
      }
    }
    } else {
    out->data_bits = DATA_BITS_NONE;
  }

  const base::Value* parity_bit_value = dict->FindKey("parityBit");
  if (parity_bit_value) {
    {
      std::string parity_bit_as_string;
      if (!parity_bit_value->GetAsString(&parity_bit_as_string)) {
        return false;
      }
      out->parity_bit = ParseParityBit(parity_bit_as_string);
      if (out->parity_bit == PARITY_BIT_NONE) {
        return false;
      }
    }
    } else {
    out->parity_bit = PARITY_BIT_NONE;
  }

  const base::Value* stop_bits_value = dict->FindKey("stopBits");
  if (stop_bits_value) {
    {
      std::string stop_bits_as_string;
      if (!stop_bits_value->GetAsString(&stop_bits_as_string)) {
        return false;
      }
      out->stop_bits = ParseStopBits(stop_bits_as_string);
      if (out->stop_bits == STOP_BITS_NONE) {
        return false;
      }
    }
    } else {
    out->stop_bits = STOP_BITS_NONE;
  }

  const base::Value* cts_flow_control_value = dict->FindKey("ctsFlowControl");
  if (cts_flow_control_value) {
    {
      auto temp = cts_flow_control_value->GetIfBool();
      if (!temp.has_value()) {
        out->cts_flow_control.reset();
        return false;
      }
      out->cts_flow_control = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ConnectionInfo> ConnectionInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ConnectionInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ConnectionInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("connectionId", std::make_unique<base::Value>(this->connection_id));

  to_value_result->SetWithoutPathExpansion("paused", std::make_unique<base::Value>(this->paused));

  to_value_result->SetWithoutPathExpansion("persistent", std::make_unique<base::Value>(this->persistent));

  to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("bufferSize", std::make_unique<base::Value>(this->buffer_size));

  to_value_result->SetWithoutPathExpansion("receiveTimeout", std::make_unique<base::Value>(this->receive_timeout));

  to_value_result->SetWithoutPathExpansion("sendTimeout", std::make_unique<base::Value>(this->send_timeout));

  if (this->bitrate.get()) {
    to_value_result->SetWithoutPathExpansion("bitrate", std::make_unique<base::Value>(*this->bitrate));

  }
  if (this->data_bits != DATA_BITS_NONE) {
    to_value_result->SetWithoutPathExpansion("dataBits", std::make_unique<base::Value>(serial::ToString(this->data_bits)));

  }
  if (this->parity_bit != PARITY_BIT_NONE) {
    to_value_result->SetWithoutPathExpansion("parityBit", std::make_unique<base::Value>(serial::ToString(this->parity_bit)));

  }
  if (this->stop_bits != STOP_BITS_NONE) {
    to_value_result->SetWithoutPathExpansion("stopBits", std::make_unique<base::Value>(serial::ToString(this->stop_bits)));

  }
  if (this->cts_flow_control.get()) {
    to_value_result->SetWithoutPathExpansion("ctsFlowControl", std::make_unique<base::Value>(*this->cts_flow_control));

  }

  return to_value_result;
}


const char* ToString(SendError enum_param) {
  switch (enum_param) {
    case SEND_ERROR_DISCONNECTED:
      return "disconnected";
    case SEND_ERROR_PENDING:
      return "pending";
    case SEND_ERROR_TIMEOUT:
      return "timeout";
    case SEND_ERROR_SYSTEM_ERROR:
      return "system_error";
    case SEND_ERROR_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

SendError ParseSendError(const std::string& enum_string) {
  if (enum_string == "disconnected")
    return SEND_ERROR_DISCONNECTED;
  if (enum_string == "pending")
    return SEND_ERROR_PENDING;
  if (enum_string == "timeout")
    return SEND_ERROR_TIMEOUT;
  if (enum_string == "system_error")
    return SEND_ERROR_SYSTEM_ERROR;
  return SEND_ERROR_NONE;
}


SendInfo::SendInfo()
: bytes_sent(0),
error(SEND_ERROR_NONE) {}

SendInfo::~SendInfo() = default;
SendInfo::SendInfo(SendInfo&& rhs) = default;
SendInfo& SendInfo::operator=(SendInfo&& rhs) = default;
// static
bool SendInfo::Populate(
    const base::Value& value, SendInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->error = SEND_ERROR_NONE;
  const base::Value* bytes_sent_value = dict->FindKey("bytesSent");
  if (!bytes_sent_value) {
    return false;
  }
  {
    auto temp = bytes_sent_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->bytes_sent = temp.value();
  }

  const base::Value* error_value = dict->FindKey("error");
  if (error_value) {
    {
      std::string send_error_as_string;
      if (!error_value->GetAsString(&send_error_as_string)) {
        return false;
      }
      out->error = ParseSendError(send_error_as_string);
      if (out->error == SEND_ERROR_NONE) {
        return false;
      }
    }
    } else {
    out->error = SEND_ERROR_NONE;
  }

  return true;
}

// static
std::unique_ptr<SendInfo> SendInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<SendInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SendInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("bytesSent", std::make_unique<base::Value>(this->bytes_sent));

  if (this->error != SEND_ERROR_NONE) {
    to_value_result->SetWithoutPathExpansion("error", std::make_unique<base::Value>(serial::ToString(this->error)));

  }

  return to_value_result;
}


HostControlSignals::HostControlSignals()
 {}

HostControlSignals::~HostControlSignals() = default;
HostControlSignals::HostControlSignals(HostControlSignals&& rhs) = default;
HostControlSignals& HostControlSignals::operator=(HostControlSignals&& rhs) = default;
// static
bool HostControlSignals::Populate(
    const base::Value& value, HostControlSignals* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* dtr_value = dict->FindKey("dtr");
  if (dtr_value) {
    {
      auto temp = dtr_value->GetIfBool();
      if (!temp.has_value()) {
        out->dtr.reset();
        return false;
      }
      out->dtr = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* rts_value = dict->FindKey("rts");
  if (rts_value) {
    {
      auto temp = rts_value->GetIfBool();
      if (!temp.has_value()) {
        out->rts.reset();
        return false;
      }
      out->rts = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<HostControlSignals> HostControlSignals::FromValue(const base::Value& value) {
  auto out = std::make_unique<HostControlSignals>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HostControlSignals::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->dtr.get()) {
    to_value_result->SetWithoutPathExpansion("dtr", std::make_unique<base::Value>(*this->dtr));

  }
  if (this->rts.get()) {
    to_value_result->SetWithoutPathExpansion("rts", std::make_unique<base::Value>(*this->rts));

  }

  return to_value_result;
}


DeviceControlSignals::DeviceControlSignals()
: dcd(false),
cts(false),
ri(false),
dsr(false) {}

DeviceControlSignals::~DeviceControlSignals() = default;
DeviceControlSignals::DeviceControlSignals(DeviceControlSignals&& rhs) = default;
DeviceControlSignals& DeviceControlSignals::operator=(DeviceControlSignals&& rhs) = default;
// static
bool DeviceControlSignals::Populate(
    const base::Value& value, DeviceControlSignals* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* dcd_value = dict->FindKey("dcd");
  if (!dcd_value) {
    return false;
  }
  {
    auto temp = dcd_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->dcd = temp.value();
  }

  const base::Value* cts_value = dict->FindKey("cts");
  if (!cts_value) {
    return false;
  }
  {
    auto temp = cts_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->cts = temp.value();
  }

  const base::Value* ri_value = dict->FindKey("ri");
  if (!ri_value) {
    return false;
  }
  {
    auto temp = ri_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->ri = temp.value();
  }

  const base::Value* dsr_value = dict->FindKey("dsr");
  if (!dsr_value) {
    return false;
  }
  {
    auto temp = dsr_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->dsr = temp.value();
  }

  return true;
}

// static
std::unique_ptr<DeviceControlSignals> DeviceControlSignals::FromValue(const base::Value& value) {
  auto out = std::make_unique<DeviceControlSignals>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DeviceControlSignals::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("dcd", std::make_unique<base::Value>(this->dcd));

  to_value_result->SetWithoutPathExpansion("cts", std::make_unique<base::Value>(this->cts));

  to_value_result->SetWithoutPathExpansion("ri", std::make_unique<base::Value>(this->ri));

  to_value_result->SetWithoutPathExpansion("dsr", std::make_unique<base::Value>(this->dsr));


  return to_value_result;
}


ReceiveInfo::ReceiveInfo()
: connection_id(0) {}

ReceiveInfo::~ReceiveInfo() = default;
ReceiveInfo::ReceiveInfo(ReceiveInfo&& rhs) = default;
ReceiveInfo& ReceiveInfo::operator=(ReceiveInfo&& rhs) = default;
// static
bool ReceiveInfo::Populate(
    const base::Value& value, ReceiveInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* connection_id_value = dict->FindKey("connectionId");
  if (!connection_id_value) {
    return false;
  }
  {
    auto temp = connection_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->connection_id = temp.value();
  }

  const base::Value* data_value = dict->FindKey("data");
  if (!data_value) {
    return false;
  }
  {
    if (!data_value->is_blob()) {
      return false;
    }
    else {
      out->data = data_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<ReceiveInfo> ReceiveInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ReceiveInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ReceiveInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("connectionId", std::make_unique<base::Value>(this->connection_id));

  to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(this->data));


  return to_value_result;
}


const char* ToString(ReceiveError enum_param) {
  switch (enum_param) {
    case RECEIVE_ERROR_DISCONNECTED:
      return "disconnected";
    case RECEIVE_ERROR_TIMEOUT:
      return "timeout";
    case RECEIVE_ERROR_DEVICE_LOST:
      return "device_lost";
    case RECEIVE_ERROR_BREAK:
      return "break";
    case RECEIVE_ERROR_FRAME_ERROR:
      return "frame_error";
    case RECEIVE_ERROR_OVERRUN:
      return "overrun";
    case RECEIVE_ERROR_BUFFER_OVERFLOW:
      return "buffer_overflow";
    case RECEIVE_ERROR_PARITY_ERROR:
      return "parity_error";
    case RECEIVE_ERROR_SYSTEM_ERROR:
      return "system_error";
    case RECEIVE_ERROR_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ReceiveError ParseReceiveError(const std::string& enum_string) {
  if (enum_string == "disconnected")
    return RECEIVE_ERROR_DISCONNECTED;
  if (enum_string == "timeout")
    return RECEIVE_ERROR_TIMEOUT;
  if (enum_string == "device_lost")
    return RECEIVE_ERROR_DEVICE_LOST;
  if (enum_string == "break")
    return RECEIVE_ERROR_BREAK;
  if (enum_string == "frame_error")
    return RECEIVE_ERROR_FRAME_ERROR;
  if (enum_string == "overrun")
    return RECEIVE_ERROR_OVERRUN;
  if (enum_string == "buffer_overflow")
    return RECEIVE_ERROR_BUFFER_OVERFLOW;
  if (enum_string == "parity_error")
    return RECEIVE_ERROR_PARITY_ERROR;
  if (enum_string == "system_error")
    return RECEIVE_ERROR_SYSTEM_ERROR;
  return RECEIVE_ERROR_NONE;
}


ReceiveErrorInfo::ReceiveErrorInfo()
: connection_id(0),
error(RECEIVE_ERROR_NONE) {}

ReceiveErrorInfo::~ReceiveErrorInfo() = default;
ReceiveErrorInfo::ReceiveErrorInfo(ReceiveErrorInfo&& rhs) = default;
ReceiveErrorInfo& ReceiveErrorInfo::operator=(ReceiveErrorInfo&& rhs) = default;
// static
bool ReceiveErrorInfo::Populate(
    const base::Value& value, ReceiveErrorInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* connection_id_value = dict->FindKey("connectionId");
  if (!connection_id_value) {
    return false;
  }
  {
    auto temp = connection_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->connection_id = temp.value();
  }

  const base::Value* error_value = dict->FindKey("error");
  if (!error_value) {
    return false;
  }
  {
    std::string receive_error_as_string;
    if (!error_value->GetAsString(&receive_error_as_string)) {
      return false;
    }
    out->error = ParseReceiveError(receive_error_as_string);
    if (out->error == RECEIVE_ERROR_NONE) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<ReceiveErrorInfo> ReceiveErrorInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ReceiveErrorInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ReceiveErrorInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("connectionId", std::make_unique<base::Value>(this->connection_id));

  to_value_result->SetWithoutPathExpansion("error", std::make_unique<base::Value>(serial::ToString(this->error)));


  return to_value_result;
}



//
// Functions
//

namespace GetDevices {

std::vector<base::Value> Results::Create(const std::vector<DeviceInfo>& ports) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(ports)));

  return create_results;
}
}  // namespace GetDevices

namespace Connect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* path_value = nullptr;
  if (args.Get(0, &path_value) &&
      !path_value->is_none()) {
    {
      auto* temp = path_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->path = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<ConnectionOptions>();
        if (!ConnectionOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const ConnectionInfo& connection_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((connection_info).ToValue()));

  return create_results;
}
}  // namespace Connect

namespace Update {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionOptions::Populate(*dictionary, &params->options)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Update

namespace Disconnect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Disconnect

namespace SetPaused {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* paused_value = nullptr;
  if (args.Get(1, &paused_value) &&
      !paused_value->is_none()) {
    {
      auto temp = paused_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->paused = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetPaused

namespace GetInfo {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const ConnectionInfo& connection_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((connection_info).ToValue()));

  return create_results;
}
}  // namespace GetInfo

namespace GetConnections {

std::vector<base::Value> Results::Create(const std::vector<ConnectionInfo>& connection_infos) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(connection_infos)));

  return create_results;
}
}  // namespace GetConnections

namespace Send {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_value = nullptr;
  if (args.Get(1, &data_value) &&
      !data_value->is_none()) {
    {
      if (!data_value->is_blob()) {
        return std::unique_ptr<Params>();
      }
      else {
        params->data = data_value->GetBlob();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const SendInfo& send_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((send_info).ToValue()));

  return create_results;
}
}  // namespace Send

namespace Flush {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Flush

namespace GetControlSignals {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const DeviceControlSignals& signals) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((signals).ToValue()));

  return create_results;
}
}  // namespace GetControlSignals

namespace SetControlSignals {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* signals_value = nullptr;
  if (args.Get(1, &signals_value) &&
      !signals_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!signals_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!HostControlSignals::Populate(*dictionary, &params->signals)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetControlSignals

namespace SetBreak {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetBreak

namespace ClearBreak {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* connection_id_value = nullptr;
  if (args.Get(0, &connection_id_value) &&
      !connection_id_value->is_none()) {
    {
      auto temp = connection_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->connection_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace ClearBreak

//
// Events
//

namespace OnReceive {

const char kEventName[] = "serial.onReceive";

std::vector<base::Value> Create(const ReceiveInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}

}  // namespace OnReceive

namespace OnReceiveError {

const char kEventName[] = "serial.onReceiveError";

std::vector<base::Value> Create(const ReceiveErrorInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}

}  // namespace OnReceiveError

}  // namespace serial
}  // namespace api
}  // namespace extensions

