// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/socket.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/socket.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace socket {
//
// Types
//

const char* ToString(SocketType enum_param) {
  switch (enum_param) {
    case SOCKET_TYPE_TCP:
      return "tcp";
    case SOCKET_TYPE_UDP:
      return "udp";
    case SOCKET_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

SocketType ParseSocketType(const std::string& enum_string) {
  if (enum_string == "tcp")
    return SOCKET_TYPE_TCP;
  if (enum_string == "udp")
    return SOCKET_TYPE_UDP;
  return SOCKET_TYPE_NONE;
}


CreateOptions::CreateOptions()
 {}

CreateOptions::~CreateOptions() = default;
CreateOptions::CreateOptions(CreateOptions&& rhs) = default;
CreateOptions& CreateOptions::operator=(CreateOptions&& rhs) = default;
// static
bool CreateOptions::Populate(
    const base::Value& value, CreateOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  return true;
}

// static
std::unique_ptr<CreateOptions> CreateOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<CreateOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CreateOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();


  return to_value_result;
}


CreateInfo::CreateInfo()
: socket_id(0) {}

CreateInfo::~CreateInfo() = default;
CreateInfo::CreateInfo(CreateInfo&& rhs) = default;
CreateInfo& CreateInfo::operator=(CreateInfo&& rhs) = default;
// static
bool CreateInfo::Populate(
    const base::Value& value, CreateInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* socket_id_value = dict->FindKey("socketId");
  if (!socket_id_value) {
    return false;
  }
  {
    auto temp = socket_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->socket_id = temp.value();
  }

  return true;
}

// static
std::unique_ptr<CreateInfo> CreateInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<CreateInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CreateInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("socketId", std::make_unique<base::Value>(this->socket_id));


  return to_value_result;
}


AcceptInfo::AcceptInfo()
: result_code(0) {}

AcceptInfo::~AcceptInfo() = default;
AcceptInfo::AcceptInfo(AcceptInfo&& rhs) = default;
AcceptInfo& AcceptInfo::operator=(AcceptInfo&& rhs) = default;
// static
bool AcceptInfo::Populate(
    const base::Value& value, AcceptInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (!result_code_value) {
    return false;
  }
  {
    auto temp = result_code_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->result_code = temp.value();
  }

  const base::Value* socket_id_value = dict->FindKey("socketId");
  if (socket_id_value) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->socket_id.reset();
        return false;
      }
      out->socket_id = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<AcceptInfo> AcceptInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<AcceptInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> AcceptInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(this->result_code));

  if (this->socket_id.get()) {
    to_value_result->SetWithoutPathExpansion("socketId", std::make_unique<base::Value>(*this->socket_id));

  }

  return to_value_result;
}


ReadInfo::ReadInfo()
: result_code(0) {}

ReadInfo::~ReadInfo() = default;
ReadInfo::ReadInfo(ReadInfo&& rhs) = default;
ReadInfo& ReadInfo::operator=(ReadInfo&& rhs) = default;
// static
bool ReadInfo::Populate(
    const base::Value& value, ReadInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (!result_code_value) {
    return false;
  }
  {
    auto temp = result_code_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->result_code = temp.value();
  }

  const base::Value* data_value = dict->FindKey("data");
  if (!data_value) {
    return false;
  }
  {
    if (!data_value->is_blob()) {
      return false;
    }
    else {
      out->data = data_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<ReadInfo> ReadInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ReadInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ReadInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(this->result_code));

  to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(this->data));


  return to_value_result;
}


WriteInfo::WriteInfo()
: bytes_written(0) {}

WriteInfo::~WriteInfo() = default;
WriteInfo::WriteInfo(WriteInfo&& rhs) = default;
WriteInfo& WriteInfo::operator=(WriteInfo&& rhs) = default;
// static
bool WriteInfo::Populate(
    const base::Value& value, WriteInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* bytes_written_value = dict->FindKey("bytesWritten");
  if (!bytes_written_value) {
    return false;
  }
  {
    auto temp = bytes_written_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->bytes_written = temp.value();
  }

  return true;
}

// static
std::unique_ptr<WriteInfo> WriteInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<WriteInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> WriteInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("bytesWritten", std::make_unique<base::Value>(this->bytes_written));


  return to_value_result;
}


RecvFromInfo::RecvFromInfo()
: result_code(0),
port(0) {}

RecvFromInfo::~RecvFromInfo() = default;
RecvFromInfo::RecvFromInfo(RecvFromInfo&& rhs) = default;
RecvFromInfo& RecvFromInfo::operator=(RecvFromInfo&& rhs) = default;
// static
bool RecvFromInfo::Populate(
    const base::Value& value, RecvFromInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (!result_code_value) {
    return false;
  }
  {
    auto temp = result_code_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->result_code = temp.value();
  }

  const base::Value* data_value = dict->FindKey("data");
  if (!data_value) {
    return false;
  }
  {
    if (!data_value->is_blob()) {
      return false;
    }
    else {
      out->data = data_value->GetBlob();
    }
  }

  const base::Value* address_value = dict->FindKey("address");
  if (!address_value) {
    return false;
  }
  {
    auto* temp = address_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->address = *temp;
  }

  const base::Value* port_value = dict->FindKey("port");
  if (!port_value) {
    return false;
  }
  {
    auto temp = port_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->port = temp.value();
  }

  return true;
}

// static
std::unique_ptr<RecvFromInfo> RecvFromInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<RecvFromInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RecvFromInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(this->result_code));

  to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(this->data));

  to_value_result->SetWithoutPathExpansion("address", std::make_unique<base::Value>(this->address));

  to_value_result->SetWithoutPathExpansion("port", std::make_unique<base::Value>(this->port));


  return to_value_result;
}


SocketInfo::SocketInfo()
: socket_type(SOCKET_TYPE_NONE),
connected(false) {}

SocketInfo::~SocketInfo() = default;
SocketInfo::SocketInfo(SocketInfo&& rhs) = default;
SocketInfo& SocketInfo::operator=(SocketInfo&& rhs) = default;
// static
bool SocketInfo::Populate(
    const base::Value& value, SocketInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* socket_type_value = dict->FindKey("socketType");
  if (!socket_type_value) {
    return false;
  }
  {
    std::string socket_type_as_string;
    if (!socket_type_value->GetAsString(&socket_type_as_string)) {
      return false;
    }
    out->socket_type = ParseSocketType(socket_type_as_string);
    if (out->socket_type == SOCKET_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* connected_value = dict->FindKey("connected");
  if (!connected_value) {
    return false;
  }
  {
    auto temp = connected_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->connected = temp.value();
  }

  const base::Value* peer_address_value = dict->FindKey("peerAddress");
  if (peer_address_value) {
    {
      auto* temp = peer_address_value->GetIfString();
      if (!temp) {
        out->peer_address.reset();
        return false;
      }
      out->peer_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* peer_port_value = dict->FindKey("peerPort");
  if (peer_port_value) {
    {
      auto temp = peer_port_value->GetIfInt();
      if (!temp.has_value()) {
        out->peer_port.reset();
        return false;
      }
      out->peer_port = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* local_address_value = dict->FindKey("localAddress");
  if (local_address_value) {
    {
      auto* temp = local_address_value->GetIfString();
      if (!temp) {
        out->local_address.reset();
        return false;
      }
      out->local_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* local_port_value = dict->FindKey("localPort");
  if (local_port_value) {
    {
      auto temp = local_port_value->GetIfInt();
      if (!temp.has_value()) {
        out->local_port.reset();
        return false;
      }
      out->local_port = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<SocketInfo> SocketInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<SocketInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SocketInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("socketType", std::make_unique<base::Value>(socket::ToString(this->socket_type)));

  to_value_result->SetWithoutPathExpansion("connected", std::make_unique<base::Value>(this->connected));

  if (this->peer_address.get()) {
    to_value_result->SetWithoutPathExpansion("peerAddress", std::make_unique<base::Value>(*this->peer_address));

  }
  if (this->peer_port.get()) {
    to_value_result->SetWithoutPathExpansion("peerPort", std::make_unique<base::Value>(*this->peer_port));

  }
  if (this->local_address.get()) {
    to_value_result->SetWithoutPathExpansion("localAddress", std::make_unique<base::Value>(*this->local_address));

  }
  if (this->local_port.get()) {
    to_value_result->SetWithoutPathExpansion("localPort", std::make_unique<base::Value>(*this->local_port));

  }

  return to_value_result;
}


NetworkInterface::NetworkInterface()
: prefix_length(0) {}

NetworkInterface::~NetworkInterface() = default;
NetworkInterface::NetworkInterface(NetworkInterface&& rhs) = default;
NetworkInterface& NetworkInterface::operator=(NetworkInterface&& rhs) = default;
// static
bool NetworkInterface::Populate(
    const base::Value& value, NetworkInterface* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* name_value = dict->FindKey("name");
  if (!name_value) {
    return false;
  }
  {
    auto* temp = name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->name = *temp;
  }

  const base::Value* address_value = dict->FindKey("address");
  if (!address_value) {
    return false;
  }
  {
    auto* temp = address_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->address = *temp;
  }

  const base::Value* prefix_length_value = dict->FindKey("prefixLength");
  if (!prefix_length_value) {
    return false;
  }
  {
    auto temp = prefix_length_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->prefix_length = temp.value();
  }

  return true;
}

// static
std::unique_ptr<NetworkInterface> NetworkInterface::FromValue(const base::Value& value) {
  auto out = std::make_unique<NetworkInterface>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> NetworkInterface::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("address", std::make_unique<base::Value>(this->address));

  to_value_result->SetWithoutPathExpansion("prefixLength", std::make_unique<base::Value>(this->prefix_length));


  return to_value_result;
}


TLSVersionConstraints::TLSVersionConstraints()
 {}

TLSVersionConstraints::~TLSVersionConstraints() = default;
TLSVersionConstraints::TLSVersionConstraints(TLSVersionConstraints&& rhs) = default;
TLSVersionConstraints& TLSVersionConstraints::operator=(TLSVersionConstraints&& rhs) = default;
// static
bool TLSVersionConstraints::Populate(
    const base::Value& value, TLSVersionConstraints* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* min_value = dict->FindKey("min");
  if (min_value) {
    {
      auto* temp = min_value->GetIfString();
      if (!temp) {
        out->min.reset();
        return false;
      }
      out->min = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* max_value = dict->FindKey("max");
  if (max_value) {
    {
      auto* temp = max_value->GetIfString();
      if (!temp) {
        out->max.reset();
        return false;
      }
      out->max = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<TLSVersionConstraints> TLSVersionConstraints::FromValue(const base::Value& value) {
  auto out = std::make_unique<TLSVersionConstraints>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> TLSVersionConstraints::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->min.get()) {
    to_value_result->SetWithoutPathExpansion("min", std::make_unique<base::Value>(*this->min));

  }
  if (this->max.get()) {
    to_value_result->SetWithoutPathExpansion("max", std::make_unique<base::Value>(*this->max));

  }

  return to_value_result;
}


SecureOptions::SecureOptions()
 {}

SecureOptions::~SecureOptions() = default;
SecureOptions::SecureOptions(SecureOptions&& rhs) = default;
SecureOptions& SecureOptions::operator=(SecureOptions&& rhs) = default;
// static
bool SecureOptions::Populate(
    const base::Value& value, SecureOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tls_version_value = dict->FindKey("tlsVersion");
  if (tls_version_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tls_version_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<TLSVersionConstraints>();
        if (!TLSVersionConstraints::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tls_version = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<SecureOptions> SecureOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<SecureOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SecureOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->tls_version.get()) {
    to_value_result->SetWithoutPathExpansion("tlsVersion", (this->tls_version)->ToValue());

  }

  return to_value_result;
}



//
// Functions
//

namespace Create {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* type_value = nullptr;
  if (args.Get(0, &type_value) &&
      !type_value->is_none()) {
    {
      std::string socket_type_as_string;
      if (!type_value->GetAsString(&socket_type_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->type = ParseSocketType(socket_type_as_string);
      if (params->type == SOCKET_TYPE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<CreateOptions>();
        if (!CreateOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const CreateInfo& create_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((create_info).ToValue()));

  return create_results;
}
}  // namespace Create

namespace Destroy {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Destroy

namespace Connect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* hostname_value = nullptr;
  if (args.Get(1, &hostname_value) &&
      !hostname_value->is_none()) {
    {
      auto* temp = hostname_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->hostname = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* port_value = nullptr;
  if (args.Get(2, &port_value) &&
      !port_value->is_none()) {
    {
      auto temp = port_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->port = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Connect

namespace Bind {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* address_value = nullptr;
  if (args.Get(1, &address_value) &&
      !address_value->is_none()) {
    {
      auto* temp = address_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->address = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* port_value = nullptr;
  if (args.Get(2, &port_value) &&
      !port_value->is_none()) {
    {
      auto temp = port_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->port = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Bind

namespace Disconnect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace Disconnect

namespace Read {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* buffer_size_value = nullptr;
  if (args.Get(1, &buffer_size_value) &&
      !buffer_size_value->is_none()) {
    {
      auto temp = buffer_size_value->GetIfInt();
      if (!temp.has_value()) {
        params->buffer_size.reset();
        return std::unique_ptr<Params>();
      }
      params->buffer_size = std::make_unique<int>(temp.value());
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const ReadInfo& read_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((read_info).ToValue()));

  return create_results;
}
}  // namespace Read

namespace Write {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_value = nullptr;
  if (args.Get(1, &data_value) &&
      !data_value->is_none()) {
    {
      if (!data_value->is_blob()) {
        return std::unique_ptr<Params>();
      }
      else {
        params->data = data_value->GetBlob();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const WriteInfo& write_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((write_info).ToValue()));

  return create_results;
}
}  // namespace Write

namespace RecvFrom {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* buffer_size_value = nullptr;
  if (args.Get(1, &buffer_size_value) &&
      !buffer_size_value->is_none()) {
    {
      auto temp = buffer_size_value->GetIfInt();
      if (!temp.has_value()) {
        params->buffer_size.reset();
        return std::unique_ptr<Params>();
      }
      params->buffer_size = std::make_unique<int>(temp.value());
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(const RecvFromInfo& recv_from_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((recv_from_info).ToValue()));

  return create_results;
}
}  // namespace RecvFrom

namespace SendTo {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 4) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* data_value = nullptr;
  if (args.Get(1, &data_value) &&
      !data_value->is_none()) {
    {
      if (!data_value->is_blob()) {
        return std::unique_ptr<Params>();
      }
      else {
        params->data = data_value->GetBlob();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* address_value = nullptr;
  if (args.Get(2, &address_value) &&
      !address_value->is_none()) {
    {
      auto* temp = address_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->address = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* port_value = nullptr;
  if (args.Get(3, &port_value) &&
      !port_value->is_none()) {
    {
      auto temp = port_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->port = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const WriteInfo& write_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((write_info).ToValue()));

  return create_results;
}
}  // namespace SendTo

namespace Listen {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 3 || args.GetSize() > 4) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* address_value = nullptr;
  if (args.Get(1, &address_value) &&
      !address_value->is_none()) {
    {
      auto* temp = address_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->address = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* port_value = nullptr;
  if (args.Get(2, &port_value) &&
      !port_value->is_none()) {
    {
      auto temp = port_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->port = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* backlog_value = nullptr;
  if (args.Get(3, &backlog_value) &&
      !backlog_value->is_none()) {
    {
      auto temp = backlog_value->GetIfInt();
      if (!temp.has_value()) {
        params->backlog.reset();
        return std::unique_ptr<Params>();
      }
      params->backlog = std::make_unique<int>(temp.value());
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Listen

namespace Accept {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const AcceptInfo& accept_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((accept_info).ToValue()));

  return create_results;
}
}  // namespace Accept

namespace SetKeepAlive {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 2 || args.GetSize() > 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* enable_value = nullptr;
  if (args.Get(1, &enable_value) &&
      !enable_value->is_none()) {
    {
      auto temp = enable_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->enable = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* delay_value = nullptr;
  if (args.Get(2, &delay_value) &&
      !delay_value->is_none()) {
    {
      auto temp = delay_value->GetIfInt();
      if (!temp.has_value()) {
        params->delay.reset();
        return std::unique_ptr<Params>();
      }
      params->delay = std::make_unique<int>(temp.value());
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetKeepAlive

namespace SetNoDelay {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* no_delay_value = nullptr;
  if (args.Get(1, &no_delay_value) &&
      !no_delay_value->is_none()) {
    {
      auto temp = no_delay_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->no_delay = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetNoDelay

namespace GetInfo {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const SocketInfo& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetInfo

namespace GetNetworkList {

std::vector<base::Value> Results::Create(const std::vector<NetworkInterface>& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(result)));

  return create_results;
}
}  // namespace GetNetworkList

namespace JoinGroup {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* address_value = nullptr;
  if (args.Get(1, &address_value) &&
      !address_value->is_none()) {
    {
      auto* temp = address_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->address = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace JoinGroup

namespace LeaveGroup {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* address_value = nullptr;
  if (args.Get(1, &address_value) &&
      !address_value->is_none()) {
    {
      auto* temp = address_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->address = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace LeaveGroup

namespace SetMulticastTimeToLive {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* ttl_value = nullptr;
  if (args.Get(1, &ttl_value) &&
      !ttl_value->is_none()) {
    {
      auto temp = ttl_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->ttl = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetMulticastTimeToLive

namespace SetMulticastLoopbackMode {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* enabled_value = nullptr;
  if (args.Get(1, &enabled_value) &&
      !enabled_value->is_none()) {
    {
      auto temp = enabled_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->enabled = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace SetMulticastLoopbackMode

namespace GetJoinedGroups {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<std::string>& groups) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(groups)));

  return create_results;
}
}  // namespace GetJoinedGroups

namespace Secure {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* socket_id_value = nullptr;
  if (args.Get(0, &socket_id_value) &&
      !socket_id_value->is_none()) {
    {
      auto temp = socket_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->socket_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<SecureOptions>();
        if (!SecureOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::vector<base::Value> Results::Create(int result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace Secure

}  // namespace socket
}  // namespace api
}  // namespace extensions

