// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/system_network.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/system_network.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace system_network {
//
// Types
//

NetworkInterface::NetworkInterface()
: prefix_length(0) {}

NetworkInterface::~NetworkInterface() = default;
NetworkInterface::NetworkInterface(NetworkInterface&& rhs) = default;
NetworkInterface& NetworkInterface::operator=(NetworkInterface&& rhs) = default;
// static
bool NetworkInterface::Populate(
    const base::Value& value, NetworkInterface* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* name_value = dict->FindKey("name");
  if (!name_value) {
    return false;
  }
  {
    auto* temp = name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->name = *temp;
  }

  const base::Value* address_value = dict->FindKey("address");
  if (!address_value) {
    return false;
  }
  {
    auto* temp = address_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->address = *temp;
  }

  const base::Value* prefix_length_value = dict->FindKey("prefixLength");
  if (!prefix_length_value) {
    return false;
  }
  {
    auto temp = prefix_length_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->prefix_length = temp.value();
  }

  return true;
}

// static
std::unique_ptr<NetworkInterface> NetworkInterface::FromValue(const base::Value& value) {
  auto out = std::make_unique<NetworkInterface>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> NetworkInterface::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("address", std::make_unique<base::Value>(this->address));

  to_value_result->SetWithoutPathExpansion("prefixLength", std::make_unique<base::Value>(this->prefix_length));


  return to_value_result;
}



//
// Functions
//

namespace GetNetworkInterfaces {

std::vector<base::Value> Results::Create(const std::vector<NetworkInterface>& network_interfaces) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(network_interfaces)));

  return create_results;
}
}  // namespace GetNetworkInterfaces

}  // namespace system_network
}  // namespace api
}  // namespace extensions

