// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/usb.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/usb.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace usb {
//
// Types
//

const char* ToString(Direction enum_param) {
  switch (enum_param) {
    case DIRECTION_IN:
      return "in";
    case DIRECTION_OUT:
      return "out";
    case DIRECTION_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

Direction ParseDirection(const std::string& enum_string) {
  if (enum_string == "in")
    return DIRECTION_IN;
  if (enum_string == "out")
    return DIRECTION_OUT;
  return DIRECTION_NONE;
}


const char* ToString(Recipient enum_param) {
  switch (enum_param) {
    case RECIPIENT_DEVICE:
      return "device";
    case RECIPIENT_INTERFACE:
      return "interface";
    case RECIPIENT_ENDPOINT:
      return "endpoint";
    case RECIPIENT_OTHER:
      return "other";
    case RECIPIENT_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

Recipient ParseRecipient(const std::string& enum_string) {
  if (enum_string == "device")
    return RECIPIENT_DEVICE;
  if (enum_string == "interface")
    return RECIPIENT_INTERFACE;
  if (enum_string == "endpoint")
    return RECIPIENT_ENDPOINT;
  if (enum_string == "other")
    return RECIPIENT_OTHER;
  return RECIPIENT_NONE;
}


const char* ToString(RequestType enum_param) {
  switch (enum_param) {
    case REQUEST_TYPE_STANDARD:
      return "standard";
    case REQUEST_TYPE_CLASS:
      return "class";
    case REQUEST_TYPE_VENDOR:
      return "vendor";
    case REQUEST_TYPE_RESERVED:
      return "reserved";
    case REQUEST_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

RequestType ParseRequestType(const std::string& enum_string) {
  if (enum_string == "standard")
    return REQUEST_TYPE_STANDARD;
  if (enum_string == "class")
    return REQUEST_TYPE_CLASS;
  if (enum_string == "vendor")
    return REQUEST_TYPE_VENDOR;
  if (enum_string == "reserved")
    return REQUEST_TYPE_RESERVED;
  return REQUEST_TYPE_NONE;
}


const char* ToString(TransferType enum_param) {
  switch (enum_param) {
    case TRANSFER_TYPE_CONTROL:
      return "control";
    case TRANSFER_TYPE_INTERRUPT:
      return "interrupt";
    case TRANSFER_TYPE_ISOCHRONOUS:
      return "isochronous";
    case TRANSFER_TYPE_BULK:
      return "bulk";
    case TRANSFER_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

TransferType ParseTransferType(const std::string& enum_string) {
  if (enum_string == "control")
    return TRANSFER_TYPE_CONTROL;
  if (enum_string == "interrupt")
    return TRANSFER_TYPE_INTERRUPT;
  if (enum_string == "isochronous")
    return TRANSFER_TYPE_ISOCHRONOUS;
  if (enum_string == "bulk")
    return TRANSFER_TYPE_BULK;
  return TRANSFER_TYPE_NONE;
}


const char* ToString(SynchronizationType enum_param) {
  switch (enum_param) {
    case SYNCHRONIZATION_TYPE_ASYNCHRONOUS:
      return "asynchronous";
    case SYNCHRONIZATION_TYPE_ADAPTIVE:
      return "adaptive";
    case SYNCHRONIZATION_TYPE_SYNCHRONOUS:
      return "synchronous";
    case SYNCHRONIZATION_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

SynchronizationType ParseSynchronizationType(const std::string& enum_string) {
  if (enum_string == "asynchronous")
    return SYNCHRONIZATION_TYPE_ASYNCHRONOUS;
  if (enum_string == "adaptive")
    return SYNCHRONIZATION_TYPE_ADAPTIVE;
  if (enum_string == "synchronous")
    return SYNCHRONIZATION_TYPE_SYNCHRONOUS;
  return SYNCHRONIZATION_TYPE_NONE;
}


const char* ToString(UsageType enum_param) {
  switch (enum_param) {
    case USAGE_TYPE_DATA:
      return "data";
    case USAGE_TYPE_FEEDBACK:
      return "feedback";
    case USAGE_TYPE_EXPLICITFEEDBACK:
      return "explicitFeedback";
    case USAGE_TYPE_PERIODIC:
      return "periodic";
    case USAGE_TYPE_NOTIFICATION:
      return "notification";
    case USAGE_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

UsageType ParseUsageType(const std::string& enum_string) {
  if (enum_string == "data")
    return USAGE_TYPE_DATA;
  if (enum_string == "feedback")
    return USAGE_TYPE_FEEDBACK;
  if (enum_string == "explicitFeedback")
    return USAGE_TYPE_EXPLICITFEEDBACK;
  if (enum_string == "periodic")
    return USAGE_TYPE_PERIODIC;
  if (enum_string == "notification")
    return USAGE_TYPE_NOTIFICATION;
  return USAGE_TYPE_NONE;
}


Device::Device()
: device(0),
vendor_id(0),
product_id(0),
version(0) {}

Device::~Device() = default;
Device::Device(Device&& rhs) = default;
Device& Device::operator=(Device&& rhs) = default;
// static
bool Device::Populate(
    const base::Value& value, Device* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* device_value = dict->FindKey("device");
  if (!device_value) {
    return false;
  }
  {
    auto temp = device_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->device = temp.value();
  }

  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (!vendor_id_value) {
    return false;
  }
  {
    auto temp = vendor_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->vendor_id = temp.value();
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (!product_id_value) {
    return false;
  }
  {
    auto temp = product_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->product_id = temp.value();
  }

  const base::Value* version_value = dict->FindKey("version");
  if (!version_value) {
    return false;
  }
  {
    auto temp = version_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->version = temp.value();
  }

  const base::Value* product_name_value = dict->FindKey("productName");
  if (!product_name_value) {
    return false;
  }
  {
    auto* temp = product_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->product_name = *temp;
  }

  const base::Value* manufacturer_name_value = dict->FindKey("manufacturerName");
  if (!manufacturer_name_value) {
    return false;
  }
  {
    auto* temp = manufacturer_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->manufacturer_name = *temp;
  }

  const base::Value* serial_number_value = dict->FindKey("serialNumber");
  if (!serial_number_value) {
    return false;
  }
  {
    auto* temp = serial_number_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->serial_number = *temp;
  }

  return true;
}

// static
std::unique_ptr<Device> Device::FromValue(const base::Value& value) {
  auto out = std::make_unique<Device>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Device::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("device", std::make_unique<base::Value>(this->device));

  to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(this->vendor_id));

  to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(this->product_id));

  to_value_result->SetWithoutPathExpansion("version", std::make_unique<base::Value>(this->version));

  to_value_result->SetWithoutPathExpansion("productName", std::make_unique<base::Value>(this->product_name));

  to_value_result->SetWithoutPathExpansion("manufacturerName", std::make_unique<base::Value>(this->manufacturer_name));

  to_value_result->SetWithoutPathExpansion("serialNumber", std::make_unique<base::Value>(this->serial_number));


  return to_value_result;
}


ConnectionHandle::ConnectionHandle()
: handle(0),
vendor_id(0),
product_id(0) {}

ConnectionHandle::~ConnectionHandle() = default;
ConnectionHandle::ConnectionHandle(ConnectionHandle&& rhs) = default;
ConnectionHandle& ConnectionHandle::operator=(ConnectionHandle&& rhs) = default;
// static
bool ConnectionHandle::Populate(
    const base::Value& value, ConnectionHandle* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* handle_value = dict->FindKey("handle");
  if (!handle_value) {
    return false;
  }
  {
    auto temp = handle_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->handle = temp.value();
  }

  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (!vendor_id_value) {
    return false;
  }
  {
    auto temp = vendor_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->vendor_id = temp.value();
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (!product_id_value) {
    return false;
  }
  {
    auto temp = product_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->product_id = temp.value();
  }

  return true;
}

// static
std::unique_ptr<ConnectionHandle> ConnectionHandle::FromValue(const base::Value& value) {
  auto out = std::make_unique<ConnectionHandle>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ConnectionHandle::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("handle", std::make_unique<base::Value>(this->handle));

  to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(this->vendor_id));

  to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(this->product_id));


  return to_value_result;
}


EndpointDescriptor::EndpointDescriptor()
: address(0),
type(TRANSFER_TYPE_NONE),
direction(DIRECTION_NONE),
maximum_packet_size(0),
synchronization(SYNCHRONIZATION_TYPE_NONE),
usage(USAGE_TYPE_NONE) {}

EndpointDescriptor::~EndpointDescriptor() = default;
EndpointDescriptor::EndpointDescriptor(EndpointDescriptor&& rhs) = default;
EndpointDescriptor& EndpointDescriptor::operator=(EndpointDescriptor&& rhs) = default;
// static
bool EndpointDescriptor::Populate(
    const base::Value& value, EndpointDescriptor* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->synchronization = SYNCHRONIZATION_TYPE_NONE;
  out->usage = USAGE_TYPE_NONE;
  const base::Value* address_value = dict->FindKey("address");
  if (!address_value) {
    return false;
  }
  {
    auto temp = address_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->address = temp.value();
  }

  const base::Value* type_value = dict->FindKey("type");
  if (!type_value) {
    return false;
  }
  {
    std::string transfer_type_as_string;
    if (!type_value->GetAsString(&transfer_type_as_string)) {
      return false;
    }
    out->type = ParseTransferType(transfer_type_as_string);
    if (out->type == TRANSFER_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* direction_value = dict->FindKey("direction");
  if (!direction_value) {
    return false;
  }
  {
    std::string direction_as_string;
    if (!direction_value->GetAsString(&direction_as_string)) {
      return false;
    }
    out->direction = ParseDirection(direction_as_string);
    if (out->direction == DIRECTION_NONE) {
      return false;
    }
  }

  const base::Value* maximum_packet_size_value = dict->FindKey("maximumPacketSize");
  if (!maximum_packet_size_value) {
    return false;
  }
  {
    auto temp = maximum_packet_size_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->maximum_packet_size = temp.value();
  }

  const base::Value* synchronization_value = dict->FindKey("synchronization");
  if (synchronization_value) {
    {
      std::string synchronization_type_as_string;
      if (!synchronization_value->GetAsString(&synchronization_type_as_string)) {
        return false;
      }
      out->synchronization = ParseSynchronizationType(synchronization_type_as_string);
      if (out->synchronization == SYNCHRONIZATION_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->synchronization = SYNCHRONIZATION_TYPE_NONE;
  }

  const base::Value* usage_value = dict->FindKey("usage");
  if (usage_value) {
    {
      std::string usage_type_as_string;
      if (!usage_value->GetAsString(&usage_type_as_string)) {
        return false;
      }
      out->usage = ParseUsageType(usage_type_as_string);
      if (out->usage == USAGE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->usage = USAGE_TYPE_NONE;
  }

  const base::Value* polling_interval_value = dict->FindKey("pollingInterval");
  if (polling_interval_value) {
    {
      auto temp = polling_interval_value->GetIfInt();
      if (!temp.has_value()) {
        out->polling_interval.reset();
        return false;
      }
      out->polling_interval = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* extra_data_value = dict->FindKey("extra_data");
  if (!extra_data_value) {
    return false;
  }
  {
    if (!extra_data_value->is_blob()) {
      return false;
    }
    else {
      out->extra_data = extra_data_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<EndpointDescriptor> EndpointDescriptor::FromValue(const base::Value& value) {
  auto out = std::make_unique<EndpointDescriptor>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EndpointDescriptor::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("address", std::make_unique<base::Value>(this->address));

  to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(usb::ToString(this->type)));

  to_value_result->SetWithoutPathExpansion("direction", std::make_unique<base::Value>(usb::ToString(this->direction)));

  to_value_result->SetWithoutPathExpansion("maximumPacketSize", std::make_unique<base::Value>(this->maximum_packet_size));

  if (this->synchronization != SYNCHRONIZATION_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("synchronization", std::make_unique<base::Value>(usb::ToString(this->synchronization)));

  }
  if (this->usage != USAGE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("usage", std::make_unique<base::Value>(usb::ToString(this->usage)));

  }
  if (this->polling_interval.get()) {
    to_value_result->SetWithoutPathExpansion("pollingInterval", std::make_unique<base::Value>(*this->polling_interval));

  }
  to_value_result->SetWithoutPathExpansion("extra_data", std::make_unique<base::Value>(this->extra_data));


  return to_value_result;
}


InterfaceDescriptor::InterfaceDescriptor()
: interface_number(0),
alternate_setting(0),
interface_class(0),
interface_subclass(0),
interface_protocol(0) {}

InterfaceDescriptor::~InterfaceDescriptor() = default;
InterfaceDescriptor::InterfaceDescriptor(InterfaceDescriptor&& rhs) = default;
InterfaceDescriptor& InterfaceDescriptor::operator=(InterfaceDescriptor&& rhs) = default;
// static
bool InterfaceDescriptor::Populate(
    const base::Value& value, InterfaceDescriptor* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* interface_number_value = dict->FindKey("interfaceNumber");
  if (!interface_number_value) {
    return false;
  }
  {
    auto temp = interface_number_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->interface_number = temp.value();
  }

  const base::Value* alternate_setting_value = dict->FindKey("alternateSetting");
  if (!alternate_setting_value) {
    return false;
  }
  {
    auto temp = alternate_setting_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->alternate_setting = temp.value();
  }

  const base::Value* interface_class_value = dict->FindKey("interfaceClass");
  if (!interface_class_value) {
    return false;
  }
  {
    auto temp = interface_class_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->interface_class = temp.value();
  }

  const base::Value* interface_subclass_value = dict->FindKey("interfaceSubclass");
  if (!interface_subclass_value) {
    return false;
  }
  {
    auto temp = interface_subclass_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->interface_subclass = temp.value();
  }

  const base::Value* interface_protocol_value = dict->FindKey("interfaceProtocol");
  if (!interface_protocol_value) {
    return false;
  }
  {
    auto temp = interface_protocol_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->interface_protocol = temp.value();
  }

  const base::Value* description_value = dict->FindKey("description");
  if (description_value) {
    {
      auto* temp = description_value->GetIfString();
      if (!temp) {
        out->description.reset();
        return false;
      }
      out->description = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* endpoints_value = dict->FindKey("endpoints");
  if (!endpoints_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!endpoints_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->endpoints)) {
        return false;
      }
    }
  }

  const base::Value* extra_data_value = dict->FindKey("extra_data");
  if (!extra_data_value) {
    return false;
  }
  {
    if (!extra_data_value->is_blob()) {
      return false;
    }
    else {
      out->extra_data = extra_data_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<InterfaceDescriptor> InterfaceDescriptor::FromValue(const base::Value& value) {
  auto out = std::make_unique<InterfaceDescriptor>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> InterfaceDescriptor::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("interfaceNumber", std::make_unique<base::Value>(this->interface_number));

  to_value_result->SetWithoutPathExpansion("alternateSetting", std::make_unique<base::Value>(this->alternate_setting));

  to_value_result->SetWithoutPathExpansion("interfaceClass", std::make_unique<base::Value>(this->interface_class));

  to_value_result->SetWithoutPathExpansion("interfaceSubclass", std::make_unique<base::Value>(this->interface_subclass));

  to_value_result->SetWithoutPathExpansion("interfaceProtocol", std::make_unique<base::Value>(this->interface_protocol));

  if (this->description.get()) {
    to_value_result->SetWithoutPathExpansion("description", std::make_unique<base::Value>(*this->description));

  }
  to_value_result->SetWithoutPathExpansion("endpoints", json_schema_compiler::util::CreateValueFromArray(this->endpoints));

  to_value_result->SetWithoutPathExpansion("extra_data", std::make_unique<base::Value>(this->extra_data));


  return to_value_result;
}


ConfigDescriptor::ConfigDescriptor()
: active(false),
configuration_value(0),
self_powered(false),
remote_wakeup(false),
max_power(0) {}

ConfigDescriptor::~ConfigDescriptor() = default;
ConfigDescriptor::ConfigDescriptor(ConfigDescriptor&& rhs) = default;
ConfigDescriptor& ConfigDescriptor::operator=(ConfigDescriptor&& rhs) = default;
// static
bool ConfigDescriptor::Populate(
    const base::Value& value, ConfigDescriptor* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* active_value = dict->FindKey("active");
  if (!active_value) {
    return false;
  }
  {
    auto temp = active_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->active = temp.value();
  }

  const base::Value* configuration_value_value = dict->FindKey("configurationValue");
  if (!configuration_value_value) {
    return false;
  }
  {
    auto temp = configuration_value_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->configuration_value = temp.value();
  }

  const base::Value* description_value = dict->FindKey("description");
  if (description_value) {
    {
      auto* temp = description_value->GetIfString();
      if (!temp) {
        out->description.reset();
        return false;
      }
      out->description = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* self_powered_value = dict->FindKey("selfPowered");
  if (!self_powered_value) {
    return false;
  }
  {
    auto temp = self_powered_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->self_powered = temp.value();
  }

  const base::Value* remote_wakeup_value = dict->FindKey("remoteWakeup");
  if (!remote_wakeup_value) {
    return false;
  }
  {
    auto temp = remote_wakeup_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->remote_wakeup = temp.value();
  }

  const base::Value* max_power_value = dict->FindKey("maxPower");
  if (!max_power_value) {
    return false;
  }
  {
    auto temp = max_power_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->max_power = temp.value();
  }

  const base::Value* interfaces_value = dict->FindKey("interfaces");
  if (!interfaces_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!interfaces_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->interfaces)) {
        return false;
      }
    }
  }

  const base::Value* extra_data_value = dict->FindKey("extra_data");
  if (!extra_data_value) {
    return false;
  }
  {
    if (!extra_data_value->is_blob()) {
      return false;
    }
    else {
      out->extra_data = extra_data_value->GetBlob();
    }
  }

  return true;
}

// static
std::unique_ptr<ConfigDescriptor> ConfigDescriptor::FromValue(const base::Value& value) {
  auto out = std::make_unique<ConfigDescriptor>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ConfigDescriptor::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("active", std::make_unique<base::Value>(this->active));

  to_value_result->SetWithoutPathExpansion("configurationValue", std::make_unique<base::Value>(this->configuration_value));

  if (this->description.get()) {
    to_value_result->SetWithoutPathExpansion("description", std::make_unique<base::Value>(*this->description));

  }
  to_value_result->SetWithoutPathExpansion("selfPowered", std::make_unique<base::Value>(this->self_powered));

  to_value_result->SetWithoutPathExpansion("remoteWakeup", std::make_unique<base::Value>(this->remote_wakeup));

  to_value_result->SetWithoutPathExpansion("maxPower", std::make_unique<base::Value>(this->max_power));

  to_value_result->SetWithoutPathExpansion("interfaces", json_schema_compiler::util::CreateValueFromArray(this->interfaces));

  to_value_result->SetWithoutPathExpansion("extra_data", std::make_unique<base::Value>(this->extra_data));


  return to_value_result;
}


ControlTransferInfo::ControlTransferInfo()
: direction(DIRECTION_NONE),
recipient(RECIPIENT_NONE),
request_type(REQUEST_TYPE_NONE),
request(0),
value(0),
index(0) {}

ControlTransferInfo::~ControlTransferInfo() = default;
ControlTransferInfo::ControlTransferInfo(ControlTransferInfo&& rhs) = default;
ControlTransferInfo& ControlTransferInfo::operator=(ControlTransferInfo&& rhs) = default;
// static
bool ControlTransferInfo::Populate(
    const base::Value& value, ControlTransferInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* direction_value = dict->FindKey("direction");
  if (!direction_value) {
    return false;
  }
  {
    std::string direction_as_string;
    if (!direction_value->GetAsString(&direction_as_string)) {
      return false;
    }
    out->direction = ParseDirection(direction_as_string);
    if (out->direction == DIRECTION_NONE) {
      return false;
    }
  }

  const base::Value* recipient_value = dict->FindKey("recipient");
  if (!recipient_value) {
    return false;
  }
  {
    std::string recipient_as_string;
    if (!recipient_value->GetAsString(&recipient_as_string)) {
      return false;
    }
    out->recipient = ParseRecipient(recipient_as_string);
    if (out->recipient == RECIPIENT_NONE) {
      return false;
    }
  }

  const base::Value* request_type_value = dict->FindKey("requestType");
  if (!request_type_value) {
    return false;
  }
  {
    std::string request_type_as_string;
    if (!request_type_value->GetAsString(&request_type_as_string)) {
      return false;
    }
    out->request_type = ParseRequestType(request_type_as_string);
    if (out->request_type == REQUEST_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* request_value = dict->FindKey("request");
  if (!request_value) {
    return false;
  }
  {
    auto temp = request_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->request = temp.value();
  }

  const base::Value* value_value = dict->FindKey("value");
  if (!value_value) {
    return false;
  }
  {
    auto temp = value_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->value = temp.value();
  }

  const base::Value* index_value = dict->FindKey("index");
  if (!index_value) {
    return false;
  }
  {
    auto temp = index_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->index = temp.value();
  }

  const base::Value* length_value = dict->FindKey("length");
  if (length_value) {
    {
      auto temp = length_value->GetIfInt();
      if (!temp.has_value()) {
        out->length.reset();
        return false;
      }
      out->length = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* data_value = dict->FindKey("data");
  if (data_value) {
    {
      if (!data_value->is_blob()) {
        return false;
      }
      else {
        out->data = std::make_unique<std::vector<uint8_t>>(data_value->GetBlob());
      }
    }
  }

  const base::Value* timeout_value = dict->FindKey("timeout");
  if (timeout_value) {
    {
      auto temp = timeout_value->GetIfInt();
      if (!temp.has_value()) {
        out->timeout.reset();
        return false;
      }
      out->timeout = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ControlTransferInfo> ControlTransferInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ControlTransferInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ControlTransferInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("direction", std::make_unique<base::Value>(usb::ToString(this->direction)));

  to_value_result->SetWithoutPathExpansion("recipient", std::make_unique<base::Value>(usb::ToString(this->recipient)));

  to_value_result->SetWithoutPathExpansion("requestType", std::make_unique<base::Value>(usb::ToString(this->request_type)));

  to_value_result->SetWithoutPathExpansion("request", std::make_unique<base::Value>(this->request));

  to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(this->value));

  to_value_result->SetWithoutPathExpansion("index", std::make_unique<base::Value>(this->index));

  if (this->length.get()) {
    to_value_result->SetWithoutPathExpansion("length", std::make_unique<base::Value>(*this->length));

  }
  if (this->data.get()) {
    to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(*this->data));

  }
  if (this->timeout.get()) {
    to_value_result->SetWithoutPathExpansion("timeout", std::make_unique<base::Value>(*this->timeout));

  }

  return to_value_result;
}


GenericTransferInfo::GenericTransferInfo()
: direction(DIRECTION_NONE),
endpoint(0) {}

GenericTransferInfo::~GenericTransferInfo() = default;
GenericTransferInfo::GenericTransferInfo(GenericTransferInfo&& rhs) = default;
GenericTransferInfo& GenericTransferInfo::operator=(GenericTransferInfo&& rhs) = default;
// static
bool GenericTransferInfo::Populate(
    const base::Value& value, GenericTransferInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* direction_value = dict->FindKey("direction");
  if (!direction_value) {
    return false;
  }
  {
    std::string direction_as_string;
    if (!direction_value->GetAsString(&direction_as_string)) {
      return false;
    }
    out->direction = ParseDirection(direction_as_string);
    if (out->direction == DIRECTION_NONE) {
      return false;
    }
  }

  const base::Value* endpoint_value = dict->FindKey("endpoint");
  if (!endpoint_value) {
    return false;
  }
  {
    auto temp = endpoint_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->endpoint = temp.value();
  }

  const base::Value* length_value = dict->FindKey("length");
  if (length_value) {
    {
      auto temp = length_value->GetIfInt();
      if (!temp.has_value()) {
        out->length.reset();
        return false;
      }
      out->length = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* data_value = dict->FindKey("data");
  if (data_value) {
    {
      if (!data_value->is_blob()) {
        return false;
      }
      else {
        out->data = std::make_unique<std::vector<uint8_t>>(data_value->GetBlob());
      }
    }
  }

  const base::Value* timeout_value = dict->FindKey("timeout");
  if (timeout_value) {
    {
      auto temp = timeout_value->GetIfInt();
      if (!temp.has_value()) {
        out->timeout.reset();
        return false;
      }
      out->timeout = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<GenericTransferInfo> GenericTransferInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<GenericTransferInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> GenericTransferInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("direction", std::make_unique<base::Value>(usb::ToString(this->direction)));

  to_value_result->SetWithoutPathExpansion("endpoint", std::make_unique<base::Value>(this->endpoint));

  if (this->length.get()) {
    to_value_result->SetWithoutPathExpansion("length", std::make_unique<base::Value>(*this->length));

  }
  if (this->data.get()) {
    to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(*this->data));

  }
  if (this->timeout.get()) {
    to_value_result->SetWithoutPathExpansion("timeout", std::make_unique<base::Value>(*this->timeout));

  }

  return to_value_result;
}


IsochronousTransferInfo::IsochronousTransferInfo()
: packets(0),
packet_length(0) {}

IsochronousTransferInfo::~IsochronousTransferInfo() = default;
IsochronousTransferInfo::IsochronousTransferInfo(IsochronousTransferInfo&& rhs) = default;
IsochronousTransferInfo& IsochronousTransferInfo::operator=(IsochronousTransferInfo&& rhs) = default;
// static
bool IsochronousTransferInfo::Populate(
    const base::Value& value, IsochronousTransferInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* transfer_info_value = dict->FindKey("transferInfo");
  if (!transfer_info_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!transfer_info_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!GenericTransferInfo::Populate(*dictionary, &out->transfer_info)) {
      return false;
    }
  }

  const base::Value* packets_value = dict->FindKey("packets");
  if (!packets_value) {
    return false;
  }
  {
    auto temp = packets_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->packets = temp.value();
  }

  const base::Value* packet_length_value = dict->FindKey("packetLength");
  if (!packet_length_value) {
    return false;
  }
  {
    auto temp = packet_length_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->packet_length = temp.value();
  }

  return true;
}

// static
std::unique_ptr<IsochronousTransferInfo> IsochronousTransferInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<IsochronousTransferInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> IsochronousTransferInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("transferInfo", (this->transfer_info).ToValue());

  to_value_result->SetWithoutPathExpansion("packets", std::make_unique<base::Value>(this->packets));

  to_value_result->SetWithoutPathExpansion("packetLength", std::make_unique<base::Value>(this->packet_length));


  return to_value_result;
}


TransferResultInfo::TransferResultInfo()
 {}

TransferResultInfo::~TransferResultInfo() = default;
TransferResultInfo::TransferResultInfo(TransferResultInfo&& rhs) = default;
TransferResultInfo& TransferResultInfo::operator=(TransferResultInfo&& rhs) = default;
// static
bool TransferResultInfo::Populate(
    const base::Value& value, TransferResultInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (result_code_value) {
    {
      auto temp = result_code_value->GetIfInt();
      if (!temp.has_value()) {
        out->result_code.reset();
        return false;
      }
      out->result_code = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* data_value = dict->FindKey("data");
  if (data_value) {
    {
      if (!data_value->is_blob()) {
        return false;
      }
      else {
        out->data = std::make_unique<std::vector<uint8_t>>(data_value->GetBlob());
      }
    }
  }

  return true;
}

// static
std::unique_ptr<TransferResultInfo> TransferResultInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<TransferResultInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> TransferResultInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->result_code.get()) {
    to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(*this->result_code));

  }
  if (this->data.get()) {
    to_value_result->SetWithoutPathExpansion("data", std::make_unique<base::Value>(*this->data));

  }

  return to_value_result;
}


DeviceFilter::DeviceFilter()
 {}

DeviceFilter::~DeviceFilter() = default;
DeviceFilter::DeviceFilter(DeviceFilter&& rhs) = default;
DeviceFilter& DeviceFilter::operator=(DeviceFilter&& rhs) = default;
// static
bool DeviceFilter::Populate(
    const base::Value& value, DeviceFilter* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (vendor_id_value) {
    {
      auto temp = vendor_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->vendor_id.reset();
        return false;
      }
      out->vendor_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (product_id_value) {
    {
      auto temp = product_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->product_id.reset();
        return false;
      }
      out->product_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* interface_class_value = dict->FindKey("interfaceClass");
  if (interface_class_value) {
    {
      auto temp = interface_class_value->GetIfInt();
      if (!temp.has_value()) {
        out->interface_class.reset();
        return false;
      }
      out->interface_class = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* interface_subclass_value = dict->FindKey("interfaceSubclass");
  if (interface_subclass_value) {
    {
      auto temp = interface_subclass_value->GetIfInt();
      if (!temp.has_value()) {
        out->interface_subclass.reset();
        return false;
      }
      out->interface_subclass = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* interface_protocol_value = dict->FindKey("interfaceProtocol");
  if (interface_protocol_value) {
    {
      auto temp = interface_protocol_value->GetIfInt();
      if (!temp.has_value()) {
        out->interface_protocol.reset();
        return false;
      }
      out->interface_protocol = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<DeviceFilter> DeviceFilter::FromValue(const base::Value& value) {
  auto out = std::make_unique<DeviceFilter>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DeviceFilter::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->vendor_id.get()) {
    to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(*this->vendor_id));

  }
  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->interface_class.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceClass", std::make_unique<base::Value>(*this->interface_class));

  }
  if (this->interface_subclass.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceSubclass", std::make_unique<base::Value>(*this->interface_subclass));

  }
  if (this->interface_protocol.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceProtocol", std::make_unique<base::Value>(*this->interface_protocol));

  }

  return to_value_result;
}


EnumerateDevicesOptions::EnumerateDevicesOptions()
 {}

EnumerateDevicesOptions::~EnumerateDevicesOptions() = default;
EnumerateDevicesOptions::EnumerateDevicesOptions(EnumerateDevicesOptions&& rhs) = default;
EnumerateDevicesOptions& EnumerateDevicesOptions::operator=(EnumerateDevicesOptions&& rhs) = default;
// static
bool EnumerateDevicesOptions::Populate(
    const base::Value& value, EnumerateDevicesOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (vendor_id_value) {
    {
      auto temp = vendor_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->vendor_id.reset();
        return false;
      }
      out->vendor_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (product_id_value) {
    {
      auto temp = product_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->product_id.reset();
        return false;
      }
      out->product_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* filters_value = dict->FindKey("filters");
  if (filters_value) {
    {
      const base::ListValue* list = nullptr;
      if (!filters_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->filters)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<EnumerateDevicesOptions> EnumerateDevicesOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<EnumerateDevicesOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EnumerateDevicesOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->vendor_id.get()) {
    to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(*this->vendor_id));

  }
  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->filters.get()) {
    to_value_result->SetWithoutPathExpansion("filters", json_schema_compiler::util::CreateValueFromArray(*this->filters));

  }

  return to_value_result;
}


EnumerateDevicesAndRequestAccessOptions::EnumerateDevicesAndRequestAccessOptions()
: vendor_id(0),
product_id(0) {}

EnumerateDevicesAndRequestAccessOptions::~EnumerateDevicesAndRequestAccessOptions() = default;
EnumerateDevicesAndRequestAccessOptions::EnumerateDevicesAndRequestAccessOptions(EnumerateDevicesAndRequestAccessOptions&& rhs) = default;
EnumerateDevicesAndRequestAccessOptions& EnumerateDevicesAndRequestAccessOptions::operator=(EnumerateDevicesAndRequestAccessOptions&& rhs) = default;
// static
bool EnumerateDevicesAndRequestAccessOptions::Populate(
    const base::Value& value, EnumerateDevicesAndRequestAccessOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = dict->FindKey("vendorId");
  if (!vendor_id_value) {
    return false;
  }
  {
    auto temp = vendor_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->vendor_id = temp.value();
  }

  const base::Value* product_id_value = dict->FindKey("productId");
  if (!product_id_value) {
    return false;
  }
  {
    auto temp = product_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->product_id = temp.value();
  }

  const base::Value* interface_id_value = dict->FindKey("interfaceId");
  if (interface_id_value) {
    {
      auto temp = interface_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->interface_id.reset();
        return false;
      }
      out->interface_id = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<EnumerateDevicesAndRequestAccessOptions> EnumerateDevicesAndRequestAccessOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<EnumerateDevicesAndRequestAccessOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EnumerateDevicesAndRequestAccessOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(this->vendor_id));

  to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(this->product_id));

  if (this->interface_id.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceId", std::make_unique<base::Value>(*this->interface_id));

  }

  return to_value_result;
}


DevicePromptOptions::DevicePromptOptions()
 {}

DevicePromptOptions::~DevicePromptOptions() = default;
DevicePromptOptions::DevicePromptOptions(DevicePromptOptions&& rhs) = default;
DevicePromptOptions& DevicePromptOptions::operator=(DevicePromptOptions&& rhs) = default;
// static
bool DevicePromptOptions::Populate(
    const base::Value& value, DevicePromptOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* multiple_value = dict->FindKey("multiple");
  if (multiple_value) {
    {
      auto temp = multiple_value->GetIfBool();
      if (!temp.has_value()) {
        out->multiple.reset();
        return false;
      }
      out->multiple = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* filters_value = dict->FindKey("filters");
  if (filters_value) {
    {
      const base::ListValue* list = nullptr;
      if (!filters_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->filters)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<DevicePromptOptions> DevicePromptOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<DevicePromptOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DevicePromptOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->multiple.get()) {
    to_value_result->SetWithoutPathExpansion("multiple", std::make_unique<base::Value>(*this->multiple));

  }
  if (this->filters.get()) {
    to_value_result->SetWithoutPathExpansion("filters", json_schema_compiler::util::CreateValueFromArray(*this->filters));

  }

  return to_value_result;
}



//
// Functions
//

namespace GetDevices {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!EnumerateDevicesOptions::Populate(*dictionary, &params->options)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<Device>& devices) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(devices)));

  return create_results;
}
}  // namespace GetDevices

namespace GetUserSelectedDevices {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!DevicePromptOptions::Populate(*dictionary, &params->options)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<Device>& devices) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(devices)));

  return create_results;
}
}  // namespace GetUserSelectedDevices

namespace GetConfigurations {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* device_value = nullptr;
  if (args.Get(0, &device_value) &&
      !device_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!device_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!Device::Populate(*dictionary, &params->device)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<ConfigDescriptor>& configs) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(configs)));

  return create_results;
}
}  // namespace GetConfigurations

namespace RequestAccess {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* device_value = nullptr;
  if (args.Get(0, &device_value) &&
      !device_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!device_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!Device::Populate(*dictionary, &params->device)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* interface_id_value = nullptr;
  if (args.Get(1, &interface_id_value) &&
      !interface_id_value->is_none()) {
    {
      auto temp = interface_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->interface_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool success) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(success)));

  return create_results;
}
}  // namespace RequestAccess

namespace OpenDevice {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* device_value = nullptr;
  if (args.Get(0, &device_value) &&
      !device_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!device_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!Device::Populate(*dictionary, &params->device)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const ConnectionHandle& handle) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((handle).ToValue()));

  return create_results;
}
}  // namespace OpenDevice

namespace FindDevices {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!EnumerateDevicesAndRequestAccessOptions::Populate(*dictionary, &params->options)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<ConnectionHandle>& handles) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(handles)));

  return create_results;
}
}  // namespace FindDevices

namespace CloseDevice {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace CloseDevice

namespace SetConfiguration {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* configuration_value_value = nullptr;
  if (args.Get(1, &configuration_value_value) &&
      !configuration_value_value->is_none()) {
    {
      auto temp = configuration_value_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->configuration_value = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetConfiguration

namespace GetConfiguration {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const ConfigDescriptor& config) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((config).ToValue()));

  return create_results;
}
}  // namespace GetConfiguration

namespace ListInterfaces {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<InterfaceDescriptor>& descriptors) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(descriptors)));

  return create_results;
}
}  // namespace ListInterfaces

namespace ClaimInterface {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* interface_number_value = nullptr;
  if (args.Get(1, &interface_number_value) &&
      !interface_number_value->is_none()) {
    {
      auto temp = interface_number_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->interface_number = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace ClaimInterface

namespace ReleaseInterface {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* interface_number_value = nullptr;
  if (args.Get(1, &interface_number_value) &&
      !interface_number_value->is_none()) {
    {
      auto temp = interface_number_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->interface_number = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace ReleaseInterface

namespace SetInterfaceAlternateSetting {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* interface_number_value = nullptr;
  if (args.Get(1, &interface_number_value) &&
      !interface_number_value->is_none()) {
    {
      auto temp = interface_number_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->interface_number = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* alternate_setting_value = nullptr;
  if (args.Get(2, &alternate_setting_value) &&
      !alternate_setting_value->is_none()) {
    {
      auto temp = alternate_setting_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->alternate_setting = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetInterfaceAlternateSetting

namespace ControlTransfer {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* transfer_info_value = nullptr;
  if (args.Get(1, &transfer_info_value) &&
      !transfer_info_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!transfer_info_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ControlTransferInfo::Populate(*dictionary, &params->transfer_info)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const TransferResultInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace ControlTransfer

namespace BulkTransfer {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* transfer_info_value = nullptr;
  if (args.Get(1, &transfer_info_value) &&
      !transfer_info_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!transfer_info_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!GenericTransferInfo::Populate(*dictionary, &params->transfer_info)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const TransferResultInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace BulkTransfer

namespace InterruptTransfer {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* transfer_info_value = nullptr;
  if (args.Get(1, &transfer_info_value) &&
      !transfer_info_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!transfer_info_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!GenericTransferInfo::Populate(*dictionary, &params->transfer_info)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const TransferResultInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace InterruptTransfer

namespace IsochronousTransfer {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* transfer_info_value = nullptr;
  if (args.Get(1, &transfer_info_value) &&
      !transfer_info_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!transfer_info_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!IsochronousTransferInfo::Populate(*dictionary, &params->transfer_info)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const TransferResultInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace IsochronousTransfer

namespace ResetDevice {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* handle_value = nullptr;
  if (args.Get(0, &handle_value) &&
      !handle_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!handle_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!ConnectionHandle::Populate(*dictionary, &params->handle)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(bool success) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(success)));

  return create_results;
}
}  // namespace ResetDevice

//
// Events
//

namespace OnDeviceAdded {

const char kEventName[] = "usb.onDeviceAdded";

std::vector<base::Value> Create(const Device& device) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((device).ToValue()));

  return create_results;
}

}  // namespace OnDeviceAdded

namespace OnDeviceRemoved {

const char kEventName[] = "usb.onDeviceRemoved";

std::vector<base::Value> Create(const Device& device) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((device).ToValue()));

  return create_results;
}

}  // namespace OnDeviceRemoved

}  // namespace usb
}  // namespace api
}  // namespace extensions

