// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/web_accessible_resources.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/web_accessible_resources.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace web_accessible_resources {
//
// Types
//

WebAccessibleResource::WebAccessibleResource()
 {}

WebAccessibleResource::~WebAccessibleResource() = default;
WebAccessibleResource::WebAccessibleResource(WebAccessibleResource&& rhs) = default;
WebAccessibleResource& WebAccessibleResource::operator=(WebAccessibleResource&& rhs) = default;
// static
constexpr char WebAccessibleResource::kResources[];
// static
constexpr char WebAccessibleResource::kMatches[];
// static
constexpr char WebAccessibleResource::kExtensionIds[];
// static
constexpr char WebAccessibleResource::kUseDynamicUrl[];

// static
bool WebAccessibleResource::Populate(
    const base::Value& value, WebAccessibleResource* out, std::u16string* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = u"expected dictionary, got " + UTF8ToUTF16(base::Value::GetTypeName(value.type()));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* resources_value = dict->FindKey("resources");
  if (!resources_value) {
    DCHECK(error->empty());
    *error = u"'resources' is required";
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!resources_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = u"'resources': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(resources_value->type()));
      return false;
    }
    else {
      std::u16string array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->resources, &array_parse_error)) {
        array_parse_error = u"Error at key 'resources': " + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  const base::Value* matches_value = dict->FindKey("matches");
  if (matches_value) {
    {
      const base::ListValue* list = nullptr;
      if (!matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'matches': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(matches_value->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->matches, &array_parse_error)) {
          array_parse_error = u"Error at key 'matches': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* extension_ids_value = dict->FindKey("extension_ids");
  if (extension_ids_value) {
    {
      const base::ListValue* list = nullptr;
      if (!extension_ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = u"'extension_ids': expected list, got " + UTF8ToUTF16(base::Value::GetTypeName(extension_ids_value->type()));
        return false;
      }
      else {
        std::u16string array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->extension_ids, &array_parse_error)) {
          array_parse_error = u"Error at key 'extension_ids': " + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* use_dynamic_url_value = dict->FindKey("use_dynamic_url");
  if (use_dynamic_url_value) {
    {
      auto temp = use_dynamic_url_value->GetIfBool();
      if (!temp.has_value()) {
        DCHECK(error->empty());
        *error = u"'use_dynamic_url': expected use_dynamic_url, got " + UTF8ToUTF16(base::Value::GetTypeName(use_dynamic_url_value->type()));
        out->use_dynamic_url.reset();
        return false;
      }
      out->use_dynamic_url = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<WebAccessibleResource> WebAccessibleResource::FromValue(const base::Value& value, std::u16string* error) {
  DCHECK(error);
  auto out = std::make_unique<WebAccessibleResource>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> WebAccessibleResource::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resources", json_schema_compiler::util::CreateValueFromArray(this->resources));

  if (this->matches.get()) {
    to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(*this->matches));

  }
  if (this->extension_ids.get()) {
    to_value_result->SetWithoutPathExpansion("extension_ids", json_schema_compiler::util::CreateValueFromArray(*this->extension_ids));

  }
  if (this->use_dynamic_url.get()) {
    to_value_result->SetWithoutPathExpansion("use_dynamic_url", std::make_unique<base::Value>(*this->use_dynamic_url));

  }

  return to_value_result;
}

//static
bool WebAccessibleResource::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, WebAccessibleResource* out, std::u16string* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kResources, &out->resources, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kMatches, &out->matches, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kExtensionIds, &out->extension_ids, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kUseDynamicUrl, &out->use_dynamic_url, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kWebAccessibleResources[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, std::u16string* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kWebAccessibleResources, &out->web_accessible_resources, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace web_accessible_resources
}  // namespace api
}  // namespace extensions

