// extensions/common/mojom/code_injection.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/code_injection.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/code_injection.mojom-params-data.h"
namespace extensions {
namespace mojom {

static NOINLINE const char* CSSInjection_OperationToStringHelper(CSSInjection_Operation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CSSInjection_Operation::kAdd:
      return "kAdd";
    case CSSInjection_Operation::kRemove:
      return "kRemove";
    default:
      return nullptr;
  }
}

std::string CSSInjection_OperationToString(CSSInjection_Operation value) {
  const char *str = CSSInjection_OperationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CSSInjection_Operation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CSSInjection_Operation value) {
  return os << CSSInjection_OperationToString(value);
}

namespace internal {
// static
bool CodeInjection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CodeInjection_Data* object = static_cast<const CodeInjection_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CodeInjection_Tag::CSS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_css, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_css, validation_context))
        return false;
      return true;
    }
    case CodeInjection_Tag::JS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_js, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_js, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CodeInjection");
      return false;
    }
  }
}


// static
bool JSSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const JSSource_Data* object = static_cast<const JSSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams code_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_url, validation_context))
    return false;

  return true;
}

JSSource_Data::JSSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSSSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSSSource_Data* object = static_cast<const CSSSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams code_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

CSSSource_Data::CSSSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool JSInjection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const JSInjection_Data* object = static_cast<const JSInjection_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  return true;
}

JSInjection_Data::JSInjection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSSInjection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSSInjection_Data* object = static_cast<const CSSInjection_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }


  if (!::extensions::mojom::internal::CSSOrigin_Data
        ::Validate(object->css_origin, validation_context))
    return false;


  if (!::extensions::mojom::internal::CSSInjection_Operation_Data
        ::Validate(object->operation, validation_context))
    return false;

  return true;
}

CSSInjection_Data::CSSInjection_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::CSSInjection_Operation>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::CSSInjection_Operation value) {
  return std::move(context).WriteString(::extensions::mojom::CSSInjection_OperationToString(value));
}

} // namespace perfetto
