// extensions/common/mojom/event_dispatcher.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/event_dispatcher.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/event_dispatcher.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool EventFilteringInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventFilteringInfo_Data* object = static_cast<const EventFilteringInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams service_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->service_type, validation_context,
                                         &service_type_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams window_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->window_type, validation_context,
                                         &window_type_validate_params)) {
    return false;
  }

  return true;
}

EventFilteringInfo_Data::EventFilteringInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DispatchEventParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DispatchEventParams_Data* object = static_cast<const DispatchEventParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filtering_info, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filtering_info, validation_context))
    return false;

  return true;
}

DispatchEventParams_Data::DispatchEventParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions
