// extensions/common/mojom/event_dispatcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/event_dispatcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/event_dispatcher.mojom-params-data.h"
#include "extensions/common/mojom/event_dispatcher.mojom-shared-message-ids.h"

#include "extensions/common/mojom/event_dispatcher.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
EventFilteringInfo::EventFilteringInfo()
    : url(),
      service_type(),
      has_instance_id(),
      instance_id(),
      window_type(),
      has_window_exposed_by_default(),
      window_exposed_by_default() {}

EventFilteringInfo::EventFilteringInfo(
    const absl::optional<::GURL>& url_in,
    const absl::optional<std::string>& service_type_in,
    bool has_instance_id_in,
    int32_t instance_id_in,
    const absl::optional<std::string>& window_type_in,
    bool has_window_exposed_by_default_in,
    bool window_exposed_by_default_in)
    : url(std::move(url_in)),
      service_type(std::move(service_type_in)),
      has_instance_id(std::move(has_instance_id_in)),
      instance_id(std::move(instance_id_in)),
      window_type(std::move(window_type_in)),
      has_window_exposed_by_default(std::move(has_window_exposed_by_default_in)),
      window_exposed_by_default(std::move(window_exposed_by_default_in)) {}

EventFilteringInfo::~EventFilteringInfo() = default;

void EventFilteringInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_type"), this->service_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_instance_id"), this->has_instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_type"), this->window_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_window_exposed_by_default"), this->has_window_exposed_by_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_exposed_by_default"), this->window_exposed_by_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventFilteringInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DispatchEventParams::DispatchEventParams()
    : worker_thread_id(),
      extension_id(),
      event_name(),
      event_id(),
      is_user_gesture(),
      filtering_info() {}

DispatchEventParams::DispatchEventParams(
    int32_t worker_thread_id_in,
    const std::string& extension_id_in,
    const std::string& event_name_in,
    int32_t event_id_in,
    bool is_user_gesture_in,
    const ::extensions::EventFilteringInfo& filtering_info_in)
    : worker_thread_id(std::move(worker_thread_id_in)),
      extension_id(std::move(extension_id_in)),
      event_name(std::move(event_name_in)),
      event_id(std::move(event_id_in)),
      is_user_gesture(std::move(is_user_gesture_in)),
      filtering_info(std::move(filtering_info_in)) {}

DispatchEventParams::~DispatchEventParams() = default;

void DispatchEventParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worker_thread_id"), this->worker_thread_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension_id"), this->extension_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_name"), this->event_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_id"), this->event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_user_gesture"), this->is_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_info"), this->filtering_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::extensions::EventFilteringInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DispatchEventParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace extensions

namespace mojo {


// static
bool StructTraits<::extensions::mojom::EventFilteringInfo::DataView, ::extensions::mojom::EventFilteringInfoPtr>::Read(
    ::extensions::mojom::EventFilteringInfo::DataView input,
    ::extensions::mojom::EventFilteringInfoPtr* output) {
  bool success = true;
  ::extensions::mojom::EventFilteringInfoPtr result(::extensions::mojom::EventFilteringInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadServiceType(&result->service_type))
        success = false;
      if (success)
        result->has_instance_id = input.has_instance_id();
      if (success)
        result->instance_id = input.instance_id();
      if (success && !input.ReadWindowType(&result->window_type))
        success = false;
      if (success)
        result->has_window_exposed_by_default = input.has_window_exposed_by_default();
      if (success)
        result->window_exposed_by_default = input.window_exposed_by_default();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::DispatchEventParams::DataView, ::extensions::mojom::DispatchEventParamsPtr>::Read(
    ::extensions::mojom::DispatchEventParams::DataView input,
    ::extensions::mojom::DispatchEventParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::DispatchEventParamsPtr result(::extensions::mojom::DispatchEventParams::New());
  
      if (success)
        result->worker_thread_id = input.worker_thread_id();
      if (success && !input.ReadExtensionId(&result->extension_id))
        success = false;
      if (success && !input.ReadEventName(&result->event_name))
        success = false;
      if (success)
        result->event_id = input.event_id();
      if (success)
        result->is_user_gesture = input.is_user_gesture();
      if (success && !input.ReadFilteringInfo(&result->filtering_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif