// extensions/common/mojom/event_router.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/event_router.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/event_router.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {
// static
bool EventListenerParam_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const EventListenerParam_Data* object = static_cast<const EventListenerParam_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case EventListenerParam_Tag::EXTENSION_ID: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_extension_id, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams extension_id_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_extension_id, validation_context,
                                             &extension_id_validate_params)) {
        return false;
      }
      return true;
    }
    case EventListenerParam_Tag::LISTENER_URL: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_listener_url, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_listener_url, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in EventListenerParam");
      return false;
    }
  }
}


// static
bool EventRouter_AddListenerForMainThread_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_AddListenerForMainThread_Params_Data* object = static_cast<const EventRouter_AddListenerForMainThread_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->param, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->param, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_AddListenerForMainThread_Params_Data::EventRouter_AddListenerForMainThread_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_AddListenerForServiceWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_AddListenerForServiceWorker_Params_Data* object = static_cast<const EventRouter_AddListenerForServiceWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker_scope_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker_scope_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_AddListenerForServiceWorker_Params_Data::EventRouter_AddListenerForServiceWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_AddLazyListenerForMainThread_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_AddLazyListenerForMainThread_Params_Data* object = static_cast<const EventRouter_AddLazyListenerForMainThread_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_AddLazyListenerForMainThread_Params_Data::EventRouter_AddLazyListenerForMainThread_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_AddLazyListenerForServiceWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_AddLazyListenerForServiceWorker_Params_Data* object = static_cast<const EventRouter_AddLazyListenerForServiceWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker_scope_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker_scope_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_AddLazyListenerForServiceWorker_Params_Data::EventRouter_AddLazyListenerForServiceWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_AddFilteredListenerForMainThread_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_AddFilteredListenerForMainThread_Params_Data* object = static_cast<const EventRouter_AddFilteredListenerForMainThread_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

EventRouter_AddFilteredListenerForMainThread_Params_Data::EventRouter_AddFilteredListenerForMainThread_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_AddFilteredListenerForServiceWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_AddFilteredListenerForServiceWorker_Params_Data* object = static_cast<const EventRouter_AddFilteredListenerForServiceWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker_scope_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker_scope_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

EventRouter_AddFilteredListenerForServiceWorker_Params_Data::EventRouter_AddFilteredListenerForServiceWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_RemoveListenerForMainThread_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_RemoveListenerForMainThread_Params_Data* object = static_cast<const EventRouter_RemoveListenerForMainThread_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->param, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->param, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_RemoveListenerForMainThread_Params_Data::EventRouter_RemoveListenerForMainThread_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_RemoveListenerForServiceWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_RemoveListenerForServiceWorker_Params_Data* object = static_cast<const EventRouter_RemoveListenerForServiceWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker_scope_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker_scope_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_RemoveListenerForServiceWorker_Params_Data::EventRouter_RemoveListenerForServiceWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_RemoveLazyListenerForMainThread_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_RemoveLazyListenerForMainThread_Params_Data* object = static_cast<const EventRouter_RemoveLazyListenerForMainThread_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_RemoveLazyListenerForMainThread_Params_Data::EventRouter_RemoveLazyListenerForMainThread_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_RemoveLazyListenerForServiceWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_RemoveLazyListenerForServiceWorker_Params_Data* object = static_cast<const EventRouter_RemoveLazyListenerForServiceWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker_scope_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker_scope_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  return true;
}

EventRouter_RemoveLazyListenerForServiceWorker_Params_Data::EventRouter_RemoveLazyListenerForServiceWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_RemoveFilteredListenerForMainThread_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_RemoveFilteredListenerForMainThread_Params_Data* object = static_cast<const EventRouter_RemoveFilteredListenerForMainThread_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

EventRouter_RemoveFilteredListenerForMainThread_Params_Data::EventRouter_RemoveFilteredListenerForMainThread_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data* object = static_cast<const EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker_scope_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker_scope_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams event_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data::EventRouter_RemoveFilteredListenerForServiceWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions
