// extensions/common/mojom/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/frame.mojom-params-data.h"
#include "extensions/common/mojom/frame.mojom-shared-message-ids.h"

#include "extensions/common/mojom/frame.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
ExecuteCodeParams::ExecuteCodeParams()
    : host_id(),
      injection(),
      webview_src(),
      match_about_blank(),
      run_at(),
      is_web_view() {}

ExecuteCodeParams::ExecuteCodeParams(
    ::extensions::mojom::HostIDPtr host_id_in,
    ::extensions::mojom::CodeInjectionPtr injection_in,
    const ::GURL& webview_src_in,
    bool match_about_blank_in,
    ::extensions::mojom::RunLocation run_at_in,
    bool is_web_view_in)
    : host_id(std::move(host_id_in)),
      injection(std::move(injection_in)),
      webview_src(std::move(webview_src_in)),
      match_about_blank(std::move(match_about_blank_in)),
      run_at(std::move(run_at_in)),
      is_web_view(std::move(is_web_view_in)) {}

ExecuteCodeParams::~ExecuteCodeParams() = default;

void ExecuteCodeParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_id"), this->host_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::HostIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injection"), this->injection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::CodeInjectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webview_src"), this->webview_src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_about_blank"), this->match_about_blank,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "run_at"), this->run_at,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::RunLocation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_web_view"), this->is_web_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExecuteCodeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestParams::RequestParams()
    : name(),
      arguments(),
      extension_id(),
      source_url(),
      request_id(),
      has_callback(),
      user_gesture(),
      worker_thread_id(),
      service_worker_version_id() {}

RequestParams::RequestParams(
    const std::string& name_in,
    ::base::Value arguments_in,
    const std::string& extension_id_in,
    const ::GURL& source_url_in,
    int32_t request_id_in,
    bool has_callback_in,
    bool user_gesture_in,
    int32_t worker_thread_id_in,
    int64_t service_worker_version_id_in)
    : name(std::move(name_in)),
      arguments(std::move(arguments_in)),
      extension_id(std::move(extension_id_in)),
      source_url(std::move(source_url_in)),
      request_id(std::move(request_id_in)),
      has_callback(std::move(has_callback_in)),
      user_gesture(std::move(user_gesture_in)),
      worker_thread_id(std::move(worker_thread_id_in)),
      service_worker_version_id(std::move(service_worker_version_id_in)) {}

RequestParams::~RequestParams() = default;

void RequestParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "arguments"), this->arguments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension_id"), this->extension_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_url"), this->source_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_callback"), this->has_callback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worker_thread_id"), this->worker_thread_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_version_id"), this->service_worker_version_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char LocalFrame::Name_[] = "extensions.mojom.LocalFrame";

class LocalFrame_ExecuteCode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_ExecuteCode_ForwardToCallback(
      LocalFrame::ExecuteCodeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::ExecuteCodeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_ExecuteCode_ForwardToCallback);
};

LocalFrameProxy::LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameProxy::SetFrameName(
    const std::string& in_frame_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::SetFrameName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_name"), in_frame_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SetFrameName_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetFrameName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_name)::BaseType> frame_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_name, frame_name_fragment);
  params->frame_name.Set(
      frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_name in LocalFrame.SetFrameName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetFrameName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SetSpatialNavigationEnabled(
    bool in_spatial_nav_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::SetSpatialNavigationEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("spatial_nav_enabled"), in_spatial_nav_enabled,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SetSpatialNavigationEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->spatial_nav_enabled = in_spatial_nav_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetSpatialNavigationEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SetTabId(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::SetTabId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_SetTabId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetTabId_Params_Data> params(
          message);
  params.Allocate();
  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetTabId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AppWindowClosed(
    bool in_send_onclosed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::AppWindowClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_onclosed"), in_send_onclosed,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_AppWindowClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_AppWindowClosed_Params_Data> params(
          message);
  params.Allocate();
  params->send_onclosed = in_send_onclosed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AppWindowClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::NotifyRenderViewType(
    ::extensions::mojom::ViewType in_view_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::NotifyRenderViewType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_type"), in_view_type,
                        "<value of type ::extensions::mojom::ViewType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_NotifyRenderViewType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_NotifyRenderViewType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::extensions::mojom::ViewType>(
      in_view_type, &params->view_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyRenderViewType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::MessageInvoke(
    const std::string& in_extension_id, const std::string& in_module_name, const std::string& in_function_name, ::base::Value in_args) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::MessageInvoke", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("function_name"), in_function_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_MessageInvoke_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_MessageInvoke_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in LocalFrame.MessageInvoke request");
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_module_name, module_name_fragment);
  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->module_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null module_name in LocalFrame.MessageInvoke request");
  mojo::internal::MessageFragment<
      typename decltype(params->function_name)::BaseType> function_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_function_name, function_name_fragment);
  params->function_name.Set(
      function_name_fragment.is_null() ? nullptr : function_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->function_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null function_name in LocalFrame.MessageInvoke request");
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in LocalFrame.MessageInvoke request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MessageInvoke");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ExecuteCode(
    ExecuteCodeParamsPtr in_param, ExecuteCodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::ExecuteCode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("param"), in_param,
                        "<value of type ExecuteCodeParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_ExecuteCode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_ExecuteCode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->param)::BaseType> param_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::ExecuteCodeParamsDataView>(
      in_param, param_fragment);
  params->param.Set(
      param_fragment.is_null() ? nullptr : param_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->param.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null param in LocalFrame.ExecuteCode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExecuteCode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_ExecuteCode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::ExecuteDeclarativeScript(
    int32_t in_tab_id, const std::string& in_extension_id, const std::string& in_script_id, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::ExecuteDeclarativeScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_id"), in_script_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_ExecuteDeclarativeScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_ExecuteDeclarativeScript_Params_Data> params(
          message);
  params.Allocate();
  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in LocalFrame.ExecuteDeclarativeScript request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_id)::BaseType> script_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_script_id, script_id_fragment);
  params->script_id.Set(
      script_id_fragment.is_null() ? nullptr : script_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_id in LocalFrame.ExecuteDeclarativeScript request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrame.ExecuteDeclarativeScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExecuteDeclarativeScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalFrame_ExecuteCode_ProxyToResponder {
 public:
  static LocalFrame::ExecuteCodeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_ExecuteCode_ProxyToResponder> proxy(
        new LocalFrame_ExecuteCode_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_ExecuteCode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_ExecuteCode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_ExecuteCode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::ExecuteCodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_error, const ::GURL& in_url, absl::optional<::base::Value> in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_ExecuteCode_ProxyToResponder);
};

bool LocalFrame_ExecuteCode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::LocalFrame::ExecuteCodeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrame_ExecuteCode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_ExecuteCode_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_error{};
  ::GURL p_url{};
  absl::optional<::base::Value> p_result{};
  LocalFrame_ExecuteCode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_url), 
std::move(p_result));
  return true;
}

void LocalFrame_ExecuteCode_ProxyToResponder::Run(
    const std::string& in_error, const ::GURL& in_url, absl::optional<::base::Value> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)extensions::mojom::LocalFrame::ExecuteCodeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type absl::optional<::base::Value>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrame_ExecuteCode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_ExecuteCode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ");
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::LocalFrame::ExecuteCodeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExecuteCode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameStubDispatch::Accept(
    LocalFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalFrame_SetFrameName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::SetFrameName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::SetFrameName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetFrameName_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetFrameName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_frame_name{};
      LocalFrame_SetFrameName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameName(&p_frame_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameName(
std::move(p_frame_name));
      return true;
    }
    case internal::kLocalFrame_SetSpatialNavigationEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::SetSpatialNavigationEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::SetSpatialNavigationEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_spatial_nav_enabled{};
      LocalFrame_SetSpatialNavigationEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_spatial_nav_enabled = input_data_view.spatial_nav_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSpatialNavigationEnabled(
std::move(p_spatial_nav_enabled));
      return true;
    }
    case internal::kLocalFrame_SetTabId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::SetTabId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::SetTabId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetTabId_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetTabId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_tab_id{};
      LocalFrame_SetTabId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTabId(
std::move(p_tab_id));
      return true;
    }
    case internal::kLocalFrame_AppWindowClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::AppWindowClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::AppWindowClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AppWindowClosed_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AppWindowClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_send_onclosed{};
      LocalFrame_AppWindowClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_send_onclosed = input_data_view.send_onclosed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AppWindowClosed(
std::move(p_send_onclosed));
      return true;
    }
    case internal::kLocalFrame_NotifyRenderViewType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::NotifyRenderViewType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::NotifyRenderViewType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyRenderViewType_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyRenderViewType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::extensions::mojom::ViewType p_view_type{};
      LocalFrame_NotifyRenderViewType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViewType(&p_view_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyRenderViewType(
std::move(p_view_type));
      return true;
    }
    case internal::kLocalFrame_MessageInvoke_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::MessageInvoke",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::MessageInvoke");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_MessageInvoke_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MessageInvoke_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      std::string p_module_name{};
      std::string p_function_name{};
      ::base::Value p_args{};
      LocalFrame_MessageInvoke_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadFunctionName(&p_function_name))
        success = false;
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MessageInvoke(
std::move(p_extension_id), 
std::move(p_module_name), 
std::move(p_function_name), 
std::move(p_args));
      return true;
    }
    case internal::kLocalFrame_ExecuteCode_Name: {
      break;
    }
    case internal::kLocalFrame_ExecuteDeclarativeScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::ExecuteDeclarativeScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::ExecuteDeclarativeScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ExecuteDeclarativeScript_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ExecuteDeclarativeScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_tab_id{};
      std::string p_extension_id{};
      std::string p_script_id{};
      ::GURL p_url{};
      LocalFrame_ExecuteDeclarativeScript_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadScriptId(&p_script_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteDeclarativeScript(
std::move(p_tab_id), 
std::move(p_extension_id), 
std::move(p_script_id), 
std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool LocalFrameStubDispatch::AcceptWithResponder(
    LocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrame_SetFrameName_Name: {
      break;
    }
    case internal::kLocalFrame_SetSpatialNavigationEnabled_Name: {
      break;
    }
    case internal::kLocalFrame_SetTabId_Name: {
      break;
    }
    case internal::kLocalFrame_AppWindowClosed_Name: {
      break;
    }
    case internal::kLocalFrame_NotifyRenderViewType_Name: {
      break;
    }
    case internal::kLocalFrame_MessageInvoke_Name: {
      break;
    }
    case internal::kLocalFrame_ExecuteCode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::ExecuteCode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::ExecuteCode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_ExecuteCode_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_ExecuteCode_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ExecuteCodeParamsPtr p_param{};
      LocalFrame_ExecuteCode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParam(&p_param))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 6, false);
        return false;
      }
      LocalFrame::ExecuteCodeCallback callback =
          LocalFrame_ExecuteCode_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteCode(
std::move(p_param), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_ExecuteDeclarativeScript_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameValidationInfo[] = {
    {internal::kLocalFrame_SetFrameName_Name,
     {&internal::LocalFrame_SetFrameName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SetSpatialNavigationEnabled_Name,
     {&internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SetTabId_Name,
     {&internal::LocalFrame_SetTabId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AppWindowClosed_Name,
     {&internal::LocalFrame_AppWindowClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_NotifyRenderViewType_Name,
     {&internal::LocalFrame_NotifyRenderViewType_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_MessageInvoke_Name,
     {&internal::LocalFrame_MessageInvoke_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ExecuteCode_Name,
     {&internal::LocalFrame_ExecuteCode_Params_Data::Validate,
      &internal::LocalFrame_ExecuteCode_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_ExecuteDeclarativeScript_Name,
     {&internal::LocalFrame_ExecuteDeclarativeScript_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::LocalFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameValidationInfo);
}

bool LocalFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::LocalFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalFrameValidationInfo);

}
const char LocalFrameHost::Name_[] = "extensions.mojom.LocalFrameHost";

class LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback(
      LocalFrameHost::RequestScriptInjectionPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RequestScriptInjectionPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback);
};

class LocalFrameHost_GetAppInstallState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_GetAppInstallState_ForwardToCallback(
      LocalFrameHost::GetAppInstallStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::GetAppInstallStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_GetAppInstallState_ForwardToCallback);
};

class LocalFrameHost_Request_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_Request_ForwardToCallback(
      LocalFrameHost::RequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_Request_ForwardToCallback);
};

LocalFrameHostProxy::LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameHostProxy::RequestScriptInjectionPermission(
    const std::string& in_extension_id, ::extensions::mojom::InjectionType in_script_type, ::extensions::mojom::RunLocation in_run_location, RequestScriptInjectionPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_type"), in_script_type,
                        "<value of type ::extensions::mojom::InjectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("run_location"), in_run_location,
                        "<value of type ::extensions::mojom::RunLocation>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RequestScriptInjectionPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in LocalFrameHost.RequestScriptInjectionPermission request");
  mojo::internal::Serialize<::extensions::mojom::InjectionType>(
      in_script_type, &params->script_type);
  mojo::internal::Serialize<::extensions::mojom::RunLocation>(
      in_run_location, &params->run_location);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RequestScriptInjectionPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::GetAppInstallState(
    const ::GURL& in_url, GetAppInstallStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrameHost::GetAppInstallState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_GetAppInstallState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_GetAppInstallState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.GetAppInstallState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GetAppInstallState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_GetAppInstallState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::Request(
    RequestParamsPtr in_params, RequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrameHost::Request", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type RequestParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_Request_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_Request_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::RequestParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.Request request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Request");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_Request_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::WatchedPageChange(
    const std::vector<std::string>& in_css_selectors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrameHost::WatchedPageChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("css_selectors"), in_css_selectors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_WatchedPageChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_WatchedPageChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->css_selectors)::BaseType>
      css_selectors_fragment(params.message());
  const mojo::internal::ContainerValidateParams css_selectors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_css_selectors, css_selectors_fragment, &css_selectors_validate_params);
  params->css_selectors.Set(
      css_selectors_fragment.is_null() ? nullptr : css_selectors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->css_selectors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null css_selectors in LocalFrameHost.WatchedPageChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("WatchedPageChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder {
 public:
  static LocalFrameHost::RequestScriptInjectionPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder> proxy(
        new LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RequestScriptInjectionPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_granted);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder);
};

bool LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::LocalFrameHost::RequestScriptInjectionPermissionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_granted{};
  LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted = input_data_view.granted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_granted));
  return true;
}

void LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder::Run(
    bool in_granted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)extensions::mojom::LocalFrameHost::RequestScriptInjectionPermissionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted"), in_granted,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_RequestScriptInjectionPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->granted = in_granted;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::LocalFrameHost::RequestScriptInjectionPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RequestScriptInjectionPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_GetAppInstallState_ProxyToResponder {
 public:
  static LocalFrameHost::GetAppInstallStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_GetAppInstallState_ProxyToResponder> proxy(
        new LocalFrameHost_GetAppInstallState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_GetAppInstallState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_GetAppInstallState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_GetAppInstallState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::GetAppInstallStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_GetAppInstallState_ProxyToResponder);
};

bool LocalFrameHost_GetAppInstallState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::LocalFrameHost::GetAppInstallStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_state{};
  LocalFrameHost_GetAppInstallState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_state));
  return true;
}

void LocalFrameHost_GetAppInstallState_ProxyToResponder::Run(
    const std::string& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)extensions::mojom::LocalFrameHost::GetAppInstallStateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_GetAppInstallState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::LocalFrameHost::GetAppInstallStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GetAppInstallState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_Request_ProxyToResponder {
 public:
  static LocalFrameHost::RequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_Request_ProxyToResponder> proxy(
        new LocalFrameHost_Request_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_Request_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_Request_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_Request_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::base::Value in_response_wrapper, const std::string& in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_Request_ProxyToResponder);
};

bool LocalFrameHost_Request_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mojom::LocalFrameHost::RequestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_Request_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_Request_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  ::base::Value p_response_wrapper{};
  std::string p_error{};
  LocalFrameHost_Request_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResponseWrapper(&p_response_wrapper))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_response_wrapper), 
std::move(p_error));
  return true;
}

void LocalFrameHost_Request_ProxyToResponder::Run(
    bool in_success, ::base::Value in_response_wrapper, const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)extensions::mojom::LocalFrameHost::RequestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_wrapper"), in_response_wrapper,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLocalFrameHost_Request_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_Request_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->response_wrapper)::BaseType> response_wrapper_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_response_wrapper, response_wrapper_fragment);
  params->response_wrapper.Set(
      response_wrapper_fragment.is_null() ? nullptr : response_wrapper_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_wrapper.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_wrapper in ");
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mojom::LocalFrameHost::RequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Request");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameHostStubDispatch::Accept(
    LocalFrameHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalFrameHost_RequestScriptInjectionPermission_Name: {
      break;
    }
    case internal::kLocalFrameHost_GetAppInstallState_Name: {
      break;
    }
    case internal::kLocalFrameHost_Request_Name: {
      break;
    }
    case internal::kLocalFrameHost_WatchedPageChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrameHost::WatchedPageChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrameHost::WatchedPageChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_WatchedPageChange_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_WatchedPageChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_css_selectors{};
      LocalFrameHost_WatchedPageChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCssSelectors(&p_css_selectors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WatchedPageChange(
std::move(p_css_selectors));
      return true;
    }
  }
  return false;
}

// static
bool LocalFrameHostStubDispatch::AcceptWithResponder(
    LocalFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrameHost_RequestScriptInjectionPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      ::extensions::mojom::InjectionType p_script_type{};
      ::extensions::mojom::RunLocation p_run_location{};
      LocalFrameHost_RequestScriptInjectionPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadScriptType(&p_script_type))
        success = false;
      if (success && !input_data_view.ReadRunLocation(&p_run_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 0, false);
        return false;
      }
      LocalFrameHost::RequestScriptInjectionPermissionCallback callback =
          LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestScriptInjectionPermission(
std::move(p_extension_id), 
std::move(p_script_type), 
std::move(p_run_location), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_GetAppInstallState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrameHost::GetAppInstallState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrameHost::GetAppInstallState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_GetAppInstallState_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_GetAppInstallState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      LocalFrameHost_GetAppInstallState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 1, false);
        return false;
      }
      LocalFrameHost::GetAppInstallStateCallback callback =
          LocalFrameHost_GetAppInstallState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAppInstallState(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_Request_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrameHost::Request",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrameHost::Request");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_Request_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_Request_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RequestParamsPtr p_params{};
      LocalFrameHost_Request_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 2, false);
        return false;
      }
      LocalFrameHost::RequestCallback callback =
          LocalFrameHost_Request_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Request(
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_WatchedPageChange_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameHostValidationInfo[] = {
    {internal::kLocalFrameHost_RequestScriptInjectionPermission_Name,
     {&internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data::Validate,
      &internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_GetAppInstallState_Name,
     {&internal::LocalFrameHost_GetAppInstallState_Params_Data::Validate,
      &internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_Request_Name,
     {&internal::LocalFrameHost_Request_Params_Data::Validate,
      &internal::LocalFrameHost_Request_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_WatchedPageChange_Name,
     {&internal::LocalFrameHost_WatchedPageChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::LocalFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameHostValidationInfo);
}

bool LocalFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::LocalFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalFrameHostValidationInfo);

}
}  // namespace mojom
}  // namespace extensions

namespace mojo {


// static
bool StructTraits<::extensions::mojom::ExecuteCodeParams::DataView, ::extensions::mojom::ExecuteCodeParamsPtr>::Read(
    ::extensions::mojom::ExecuteCodeParams::DataView input,
    ::extensions::mojom::ExecuteCodeParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::ExecuteCodeParamsPtr result(::extensions::mojom::ExecuteCodeParams::New());
  
      if (success && !input.ReadHostId(&result->host_id))
        success = false;
      if (success && !input.ReadInjection(&result->injection))
        success = false;
      if (success && !input.ReadWebviewSrc(&result->webview_src))
        success = false;
      if (success)
        result->match_about_blank = input.match_about_blank();
      if (success && !input.ReadRunAt(&result->run_at))
        success = false;
      if (success)
        result->is_web_view = input.is_web_view();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::RequestParams::DataView, ::extensions::mojom::RequestParamsPtr>::Read(
    ::extensions::mojom::RequestParams::DataView input,
    ::extensions::mojom::RequestParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::RequestParamsPtr result(::extensions::mojom::RequestParams::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadArguments(&result->arguments))
        success = false;
      if (success && !input.ReadExtensionId(&result->extension_id))
        success = false;
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->has_callback = input.has_callback();
      if (success)
        result->user_gesture = input.user_gesture();
      if (success)
        result->worker_thread_id = input.worker_thread_id();
      if (success)
        result->service_worker_version_id = input.service_worker_version_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif