// extensions/common/mojom/renderer.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "extensions/common/mojom/renderer.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "extensions/common/mojom/activation_sequence.mojom.h"
#include "extensions/common/mojom/api_permission_id.mojom.h"
#include "extensions/common/mojom/channel.mojom.h"
#include "extensions/common/mojom/host_id.mojom.h"
#include "extensions/common/mojom/feature_session_type.mojom.h"
#include "extensions/common/mojom/manifest.mojom.h"
#include "extensions/common/mojom/permission_set.mojom.h"
#include "extensions/common/mojom/url_pattern_set.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"


#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_JUMBO_H_
#endif


namespace extensions {
namespace mojom {


void RendererInterceptorForTesting::ActivateExtension(const std::string& extension_id) {
  GetForwardingInterface()->ActivateExtension(std::move(extension_id));
}
void RendererInterceptorForTesting::SetActivityLoggingEnabled(bool enabled) {
  GetForwardingInterface()->SetActivityLoggingEnabled(std::move(enabled));
}
void RendererInterceptorForTesting::LoadExtensions(std::vector<ExtensionLoadedParamsPtr> params) {
  GetForwardingInterface()->LoadExtensions(std::move(params));
}
void RendererInterceptorForTesting::UnloadExtension(const std::string& extension_id) {
  GetForwardingInterface()->UnloadExtension(std::move(extension_id));
}
void RendererInterceptorForTesting::SuspendExtension(const std::string& extension_id, SuspendExtensionCallback callback) {
  GetForwardingInterface()->SuspendExtension(std::move(extension_id), std::move(callback));
}
void RendererInterceptorForTesting::CancelSuspendExtension(const std::string& extension_id) {
  GetForwardingInterface()->CancelSuspendExtension(std::move(extension_id));
}
void RendererInterceptorForTesting::SetSessionInfo(version_info::Channel channel, ::extensions::mojom::FeatureSessionType session, bool is_lock_screen_context) {
  GetForwardingInterface()->SetSessionInfo(std::move(channel), std::move(session), std::move(is_lock_screen_context));
}
void RendererInterceptorForTesting::SetSystemFont(const std::string& font_family, const std::string& font_size) {
  GetForwardingInterface()->SetSystemFont(std::move(font_family), std::move(font_size));
}
void RendererInterceptorForTesting::SetWebViewPartitionID(const std::string& partition_id) {
  GetForwardingInterface()->SetWebViewPartitionID(std::move(partition_id));
}
void RendererInterceptorForTesting::SetScriptingAllowlist(const std::vector<std::string>& extension_ids) {
  GetForwardingInterface()->SetScriptingAllowlist(std::move(extension_ids));
}
void RendererInterceptorForTesting::ShouldSuspend(ShouldSuspendCallback callback) {
  GetForwardingInterface()->ShouldSuspend(std::move(callback));
}
void RendererInterceptorForTesting::TransferBlobs(TransferBlobsCallback callback) {
  GetForwardingInterface()->TransferBlobs(std::move(callback));
}
void RendererInterceptorForTesting::UpdatePermissions(const std::string& extension_id, ::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions, ::extensions::URLPatternSet policy_blocked_hosts, ::extensions::URLPatternSet policy_allowed_hosts, bool uses_default_policy_host_restrictions) {
  GetForwardingInterface()->UpdatePermissions(std::move(extension_id), std::move(active_permissions), std::move(withheld_permissions), std::move(policy_blocked_hosts), std::move(policy_allowed_hosts), std::move(uses_default_policy_host_restrictions));
}
void RendererInterceptorForTesting::UpdateDefaultPolicyHostRestrictions(::extensions::URLPatternSet default_policy_blocked_hosts, ::extensions::URLPatternSet default_policy_allowed_hosts) {
  GetForwardingInterface()->UpdateDefaultPolicyHostRestrictions(std::move(default_policy_blocked_hosts), std::move(default_policy_allowed_hosts));
}
void RendererInterceptorForTesting::UpdateTabSpecificPermissions(const std::string& extension_id, ::extensions::URLPatternSet new_hosts, int32_t tab_id, bool update_origin_whitelist) {
  GetForwardingInterface()->UpdateTabSpecificPermissions(std::move(extension_id), std::move(new_hosts), std::move(tab_id), std::move(update_origin_whitelist));
}
void RendererInterceptorForTesting::UpdateUserScripts(::base::ReadOnlySharedMemoryRegion region, ::extensions::mojom::HostIDPtr owner) {
  GetForwardingInterface()->UpdateUserScripts(std::move(region), std::move(owner));
}
void RendererInterceptorForTesting::ClearTabSpecificPermissions(const std::vector<std::string>& extension_ids, int32_t tab_id, bool update_origin_whitelist) {
  GetForwardingInterface()->ClearTabSpecificPermissions(std::move(extension_ids), std::move(tab_id), std::move(update_origin_whitelist));
}
void RendererInterceptorForTesting::WatchPages(const std::vector<std::string>& css_selectors) {
  GetForwardingInterface()->WatchPages(std::move(css_selectors));
}
RendererAsyncWaiter::RendererAsyncWaiter(
    Renderer* proxy) : proxy_(proxy) {}

RendererAsyncWaiter::~RendererAsyncWaiter() = default;

void RendererAsyncWaiter::SuspendExtension(
    const std::string& extension_id) {
  base::RunLoop loop;
  proxy_->SuspendExtension(std::move(extension_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void RendererAsyncWaiter::ShouldSuspend(
    ) {
  base::RunLoop loop;
  proxy_->ShouldSuspend(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void RendererAsyncWaiter::TransferBlobs(
    ) {
  base::RunLoop loop;
  proxy_->TransferBlobs(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace extensions

#if defined(__clang__)
#pragma clang diagnostic pop
#endif