// extensions/common/mojom/view_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/view_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/view_type.mojom-params-data.h"
namespace extensions {
namespace mojom {

static NOINLINE const char* ViewTypeToStringHelper(ViewType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ViewType::kInvalid:
      return "kInvalid";
    case ViewType::kAppWindow:
      return "kAppWindow";
    case ViewType::kBackgroundContents:
      return "kBackgroundContents";
    case ViewType::kComponent:
      return "kComponent";
    case ViewType::kExtensionBackgroundPage:
      return "kExtensionBackgroundPage";
    case ViewType::kExtensionDialog:
      return "kExtensionDialog";
    case ViewType::kExtensionGuest:
      return "kExtensionGuest";
    case ViewType::kExtensionPopup:
      return "kExtensionPopup";
    case ViewType::kTabContents:
      return "kTabContents";
    default:
      return nullptr;
  }
}

std::string ViewTypeToString(ViewType value) {
  const char *str = ViewTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ViewType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ViewType value) {
  return os << ViewTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::ViewType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::ViewType value) {
  return std::move(context).WriteString(::extensions::mojom::ViewTypeToString(value));
}

} // namespace perfetto
