// gpu/ipc/common/gpu_channel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_channel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_channel.mojom-params-data.h"
#include "gpu/ipc/common/gpu_channel.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_channel.mojom-import-headers.h"


#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_JUMBO_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
ContextCreationAttribs::ContextCreationAttribs()
    : offscreen_framebuffer_size(),
      gpu_preference(mojo::internal::ConvertEnumValue<::gl::mojom::GpuPreference, ::gl::GpuPreference>(::gl::mojom::GpuPreference::kLowPower)),
      alpha_size(-1),
      blue_size(-1),
      green_size(-1),
      red_size(-1),
      depth_size(-1),
      stencil_size(-1),
      samples(-1),
      sample_buffers(-1),
      buffer_preserved(true),
      bind_generates_resource(true),
      fail_if_major_perf_caveat(false),
      lose_context_when_out_of_memory(false),
      should_use_native_gmb_for_backbuffer(false),
      own_offscreen_surface(false),
      single_buffer(false),
      enable_gles2_interface(true),
      enable_grcontext(false),
      enable_raster_interface(false),
      enable_oop_rasterization(false),
      enable_swap_timestamps_if_supported(false),
      context_type(mojo::internal::ConvertEnumValue<ContextType, ::gpu::ContextType>(ContextType::kOpenGLES2)),
      color_space(ContextColorSpace::kUnspecified) {}

ContextCreationAttribs::ContextCreationAttribs(
    const ::gfx::Size& offscreen_framebuffer_size_in,
    ::gl::GpuPreference gpu_preference_in,
    int32_t alpha_size_in,
    int32_t blue_size_in,
    int32_t green_size_in,
    int32_t red_size_in,
    int32_t depth_size_in,
    int32_t stencil_size_in,
    int32_t samples_in,
    int32_t sample_buffers_in,
    bool buffer_preserved_in,
    bool bind_generates_resource_in,
    bool fail_if_major_perf_caveat_in,
    bool lose_context_when_out_of_memory_in,
    bool should_use_native_gmb_for_backbuffer_in,
    bool own_offscreen_surface_in,
    bool single_buffer_in,
    bool enable_gles2_interface_in,
    bool enable_grcontext_in,
    bool enable_raster_interface_in,
    bool enable_oop_rasterization_in,
    bool enable_swap_timestamps_if_supported_in,
    ::gpu::ContextType context_type_in,
    ContextColorSpace color_space_in)
    : offscreen_framebuffer_size(std::move(offscreen_framebuffer_size_in)),
      gpu_preference(std::move(gpu_preference_in)),
      alpha_size(std::move(alpha_size_in)),
      blue_size(std::move(blue_size_in)),
      green_size(std::move(green_size_in)),
      red_size(std::move(red_size_in)),
      depth_size(std::move(depth_size_in)),
      stencil_size(std::move(stencil_size_in)),
      samples(std::move(samples_in)),
      sample_buffers(std::move(sample_buffers_in)),
      buffer_preserved(std::move(buffer_preserved_in)),
      bind_generates_resource(std::move(bind_generates_resource_in)),
      fail_if_major_perf_caveat(std::move(fail_if_major_perf_caveat_in)),
      lose_context_when_out_of_memory(std::move(lose_context_when_out_of_memory_in)),
      should_use_native_gmb_for_backbuffer(std::move(should_use_native_gmb_for_backbuffer_in)),
      own_offscreen_surface(std::move(own_offscreen_surface_in)),
      single_buffer(std::move(single_buffer_in)),
      enable_gles2_interface(std::move(enable_gles2_interface_in)),
      enable_grcontext(std::move(enable_grcontext_in)),
      enable_raster_interface(std::move(enable_raster_interface_in)),
      enable_oop_rasterization(std::move(enable_oop_rasterization_in)),
      enable_swap_timestamps_if_supported(std::move(enable_swap_timestamps_if_supported_in)),
      context_type(std::move(context_type_in)),
      color_space(std::move(color_space_in)) {}

ContextCreationAttribs::~ContextCreationAttribs() = default;

void ContextCreationAttribs::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offscreen_framebuffer_size"), this->offscreen_framebuffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_preference"), this->gpu_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gl::GpuPreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_size"), this->alpha_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blue_size"), this->blue_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "green_size"), this->green_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "red_size"), this->red_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_size"), this->depth_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stencil_size"), this->stencil_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samples"), this->samples,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_buffers"), this->sample_buffers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_preserved"), this->buffer_preserved,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bind_generates_resource"), this->bind_generates_resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fail_if_major_perf_caveat"), this->fail_if_major_perf_caveat,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lose_context_when_out_of_memory"), this->lose_context_when_out_of_memory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_use_native_gmb_for_backbuffer"), this->should_use_native_gmb_for_backbuffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "own_offscreen_surface"), this->own_offscreen_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "single_buffer"), this->single_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gles2_interface"), this->enable_gles2_interface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_grcontext"), this->enable_grcontext,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_raster_interface"), this->enable_raster_interface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_oop_rasterization"), this->enable_oop_rasterization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_swap_timestamps_if_supported"), this->enable_swap_timestamps_if_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_type"), this->context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::ContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContextColorSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContextCreationAttribs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateCommandBufferParams::CreateCommandBufferParams()
    : surface_handle(),
      share_group_id(),
      stream_id(),
      stream_priority(),
      attribs(),
      active_url() {}

CreateCommandBufferParams::CreateCommandBufferParams(
    ::gpu::SurfaceHandle surface_handle_in,
    int32_t share_group_id_in,
    int32_t stream_id_in,
    ::gpu::SchedulingPriority stream_priority_in,
    const ::gpu::ContextCreationAttribs& attribs_in,
    const ::GURL& active_url_in)
    : surface_handle(std::move(surface_handle_in)),
      share_group_id(std::move(share_group_id_in)),
      stream_id(std::move(stream_id_in)),
      stream_priority(std::move(stream_priority_in)),
      attribs(std::move(attribs_in)),
      active_url(std::move(active_url_in)) {}

CreateCommandBufferParams::~CreateCommandBufferParams() = default;

void CreateCommandBufferParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_handle"), this->surface_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::SurfaceHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_group_id"), this->share_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_id"), this->stream_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_priority"), this->stream_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::SchedulingPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribs"), this->attribs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::ContextCreationAttribs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_url"), this->active_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateCommandBufferParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommandBufferState::CommandBufferState()
    : get_offset(),
      token(),
      release_count(),
      error(),
      context_lost_reason(),
      generation(),
      set_get_buffer_count() {}

CommandBufferState::CommandBufferState(
    int32_t get_offset_in,
    int32_t token_in,
    uint64_t release_count_in,
    ::gpu::error::Error error_in,
    ::gpu::error::ContextLostReason context_lost_reason_in,
    uint32_t generation_in,
    uint32_t set_get_buffer_count_in)
    : get_offset(std::move(get_offset_in)),
      token(std::move(token_in)),
      release_count(std::move(release_count_in)),
      error(std::move(error_in)),
      context_lost_reason(std::move(context_lost_reason_in)),
      generation(std::move(generation_in)),
      set_get_buffer_count(std::move(set_get_buffer_count_in)) {}

CommandBufferState::~CommandBufferState() = default;

void CommandBufferState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_offset"), this->get_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_count"), this->release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::error::Error>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_lost_reason"), this->context_lost_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::error::ContextLostReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generation"), this->generation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "set_get_buffer_count"), this->set_get_buffer_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommandBufferState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScheduleImageDecodeParams::ScheduleImageDecodeParams()
    : encoded_data(),
      output_size(),
      raster_decoder_route_id(),
      transfer_cache_entry_id(),
      discardable_handle_shm_id(),
      discardable_handle_shm_offset(),
      discardable_handle_release_count(),
      target_color_space(),
      needs_mips() {}

ScheduleImageDecodeParams::ScheduleImageDecodeParams(
    std::vector<uint8_t> encoded_data_in,
    const ::gfx::Size& output_size_in,
    int32_t raster_decoder_route_id_in,
    uint32_t transfer_cache_entry_id_in,
    int32_t discardable_handle_shm_id_in,
    uint32_t discardable_handle_shm_offset_in,
    uint64_t discardable_handle_release_count_in,
    const ::gfx::ColorSpace& target_color_space_in,
    bool needs_mips_in)
    : encoded_data(std::move(encoded_data_in)),
      output_size(std::move(output_size_in)),
      raster_decoder_route_id(std::move(raster_decoder_route_id_in)),
      transfer_cache_entry_id(std::move(transfer_cache_entry_id_in)),
      discardable_handle_shm_id(std::move(discardable_handle_shm_id_in)),
      discardable_handle_shm_offset(std::move(discardable_handle_shm_offset_in)),
      discardable_handle_release_count(std::move(discardable_handle_release_count_in)),
      target_color_space(std::move(target_color_space_in)),
      needs_mips(std::move(needs_mips_in)) {}

ScheduleImageDecodeParams::~ScheduleImageDecodeParams() = default;

void ScheduleImageDecodeParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_data"), this->encoded_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_size"), this->output_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raster_decoder_route_id"), this->raster_decoder_route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer_cache_entry_id"), this->transfer_cache_entry_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discardable_handle_shm_id"), this->discardable_handle_shm_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discardable_handle_shm_offset"), this->discardable_handle_shm_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discardable_handle_release_count"), this->discardable_handle_release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_color_space"), this->target_color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_mips"), this->needs_mips,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScheduleImageDecodeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateImageParams::CreateImageParams()
    : id(),
      gpu_memory_buffer(),
      size(),
      format(),
      plane(),
      image_release_count() {}

CreateImageParams::CreateImageParams(
    int32_t id_in,
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_in,
    const ::gfx::Size& size_in,
    ::gfx::BufferFormat format_in,
    ::gfx::BufferPlane plane_in,
    uint64_t image_release_count_in)
    : id(std::move(id_in)),
      gpu_memory_buffer(std::move(gpu_memory_buffer_in)),
      size(std::move(size_in)),
      format(std::move(format_in)),
      plane(std::move(plane_in)),
      image_release_count(std::move(image_release_count_in)) {}

CreateImageParams::~CreateImageParams() = default;

void CreateImageParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_memory_buffer"), this->gpu_memory_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::BufferFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plane"), this->plane,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::BufferPlane>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_release_count"), this->image_release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeferredRequest::DeferredRequest()
    : params(),
      sync_token_fences() {}

DeferredRequest::DeferredRequest(
    DeferredRequestParamsPtr params_in,
    std::vector<::gpu::SyncToken> sync_token_fences_in)
    : params(std::move(params_in)),
      sync_token_fences(std::move(sync_token_fences_in)) {}

DeferredRequest::~DeferredRequest() = default;

void DeferredRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DeferredRequestParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token_fences"), this->sync_token_fences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeferredRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeferredCommandBufferRequest::DeferredCommandBufferRequest()
    : routing_id(),
      params() {}

DeferredCommandBufferRequest::DeferredCommandBufferRequest(
    int32_t routing_id_in,
    DeferredCommandBufferRequestParamsPtr params_in)
    : routing_id(std::move(routing_id_in)),
      params(std::move(params_in)) {}

DeferredCommandBufferRequest::~DeferredCommandBufferRequest() = default;

void DeferredCommandBufferRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DeferredCommandBufferRequestParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeferredCommandBufferRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AsyncFlushParams::AsyncFlushParams()
    : put_offset(),
      flush_id(),
      sync_token_fences() {}

AsyncFlushParams::AsyncFlushParams(
    int32_t put_offset_in,
    uint32_t flush_id_in,
    std::vector<::gpu::SyncToken> sync_token_fences_in)
    : put_offset(std::move(put_offset_in)),
      flush_id(std::move(flush_id_in)),
      sync_token_fences(std::move(sync_token_fences_in)) {}

AsyncFlushParams::~AsyncFlushParams() = default;

void AsyncFlushParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "put_offset"), this->put_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flush_id"), this->flush_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token_fences"), this->sync_token_fences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AsyncFlushParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReturnFrontBufferParams::ReturnFrontBufferParams()
    : mailbox(),
      is_lost() {}

ReturnFrontBufferParams::ReturnFrontBufferParams(
    const ::gpu::Mailbox& mailbox_in,
    bool is_lost_in)
    : mailbox(std::move(mailbox_in)),
      is_lost(std::move(is_lost_in)) {}

ReturnFrontBufferParams::~ReturnFrontBufferParams() = default;

void ReturnFrontBufferParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_lost"), this->is_lost,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReturnFrontBufferParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateSharedImageParams::CreateSharedImageParams()
    : mailbox(),
      format(),
      size(),
      color_space(),
      usage(),
      release_id(),
      surface_origin(),
      alpha_type() {}

CreateSharedImageParams::CreateSharedImageParams(
    const ::gpu::Mailbox& mailbox_in,
    ::viz::ResourceFormat format_in,
    const ::gfx::Size& size_in,
    const ::gfx::ColorSpace& color_space_in,
    uint32_t usage_in,
    uint32_t release_id_in,
    ::GrSurfaceOrigin surface_origin_in,
    ::SkAlphaType alpha_type_in)
    : mailbox(std::move(mailbox_in)),
      format(std::move(format_in)),
      size(std::move(size_in)),
      color_space(std::move(color_space_in)),
      usage(std::move(usage_in)),
      release_id(std::move(release_id_in)),
      surface_origin(std::move(surface_origin_in)),
      alpha_type(std::move(alpha_type_in)) {}

CreateSharedImageParams::~CreateSharedImageParams() = default;

void CreateSharedImageParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::ResourceFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_id"), this->release_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_origin"), this->surface_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::GrSurfaceOrigin>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkAlphaType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateSharedImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateSharedImageWithDataParams::CreateSharedImageWithDataParams()
    : mailbox(),
      format(),
      size(),
      color_space(),
      usage(),
      release_id(),
      pixel_data_offset(),
      pixel_data_size(),
      done_with_shm(),
      surface_origin(),
      alpha_type() {}

CreateSharedImageWithDataParams::CreateSharedImageWithDataParams(
    const ::gpu::Mailbox& mailbox_in,
    ::viz::ResourceFormat format_in,
    const ::gfx::Size& size_in,
    const ::gfx::ColorSpace& color_space_in,
    uint32_t usage_in,
    uint32_t release_id_in,
    uint32_t pixel_data_offset_in,
    uint32_t pixel_data_size_in,
    bool done_with_shm_in,
    ::GrSurfaceOrigin surface_origin_in,
    ::SkAlphaType alpha_type_in)
    : mailbox(std::move(mailbox_in)),
      format(std::move(format_in)),
      size(std::move(size_in)),
      color_space(std::move(color_space_in)),
      usage(std::move(usage_in)),
      release_id(std::move(release_id_in)),
      pixel_data_offset(std::move(pixel_data_offset_in)),
      pixel_data_size(std::move(pixel_data_size_in)),
      done_with_shm(std::move(done_with_shm_in)),
      surface_origin(std::move(surface_origin_in)),
      alpha_type(std::move(alpha_type_in)) {}

CreateSharedImageWithDataParams::~CreateSharedImageWithDataParams() = default;

void CreateSharedImageWithDataParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::ResourceFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_id"), this->release_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data_offset"), this->pixel_data_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data_size"), this->pixel_data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "done_with_shm"), this->done_with_shm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_origin"), this->surface_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::GrSurfaceOrigin>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkAlphaType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateSharedImageWithDataParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateGMBSharedImageParams::CreateGMBSharedImageParams()
    : mailbox(),
      buffer_handle(),
      size(),
      format(),
      plane(),
      color_space(),
      usage(),
      release_id(),
      surface_origin(),
      alpha_type() {}

CreateGMBSharedImageParams::CreateGMBSharedImageParams(
    const ::gpu::Mailbox& mailbox_in,
    ::gfx::GpuMemoryBufferHandle buffer_handle_in,
    const ::gfx::Size& size_in,
    ::gfx::BufferFormat format_in,
    ::gfx::BufferPlane plane_in,
    const ::gfx::ColorSpace& color_space_in,
    uint32_t usage_in,
    uint32_t release_id_in,
    ::GrSurfaceOrigin surface_origin_in,
    ::SkAlphaType alpha_type_in)
    : mailbox(std::move(mailbox_in)),
      buffer_handle(std::move(buffer_handle_in)),
      size(std::move(size_in)),
      format(std::move(format_in)),
      plane(std::move(plane_in)),
      color_space(std::move(color_space_in)),
      usage(std::move(usage_in)),
      release_id(std::move(release_id_in)),
      surface_origin(std::move(surface_origin_in)),
      alpha_type(std::move(alpha_type_in)) {}

CreateGMBSharedImageParams::~CreateGMBSharedImageParams() = default;

void CreateGMBSharedImageParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_handle"), this->buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::BufferFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plane"), this->plane,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::BufferPlane>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_id"), this->release_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_origin"), this->surface_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::GrSurfaceOrigin>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkAlphaType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateGMBSharedImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateSharedImageParams::UpdateSharedImageParams()
    : mailbox(),
      release_id(),
      in_fence_handle() {}

UpdateSharedImageParams::UpdateSharedImageParams(
    const ::gpu::Mailbox& mailbox_in,
    uint32_t release_id_in,
    ::gfx::GpuFenceHandle in_fence_handle_in)
    : mailbox(std::move(mailbox_in)),
      release_id(std::move(release_id_in)),
      in_fence_handle(std::move(in_fence_handle_in)) {}

UpdateSharedImageParams::~UpdateSharedImageParams() = default;

void UpdateSharedImageParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_id"), this->release_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_fence_handle"), this->in_fence_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuFenceHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateSharedImageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeferredRequestParams::DeferredRequestParams() : tag_(Tag::COMMAND_BUFFER_REQUEST) {
  data_.command_buffer_request = new DeferredCommandBufferRequestPtr;
}

DeferredRequestParams::~DeferredRequestParams() {
  DestroyActive();
}


void DeferredRequestParams::set_command_buffer_request(
    DeferredCommandBufferRequestPtr command_buffer_request) {
  if (tag_ == Tag::COMMAND_BUFFER_REQUEST) {
    *(data_.command_buffer_request) = std::move(command_buffer_request);
  } else {
    DestroyActive();
    tag_ = Tag::COMMAND_BUFFER_REQUEST;
    data_.command_buffer_request = new DeferredCommandBufferRequestPtr(
        std::move(command_buffer_request));
  }
}
void DeferredRequestParams::set_shared_image_request(
    DeferredSharedImageRequestPtr shared_image_request) {
  if (tag_ == Tag::SHARED_IMAGE_REQUEST) {
    *(data_.shared_image_request) = std::move(shared_image_request);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_IMAGE_REQUEST;
    data_.shared_image_request = new DeferredSharedImageRequestPtr(
        std::move(shared_image_request));
  }
}

void DeferredRequestParams::DestroyActive() {
  switch (tag_) {

    case Tag::COMMAND_BUFFER_REQUEST:

      delete data_.command_buffer_request;
      break;
    case Tag::SHARED_IMAGE_REQUEST:

      delete data_.shared_image_request;
      break;
  }
}

bool DeferredRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
DeferredCommandBufferRequestParams::DeferredCommandBufferRequestParams() : tag_(Tag::ASYNC_FLUSH) {
  data_.async_flush = new AsyncFlushParamsPtr;
}

DeferredCommandBufferRequestParams::~DeferredCommandBufferRequestParams() {
  DestroyActive();
}


void DeferredCommandBufferRequestParams::set_async_flush(
    AsyncFlushParamsPtr async_flush) {
  if (tag_ == Tag::ASYNC_FLUSH) {
    *(data_.async_flush) = std::move(async_flush);
  } else {
    DestroyActive();
    tag_ = Tag::ASYNC_FLUSH;
    data_.async_flush = new AsyncFlushParamsPtr(
        std::move(async_flush));
  }
}
void DeferredCommandBufferRequestParams::set_destroy_transfer_buffer(
    int32_t destroy_transfer_buffer) {
  if (tag_ != Tag::DESTROY_TRANSFER_BUFFER) {
    DestroyActive();
    tag_ = Tag::DESTROY_TRANSFER_BUFFER;
  }
  data_.destroy_transfer_buffer = destroy_transfer_buffer;
}
void DeferredCommandBufferRequestParams::set_take_front_buffer(
    const ::gpu::Mailbox& take_front_buffer) {
  if (tag_ == Tag::TAKE_FRONT_BUFFER) {
    *(data_.take_front_buffer) = std::move(take_front_buffer);
  } else {
    DestroyActive();
    tag_ = Tag::TAKE_FRONT_BUFFER;
    data_.take_front_buffer = new ::gpu::Mailbox(
        std::move(take_front_buffer));
  }
}
void DeferredCommandBufferRequestParams::set_return_front_buffer(
    ReturnFrontBufferParamsPtr return_front_buffer) {
  if (tag_ == Tag::RETURN_FRONT_BUFFER) {
    *(data_.return_front_buffer) = std::move(return_front_buffer);
  } else {
    DestroyActive();
    tag_ = Tag::RETURN_FRONT_BUFFER;
    data_.return_front_buffer = new ReturnFrontBufferParamsPtr(
        std::move(return_front_buffer));
  }
}

void DeferredCommandBufferRequestParams::DestroyActive() {
  switch (tag_) {

    case Tag::ASYNC_FLUSH:

      delete data_.async_flush;
      break;
    case Tag::DESTROY_TRANSFER_BUFFER:

      break;
    case Tag::TAKE_FRONT_BUFFER:

      delete data_.take_front_buffer;
      break;
    case Tag::RETURN_FRONT_BUFFER:

      delete data_.return_front_buffer;
      break;
  }
}

bool DeferredCommandBufferRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
DeferredSharedImageRequest::DeferredSharedImageRequest() : tag_(Tag::NOP) {
  data_.nop = uint8_t();
}

DeferredSharedImageRequest::~DeferredSharedImageRequest() {
  DestroyActive();
}


void DeferredSharedImageRequest::set_nop(
    uint8_t nop) {
  if (tag_ != Tag::NOP) {
    DestroyActive();
    tag_ = Tag::NOP;
  }
  data_.nop = nop;
}
void DeferredSharedImageRequest::set_create_shared_image(
    CreateSharedImageParamsPtr create_shared_image) {
  if (tag_ == Tag::CREATE_SHARED_IMAGE) {
    *(data_.create_shared_image) = std::move(create_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::CREATE_SHARED_IMAGE;
    data_.create_shared_image = new CreateSharedImageParamsPtr(
        std::move(create_shared_image));
  }
}
void DeferredSharedImageRequest::set_create_shared_image_with_data(
    CreateSharedImageWithDataParamsPtr create_shared_image_with_data) {
  if (tag_ == Tag::CREATE_SHARED_IMAGE_WITH_DATA) {
    *(data_.create_shared_image_with_data) = std::move(create_shared_image_with_data);
  } else {
    DestroyActive();
    tag_ = Tag::CREATE_SHARED_IMAGE_WITH_DATA;
    data_.create_shared_image_with_data = new CreateSharedImageWithDataParamsPtr(
        std::move(create_shared_image_with_data));
  }
}
void DeferredSharedImageRequest::set_create_gmb_shared_image(
    CreateGMBSharedImageParamsPtr create_gmb_shared_image) {
  if (tag_ == Tag::CREATE_GMB_SHARED_IMAGE) {
    *(data_.create_gmb_shared_image) = std::move(create_gmb_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::CREATE_GMB_SHARED_IMAGE;
    data_.create_gmb_shared_image = new CreateGMBSharedImageParamsPtr(
        std::move(create_gmb_shared_image));
  }
}
void DeferredSharedImageRequest::set_register_upload_buffer(
    ::base::ReadOnlySharedMemoryRegion register_upload_buffer) {
  if (tag_ == Tag::REGISTER_UPLOAD_BUFFER) {
    *(data_.register_upload_buffer) = std::move(register_upload_buffer);
  } else {
    DestroyActive();
    tag_ = Tag::REGISTER_UPLOAD_BUFFER;
    data_.register_upload_buffer = new ::base::ReadOnlySharedMemoryRegion(
        std::move(register_upload_buffer));
  }
}
void DeferredSharedImageRequest::set_update_shared_image(
    UpdateSharedImageParamsPtr update_shared_image) {
  if (tag_ == Tag::UPDATE_SHARED_IMAGE) {
    *(data_.update_shared_image) = std::move(update_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::UPDATE_SHARED_IMAGE;
    data_.update_shared_image = new UpdateSharedImageParamsPtr(
        std::move(update_shared_image));
  }
}
void DeferredSharedImageRequest::set_destroy_shared_image(
    const ::gpu::Mailbox& destroy_shared_image) {
  if (tag_ == Tag::DESTROY_SHARED_IMAGE) {
    *(data_.destroy_shared_image) = std::move(destroy_shared_image);
  } else {
    DestroyActive();
    tag_ = Tag::DESTROY_SHARED_IMAGE;
    data_.destroy_shared_image = new ::gpu::Mailbox(
        std::move(destroy_shared_image));
  }
}

void DeferredSharedImageRequest::DestroyActive() {
  switch (tag_) {

    case Tag::NOP:

      break;
    case Tag::CREATE_SHARED_IMAGE:

      delete data_.create_shared_image;
      break;
    case Tag::CREATE_SHARED_IMAGE_WITH_DATA:

      delete data_.create_shared_image_with_data;
      break;
    case Tag::CREATE_GMB_SHARED_IMAGE:

      delete data_.create_gmb_shared_image;
      break;
    case Tag::REGISTER_UPLOAD_BUFFER:

      delete data_.register_upload_buffer;
      break;
    case Tag::UPDATE_SHARED_IMAGE:

      delete data_.update_shared_image;
      break;
    case Tag::DESTROY_SHARED_IMAGE:

      delete data_.destroy_shared_image;
      break;
  }
}

bool DeferredSharedImageRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char GpuChannel::Name_[] = "gpu.mojom.GpuChannel";
bool GpuChannel::GetChannelToken(::base::UnguessableToken* out_token) {
  NOTREACHED();
  return false;
}
bool GpuChannel::Flush() {
  NOTREACHED();
  return false;
}
bool GpuChannel::CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties) {
  NOTREACHED();
  return false;
}
bool GpuChannel::DestroyCommandBuffer(int32_t routing_id) {
  NOTREACHED();
  return false;
}
bool GpuChannel::WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  NOTREACHED();
  return false;
}
bool GpuChannel::WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) {
  NOTREACHED();
  return false;
}
class GpuChannel_GetChannelToken_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_GetChannelToken_HandleSyncResponse(
      bool* result, ::base::UnguessableToken* out_token)
      : result_(result), out_token_(out_token) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::UnguessableToken* out_token_;DISALLOW_COPY_AND_ASSIGN(GpuChannel_GetChannelToken_HandleSyncResponse);
};

class GpuChannel_GetChannelToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_GetChannelToken_ForwardToCallback(
      GpuChannel::GetChannelTokenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::GetChannelTokenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuChannel_GetChannelToken_ForwardToCallback);
};
class GpuChannel_Flush_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_Flush_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(GpuChannel_Flush_HandleSyncResponse);
};

class GpuChannel_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_Flush_ForwardToCallback(
      GpuChannel::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuChannel_Flush_ForwardToCallback);
};
class GpuChannel_CreateCommandBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_CreateCommandBuffer_HandleSyncResponse(
      bool* result, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties)
      : result_(result), out_result_(out_result), out_capabilties_(out_capabilties) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gpu::ContextResult* out_result_;
  ::gpu::Capabilities* out_capabilties_;DISALLOW_COPY_AND_ASSIGN(GpuChannel_CreateCommandBuffer_HandleSyncResponse);
};

class GpuChannel_CreateCommandBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_CreateCommandBuffer_ForwardToCallback(
      GpuChannel::CreateCommandBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::CreateCommandBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuChannel_CreateCommandBuffer_ForwardToCallback);
};
class GpuChannel_DestroyCommandBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_DestroyCommandBuffer_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(GpuChannel_DestroyCommandBuffer_HandleSyncResponse);
};

class GpuChannel_DestroyCommandBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_DestroyCommandBuffer_ForwardToCallback(
      GpuChannel::DestroyCommandBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::DestroyCommandBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuChannel_DestroyCommandBuffer_ForwardToCallback);
};
class GpuChannel_WaitForTokenInRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForTokenInRange_HandleSyncResponse(
      bool* result, ::gpu::CommandBuffer::State* out_state)
      : result_(result), out_state_(out_state) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gpu::CommandBuffer::State* out_state_;DISALLOW_COPY_AND_ASSIGN(GpuChannel_WaitForTokenInRange_HandleSyncResponse);
};

class GpuChannel_WaitForTokenInRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForTokenInRange_ForwardToCallback(
      GpuChannel::WaitForTokenInRangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::WaitForTokenInRangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuChannel_WaitForTokenInRange_ForwardToCallback);
};
class GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse(
      bool* result, ::gpu::CommandBuffer::State* out_state)
      : result_(result), out_state_(out_state) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gpu::CommandBuffer::State* out_state_;DISALLOW_COPY_AND_ASSIGN(GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse);
};

class GpuChannel_WaitForGetOffsetInRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuChannel_WaitForGetOffsetInRange_ForwardToCallback(
      GpuChannel::WaitForGetOffsetInRangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuChannel::WaitForGetOffsetInRangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuChannel_WaitForGetOffsetInRange_ForwardToCallback);
};

GpuChannelProxy::GpuChannelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuChannelProxy::CrashForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "gpu::mojom::GpuChannel::CrashForTesting");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_CrashForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CrashForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CrashForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuChannelProxy::TerminateForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "gpu::mojom::GpuChannel::TerminateForTesting");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_TerminateForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_TerminateForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("TerminateForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool GpuChannelProxy::GetChannelToken(
    ::base::UnguessableToken* out_param_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "gpu::mojom::GpuChannel::GetChannelToken");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_GetChannelToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetChannelToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetChannelToken");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_GetChannelToken_HandleSyncResponse(
          &result, out_param_token));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "gpu::mojom::GpuChannel::GetChannelToken", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), out_param_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  return result;
}

void GpuChannelProxy::GetChannelToken(
    GetChannelTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "gpu::mojom::GpuChannel::GetChannelToken");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_GetChannelToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetChannelToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetChannelToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_GetChannelToken_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool GpuChannelProxy::Flush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "gpu::mojom::GpuChannel::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("Flush");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_Flush_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "gpu::mojom::GpuChannel::Flush");
#endif
  return result;
}

void GpuChannelProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "gpu::mojom::GpuChannel::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool GpuChannelProxy::CreateCommandBuffer(
    CreateCommandBufferParamsPtr param_params, int32_t param_routing_id, ::base::UnsafeSharedMemoryRegion param_shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> param_receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> param_client, ::gpu::ContextResult* out_param_result, ::gpu::Capabilities* out_param_capabilties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "gpu::mojom::GpuChannel::CreateCommandBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type CreateCommandBufferParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_state"), param_shared_state,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), param_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<CommandBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), param_client,
                        "<value of type ::mojo::PendingAssociatedRemote<CommandBufferClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_CreateCommandBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateCommandBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CreateCommandBufferParamsDataView>(
      param_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in GpuChannel.CreateCommandBuffer request");
  params->routing_id = param_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shared_state)::BaseType> shared_state_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      param_shared_state, shared_state_fragment);
  params->shared_state.Set(
      shared_state_fragment.is_null() ? nullptr : shared_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_state in GpuChannel.CreateCommandBuffer request");
  mojo::internal::Serialize<::gpu::mojom::CommandBufferAssociatedRequestDataView>(
      param_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in GpuChannel.CreateCommandBuffer request");
  mojo::internal::Serialize<::gpu::mojom::CommandBufferClientAssociatedPtrInfoDataView>(
      param_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in GpuChannel.CreateCommandBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateCommandBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_CreateCommandBuffer_HandleSyncResponse(
          &result, out_param_result, out_param_capabilties));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "gpu::mojom::GpuChannel::CreateCommandBuffer", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type ::gpu::ContextResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilties"), out_param_capabilties,
                        "<value of type const ::gpu::Capabilities&>");
   });
#endif
  return result;
}

void GpuChannelProxy::CreateCommandBuffer(
    CreateCommandBufferParamsPtr in_params, int32_t in_routing_id, ::base::UnsafeSharedMemoryRegion in_shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> in_receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> in_client, CreateCommandBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::GpuChannel::CreateCommandBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CreateCommandBufferParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_state"), in_shared_state,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<CommandBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<CommandBufferClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_CreateCommandBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateCommandBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CreateCommandBufferParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in GpuChannel.CreateCommandBuffer request");
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->shared_state)::BaseType> shared_state_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_shared_state, shared_state_fragment);
  params->shared_state.Set(
      shared_state_fragment.is_null() ? nullptr : shared_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_state in GpuChannel.CreateCommandBuffer request");
  mojo::internal::Serialize<::gpu::mojom::CommandBufferAssociatedRequestDataView>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in GpuChannel.CreateCommandBuffer request");
  mojo::internal::Serialize<::gpu::mojom::CommandBufferClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in GpuChannel.CreateCommandBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateCommandBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_CreateCommandBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool GpuChannelProxy::DestroyCommandBuffer(
    int32_t param_routing_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "gpu::mojom::GpuChannel::DestroyCommandBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_DestroyCommandBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_DestroyCommandBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = param_routing_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("DestroyCommandBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_DestroyCommandBuffer_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "gpu::mojom::GpuChannel::DestroyCommandBuffer");
#endif
  return result;
}

void GpuChannelProxy::DestroyCommandBuffer(
    int32_t in_routing_id, DestroyCommandBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::GpuChannel::DestroyCommandBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_DestroyCommandBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_DestroyCommandBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = in_routing_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("DestroyCommandBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_DestroyCommandBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuChannelProxy::ScheduleImageDecode(
    ScheduleImageDecodeParamsPtr in_params, uint64_t in_decode_release_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::GpuChannel::ScheduleImageDecode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ScheduleImageDecodeParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decode_release_count"), in_decode_release_count,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_ScheduleImageDecode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_ScheduleImageDecode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::ScheduleImageDecodeParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in GpuChannel.ScheduleImageDecode request");
  params->decode_release_count = in_decode_release_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("ScheduleImageDecode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuChannelProxy::FlushDeferredRequests(
    std::vector<DeferredRequestPtr> in_requests) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::GpuChannel::FlushDeferredRequests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests,
                        "<value of type std::vector<DeferredRequestPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_FlushDeferredRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_FlushDeferredRequests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  const mojo::internal::ContainerValidateParams requests_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::DeferredRequestDataView>>(
      in_requests, requests_fragment, &requests_validate_params);
  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requests.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requests in GpuChannel.FlushDeferredRequests request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("FlushDeferredRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool GpuChannelProxy::WaitForTokenInRange(
    int32_t param_routing_id, int32_t param_start, int32_t param_end, ::gpu::CommandBuffer::State* out_param_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "gpu::mojom::GpuChannel::WaitForTokenInRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), param_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), param_end,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_WaitForTokenInRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForTokenInRange_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = param_routing_id;
  params->start = param_start;
  params->end = param_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForTokenInRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForTokenInRange_HandleSyncResponse(
          &result, out_param_state));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "gpu::mojom::GpuChannel::WaitForTokenInRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), out_param_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  return result;
}

void GpuChannelProxy::WaitForTokenInRange(
    int32_t in_routing_id, int32_t in_start, int32_t in_end, WaitForTokenInRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::GpuChannel::WaitForTokenInRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_WaitForTokenInRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForTokenInRange_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = in_routing_id;
  params->start = in_start;
  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForTokenInRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForTokenInRange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool GpuChannelProxy::WaitForGetOffsetInRange(
    int32_t param_routing_id, uint32_t param_set_get_buffer_count, int32_t param_start, int32_t param_end, ::gpu::CommandBuffer::State* out_param_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "gpu::mojom::GpuChannel::WaitForGetOffsetInRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), param_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set_get_buffer_count"), param_set_get_buffer_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), param_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), param_end,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_WaitForGetOffsetInRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForGetOffsetInRange_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = param_routing_id;
  params->set_get_buffer_count = param_set_get_buffer_count;
  params->start = param_start;
  params->end = param_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForGetOffsetInRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse(
          &result, out_param_state));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "gpu::mojom::GpuChannel::WaitForGetOffsetInRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), out_param_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  return result;
}

void GpuChannelProxy::WaitForGetOffsetInRange(
    int32_t in_routing_id, uint32_t in_set_get_buffer_count, int32_t in_start, int32_t in_end, WaitForGetOffsetInRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::GpuChannel::WaitForGetOffsetInRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set_get_buffer_count"), in_set_get_buffer_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_WaitForGetOffsetInRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForGetOffsetInRange_Params_Data> params(
          message);
  params.Allocate();
  params->routing_id = in_routing_id;
  params->set_get_buffer_count = in_set_get_buffer_count;
  params->start = in_start;
  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForGetOffsetInRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuChannel_WaitForGetOffsetInRange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GpuChannel_GetChannelToken_ProxyToResponder {
 public:
  static GpuChannel::GetChannelTokenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuChannel_GetChannelToken_ProxyToResponder> proxy(
        new GpuChannel_GetChannelToken_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuChannel_GetChannelToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_GetChannelToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuChannel_GetChannelToken_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::GetChannelTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuChannel_GetChannelToken_ProxyToResponder);
};

bool GpuChannel_GetChannelToken_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::GpuChannel::GetChannelTokenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuChannel_GetChannelToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_GetChannelToken_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::UnguessableToken p_token{};
  GpuChannel_GetChannelToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_token));
  return true;
}

void GpuChannel_GetChannelToken_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)gpu::mojom::GpuChannel::GetChannelTokenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_GetChannelToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_GetChannelToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::GpuChannel::GetChannelTokenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("GetChannelToken");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_GetChannelToken_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuChannel_GetChannelToken_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_GetChannelToken_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::UnguessableToken p_token{};
  GpuChannel_GetChannelToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 2, true);
    return false;
  }
  *out_token_ = std::move(p_token);
  *result_ = true;
  return true;
}
class GpuChannel_Flush_ProxyToResponder {
 public:
  static GpuChannel::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuChannel_Flush_ProxyToResponder> proxy(
        new GpuChannel_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuChannel_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuChannel_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuChannel_Flush_ProxyToResponder);
};

bool GpuChannel_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::GpuChannel::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuChannel_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GpuChannel_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void GpuChannel_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)gpu::mojom::GpuChannel::FlushCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::GpuChannel::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_Flush_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuChannel_Flush_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_Flush_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  GpuChannel_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 3, true);
    return false;
  }
  *result_ = true;
  return true;
}
class GpuChannel_CreateCommandBuffer_ProxyToResponder {
 public:
  static GpuChannel::CreateCommandBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuChannel_CreateCommandBuffer_ProxyToResponder> proxy(
        new GpuChannel_CreateCommandBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuChannel_CreateCommandBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_CreateCommandBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuChannel_CreateCommandBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::CreateCommandBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gpu::ContextResult in_result, const ::gpu::Capabilities& in_capabilties);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuChannel_CreateCommandBuffer_ProxyToResponder);
};

bool GpuChannel_CreateCommandBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::GpuChannel::CreateCommandBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gpu::ContextResult p_result{};
  ::gpu::Capabilities p_capabilties{};
  GpuChannel_CreateCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCapabilties(&p_capabilties))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_capabilties));
  return true;
}

void GpuChannel_CreateCommandBuffer_ProxyToResponder::Run(
    ::gpu::ContextResult in_result, const ::gpu::Capabilities& in_capabilties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)gpu::mojom::GpuChannel::CreateCommandBufferCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::gpu::ContextResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilties"), in_capabilties,
                        "<value of type const ::gpu::Capabilities&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_CreateCommandBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::gpu::mojom::ContextResult>(
      in_result, &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->capabilties)::BaseType> capabilties_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CapabilitiesDataView>(
      in_capabilties, capabilties_fragment);
  params->capabilties.Set(
      capabilties_fragment.is_null() ? nullptr : capabilties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->capabilties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capabilties in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::GpuChannel::CreateCommandBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("CreateCommandBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_CreateCommandBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::gpu::ContextResult p_result{};
  ::gpu::Capabilities p_capabilties{};
  GpuChannel_CreateCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCapabilties(&p_capabilties))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 4, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *out_capabilties_ = std::move(p_capabilties);
  *result_ = true;
  return true;
}
class GpuChannel_DestroyCommandBuffer_ProxyToResponder {
 public:
  static GpuChannel::DestroyCommandBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuChannel_DestroyCommandBuffer_ProxyToResponder> proxy(
        new GpuChannel_DestroyCommandBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuChannel_DestroyCommandBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_DestroyCommandBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuChannel_DestroyCommandBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::DestroyCommandBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuChannel_DestroyCommandBuffer_ProxyToResponder);
};

bool GpuChannel_DestroyCommandBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::GpuChannel::DestroyCommandBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GpuChannel_DestroyCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void GpuChannel_DestroyCommandBuffer_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)gpu::mojom::GpuChannel::DestroyCommandBufferCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_DestroyCommandBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::GpuChannel::DestroyCommandBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("DestroyCommandBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_DestroyCommandBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  GpuChannel_DestroyCommandBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 5, true);
    return false;
  }
  *result_ = true;
  return true;
}
class GpuChannel_WaitForTokenInRange_ProxyToResponder {
 public:
  static GpuChannel::WaitForTokenInRangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuChannel_WaitForTokenInRange_ProxyToResponder> proxy(
        new GpuChannel_WaitForTokenInRange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuChannel_WaitForTokenInRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_WaitForTokenInRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuChannel_WaitForTokenInRange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::WaitForTokenInRangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::CommandBuffer::State& in_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuChannel_WaitForTokenInRange_ProxyToResponder);
};

bool GpuChannel_WaitForTokenInRange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::GpuChannel::WaitForTokenInRangeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForTokenInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_state));
  return true;
}

void GpuChannel_WaitForTokenInRange_ProxyToResponder::Run(
    const ::gpu::CommandBuffer::State& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)gpu::mojom::GpuChannel::WaitForTokenInRangeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_WaitForTokenInRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CommandBufferStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::GpuChannel::WaitForTokenInRangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForTokenInRange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_WaitForTokenInRange_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForTokenInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 8, true);
    return false;
  }
  *out_state_ = std::move(p_state);
  *result_ = true;
  return true;
}
class GpuChannel_WaitForGetOffsetInRange_ProxyToResponder {
 public:
  static GpuChannel::WaitForGetOffsetInRangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuChannel_WaitForGetOffsetInRange_ProxyToResponder> proxy(
        new GpuChannel_WaitForGetOffsetInRange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuChannel_WaitForGetOffsetInRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuChannel_WaitForGetOffsetInRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuChannel_WaitForGetOffsetInRange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuChannel::WaitForGetOffsetInRangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::CommandBuffer::State& in_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuChannel_WaitForGetOffsetInRange_ProxyToResponder);
};

bool GpuChannel_WaitForGetOffsetInRange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::GpuChannel::WaitForGetOffsetInRangeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_state));
  return true;
}

void GpuChannel_WaitForGetOffsetInRange_ProxyToResponder::Run(
    const ::gpu::CommandBuffer::State& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)gpu::mojom::GpuChannel::WaitForGetOffsetInRangeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuChannel_WaitForGetOffsetInRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CommandBufferStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::GpuChannel::WaitForGetOffsetInRangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuChannel::Name_);
  message.set_method_name("WaitForGetOffsetInRange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuChannel_WaitForGetOffsetInRange_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::gpu::CommandBuffer::State p_state{};
  GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuChannel::Name_, 9, true);
    return false;
  }
  *out_state_ = std::move(p_state);
  *result_ = true;
  return true;
}

// static
bool GpuChannelStubDispatch::Accept(
    GpuChannel* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuChannel_CrashForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::CrashForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::CrashForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuChannel_CrashForTesting_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_CrashForTesting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuChannel_CrashForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashForTesting();
      return true;
    }
    case internal::kGpuChannel_TerminateForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::TerminateForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::TerminateForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuChannel_TerminateForTesting_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_TerminateForTesting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuChannel_TerminateForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TerminateForTesting();
      return true;
    }
    case internal::kGpuChannel_GetChannelToken_Name: {
      break;
    }
    case internal::kGpuChannel_Flush_Name: {
      break;
    }
    case internal::kGpuChannel_CreateCommandBuffer_Name: {
      break;
    }
    case internal::kGpuChannel_DestroyCommandBuffer_Name: {
      break;
    }
    case internal::kGpuChannel_ScheduleImageDecode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::ScheduleImageDecode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::ScheduleImageDecode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuChannel_ScheduleImageDecode_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_ScheduleImageDecode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ScheduleImageDecodeParamsPtr p_params{};
      uint64_t p_decode_release_count{};
      GpuChannel_ScheduleImageDecode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_decode_release_count = input_data_view.decode_release_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScheduleImageDecode(
std::move(p_params), 
std::move(p_decode_release_count));
      return true;
    }
    case internal::kGpuChannel_FlushDeferredRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::FlushDeferredRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::FlushDeferredRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuChannel_FlushDeferredRequests_Params_Data* params =
          reinterpret_cast<internal::GpuChannel_FlushDeferredRequests_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<DeferredRequestPtr> p_requests{};
      GpuChannel_FlushDeferredRequests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequests(&p_requests))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushDeferredRequests(
std::move(p_requests));
      return true;
    }
    case internal::kGpuChannel_WaitForTokenInRange_Name: {
      break;
    }
    case internal::kGpuChannel_WaitForGetOffsetInRange_Name: {
      break;
    }
  }
  return false;
}

// static
bool GpuChannelStubDispatch::AcceptWithResponder(
    GpuChannel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuChannel_CrashForTesting_Name: {
      break;
    }
    case internal::kGpuChannel_TerminateForTesting_Name: {
      break;
    }
    case internal::kGpuChannel_GetChannelToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::GetChannelToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::GetChannelToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuChannel_GetChannelToken_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_GetChannelToken_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuChannel_GetChannelToken_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 2, false);
        return false;
      }
      GpuChannel::GetChannelTokenCallback callback =
          GpuChannel_GetChannelToken_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetChannelToken(std::move(callback));
      return true;
    }
    case internal::kGpuChannel_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuChannel_Flush_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuChannel_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 3, false);
        return false;
      }
      GpuChannel::FlushCallback callback =
          GpuChannel_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case internal::kGpuChannel_CreateCommandBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::CreateCommandBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::CreateCommandBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuChannel_CreateCommandBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_CreateCommandBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CreateCommandBufferParamsPtr p_params{};
      int32_t p_routing_id{};
      ::base::UnsafeSharedMemoryRegion p_shared_state{};
      ::mojo::PendingAssociatedReceiver<CommandBuffer> p_receiver{};
      ::mojo::PendingAssociatedRemote<CommandBufferClient> p_client{};
      GpuChannel_CreateCommandBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadSharedState(&p_shared_state))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 4, false);
        return false;
      }
      GpuChannel::CreateCommandBufferCallback callback =
          GpuChannel_CreateCommandBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCommandBuffer(
std::move(p_params), 
std::move(p_routing_id), 
std::move(p_shared_state), 
std::move(p_receiver), 
std::move(p_client), std::move(callback));
      return true;
    }
    case internal::kGpuChannel_DestroyCommandBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::DestroyCommandBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::DestroyCommandBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuChannel_DestroyCommandBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_DestroyCommandBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_routing_id{};
      GpuChannel_DestroyCommandBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 5, false);
        return false;
      }
      GpuChannel::DestroyCommandBufferCallback callback =
          GpuChannel_DestroyCommandBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyCommandBuffer(
std::move(p_routing_id), std::move(callback));
      return true;
    }
    case internal::kGpuChannel_ScheduleImageDecode_Name: {
      break;
    }
    case internal::kGpuChannel_FlushDeferredRequests_Name: {
      break;
    }
    case internal::kGpuChannel_WaitForTokenInRange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::WaitForTokenInRange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::WaitForTokenInRange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuChannel_WaitForTokenInRange_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_WaitForTokenInRange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_routing_id{};
      int32_t p_start{};
      int32_t p_end{};
      GpuChannel_WaitForTokenInRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 8, false);
        return false;
      }
      GpuChannel::WaitForTokenInRangeCallback callback =
          GpuChannel_WaitForTokenInRange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForTokenInRange(
std::move(p_routing_id), 
std::move(p_start), 
std::move(p_end), std::move(callback));
      return true;
    }
    case internal::kGpuChannel_WaitForGetOffsetInRange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::GpuChannel::WaitForGetOffsetInRange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::GpuChannel::WaitForGetOffsetInRange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuChannel_WaitForGetOffsetInRange_Params_Data* params =
          reinterpret_cast<
              internal::GpuChannel_WaitForGetOffsetInRange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_routing_id{};
      uint32_t p_set_get_buffer_count{};
      int32_t p_start{};
      int32_t p_end{};
      GpuChannel_WaitForGetOffsetInRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_set_get_buffer_count = input_data_view.set_get_buffer_count();
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuChannel::Name_, 9, false);
        return false;
      }
      GpuChannel::WaitForGetOffsetInRangeCallback callback =
          GpuChannel_WaitForGetOffsetInRange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForGetOffsetInRange(
std::move(p_routing_id), 
std::move(p_set_get_buffer_count), 
std::move(p_start), 
std::move(p_end), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuChannelValidationInfo[] = {
    {internal::kGpuChannel_CrashForTesting_Name,
     {&internal::GpuChannel_CrashForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuChannel_TerminateForTesting_Name,
     {&internal::GpuChannel_TerminateForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuChannel_GetChannelToken_Name,
     {&internal::GpuChannel_GetChannelToken_Params_Data::Validate,
      &internal::GpuChannel_GetChannelToken_ResponseParams_Data::Validate}},
    {internal::kGpuChannel_Flush_Name,
     {&internal::GpuChannel_Flush_Params_Data::Validate,
      &internal::GpuChannel_Flush_ResponseParams_Data::Validate}},
    {internal::kGpuChannel_CreateCommandBuffer_Name,
     {&internal::GpuChannel_CreateCommandBuffer_Params_Data::Validate,
      &internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data::Validate}},
    {internal::kGpuChannel_DestroyCommandBuffer_Name,
     {&internal::GpuChannel_DestroyCommandBuffer_Params_Data::Validate,
      &internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data::Validate}},
    {internal::kGpuChannel_ScheduleImageDecode_Name,
     {&internal::GpuChannel_ScheduleImageDecode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuChannel_FlushDeferredRequests_Name,
     {&internal::GpuChannel_FlushDeferredRequests_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuChannel_WaitForTokenInRange_Name,
     {&internal::GpuChannel_WaitForTokenInRange_Params_Data::Validate,
      &internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data::Validate}},
    {internal::kGpuChannel_WaitForGetOffsetInRange_Name,
     {&internal::GpuChannel_WaitForGetOffsetInRange_Params_Data::Validate,
      &internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data::Validate}},
};

bool GpuChannelRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::GpuChannel::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuChannelValidationInfo);
}

bool GpuChannelResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::GpuChannel::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuChannelValidationInfo);

}
const char CommandBuffer::Name_[] = "gpu.mojom.CommandBuffer";
bool CommandBuffer::BindMediaReceiver(::mojo::GenericPendingAssociatedReceiver receiver) {
  NOTREACHED();
  return false;
}

class CommandBuffer_GetGpuFenceHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommandBuffer_GetGpuFenceHandle_ForwardToCallback(
      CommandBuffer::GetGpuFenceHandleCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CommandBuffer::GetGpuFenceHandleCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CommandBuffer_GetGpuFenceHandle_ForwardToCallback);
};
class CommandBuffer_BindMediaReceiver_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  CommandBuffer_BindMediaReceiver_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(CommandBuffer_BindMediaReceiver_HandleSyncResponse);
};

class CommandBuffer_BindMediaReceiver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommandBuffer_BindMediaReceiver_ForwardToCallback(
      CommandBuffer::BindMediaReceiverCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CommandBuffer::BindMediaReceiverCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CommandBuffer_BindMediaReceiver_ForwardToCallback);
};

CommandBufferProxy::CommandBufferProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommandBufferProxy::SetGetBuffer(
    int32_t in_shm_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::SetGetBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shm_id"), in_shm_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_SetGetBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_SetGetBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->shm_id = in_shm_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("SetGetBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferProxy::RegisterTransferBuffer(
    int32_t in_id, ::base::UnsafeSharedMemoryRegion in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::RegisterTransferBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_RegisterTransferBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_RegisterTransferBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in CommandBuffer.RegisterTransferBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("RegisterTransferBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferProxy::CreateGpuFenceFromHandle(
    uint32_t in_gpu_fence_id, ::gfx::GpuFenceHandle in_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_fence_id"), in_gpu_fence_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fence_handle"), in_fence_handle,
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_CreateGpuFenceFromHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data> params(
          message);
  params.Allocate();
  params->gpu_fence_id = in_gpu_fence_id;
  mojo::internal::MessageFragment<
      typename decltype(params->fence_handle)::BaseType> fence_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
      in_fence_handle, fence_handle_fragment);
  params->fence_handle.Set(
      fence_handle_fragment.is_null() ? nullptr : fence_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fence_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fence_handle in CommandBuffer.CreateGpuFenceFromHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("CreateGpuFenceFromHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferProxy::GetGpuFenceHandle(
    uint32_t in_id, GetGpuFenceHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::GetGpuFenceHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_GetGpuFenceHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_GetGpuFenceHandle_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("GetGpuFenceHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommandBuffer_GetGpuFenceHandle_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CommandBufferProxy::CreateImage(
    CreateImageParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::CreateImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CreateImageParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_CreateImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_CreateImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CreateImageParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in CommandBuffer.CreateImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("CreateImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferProxy::DestroyImage(
    int32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::DestroyImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_DestroyImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_DestroyImage_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("DestroyImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferProxy::SignalSyncToken(
    const ::gpu::SyncToken& in_sync_token, uint32_t in_signal_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::SignalSyncToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signal_id"), in_signal_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_SignalSyncToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_SignalSyncToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in CommandBuffer.SignalSyncToken request");
  params->signal_id = in_signal_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("SignalSyncToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferProxy::SignalQuery(
    uint32_t in_query, uint32_t in_signal_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::SignalQuery", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signal_id"), in_signal_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_SignalQuery_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_SignalQuery_Params_Data> params(
          message);
  params.Allocate();
  params->query = in_query;
  params->signal_id = in_signal_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("SignalQuery");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool CommandBufferProxy::BindMediaReceiver(
    ::mojo::GenericPendingAssociatedReceiver param_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "gpu::mojom::CommandBuffer::BindMediaReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), param_receiver,
                        "<value of type ::mojo::GenericPendingAssociatedReceiver>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_BindMediaReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_BindMediaReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingAssociatedReceiverDataView>(
      param_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in CommandBuffer.BindMediaReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("BindMediaReceiver");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommandBuffer_BindMediaReceiver_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "gpu::mojom::CommandBuffer::BindMediaReceiver");
#endif
  return result;
}

void CommandBufferProxy::BindMediaReceiver(
    ::mojo::GenericPendingAssociatedReceiver in_receiver, BindMediaReceiverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBuffer::BindMediaReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::GenericPendingAssociatedReceiver>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_BindMediaReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_BindMediaReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingAssociatedReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in CommandBuffer.BindMediaReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("BindMediaReceiver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommandBuffer_BindMediaReceiver_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CommandBuffer_GetGpuFenceHandle_ProxyToResponder {
 public:
  static CommandBuffer::GetGpuFenceHandleCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CommandBuffer_GetGpuFenceHandle_ProxyToResponder> proxy(
        new CommandBuffer_GetGpuFenceHandle_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CommandBuffer_GetGpuFenceHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommandBuffer_GetGpuFenceHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CommandBuffer_GetGpuFenceHandle_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CommandBuffer::GetGpuFenceHandleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuFenceHandle in_fence_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CommandBuffer_GetGpuFenceHandle_ProxyToResponder);
};

bool CommandBuffer_GetGpuFenceHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::CommandBuffer::GetGpuFenceHandleCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gfx::GpuFenceHandle p_fence_handle{};
  CommandBuffer_GetGpuFenceHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFenceHandle(&p_fence_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommandBuffer::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_fence_handle));
  return true;
}

void CommandBuffer_GetGpuFenceHandle_ProxyToResponder::Run(
    ::gfx::GpuFenceHandle in_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)gpu::mojom::CommandBuffer::GetGpuFenceHandleCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fence_handle"), in_fence_handle,
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_GetGpuFenceHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->fence_handle)::BaseType> fence_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
      in_fence_handle, fence_handle_fragment);
  params->fence_handle.Set(
      fence_handle_fragment.is_null() ? nullptr : fence_handle_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::CommandBuffer::GetGpuFenceHandleCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("GetGpuFenceHandle");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CommandBuffer_BindMediaReceiver_ProxyToResponder {
 public:
  static CommandBuffer::BindMediaReceiverCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CommandBuffer_BindMediaReceiver_ProxyToResponder> proxy(
        new CommandBuffer_BindMediaReceiver_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CommandBuffer_BindMediaReceiver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommandBuffer_BindMediaReceiver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CommandBuffer_BindMediaReceiver_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CommandBuffer::BindMediaReceiverCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CommandBuffer_BindMediaReceiver_ProxyToResponder);
};

bool CommandBuffer_BindMediaReceiver_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "gpu::mojom::CommandBuffer::BindMediaReceiverCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CommandBuffer_BindMediaReceiver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommandBuffer_BindMediaReceiver_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CommandBuffer_BindMediaReceiver_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommandBuffer::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CommandBuffer_BindMediaReceiver_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)gpu::mojom::CommandBuffer::BindMediaReceiverCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBuffer_BindMediaReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBuffer_BindMediaReceiver_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)gpu::mojom::CommandBuffer::BindMediaReceiverCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBuffer::Name_);
  message.set_method_name("BindMediaReceiver");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool CommandBuffer_BindMediaReceiver_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::CommandBuffer_BindMediaReceiver_ResponseParams_Data* params =
      reinterpret_cast<internal::CommandBuffer_BindMediaReceiver_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  CommandBuffer_BindMediaReceiver_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommandBuffer::Name_, 8, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool CommandBufferStubDispatch::Accept(
    CommandBuffer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCommandBuffer_SetGetBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::SetGetBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::SetGetBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_SetGetBuffer_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_SetGetBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_shm_id{};
      CommandBuffer_SetGetBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_shm_id = input_data_view.shm_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGetBuffer(
std::move(p_shm_id));
      return true;
    }
    case internal::kCommandBuffer_RegisterTransferBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::RegisterTransferBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::RegisterTransferBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_RegisterTransferBuffer_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_RegisterTransferBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_id{};
      ::base::UnsafeSharedMemoryRegion p_buffer{};
      CommandBuffer_RegisterTransferBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterTransferBuffer(
std::move(p_id), 
std::move(p_buffer));
      return true;
    }
    case internal::kCommandBuffer_CreateGpuFenceFromHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::CreateGpuFenceFromHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_gpu_fence_id{};
      ::gfx::GpuFenceHandle p_fence_handle{};
      CommandBuffer_CreateGpuFenceFromHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gpu_fence_id = input_data_view.gpu_fence_id();
      if (success && !input_data_view.ReadFenceHandle(&p_fence_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuFenceFromHandle(
std::move(p_gpu_fence_id), 
std::move(p_fence_handle));
      return true;
    }
    case internal::kCommandBuffer_GetGpuFenceHandle_Name: {
      break;
    }
    case internal::kCommandBuffer_CreateImage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::CreateImage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::CreateImage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_CreateImage_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_CreateImage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CreateImageParamsPtr p_params{};
      CommandBuffer_CreateImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateImage(
std::move(p_params));
      return true;
    }
    case internal::kCommandBuffer_DestroyImage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::DestroyImage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::DestroyImage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_DestroyImage_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_DestroyImage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_id{};
      CommandBuffer_DestroyImage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyImage(
std::move(p_id));
      return true;
    }
    case internal::kCommandBuffer_SignalSyncToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::SignalSyncToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::SignalSyncToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_SignalSyncToken_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_SignalSyncToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::SyncToken p_sync_token{};
      uint32_t p_signal_id{};
      CommandBuffer_SignalSyncToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success)
        p_signal_id = input_data_view.signal_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SignalSyncToken(
std::move(p_sync_token), 
std::move(p_signal_id));
      return true;
    }
    case internal::kCommandBuffer_SignalQuery_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::SignalQuery",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::SignalQuery");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBuffer_SignalQuery_Params_Data* params =
          reinterpret_cast<internal::CommandBuffer_SignalQuery_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_query{};
      uint32_t p_signal_id{};
      CommandBuffer_SignalQuery_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_query = input_data_view.query();
      if (success)
        p_signal_id = input_data_view.signal_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SignalQuery(
std::move(p_query), 
std::move(p_signal_id));
      return true;
    }
    case internal::kCommandBuffer_BindMediaReceiver_Name: {
      break;
    }
  }
  return false;
}

// static
bool CommandBufferStubDispatch::AcceptWithResponder(
    CommandBuffer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCommandBuffer_SetGetBuffer_Name: {
      break;
    }
    case internal::kCommandBuffer_RegisterTransferBuffer_Name: {
      break;
    }
    case internal::kCommandBuffer_CreateGpuFenceFromHandle_Name: {
      break;
    }
    case internal::kCommandBuffer_GetGpuFenceHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::GetGpuFenceHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::GetGpuFenceHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CommandBuffer_GetGpuFenceHandle_Params_Data* params =
          reinterpret_cast<
              internal::CommandBuffer_GetGpuFenceHandle_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_id{};
      CommandBuffer_GetGpuFenceHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 3, false);
        return false;
      }
      CommandBuffer::GetGpuFenceHandleCallback callback =
          CommandBuffer_GetGpuFenceHandle_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGpuFenceHandle(
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kCommandBuffer_CreateImage_Name: {
      break;
    }
    case internal::kCommandBuffer_DestroyImage_Name: {
      break;
    }
    case internal::kCommandBuffer_SignalSyncToken_Name: {
      break;
    }
    case internal::kCommandBuffer_SignalQuery_Name: {
      break;
    }
    case internal::kCommandBuffer_BindMediaReceiver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBuffer::BindMediaReceiver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBuffer::BindMediaReceiver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CommandBuffer_BindMediaReceiver_Params_Data* params =
          reinterpret_cast<
              internal::CommandBuffer_BindMediaReceiver_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::GenericPendingAssociatedReceiver p_receiver{};
      CommandBuffer_BindMediaReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBuffer::Name_, 8, false);
        return false;
      }
      CommandBuffer::BindMediaReceiverCallback callback =
          CommandBuffer_BindMediaReceiver_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMediaReceiver(
std::move(p_receiver), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCommandBufferValidationInfo[] = {
    {internal::kCommandBuffer_SetGetBuffer_Name,
     {&internal::CommandBuffer_SetGetBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_RegisterTransferBuffer_Name,
     {&internal::CommandBuffer_RegisterTransferBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_CreateGpuFenceFromHandle_Name,
     {&internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_GetGpuFenceHandle_Name,
     {&internal::CommandBuffer_GetGpuFenceHandle_Params_Data::Validate,
      &internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data::Validate}},
    {internal::kCommandBuffer_CreateImage_Name,
     {&internal::CommandBuffer_CreateImage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_DestroyImage_Name,
     {&internal::CommandBuffer_DestroyImage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_SignalSyncToken_Name,
     {&internal::CommandBuffer_SignalSyncToken_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_SignalQuery_Name,
     {&internal::CommandBuffer_SignalQuery_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBuffer_BindMediaReceiver_Name,
     {&internal::CommandBuffer_BindMediaReceiver_Params_Data::Validate,
      &internal::CommandBuffer_BindMediaReceiver_ResponseParams_Data::Validate}},
};

bool CommandBufferRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::CommandBuffer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCommandBufferValidationInfo);
}

bool CommandBufferResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::CommandBuffer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCommandBufferValidationInfo);

}
const char CommandBufferClient::Name_[] = "gpu.mojom.CommandBufferClient";

CommandBufferClientProxy::CommandBufferClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommandBufferClientProxy::OnConsoleMessage(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnConsoleMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnConsoleMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnConsoleMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in CommandBufferClient.OnConsoleMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnConsoleMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferClientProxy::OnGpuSwitched(
    ::gl::GpuPreference in_active_gpu_heuristic) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnGpuSwitched", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_gpu_heuristic"), in_active_gpu_heuristic,
                        "<value of type ::gl::GpuPreference>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnGpuSwitched_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnGpuSwitched_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::gl::mojom::GpuPreference>(
      in_active_gpu_heuristic, &params->active_gpu_heuristic);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnGpuSwitched");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferClientProxy::OnDestroyed(
    ::gpu::error::ContextLostReason in_reason, ::gpu::error::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::gpu::error::ContextLostReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::gpu::error::Error>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnDestroyed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnDestroyed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::gpu::mojom::ContextLostReason>(
      in_reason, &params->reason);
  mojo::internal::Serialize<::gpu::mojom::Error>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferClientProxy::OnSwapBuffersCompleted(
    const ::gpu::SwapBuffersCompleteParams& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnSwapBuffersCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::gpu::SwapBuffersCompleteParams&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnSwapBuffersCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnSwapBuffersCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SwapBuffersCompleteParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in CommandBufferClient.OnSwapBuffersCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnSwapBuffersCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferClientProxy::OnBufferPresented(
    uint64_t in_swap_id, const ::gfx::PresentationFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnBufferPresented", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("swap_id"), in_swap_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type const ::gfx::PresentationFeedback&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnBufferPresented_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnBufferPresented_Params_Data> params(
          message);
  params.Allocate();
  params->swap_id = in_swap_id;
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PresentationFeedbackDataView>(
      in_feedback, feedback_fragment);
  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feedback.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feedback in CommandBufferClient.OnBufferPresented request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnBufferPresented");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferClientProxy::OnReturnData(
    const std::vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnReturnData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnReturnData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnReturnData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in CommandBufferClient.OnReturnData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnReturnData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CommandBufferClientProxy::OnSignalAck(
    uint32_t in_signal_id, const ::gpu::CommandBuffer::State& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gpu::mojom::CommandBufferClient::OnSignalAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signal_id"), in_signal_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const ::gpu::CommandBuffer::State&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCommandBufferClient_OnSignalAck_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::CommandBufferClient_OnSignalAck_Params_Data> params(
          message);
  params.Allocate();
  params->signal_id = in_signal_id;
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::CommandBufferStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in CommandBufferClient.OnSignalAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandBufferClient::Name_);
  message.set_method_name("OnSignalAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CommandBufferClientStubDispatch::Accept(
    CommandBufferClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCommandBufferClient_OnConsoleMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnConsoleMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnConsoleMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnConsoleMessage_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnConsoleMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_message{};
      CommandBufferClient_OnConsoleMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConsoleMessage(
std::move(p_message));
      return true;
    }
    case internal::kCommandBufferClient_OnGpuSwitched_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnGpuSwitched",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnGpuSwitched");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnGpuSwitched_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnGpuSwitched_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gl::GpuPreference p_active_gpu_heuristic{};
      CommandBufferClient_OnGpuSwitched_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActiveGpuHeuristic(&p_active_gpu_heuristic))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGpuSwitched(
std::move(p_active_gpu_heuristic));
      return true;
    }
    case internal::kCommandBufferClient_OnDestroyed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnDestroyed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnDestroyed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnDestroyed_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnDestroyed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::error::ContextLostReason p_reason{};
      ::gpu::error::Error p_error{};
      CommandBufferClient_OnDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDestroyed(
std::move(p_reason), 
std::move(p_error));
      return true;
    }
    case internal::kCommandBufferClient_OnSwapBuffersCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnSwapBuffersCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnSwapBuffersCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnSwapBuffersCompleted_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnSwapBuffersCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::SwapBuffersCompleteParams p_params{};
      CommandBufferClient_OnSwapBuffersCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSwapBuffersCompleted(
std::move(p_params));
      return true;
    }
    case internal::kCommandBufferClient_OnBufferPresented_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnBufferPresented",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnBufferPresented");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnBufferPresented_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnBufferPresented_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_swap_id{};
      ::gfx::PresentationFeedback p_feedback{};
      CommandBufferClient_OnBufferPresented_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_swap_id = input_data_view.swap_id();
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferPresented(
std::move(p_swap_id), 
std::move(p_feedback));
      return true;
    }
    case internal::kCommandBufferClient_OnReturnData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnReturnData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnReturnData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnReturnData_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnReturnData_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_data{};
      CommandBufferClient_OnReturnData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReturnData(
std::move(p_data));
      return true;
    }
    case internal::kCommandBufferClient_OnSignalAck_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gpu::mojom::CommandBufferClient::OnSignalAck",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gpu::mojom::CommandBufferClient::OnSignalAck");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CommandBufferClient_OnSignalAck_Params_Data* params =
          reinterpret_cast<internal::CommandBufferClient_OnSignalAck_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_signal_id{};
      ::gpu::CommandBuffer::State p_state{};
      CommandBufferClient_OnSignalAck_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_signal_id = input_data_view.signal_id();
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandBufferClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSignalAck(
std::move(p_signal_id), 
std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool CommandBufferClientStubDispatch::AcceptWithResponder(
    CommandBufferClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCommandBufferClient_OnConsoleMessage_Name: {
      break;
    }
    case internal::kCommandBufferClient_OnGpuSwitched_Name: {
      break;
    }
    case internal::kCommandBufferClient_OnDestroyed_Name: {
      break;
    }
    case internal::kCommandBufferClient_OnSwapBuffersCompleted_Name: {
      break;
    }
    case internal::kCommandBufferClient_OnBufferPresented_Name: {
      break;
    }
    case internal::kCommandBufferClient_OnReturnData_Name: {
      break;
    }
    case internal::kCommandBufferClient_OnSignalAck_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCommandBufferClientValidationInfo[] = {
    {internal::kCommandBufferClient_OnConsoleMessage_Name,
     {&internal::CommandBufferClient_OnConsoleMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBufferClient_OnGpuSwitched_Name,
     {&internal::CommandBufferClient_OnGpuSwitched_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBufferClient_OnDestroyed_Name,
     {&internal::CommandBufferClient_OnDestroyed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBufferClient_OnSwapBuffersCompleted_Name,
     {&internal::CommandBufferClient_OnSwapBuffersCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBufferClient_OnBufferPresented_Name,
     {&internal::CommandBufferClient_OnBufferPresented_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBufferClient_OnReturnData_Name,
     {&internal::CommandBufferClient_OnReturnData_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCommandBufferClient_OnSignalAck_Name,
     {&internal::CommandBufferClient_OnSignalAck_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CommandBufferClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::CommandBufferClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCommandBufferClientValidationInfo);
}

}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::ContextCreationAttribs::DataView, ::gpu::mojom::ContextCreationAttribsPtr>::Read(
    ::gpu::mojom::ContextCreationAttribs::DataView input,
    ::gpu::mojom::ContextCreationAttribsPtr* output) {
  bool success = true;
  ::gpu::mojom::ContextCreationAttribsPtr result(::gpu::mojom::ContextCreationAttribs::New());
  
      if (success && !input.ReadOffscreenFramebufferSize(&result->offscreen_framebuffer_size))
        success = false;
      if (success && !input.ReadGpuPreference(&result->gpu_preference))
        success = false;
      if (success)
        result->alpha_size = input.alpha_size();
      if (success)
        result->blue_size = input.blue_size();
      if (success)
        result->green_size = input.green_size();
      if (success)
        result->red_size = input.red_size();
      if (success)
        result->depth_size = input.depth_size();
      if (success)
        result->stencil_size = input.stencil_size();
      if (success)
        result->samples = input.samples();
      if (success)
        result->sample_buffers = input.sample_buffers();
      if (success)
        result->buffer_preserved = input.buffer_preserved();
      if (success)
        result->bind_generates_resource = input.bind_generates_resource();
      if (success)
        result->fail_if_major_perf_caveat = input.fail_if_major_perf_caveat();
      if (success)
        result->lose_context_when_out_of_memory = input.lose_context_when_out_of_memory();
      if (success)
        result->should_use_native_gmb_for_backbuffer = input.should_use_native_gmb_for_backbuffer();
      if (success)
        result->own_offscreen_surface = input.own_offscreen_surface();
      if (success)
        result->single_buffer = input.single_buffer();
      if (success)
        result->enable_gles2_interface = input.enable_gles2_interface();
      if (success)
        result->enable_grcontext = input.enable_grcontext();
      if (success)
        result->enable_raster_interface = input.enable_raster_interface();
      if (success)
        result->enable_oop_rasterization = input.enable_oop_rasterization();
      if (success)
        result->enable_swap_timestamps_if_supported = input.enable_swap_timestamps_if_supported();
      if (success && !input.ReadContextType(&result->context_type))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateCommandBufferParams::DataView, ::gpu::mojom::CreateCommandBufferParamsPtr>::Read(
    ::gpu::mojom::CreateCommandBufferParams::DataView input,
    ::gpu::mojom::CreateCommandBufferParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateCommandBufferParamsPtr result(::gpu::mojom::CreateCommandBufferParams::New());
  
      if (success && !input.ReadSurfaceHandle(&result->surface_handle))
        success = false;
      if (success)
        result->share_group_id = input.share_group_id();
      if (success)
        result->stream_id = input.stream_id();
      if (success && !input.ReadStreamPriority(&result->stream_priority))
        success = false;
      if (success && !input.ReadAttribs(&result->attribs))
        success = false;
      if (success && !input.ReadActiveUrl(&result->active_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CommandBufferState::DataView, ::gpu::mojom::CommandBufferStatePtr>::Read(
    ::gpu::mojom::CommandBufferState::DataView input,
    ::gpu::mojom::CommandBufferStatePtr* output) {
  bool success = true;
  ::gpu::mojom::CommandBufferStatePtr result(::gpu::mojom::CommandBufferState::New());
  
      if (success)
        result->get_offset = input.get_offset();
      if (success)
        result->token = input.token();
      if (success)
        result->release_count = input.release_count();
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadContextLostReason(&result->context_lost_reason))
        success = false;
      if (success)
        result->generation = input.generation();
      if (success)
        result->set_get_buffer_count = input.set_get_buffer_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::ScheduleImageDecodeParams::DataView, ::gpu::mojom::ScheduleImageDecodeParamsPtr>::Read(
    ::gpu::mojom::ScheduleImageDecodeParams::DataView input,
    ::gpu::mojom::ScheduleImageDecodeParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::ScheduleImageDecodeParamsPtr result(::gpu::mojom::ScheduleImageDecodeParams::New());
  
      if (success && !input.ReadEncodedData(&result->encoded_data))
        success = false;
      if (success && !input.ReadOutputSize(&result->output_size))
        success = false;
      if (success)
        result->raster_decoder_route_id = input.raster_decoder_route_id();
      if (success)
        result->transfer_cache_entry_id = input.transfer_cache_entry_id();
      if (success)
        result->discardable_handle_shm_id = input.discardable_handle_shm_id();
      if (success)
        result->discardable_handle_shm_offset = input.discardable_handle_shm_offset();
      if (success)
        result->discardable_handle_release_count = input.discardable_handle_release_count();
      if (success && !input.ReadTargetColorSpace(&result->target_color_space))
        success = false;
      if (success)
        result->needs_mips = input.needs_mips();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateImageParams::DataView, ::gpu::mojom::CreateImageParamsPtr>::Read(
    ::gpu::mojom::CreateImageParams::DataView input,
    ::gpu::mojom::CreateImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateImageParamsPtr result(::gpu::mojom::CreateImageParams::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadGpuMemoryBuffer(&result->gpu_memory_buffer))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadPlane(&result->plane))
        success = false;
      if (success)
        result->image_release_count = input.image_release_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::DeferredRequest::DataView, ::gpu::mojom::DeferredRequestPtr>::Read(
    ::gpu::mojom::DeferredRequest::DataView input,
    ::gpu::mojom::DeferredRequestPtr* output) {
  bool success = true;
  ::gpu::mojom::DeferredRequestPtr result(::gpu::mojom::DeferredRequest::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadSyncTokenFences(&result->sync_token_fences))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::DeferredCommandBufferRequest::DataView, ::gpu::mojom::DeferredCommandBufferRequestPtr>::Read(
    ::gpu::mojom::DeferredCommandBufferRequest::DataView input,
    ::gpu::mojom::DeferredCommandBufferRequestPtr* output) {
  bool success = true;
  ::gpu::mojom::DeferredCommandBufferRequestPtr result(::gpu::mojom::DeferredCommandBufferRequest::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::AsyncFlushParams::DataView, ::gpu::mojom::AsyncFlushParamsPtr>::Read(
    ::gpu::mojom::AsyncFlushParams::DataView input,
    ::gpu::mojom::AsyncFlushParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::AsyncFlushParamsPtr result(::gpu::mojom::AsyncFlushParams::New());
  
      if (success)
        result->put_offset = input.put_offset();
      if (success)
        result->flush_id = input.flush_id();
      if (success && !input.ReadSyncTokenFences(&result->sync_token_fences))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::ReturnFrontBufferParams::DataView, ::gpu::mojom::ReturnFrontBufferParamsPtr>::Read(
    ::gpu::mojom::ReturnFrontBufferParams::DataView input,
    ::gpu::mojom::ReturnFrontBufferParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::ReturnFrontBufferParamsPtr result(::gpu::mojom::ReturnFrontBufferParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success)
        result->is_lost = input.is_lost();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateSharedImageParams::DataView, ::gpu::mojom::CreateSharedImageParamsPtr>::Read(
    ::gpu::mojom::CreateSharedImageParams::DataView input,
    ::gpu::mojom::CreateSharedImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateSharedImageParamsPtr result(::gpu::mojom::CreateSharedImageParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success)
        result->usage = input.usage();
      if (success)
        result->release_id = input.release_id();
      if (success && !input.ReadSurfaceOrigin(&result->surface_origin))
        success = false;
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateSharedImageWithDataParams::DataView, ::gpu::mojom::CreateSharedImageWithDataParamsPtr>::Read(
    ::gpu::mojom::CreateSharedImageWithDataParams::DataView input,
    ::gpu::mojom::CreateSharedImageWithDataParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateSharedImageWithDataParamsPtr result(::gpu::mojom::CreateSharedImageWithDataParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success)
        result->usage = input.usage();
      if (success)
        result->release_id = input.release_id();
      if (success)
        result->pixel_data_offset = input.pixel_data_offset();
      if (success)
        result->pixel_data_size = input.pixel_data_size();
      if (success)
        result->done_with_shm = input.done_with_shm();
      if (success && !input.ReadSurfaceOrigin(&result->surface_origin))
        success = false;
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::CreateGMBSharedImageParams::DataView, ::gpu::mojom::CreateGMBSharedImageParamsPtr>::Read(
    ::gpu::mojom::CreateGMBSharedImageParams::DataView input,
    ::gpu::mojom::CreateGMBSharedImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::CreateGMBSharedImageParamsPtr result(::gpu::mojom::CreateGMBSharedImageParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadBufferHandle(&result->buffer_handle))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadPlane(&result->plane))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success)
        result->usage = input.usage();
      if (success)
        result->release_id = input.release_id();
      if (success && !input.ReadSurfaceOrigin(&result->surface_origin))
        success = false;
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::UpdateSharedImageParams::DataView, ::gpu::mojom::UpdateSharedImageParamsPtr>::Read(
    ::gpu::mojom::UpdateSharedImageParams::DataView input,
    ::gpu::mojom::UpdateSharedImageParamsPtr* output) {
  bool success = true;
  ::gpu::mojom::UpdateSharedImageParamsPtr result(::gpu::mojom::UpdateSharedImageParams::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success)
        result->release_id = input.release_id();
      if (success && !input.ReadInFenceHandle(&result->in_fence_handle))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gpu::mojom::DeferredRequestParams::DataView, ::gpu::mojom::DeferredRequestParamsPtr>::Read(
    ::gpu::mojom::DeferredRequestParams::DataView input,
    ::gpu::mojom::DeferredRequestParamsPtr* output) {
  using UnionType = ::gpu::mojom::DeferredRequestParams;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::COMMAND_BUFFER_REQUEST: {
      ::gpu::mojom::DeferredCommandBufferRequestPtr result_command_buffer_request;
      if (!input.ReadCommandBufferRequest(&result_command_buffer_request))
        return false;

      *output = UnionType::NewCommandBufferRequest(
          std::move(result_command_buffer_request));
      break;
    }
    case Tag::SHARED_IMAGE_REQUEST: {
      ::gpu::mojom::DeferredSharedImageRequestPtr result_shared_image_request;
      if (!input.ReadSharedImageRequest(&result_shared_image_request))
        return false;

      *output = UnionType::NewSharedImageRequest(
          std::move(result_shared_image_request));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::gpu::mojom::DeferredCommandBufferRequestParams::DataView, ::gpu::mojom::DeferredCommandBufferRequestParamsPtr>::Read(
    ::gpu::mojom::DeferredCommandBufferRequestParams::DataView input,
    ::gpu::mojom::DeferredCommandBufferRequestParamsPtr* output) {
  using UnionType = ::gpu::mojom::DeferredCommandBufferRequestParams;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ASYNC_FLUSH: {
      ::gpu::mojom::AsyncFlushParamsPtr result_async_flush;
      if (!input.ReadAsyncFlush(&result_async_flush))
        return false;

      *output = UnionType::NewAsyncFlush(
          std::move(result_async_flush));
      break;
    }
    case Tag::DESTROY_TRANSFER_BUFFER: {
      *output = UnionType::NewDestroyTransferBuffer(input.destroy_transfer_buffer());
      break;
    }
    case Tag::TAKE_FRONT_BUFFER: {
      ::gpu::Mailbox result_take_front_buffer;
      if (!input.ReadTakeFrontBuffer(&result_take_front_buffer))
        return false;

      *output = UnionType::NewTakeFrontBuffer(
          std::move(result_take_front_buffer));
      break;
    }
    case Tag::RETURN_FRONT_BUFFER: {
      ::gpu::mojom::ReturnFrontBufferParamsPtr result_return_front_buffer;
      if (!input.ReadReturnFrontBuffer(&result_return_front_buffer))
        return false;

      *output = UnionType::NewReturnFrontBuffer(
          std::move(result_return_front_buffer));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::gpu::mojom::DeferredSharedImageRequest::DataView, ::gpu::mojom::DeferredSharedImageRequestPtr>::Read(
    ::gpu::mojom::DeferredSharedImageRequest::DataView input,
    ::gpu::mojom::DeferredSharedImageRequestPtr* output) {
  using UnionType = ::gpu::mojom::DeferredSharedImageRequest;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::NOP: {
      *output = UnionType::NewNop(input.nop());
      break;
    }
    case Tag::CREATE_SHARED_IMAGE: {
      ::gpu::mojom::CreateSharedImageParamsPtr result_create_shared_image;
      if (!input.ReadCreateSharedImage(&result_create_shared_image))
        return false;

      *output = UnionType::NewCreateSharedImage(
          std::move(result_create_shared_image));
      break;
    }
    case Tag::CREATE_SHARED_IMAGE_WITH_DATA: {
      ::gpu::mojom::CreateSharedImageWithDataParamsPtr result_create_shared_image_with_data;
      if (!input.ReadCreateSharedImageWithData(&result_create_shared_image_with_data))
        return false;

      *output = UnionType::NewCreateSharedImageWithData(
          std::move(result_create_shared_image_with_data));
      break;
    }
    case Tag::CREATE_GMB_SHARED_IMAGE: {
      ::gpu::mojom::CreateGMBSharedImageParamsPtr result_create_gmb_shared_image;
      if (!input.ReadCreateGmbSharedImage(&result_create_gmb_shared_image))
        return false;

      *output = UnionType::NewCreateGmbSharedImage(
          std::move(result_create_gmb_shared_image));
      break;
    }
    case Tag::REGISTER_UPLOAD_BUFFER: {
      ::base::ReadOnlySharedMemoryRegion result_register_upload_buffer;
      if (!input.ReadRegisterUploadBuffer(&result_register_upload_buffer))
        return false;

      *output = UnionType::NewRegisterUploadBuffer(
          std::move(result_register_upload_buffer));
      break;
    }
    case Tag::UPDATE_SHARED_IMAGE: {
      ::gpu::mojom::UpdateSharedImageParamsPtr result_update_shared_image;
      if (!input.ReadUpdateSharedImage(&result_update_shared_image))
        return false;

      *output = UnionType::NewUpdateSharedImage(
          std::move(result_update_shared_image));
      break;
    }
    case Tag::DESTROY_SHARED_IMAGE: {
      ::gpu::Mailbox result_destroy_shared_image;
      if (!input.ReadDestroySharedImage(&result_destroy_shared_image))
        return false;

      *output = UnionType::NewDestroySharedImage(
          std::move(result_destroy_shared_image));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif