// gpu/ipc/common/gpu_preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_preferences.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_preferences.mojom-params-data.h"
namespace gpu {
namespace mojom {

static NOINLINE const char* VulkanImplementationNameToStringHelper(VulkanImplementationName value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VulkanImplementationName::kNone:
      return "kNone";
    case VulkanImplementationName::kNative:
      return "kNative";
    case VulkanImplementationName::kForcedNative:
      return "kForcedNative";
    case VulkanImplementationName::kSwiftshader:
      return "{kSwiftshader, kLast}";
    default:
      return nullptr;
  }
}

std::string VulkanImplementationNameToString(VulkanImplementationName value) {
  const char *str = VulkanImplementationNameToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VulkanImplementationName value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VulkanImplementationName value) {
  return os << VulkanImplementationNameToString(value);
}

static NOINLINE const char* GrContextTypeToStringHelper(GrContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GrContextType::kGL:
      return "kGL";
    case GrContextType::kVulkan:
      return "kVulkan";
    case GrContextType::kMetal:
      return "kMetal";
    case GrContextType::kDawn:
      return "{kDawn, kLast}";
    default:
      return nullptr;
  }
}

std::string GrContextTypeToString(GrContextType value) {
  const char *str = GrContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GrContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GrContextType value) {
  return os << GrContextTypeToString(value);
}

static NOINLINE const char* DawnBackendValidationLevelToStringHelper(DawnBackendValidationLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DawnBackendValidationLevel::kDisabled:
      return "kDisabled";
    case DawnBackendValidationLevel::kPartial:
      return "kPartial";
    case DawnBackendValidationLevel::kFull:
      return "kFull";
    default:
      return nullptr;
  }
}

std::string DawnBackendValidationLevelToString(DawnBackendValidationLevel value) {
  const char *str = DawnBackendValidationLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DawnBackendValidationLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DawnBackendValidationLevel value) {
  return os << DawnBackendValidationLevelToString(value);
}

namespace internal {


// static
bool GpuPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuPreferences_Data* object = static_cast<const GpuPreferences_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->texture_target_exception_list, 34, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams texture_target_exception_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->texture_target_exception_list, validation_context,
                                         &texture_target_exception_list_validate_params)) {
    return false;
  }


  if (!::gpu::mojom::internal::GrContextType_Data
        ::Validate(object->gr_context_type, validation_context))
    return false;


  if (!::gpu::mojom::internal::VulkanImplementationName_Data
        ::Validate(object->use_vulkan, validation_context))
    return false;


  if (!::gpu::mojom::internal::DawnBackendValidationLevel_Data
        ::Validate(object->enable_dawn_backend_validation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_dawn_features_list, 53, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams enabled_dawn_features_list_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->enabled_dawn_features_list, validation_context,
                                         &enabled_dawn_features_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_dawn_features_list, 54, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams disabled_dawn_features_list_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->disabled_dawn_features_list, validation_context,
                                         &disabled_dawn_features_list_validate_params)) {
    return false;
  }


  if (!::mojo_base::mojom::internal::MessagePumpType_Data
        ::Validate(object->message_pump_type, validation_context))
    return false;

  return true;
}

GpuPreferences_Data::GpuPreferences_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::VulkanImplementationName>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::VulkanImplementationName value) {
  return std::move(context).WriteString(::gpu::mojom::VulkanImplementationNameToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::GrContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::GrContextType value) {
  return std::move(context).WriteString(::gpu::mojom::GrContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::DawnBackendValidationLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::DawnBackendValidationLevel value) {
  return std::move(context).WriteString(::gpu::mojom::DawnBackendValidationLevelToString(value));
}

} // namespace perfetto
