// gpu/ipc/common/memory_stats.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/memory_stats.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/memory_stats.mojom-params-data.h"
#include "gpu/ipc/common/memory_stats.mojom-shared-message-ids.h"

#include "gpu/ipc/common/memory_stats.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef GPU_IPC_COMMON_MEMORY_STATS_MOJOM_BLINK_JUMBO_H_
#define GPU_IPC_COMMON_MEMORY_STATS_MOJOM_BLINK_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
namespace blink {
VideoMemoryProcessStats::VideoMemoryProcessStats()
    : video_memory_bytes(),
      has_duplicates() {}

VideoMemoryProcessStats::VideoMemoryProcessStats(
    uint64_t video_memory_bytes_in,
    bool has_duplicates_in)
    : video_memory_bytes(std::move(video_memory_bytes_in)),
      has_duplicates(std::move(has_duplicates_in)) {}

VideoMemoryProcessStats::~VideoMemoryProcessStats() = default;
size_t VideoMemoryProcessStats::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->video_memory_bytes);
  seed = mojo::internal::WTFHash(seed, this->has_duplicates);
  return seed;
}

void VideoMemoryProcessStats::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_memory_bytes"), this->video_memory_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_duplicates"), this->has_duplicates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoMemoryProcessStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoMemoryUsageStats::VideoMemoryUsageStats()
    : process_map(),
      bytes_allocated() {}

VideoMemoryUsageStats::VideoMemoryUsageStats(
    WTF::HashMap<int32_t, VideoMemoryProcessStatsPtr> process_map_in,
    uint64_t bytes_allocated_in)
    : process_map(std::move(process_map_in)),
      bytes_allocated(std::move(bytes_allocated_in)) {}

VideoMemoryUsageStats::~VideoMemoryUsageStats() = default;

void VideoMemoryUsageStats::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_map"), this->process_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::HashMap<int32_t, VideoMemoryProcessStatsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes_allocated"), this->bytes_allocated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoMemoryUsageStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::VideoMemoryProcessStats::DataView, ::gpu::mojom::blink::VideoMemoryProcessStatsPtr>::Read(
    ::gpu::mojom::blink::VideoMemoryProcessStats::DataView input,
    ::gpu::mojom::blink::VideoMemoryProcessStatsPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VideoMemoryProcessStatsPtr result(::gpu::mojom::blink::VideoMemoryProcessStats::New());
  
      if (success)
        result->video_memory_bytes = input.video_memory_bytes();
      if (success)
        result->has_duplicates = input.has_duplicates();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VideoMemoryUsageStats::DataView, ::gpu::mojom::blink::VideoMemoryUsageStatsPtr>::Read(
    ::gpu::mojom::blink::VideoMemoryUsageStats::DataView input,
    ::gpu::mojom::blink::VideoMemoryUsageStatsPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VideoMemoryUsageStatsPtr result(::gpu::mojom::blink::VideoMemoryUsageStats::New());
  
      if (success && !input.ReadProcessMap(&result->process_map))
        success = false;
      if (success)
        result->bytes_allocated = input.bytes_allocated();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif