// media/capture/mojom/video_capture.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/capture/mojom/video_capture.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture.mojom-params-data.h"
namespace media {
namespace mojom {

static NOINLINE const char* VideoCaptureStateToStringHelper(VideoCaptureState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureState::STARTED:
      return "STARTED";
    case VideoCaptureState::PAUSED:
      return "PAUSED";
    case VideoCaptureState::RESUMED:
      return "RESUMED";
    case VideoCaptureState::STOPPED:
      return "STOPPED";
    case VideoCaptureState::FAILED:
      return "FAILED";
    case VideoCaptureState::ENDED:
      return "ENDED";
    default:
      return nullptr;
  }
}

std::string VideoCaptureStateToString(VideoCaptureState value) {
  const char *str = VideoCaptureStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureState value) {
  return os << VideoCaptureStateToString(value);
}

namespace internal {


// static
bool VideoCaptureObserver_OnStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureObserver_OnStateChanged_Params_Data* object = static_cast<const VideoCaptureObserver_OnStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::VideoCaptureState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnStateChanged_Params_Data::VideoCaptureObserver_OnStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnNewBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureObserver_OnNewBuffer_Params_Data* object = static_cast<const VideoCaptureObserver_OnNewBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buffer_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buffer_handle, validation_context))
    return false;

  return true;
}

VideoCaptureObserver_OnNewBuffer_Params_Data::VideoCaptureObserver_OnNewBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnBufferReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureObserver_OnBufferReady_Params_Data* object = static_cast<const VideoCaptureObserver_OnBufferReady_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scaled_buffers, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams scaled_buffers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->scaled_buffers, validation_context,
                                         &scaled_buffers_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureObserver_OnBufferReady_Params_Data::VideoCaptureObserver_OnBufferReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureObserver_OnBufferDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureObserver_OnBufferDestroyed_Params_Data* object = static_cast<const VideoCaptureObserver_OnBufferDestroyed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoCaptureObserver_OnBufferDestroyed_Params_Data::VideoCaptureObserver_OnBufferDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_Start_Params_Data* object = static_cast<const VideoCaptureHost_Start_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoCaptureHost_Start_Params_Data::VideoCaptureHost_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_Stop_Params_Data* object = static_cast<const VideoCaptureHost_Stop_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_Stop_Params_Data::VideoCaptureHost_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Pause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_Pause_Params_Data* object = static_cast<const VideoCaptureHost_Pause_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_Pause_Params_Data::VideoCaptureHost_Pause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_Resume_Params_Data* object = static_cast<const VideoCaptureHost_Resume_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

VideoCaptureHost_Resume_Params_Data::VideoCaptureHost_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_RequestRefreshFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_RequestRefreshFrame_Params_Data* object = static_cast<const VideoCaptureHost_RequestRefreshFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_RequestRefreshFrame_Params_Data::VideoCaptureHost_RequestRefreshFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_ReleaseBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_ReleaseBuffer_Params_Data* object = static_cast<const VideoCaptureHost_ReleaseBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feedback, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feedback, validation_context))
    return false;

  return true;
}

VideoCaptureHost_ReleaseBuffer_Params_Data::VideoCaptureHost_ReleaseBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceSupportedFormats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_GetDeviceSupportedFormats_Params_Data* object = static_cast<const VideoCaptureHost_GetDeviceSupportedFormats_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_GetDeviceSupportedFormats_Params_Data::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data* object = static_cast<const VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formats_supported, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams formats_supported_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->formats_supported, validation_context,
                                         &formats_supported_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceFormatsInUse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_GetDeviceFormatsInUse_Params_Data* object = static_cast<const VideoCaptureHost_GetDeviceFormatsInUse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_id, validation_context))
    return false;

  return true;
}

VideoCaptureHost_GetDeviceFormatsInUse_Params_Data::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data* object = static_cast<const VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formats_in_use, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams formats_in_use_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->formats_in_use, validation_context,
                                         &formats_in_use_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_OnFrameDropped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_OnFrameDropped_Params_Data* object = static_cast<const VideoCaptureHost_OnFrameDropped_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureFrameDropReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

VideoCaptureHost_OnFrameDropped_Params_Data::VideoCaptureHost_OnFrameDropped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureHost_OnLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureHost_OnLog_Params_Data* object = static_cast<const VideoCaptureHost_OnLog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureHost_OnLog_Params_Data::VideoCaptureHost_OnLog_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureState value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureStateToString(value));
}

} // namespace perfetto
