// media/mojo/mojom/cdm_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_service.mojom-params-data.h"
#include "media/mojo/mojom/cdm_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_service.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
const char CdmService::Name_[] = "media.mojom.CdmService";

CdmServiceProxy::CdmServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceProxy::CreateCdmFactory(
    ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> in_factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> in_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmService::CreateCdmFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_interfaces"), in_frame_interfaces,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmService_CreateCdmFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmService_CreateCdmFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in CdmService.CreateCdmFactory request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::FrameInterfaceFactoryInterfaceBase>>(
      in_frame_interfaces, &params->frame_interfaces, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame_interfaces),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_interfaces in CdmService.CreateCdmFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmService::Name_);
  message.set_method_name("CreateCdmFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CdmServiceStubDispatch::Accept(
    CdmService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCdmService_CreateCdmFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmService::CreateCdmFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmService::CreateCdmFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CdmService_CreateCdmFactory_Params_Data* params =
          reinterpret_cast<internal::CdmService_CreateCdmFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> p_factory{};
      ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> p_frame_interfaces{};
      CdmService_CreateCdmFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success) {
        p_frame_interfaces =
            input_data_view.TakeFrameInterfaces<decltype(p_frame_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdmFactory(
std::move(p_factory), 
std::move(p_frame_interfaces));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceStubDispatch::AcceptWithResponder(
    CdmService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCdmService_CreateCdmFactory_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmServiceValidationInfo[] = {
    {internal::kCdmService_CreateCdmFactory_Name,
     {&internal::CdmService_CreateCdmFactory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CdmServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmServiceValidationInfo);
}

const char CdmServiceBroker::Name_[] = "media.mojom.CdmServiceBroker";

CdmServiceBrokerProxy::CdmServiceBrokerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceBrokerProxy::GetService(
    const ::base::FilePath& in_cdm_path, ::mojo::PendingReceiver<CdmService> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmServiceBroker::GetService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_path"), in_cdm_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<CdmService>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmServiceBroker_GetService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmServiceBroker_GetService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_path)::BaseType> cdm_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_cdm_path, cdm_path_fragment);
  params->cdm_path.Set(
      cdm_path_fragment.is_null() ? nullptr : cdm_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_path in CdmServiceBroker.GetService request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmServiceInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CdmServiceBroker.GetService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmServiceBroker::Name_);
  message.set_method_name("GetService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CdmServiceBrokerStubDispatch::Accept(
    CdmServiceBroker* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCdmServiceBroker_GetService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmServiceBroker::GetService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmServiceBroker::GetService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CdmServiceBroker_GetService_Params_Data* params =
          reinterpret_cast<internal::CdmServiceBroker_GetService_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_cdm_path{};
      ::mojo::PendingReceiver<CdmService> p_receiver{};
      CdmServiceBroker_GetService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmPath(&p_cdm_path))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmServiceBroker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetService(
std::move(p_cdm_path), 
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceBrokerStubDispatch::AcceptWithResponder(
    CdmServiceBroker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCdmServiceBroker_GetService_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmServiceBrokerValidationInfo[] = {
    {internal::kCdmServiceBroker_GetService_Name,
     {&internal::CdmServiceBroker_GetService_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CdmServiceBrokerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmServiceBroker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmServiceBrokerValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif