// media/mojo/mojom/content_decryption_module.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/content_decryption_module.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "media/mojo/mojom/decryptor.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"


#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_BLINK_JUMBO_H_
#endif


namespace media {
namespace mojom {
namespace blink {


void ContentDecryptionModuleInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) {
  GetForwardingInterface()->SetClient(std::move(client));
}
void ContentDecryptionModuleInterceptorForTesting::SetServerCertificate(const WTF::Vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) {
  GetForwardingInterface()->SetServerCertificate(std::move(certificate_data), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::GetStatusForPolicy(HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) {
  GetForwardingInterface()->GetStatusForPolicy(std::move(min_hdcp_version), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::CreateSessionAndGenerateRequest(CdmSessionType session_type, EmeInitDataType init_data_type, const WTF::Vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) {
  GetForwardingInterface()->CreateSessionAndGenerateRequest(std::move(session_type), std::move(init_data_type), std::move(init_data), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::LoadSession(CdmSessionType session_type, const WTF::String& session_id, LoadSessionCallback callback) {
  GetForwardingInterface()->LoadSession(std::move(session_type), std::move(session_id), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::UpdateSession(const WTF::String& session_id, const WTF::Vector<uint8_t>& response, UpdateSessionCallback callback) {
  GetForwardingInterface()->UpdateSession(std::move(session_id), std::move(response), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::CloseSession(const WTF::String& session_id, CloseSessionCallback callback) {
  GetForwardingInterface()->CloseSession(std::move(session_id), std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::RemoveSession(const WTF::String& session_id, RemoveSessionCallback callback) {
  GetForwardingInterface()->RemoveSession(std::move(session_id), std::move(callback));
}
ContentDecryptionModuleAsyncWaiter::ContentDecryptionModuleAsyncWaiter(
    ContentDecryptionModule* proxy) : proxy_(proxy) {}

ContentDecryptionModuleAsyncWaiter::~ContentDecryptionModuleAsyncWaiter() = default;

void ContentDecryptionModuleAsyncWaiter::SetServerCertificate(
    const WTF::Vector<uint8_t>& certificate_data, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SetServerCertificate(std::move(certificate_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::GetStatusForPolicy(
    HdcpVersion min_hdcp_version, CdmPromiseResultPtr* out_result, CdmKeyStatus* out_key_status) {
  base::RunLoop loop;
  proxy_->GetStatusForPolicy(std::move(min_hdcp_version),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmKeyStatus* out_key_status
,
             CdmPromiseResultPtr result,
             CdmKeyStatus key_status) {*out_result = std::move(result);*out_key_status = std::move(key_status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_key_status));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::CreateSessionAndGenerateRequest(
    CdmSessionType session_type, EmeInitDataType init_data_type, const WTF::Vector<uint8_t>& init_data, CdmPromiseResultPtr* out_result, WTF::String* out_session_id) {
  base::RunLoop loop;
  proxy_->CreateSessionAndGenerateRequest(std::move(session_type),std::move(init_data_type),std::move(init_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             WTF::String* out_session_id
,
             CdmPromiseResultPtr result,
             const WTF::String& session_id) {*out_result = std::move(result);*out_session_id = std::move(session_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_session_id));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::LoadSession(
    CdmSessionType session_type, const WTF::String& session_id, CdmPromiseResultPtr* out_result, WTF::String* out_session_id) {
  base::RunLoop loop;
  proxy_->LoadSession(std::move(session_type),std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             WTF::String* out_session_id
,
             CdmPromiseResultPtr result,
             const WTF::String& session_id) {*out_result = std::move(result);*out_session_id = std::move(session_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_session_id));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::UpdateSession(
    const WTF::String& session_id, const WTF::Vector<uint8_t>& response, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->UpdateSession(std::move(session_id),std::move(response),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::CloseSession(
    const WTF::String& session_id, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CloseSession(std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ContentDecryptionModuleAsyncWaiter::RemoveSession(
    const WTF::String& session_id, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->RemoveSession(std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void ContentDecryptionModuleClientInterceptorForTesting::OnSessionMessage(const WTF::String& session_id, CdmMessageType message_type, const WTF::Vector<uint8_t>& message) {
  GetForwardingInterface()->OnSessionMessage(std::move(session_id), std::move(message_type), std::move(message));
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionClosed(const WTF::String& session_id, ::media::mojom::blink::CdmSessionClosedReason reason) {
  GetForwardingInterface()->OnSessionClosed(std::move(session_id), std::move(reason));
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionKeysChange(const WTF::String& session_id, bool has_additional_usable_key, WTF::Vector<CdmKeyInformationPtr> keys_info) {
  GetForwardingInterface()->OnSessionKeysChange(std::move(session_id), std::move(has_additional_usable_key), std::move(keys_info));
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionExpirationUpdate(const WTF::String& session_id, double new_expiry_time_sec) {
  GetForwardingInterface()->OnSessionExpirationUpdate(std::move(session_id), std::move(new_expiry_time_sec));
}
ContentDecryptionModuleClientAsyncWaiter::ContentDecryptionModuleClientAsyncWaiter(
    ContentDecryptionModuleClient* proxy) : proxy_(proxy) {}

ContentDecryptionModuleClientAsyncWaiter::~ContentDecryptionModuleClientAsyncWaiter() = default;




void CdmFactoryInterceptorForTesting::CreateCdm(const WTF::String& key_system, CdmConfigPtr cdm_config, CreateCdmCallback callback) {
  GetForwardingInterface()->CreateCdm(std::move(key_system), std::move(cdm_config), std::move(callback));
}
CdmFactoryAsyncWaiter::CdmFactoryAsyncWaiter(
    CdmFactory* proxy) : proxy_(proxy) {}

CdmFactoryAsyncWaiter::~CdmFactoryAsyncWaiter() = default;

void CdmFactoryAsyncWaiter::CreateCdm(
    const WTF::String& key_system, CdmConfigPtr cdm_config, ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm, CdmContextPtr* out_cdm_context, WTF::String* out_error_message) {
  base::RunLoop loop;
  proxy_->CreateCdm(std::move(key_system),std::move(cdm_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm
,
             CdmContextPtr* out_cdm_context
,
             WTF::String* out_error_message
,
             ::mojo::PendingRemote<ContentDecryptionModule> cdm,
             CdmContextPtr cdm_context,
             const WTF::String& error_message) {*out_cdm = std::move(cdm);*out_cdm_context = std::move(cdm_context);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_cdm,
          out_cdm_context,
          out_error_message));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif