// media/mojo/mojom/gpu_accelerated_video_decoder.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/gpu_accelerated_video_decoder.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/gpu_accelerated_video_decoder.mojom-params-data.h"
#include "media/mojo/mojom/gpu_accelerated_video_decoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/gpu_accelerated_video_decoder.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_GPU_ACCELERATED_VIDEO_DECODER_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_GPU_ACCELERATED_VIDEO_DECODER_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
PictureBufferAssignment::PictureBufferAssignment()
    : buffer_id(),
      texture_ids() {}

PictureBufferAssignment::PictureBufferAssignment(
    int32_t buffer_id_in,
    WTF::Vector<uint32_t> texture_ids_in)
    : buffer_id(std::move(buffer_id_in)),
      texture_ids(std::move(texture_ids_in)) {}

PictureBufferAssignment::~PictureBufferAssignment() = default;

void PictureBufferAssignment::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_id"), this->buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_ids"), this->texture_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PictureBufferAssignment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PictureReadyParams::PictureReadyParams()
    : picture_buffer_id(),
      bitstream_buffer_id(),
      visible_rect(),
      color_space(),
      allow_overlay(),
      read_lock_fences_enabled(),
      size_changed(),
      surface_texture(),
      wants_promotion_hint() {}

PictureReadyParams::PictureReadyParams(
    int32_t picture_buffer_id_in,
    int32_t bitstream_buffer_id_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::ColorSpace& color_space_in,
    bool allow_overlay_in,
    bool read_lock_fences_enabled_in,
    bool size_changed_in,
    bool surface_texture_in,
    bool wants_promotion_hint_in)
    : picture_buffer_id(std::move(picture_buffer_id_in)),
      bitstream_buffer_id(std::move(bitstream_buffer_id_in)),
      visible_rect(std::move(visible_rect_in)),
      color_space(std::move(color_space_in)),
      allow_overlay(std::move(allow_overlay_in)),
      read_lock_fences_enabled(std::move(read_lock_fences_enabled_in)),
      size_changed(std::move(size_changed_in)),
      surface_texture(std::move(surface_texture_in)),
      wants_promotion_hint(std::move(wants_promotion_hint_in)) {}

PictureReadyParams::~PictureReadyParams() = default;

void PictureReadyParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "picture_buffer_id"), this->picture_buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitstream_buffer_id"), this->bitstream_buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_overlay"), this->allow_overlay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_lock_fences_enabled"), this->read_lock_fences_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_changed"), this->size_changed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_texture"), this->surface_texture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_promotion_hint"), this->wants_promotion_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PictureReadyParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char GpuAcceleratedVideoDecoderProvider::Name_[] = "media.mojom.GpuAcceleratedVideoDecoderProvider";
bool GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoder(VideoDecodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder> receiver, ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient> client, bool* out_success) {
  NOTREACHED();
  return false;
}
class GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_HandleSyncResponse);
};

class GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ForwardToCallback(
      GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ForwardToCallback);
};

GpuAcceleratedVideoDecoderProviderProxy::GpuAcceleratedVideoDecoderProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GpuAcceleratedVideoDecoderProviderProxy::CreateAcceleratedVideoDecoder(
    VideoDecodeAcceleratorConfigPtr param_config, ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder> param_receiver, ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient> param_client, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), param_config,
                        "<value of type VideoDecodeAcceleratorConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), param_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), param_client,
                        "<value of type ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoDecodeAcceleratorConfigDataView>(
      param_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in GpuAcceleratedVideoDecoderProvider.CreateAcceleratedVideoDecoder request");
  mojo::internal::Serialize<::media::mojom::GpuAcceleratedVideoDecoderAssociatedRequestDataView>(
      param_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in GpuAcceleratedVideoDecoderProvider.CreateAcceleratedVideoDecoder request");
  mojo::internal::Serialize<::media::mojom::GpuAcceleratedVideoDecoderClientAssociatedPtrInfoDataView>(
      param_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in GpuAcceleratedVideoDecoderProvider.CreateAcceleratedVideoDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderProvider::Name_);
  message.set_method_name("CreateAcceleratedVideoDecoder");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoder", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void GpuAcceleratedVideoDecoderProviderProxy::CreateAcceleratedVideoDecoder(
    VideoDecodeAcceleratorConfigPtr in_config, ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder> in_receiver, ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient> in_client, CreateAcceleratedVideoDecoderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type VideoDecodeAcceleratorConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoDecodeAcceleratorConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in GpuAcceleratedVideoDecoderProvider.CreateAcceleratedVideoDecoder request");
  mojo::internal::Serialize<::media::mojom::GpuAcceleratedVideoDecoderAssociatedRequestDataView>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in GpuAcceleratedVideoDecoderProvider.CreateAcceleratedVideoDecoder request");
  mojo::internal::Serialize<::media::mojom::GpuAcceleratedVideoDecoderClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in GpuAcceleratedVideoDecoderProvider.CreateAcceleratedVideoDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderProvider::Name_);
  message.set_method_name("CreateAcceleratedVideoDecoder");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder {
 public:
  static GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder> proxy(
        new GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder);
};

bool GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuAcceleratedVideoDecoderProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderProvider::Name_);
  message.set_method_name("CreateAcceleratedVideoDecoder");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuAcceleratedVideoDecoderProvider::Name_, 0, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}

// static
bool GpuAcceleratedVideoDecoderProviderStubDispatch::Accept(
    GpuAcceleratedVideoDecoderProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Name: {
      break;
    }
  }
  return false;
}

// static
bool GpuAcceleratedVideoDecoderProviderStubDispatch::AcceptWithResponder(
    GpuAcceleratedVideoDecoderProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Params_Data* params =
          reinterpret_cast<
              internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoDecodeAcceleratorConfigPtr p_config{};
      ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder> p_receiver{};
      ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient> p_client{};
      GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderProvider::Name_, 0, false);
        return false;
      }
      GpuAcceleratedVideoDecoderProvider::CreateAcceleratedVideoDecoderCallback callback =
          GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAcceleratedVideoDecoder(
std::move(p_config), 
std::move(p_receiver), 
std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuAcceleratedVideoDecoderProviderValidationInfo[] = {
    {internal::kGpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Name,
     {&internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_Params_Data::Validate,
      &internal::GpuAcceleratedVideoDecoderProvider_CreateAcceleratedVideoDecoder_ResponseParams_Data::Validate}},
};

bool GpuAcceleratedVideoDecoderProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::GpuAcceleratedVideoDecoderProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuAcceleratedVideoDecoderProviderValidationInfo);
}

bool GpuAcceleratedVideoDecoderProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::GpuAcceleratedVideoDecoderProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuAcceleratedVideoDecoderProviderValidationInfo);

}
const char GpuAcceleratedVideoDecoder::Name_[] = "media.mojom.GpuAcceleratedVideoDecoder";

class GpuAcceleratedVideoDecoder_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuAcceleratedVideoDecoder_Flush_ForwardToCallback(
      GpuAcceleratedVideoDecoder::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuAcceleratedVideoDecoder::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoder_Flush_ForwardToCallback);
};

class GpuAcceleratedVideoDecoder_Reset_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuAcceleratedVideoDecoder_Reset_ForwardToCallback(
      GpuAcceleratedVideoDecoder::ResetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuAcceleratedVideoDecoder::ResetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoder_Reset_ForwardToCallback);
};

GpuAcceleratedVideoDecoderProxy::GpuAcceleratedVideoDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuAcceleratedVideoDecoderProxy::Decode(
    BitstreamBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type BitstreamBufferPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_Decode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::BitstreamBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in GpuAcceleratedVideoDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("Decode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderProxy::AssignPictureBuffers(
    WTF::Vector<PictureBufferAssignmentPtr> in_assignments) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoder::AssignPictureBuffers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("assignments"), in_assignments,
                        "<value of type WTF::Vector<PictureBufferAssignmentPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_AssignPictureBuffers_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_AssignPictureBuffers_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->assignments)::BaseType>
      assignments_fragment(params.message());
  const mojo::internal::ContainerValidateParams assignments_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::PictureBufferAssignmentDataView>>(
      in_assignments, assignments_fragment, &assignments_validate_params);
  params->assignments.Set(
      assignments_fragment.is_null() ? nullptr : assignments_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->assignments.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null assignments in GpuAcceleratedVideoDecoder.AssignPictureBuffers request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("AssignPictureBuffers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderProxy::ReusePictureBuffer(
    int32_t in_picture_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoder::ReusePictureBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("picture_buffer_id"), in_picture_buffer_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_ReusePictureBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_ReusePictureBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->picture_buffer_id = in_picture_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("ReusePictureBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::GpuAcceleratedVideoDecoder::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuAcceleratedVideoDecoder_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuAcceleratedVideoDecoderProxy::Reset(
    ResetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::GpuAcceleratedVideoDecoder::Reset");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_Reset_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("Reset");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuAcceleratedVideoDecoder_Reset_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuAcceleratedVideoDecoderProxy::SetOverlayInfo(
    ::media::mojom::blink::OverlayInfoPtr in_overlay_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoder::SetOverlayInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overlay_info"), in_overlay_info,
                        "<value of type ::media::mojom::blink::OverlayInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_SetOverlayInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_SetOverlayInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->overlay_info)::BaseType> overlay_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::OverlayInfoDataView>(
      in_overlay_info, overlay_info_fragment);
  params->overlay_info.Set(
      overlay_info_fragment.is_null() ? nullptr : overlay_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->overlay_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null overlay_info in GpuAcceleratedVideoDecoder.SetOverlayInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("SetOverlayInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class GpuAcceleratedVideoDecoder_Flush_ProxyToResponder {
 public:
  static GpuAcceleratedVideoDecoder::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuAcceleratedVideoDecoder_Flush_ProxyToResponder> proxy(
        new GpuAcceleratedVideoDecoder_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuAcceleratedVideoDecoder_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuAcceleratedVideoDecoder_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuAcceleratedVideoDecoder_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuAcceleratedVideoDecoder::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoder_Flush_ProxyToResponder);
};

bool GpuAcceleratedVideoDecoder_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::GpuAcceleratedVideoDecoder::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuAcceleratedVideoDecoder_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuAcceleratedVideoDecoder_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GpuAcceleratedVideoDecoder_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuAcceleratedVideoDecoder::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void GpuAcceleratedVideoDecoder_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media::mojom::GpuAcceleratedVideoDecoder::FlushCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::GpuAcceleratedVideoDecoder::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuAcceleratedVideoDecoder_Reset_ProxyToResponder {
 public:
  static GpuAcceleratedVideoDecoder::ResetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuAcceleratedVideoDecoder_Reset_ProxyToResponder> proxy(
        new GpuAcceleratedVideoDecoder_Reset_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuAcceleratedVideoDecoder_Reset_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuAcceleratedVideoDecoder_Reset_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuAcceleratedVideoDecoder_Reset_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuAcceleratedVideoDecoder::ResetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuAcceleratedVideoDecoder_Reset_ProxyToResponder);
};

bool GpuAcceleratedVideoDecoder_Reset_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::GpuAcceleratedVideoDecoder::ResetCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuAcceleratedVideoDecoder_Reset_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuAcceleratedVideoDecoder_Reset_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GpuAcceleratedVideoDecoder_Reset_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuAcceleratedVideoDecoder::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void GpuAcceleratedVideoDecoder_Reset_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media::mojom::GpuAcceleratedVideoDecoder::ResetCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoder_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoder_Reset_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::GpuAcceleratedVideoDecoder::ResetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoder::Name_);
  message.set_method_name("Reset");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuAcceleratedVideoDecoderStubDispatch::Accept(
    GpuAcceleratedVideoDecoder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuAcceleratedVideoDecoder_Decode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoder::Decode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoder::Decode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoder_Decode_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoder_Decode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BitstreamBufferPtr p_buffer{};
      GpuAcceleratedVideoDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(
std::move(p_buffer));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoder_AssignPictureBuffers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoder::AssignPictureBuffers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoder::AssignPictureBuffers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoder_AssignPictureBuffers_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoder_AssignPictureBuffers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<PictureBufferAssignmentPtr> p_assignments{};
      GpuAcceleratedVideoDecoder_AssignPictureBuffers_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAssignments(&p_assignments))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AssignPictureBuffers(
std::move(p_assignments));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoder_ReusePictureBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoder::ReusePictureBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoder::ReusePictureBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoder_ReusePictureBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoder_ReusePictureBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_picture_buffer_id{};
      GpuAcceleratedVideoDecoder_ReusePictureBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_picture_buffer_id = input_data_view.picture_buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReusePictureBuffer(
std::move(p_picture_buffer_id));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoder_Flush_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoder_Reset_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoder_SetOverlayInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoder::SetOverlayInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoder::SetOverlayInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoder_SetOverlayInfo_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoder_SetOverlayInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::OverlayInfoPtr p_overlay_info{};
      GpuAcceleratedVideoDecoder_SetOverlayInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOverlayInfo(&p_overlay_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOverlayInfo(
std::move(p_overlay_info));
      return true;
    }
  }
  return false;
}

// static
bool GpuAcceleratedVideoDecoderStubDispatch::AcceptWithResponder(
    GpuAcceleratedVideoDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuAcceleratedVideoDecoder_Decode_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoder_AssignPictureBuffers_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoder_ReusePictureBuffer_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoder_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoder::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoder::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuAcceleratedVideoDecoder_Flush_Params_Data* params =
          reinterpret_cast<
              internal::GpuAcceleratedVideoDecoder_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuAcceleratedVideoDecoder_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoder::Name_, 3, false);
        return false;
      }
      GpuAcceleratedVideoDecoder::FlushCallback callback =
          GpuAcceleratedVideoDecoder_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoder_Reset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoder::Reset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoder::Reset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuAcceleratedVideoDecoder_Reset_Params_Data* params =
          reinterpret_cast<
              internal::GpuAcceleratedVideoDecoder_Reset_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuAcceleratedVideoDecoder_Reset_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoder::Name_, 4, false);
        return false;
      }
      GpuAcceleratedVideoDecoder::ResetCallback callback =
          GpuAcceleratedVideoDecoder_Reset_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(std::move(callback));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoder_SetOverlayInfo_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuAcceleratedVideoDecoderValidationInfo[] = {
    {internal::kGpuAcceleratedVideoDecoder_Decode_Name,
     {&internal::GpuAcceleratedVideoDecoder_Decode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoder_AssignPictureBuffers_Name,
     {&internal::GpuAcceleratedVideoDecoder_AssignPictureBuffers_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoder_ReusePictureBuffer_Name,
     {&internal::GpuAcceleratedVideoDecoder_ReusePictureBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoder_Flush_Name,
     {&internal::GpuAcceleratedVideoDecoder_Flush_Params_Data::Validate,
      &internal::GpuAcceleratedVideoDecoder_Flush_ResponseParams_Data::Validate}},
    {internal::kGpuAcceleratedVideoDecoder_Reset_Name,
     {&internal::GpuAcceleratedVideoDecoder_Reset_Params_Data::Validate,
      &internal::GpuAcceleratedVideoDecoder_Reset_ResponseParams_Data::Validate}},
    {internal::kGpuAcceleratedVideoDecoder_SetOverlayInfo_Name,
     {&internal::GpuAcceleratedVideoDecoder_SetOverlayInfo_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuAcceleratedVideoDecoderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::GpuAcceleratedVideoDecoder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuAcceleratedVideoDecoderValidationInfo);
}

bool GpuAcceleratedVideoDecoderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::GpuAcceleratedVideoDecoder::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuAcceleratedVideoDecoderValidationInfo);

}
const char GpuAcceleratedVideoDecoderClient::Name_[] = "media.mojom.GpuAcceleratedVideoDecoderClient";

GpuAcceleratedVideoDecoderClientProxy::GpuAcceleratedVideoDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuAcceleratedVideoDecoderClientProxy::OnInitializationComplete(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderClient::OnInitializationComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderClient_OnInitializationComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderClient_OnInitializationComplete_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderClient::Name_);
  message.set_method_name("OnInitializationComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderClientProxy::OnBitstreamBufferProcessed(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderClient::OnBitstreamBufferProcessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderClient::Name_);
  message.set_method_name("OnBitstreamBufferProcessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderClientProxy::OnProvidePictureBuffers(
    uint32_t in_num_frames, ::media::mojom::blink::VideoPixelFormat in_format, uint32_t in_num_textures_per_frame, const ::gfx::Size& in_buffer_size, uint32_t in_texture_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderClient::OnProvidePictureBuffers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_frames"), in_num_frames,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type ::media::mojom::blink::VideoPixelFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_textures_per_frame"), in_num_textures_per_frame,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_size"), in_buffer_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("texture_target"), in_texture_target,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Params_Data> params(
          message);
  params.Allocate();
  params->num_frames = in_num_frames;
  mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
      in_format, &params->format);
  params->num_textures_per_frame = in_num_textures_per_frame;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_size)::BaseType> buffer_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_buffer_size, buffer_size_fragment);
  params->buffer_size.Set(
      buffer_size_fragment.is_null() ? nullptr : buffer_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_size in GpuAcceleratedVideoDecoderClient.OnProvidePictureBuffers request");
  params->texture_target = in_texture_target;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderClient::Name_);
  message.set_method_name("OnProvidePictureBuffers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderClientProxy::OnPictureReady(
    PictureReadyParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderClient::OnPictureReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PictureReadyParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderClient_OnPictureReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderClient_OnPictureReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PictureReadyParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in GpuAcceleratedVideoDecoderClient.OnPictureReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderClient::Name_);
  message.set_method_name("OnPictureReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderClientProxy::OnDismissPictureBuffer(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderClient::OnDismissPictureBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderClient::Name_);
  message.set_method_name("OnDismissPictureBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuAcceleratedVideoDecoderClientProxy::OnError(
    uint32_t in_error_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::GpuAcceleratedVideoDecoderClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_id"), in_error_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuAcceleratedVideoDecoderClient_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::GpuAcceleratedVideoDecoderClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  params->error_id = in_error_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuAcceleratedVideoDecoderClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool GpuAcceleratedVideoDecoderClientStubDispatch::Accept(
    GpuAcceleratedVideoDecoderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuAcceleratedVideoDecoderClient_OnInitializationComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnInitializationComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnInitializationComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoderClient_OnInitializationComplete_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoderClient_OnInitializationComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_success{};
      GpuAcceleratedVideoDecoderClient_OnInitializationComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInitializationComplete(
std::move(p_success));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnBitstreamBufferProcessed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnBitstreamBufferProcessed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      GpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBitstreamBufferProcessed(
std::move(p_buffer_id));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnProvidePictureBuffers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnProvidePictureBuffers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_num_frames{};
      ::media::mojom::blink::VideoPixelFormat p_format{};
      uint32_t p_num_textures_per_frame{};
      ::gfx::Size p_buffer_size{};
      uint32_t p_texture_target{};
      GpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_frames = input_data_view.num_frames();
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success)
        p_num_textures_per_frame = input_data_view.num_textures_per_frame();
      if (success && !input_data_view.ReadBufferSize(&p_buffer_size))
        success = false;
      if (success)
        p_texture_target = input_data_view.texture_target();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProvidePictureBuffers(
std::move(p_num_frames), 
std::move(p_format), 
std::move(p_num_textures_per_frame), 
std::move(p_buffer_size), 
std::move(p_texture_target));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnPictureReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnPictureReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnPictureReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoderClient_OnPictureReady_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoderClient_OnPictureReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PictureReadyParamsPtr p_params{};
      GpuAcceleratedVideoDecoderClient_OnPictureReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPictureReady(
std::move(p_params));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnDismissPictureBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnDismissPictureBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      GpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDismissPictureBuffer(
std::move(p_buffer_id));
      return true;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::GpuAcceleratedVideoDecoderClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuAcceleratedVideoDecoderClient_OnError_Params_Data* params =
          reinterpret_cast<internal::GpuAcceleratedVideoDecoderClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_error_id{};
      GpuAcceleratedVideoDecoderClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error_id = input_data_view.error_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuAcceleratedVideoDecoderClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_error_id));
      return true;
    }
  }
  return false;
}

// static
bool GpuAcceleratedVideoDecoderClientStubDispatch::AcceptWithResponder(
    GpuAcceleratedVideoDecoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuAcceleratedVideoDecoderClient_OnInitializationComplete_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnPictureReady_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Name: {
      break;
    }
    case internal::kGpuAcceleratedVideoDecoderClient_OnError_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuAcceleratedVideoDecoderClientValidationInfo[] = {
    {internal::kGpuAcceleratedVideoDecoderClient_OnInitializationComplete_Name,
     {&internal::GpuAcceleratedVideoDecoderClient_OnInitializationComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Name,
     {&internal::GpuAcceleratedVideoDecoderClient_OnBitstreamBufferProcessed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Name,
     {&internal::GpuAcceleratedVideoDecoderClient_OnProvidePictureBuffers_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoderClient_OnPictureReady_Name,
     {&internal::GpuAcceleratedVideoDecoderClient_OnPictureReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Name,
     {&internal::GpuAcceleratedVideoDecoderClient_OnDismissPictureBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuAcceleratedVideoDecoderClient_OnError_Name,
     {&internal::GpuAcceleratedVideoDecoderClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuAcceleratedVideoDecoderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::GpuAcceleratedVideoDecoderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuAcceleratedVideoDecoderClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::PictureBufferAssignment::DataView, ::media::mojom::blink::PictureBufferAssignmentPtr>::Read(
    ::media::mojom::blink::PictureBufferAssignment::DataView input,
    ::media::mojom::blink::PictureBufferAssignmentPtr* output) {
  bool success = true;
  ::media::mojom::blink::PictureBufferAssignmentPtr result(::media::mojom::blink::PictureBufferAssignment::New());
  
      if (success)
        result->buffer_id = input.buffer_id();
      if (success && !input.ReadTextureIds(&result->texture_ids))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::PictureReadyParams::DataView, ::media::mojom::blink::PictureReadyParamsPtr>::Read(
    ::media::mojom::blink::PictureReadyParams::DataView input,
    ::media::mojom::blink::PictureReadyParamsPtr* output) {
  bool success = true;
  ::media::mojom::blink::PictureReadyParamsPtr result(::media::mojom::blink::PictureReadyParams::New());
  
      if (success)
        result->picture_buffer_id = input.picture_buffer_id();
      if (success)
        result->bitstream_buffer_id = input.bitstream_buffer_id();
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success)
        result->allow_overlay = input.allow_overlay();
      if (success)
        result->read_lock_fences_enabled = input.read_lock_fences_enabled();
      if (success)
        result->size_changed = input.size_changed();
      if (success)
        result->surface_texture = input.surface_texture();
      if (success)
        result->wants_promotion_hint = input.wants_promotion_hint();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif