// media/mojo/mojom/media_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_types.mojom-params-data.h"
#include "media/mojo/mojom/media_types.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_types.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
VideoTransformation::VideoTransformation()
    : rotation(),
      mirrored() {}

VideoTransformation::VideoTransformation(
    ::media::VideoRotation rotation_in,
    bool mirrored_in)
    : rotation(std::move(rotation_in)),
      mirrored(std::move(mirrored_in)) {}

VideoTransformation::~VideoTransformation() = default;

void VideoTransformation::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation"), this->rotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoRotation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mirrored"), this->mirrored,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoTransformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EncryptionPattern::EncryptionPattern()
    : crypt_byte_block(),
      skip_byte_block() {}

EncryptionPattern::EncryptionPattern(
    uint32_t crypt_byte_block_in,
    uint32_t skip_byte_block_in)
    : crypt_byte_block(std::move(crypt_byte_block_in)),
      skip_byte_block(std::move(skip_byte_block_in)) {}

EncryptionPattern::~EncryptionPattern() = default;

void EncryptionPattern::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "crypt_byte_block"), this->crypt_byte_block,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_byte_block"), this->skip_byte_block,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EncryptionPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoColorSpace::VideoColorSpace()
    : primaries(),
      transfer(),
      matrix(),
      range() {}

VideoColorSpace::VideoColorSpace(
    ::media::VideoColorSpace::PrimaryID primaries_in,
    VideoColorSpace::TransferID transfer_in,
    VideoColorSpace::MatrixID matrix_in,
    VideoColorSpace::RangeID range_in)
    : primaries(std::move(primaries_in)),
      transfer(std::move(transfer_in)),
      matrix(std::move(matrix_in)),
      range(std::move(range_in)) {}

VideoColorSpace::~VideoColorSpace() = default;

void VideoColorSpace::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primaries"), this->primaries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoColorSpace::PrimaryID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer"), this->transfer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoColorSpace::TransferID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matrix"), this->matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoColorSpace::MatrixID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "range"), this->range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoColorSpace::RangeID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoColorSpace::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioDecoderConfig::AudioDecoderConfig()
    : codec(),
      sample_format(),
      channel_layout(),
      samples_per_second(),
      extra_data(),
      encryption_scheme(),
      seek_preroll(),
      codec_delay(),
      profile(),
      target_output_channel_layout(),
      should_discard_decoder_delay() {}

AudioDecoderConfig::AudioDecoderConfig(
    ::media::AudioCodec codec_in,
    ::media::SampleFormat sample_format_in,
    ::media::ChannelLayout channel_layout_in,
    int32_t samples_per_second_in,
    std::vector<uint8_t> extra_data_in,
    ::media::EncryptionScheme encryption_scheme_in,
    ::base::TimeDelta seek_preroll_in,
    int32_t codec_delay_in,
    ::media::AudioCodecProfile profile_in,
    ::media::ChannelLayout target_output_channel_layout_in,
    bool should_discard_decoder_delay_in)
    : codec(std::move(codec_in)),
      sample_format(std::move(sample_format_in)),
      channel_layout(std::move(channel_layout_in)),
      samples_per_second(std::move(samples_per_second_in)),
      extra_data(std::move(extra_data_in)),
      encryption_scheme(std::move(encryption_scheme_in)),
      seek_preroll(std::move(seek_preroll_in)),
      codec_delay(std::move(codec_delay_in)),
      profile(std::move(profile_in)),
      target_output_channel_layout(std::move(target_output_channel_layout_in)),
      should_discard_decoder_delay(std::move(should_discard_decoder_delay_in)) {}

AudioDecoderConfig::~AudioDecoderConfig() = default;

void AudioDecoderConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_format"), this->sample_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::SampleFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_layout"), this->channel_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ChannelLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samples_per_second"), this->samples_per_second,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seek_preroll"), this->seek_preroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec_delay"), this->codec_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_output_channel_layout"), this->target_output_channel_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ChannelLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_discard_decoder_delay"), this->should_discard_decoder_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecoderConfig::VideoDecoderConfig()
    : codec(),
      profile(),
      level(),
      has_alpha(),
      transformation(),
      coded_size(),
      visible_rect(),
      natural_size(),
      extra_data(),
      encryption_scheme(),
      color_space_info(),
      hdr_metadata() {}

VideoDecoderConfig::VideoDecoderConfig(
    ::media::VideoCodec codec_in,
    ::media::VideoCodecProfile profile_in,
    uint32_t level_in,
    bool has_alpha_in,
    const ::media::VideoTransformation& transformation_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    std::vector<uint8_t> extra_data_in,
    ::media::EncryptionScheme encryption_scheme_in,
    VideoColorSpacePtr color_space_info_in,
    const absl::optional<::gfx::HDRMetadata>& hdr_metadata_in)
    : codec(std::move(codec_in)),
      profile(std::move(profile_in)),
      level(std::move(level_in)),
      has_alpha(std::move(has_alpha_in)),
      transformation(std::move(transformation_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      extra_data(std::move(extra_data_in)),
      encryption_scheme(std::move(encryption_scheme_in)),
      color_space_info(std::move(color_space_info_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoDecoderConfig::~VideoDecoderConfig() = default;

void VideoDecoderConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level"), this->level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_alpha"), this->has_alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transformation"), this->transformation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoTransformation&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space_info"), this->color_space_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoColorSpacePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::gfx::HDRMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecryptConfig::DecryptConfig()
    : encryption_scheme(),
      key_id(),
      iv(),
      subsamples(),
      encryption_pattern() {}

DecryptConfig::DecryptConfig(
    ::media::EncryptionScheme encryption_scheme_in,
    const std::string& key_id_in,
    const std::string& iv_in,
    std::vector<::media::SubsampleEntry> subsamples_in,
    const absl::optional<::media::EncryptionPattern>& encryption_pattern_in)
    : encryption_scheme(std::move(encryption_scheme_in)),
      key_id(std::move(key_id_in)),
      iv(std::move(iv_in)),
      subsamples(std::move(subsamples_in)),
      encryption_pattern(std::move(encryption_pattern_in)) {}

DecryptConfig::~DecryptConfig() = default;

void DecryptConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iv"), this->iv,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsamples"), this->subsamples,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::SubsampleEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_pattern"), this->encryption_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::media::EncryptionPattern>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecryptConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderBuffer::DecoderBuffer()
    : timestamp(),
      duration(),
      is_end_of_stream(),
      data_size(),
      is_key_frame(),
      side_data(),
      decrypt_config(),
      front_discard(),
      back_discard() {}

DecoderBuffer::DecoderBuffer(
    ::base::TimeDelta timestamp_in,
    ::base::TimeDelta duration_in,
    bool is_end_of_stream_in,
    uint32_t data_size_in,
    bool is_key_frame_in,
    std::vector<uint8_t> side_data_in,
    DecryptConfigPtr decrypt_config_in,
    ::base::TimeDelta front_discard_in,
    ::base::TimeDelta back_discard_in)
    : timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)),
      is_end_of_stream(std::move(is_end_of_stream_in)),
      data_size(std::move(data_size_in)),
      is_key_frame(std::move(is_key_frame_in)),
      side_data(std::move(side_data_in)),
      decrypt_config(std::move(decrypt_config_in)),
      front_discard(std::move(front_discard_in)),
      back_discard(std::move(back_discard_in)) {}

DecoderBuffer::~DecoderBuffer() = default;

void DecoderBuffer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_end_of_stream"), this->is_end_of_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_size"), this->data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_key_frame"), this->is_key_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "side_data"), this->side_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decrypt_config"), this->decrypt_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DecryptConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "front_discard"), this->front_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_discard"), this->back_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecoderBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioBuffer::AudioBuffer()
    : sample_format(),
      channel_layout(),
      channel_count(),
      sample_rate(),
      frame_count(),
      end_of_stream(),
      timestamp(),
      data() {}

AudioBuffer::AudioBuffer(
    ::media::SampleFormat sample_format_in,
    ::media::ChannelLayout channel_layout_in,
    int32_t channel_count_in,
    int32_t sample_rate_in,
    int32_t frame_count_in,
    bool end_of_stream_in,
    ::base::TimeDelta timestamp_in,
    std::vector<uint8_t> data_in)
    : sample_format(std::move(sample_format_in)),
      channel_layout(std::move(channel_layout_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      frame_count(std::move(frame_count_in)),
      end_of_stream(std::move(end_of_stream_in)),
      timestamp(std::move(timestamp_in)),
      data(std::move(data_in)) {}

AudioBuffer::~AudioBuffer() = default;

void AudioBuffer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_format"), this->sample_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::SampleFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_layout"), this->channel_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ChannelLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_count"), this->frame_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_stream"), this->end_of_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioDataS16::AudioDataS16()
    : channel_count(),
      sample_rate(),
      frame_count(),
      data() {}

AudioDataS16::AudioDataS16(
    int32_t channel_count_in,
    int32_t sample_rate_in,
    int32_t frame_count_in,
    std::vector<int16_t> data_in)
    : channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      frame_count(std::move(frame_count_in)),
      data(std::move(data_in)) {}

AudioDataS16::~AudioDataS16() = default;

void AudioDataS16::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_count"), this->frame_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioDataS16::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameMetadata::VideoFrameMetadata()
    : allow_overlay(),
      capture_begin_time(),
      capture_end_time(),
      has_capture_counter(),
      capture_counter(),
      capture_update_rect(),
      has_copy_mode(),
      copy_mode(),
      end_of_stream(),
      frame_duration(),
      has_frame_rate(),
      frame_rate(),
      interactive_content(),
      reference_time(),
      read_lock_fences_enabled(),
      transformation(),
      texture_owner(),
      wants_promotion_hint(),
      protected_video(),
      hw_protected(),
      overlay_plane_id(),
      power_efficient(),
      texture_origin_is_top_left(),
      has_device_scale_factor(),
      device_scale_factor(),
      has_page_scale_factor(),
      page_scale_factor(),
      has_root_scroll_offset_x(),
      root_scroll_offset_x(),
      has_root_scroll_offset_y(),
      root_scroll_offset_y(),
      has_top_controls_visible_height(),
      top_controls_visible_height(),
      decode_begin_time(),
      decode_end_time(),
      processing_time(),
      has_rtp_timestamp(),
      rtp_timestamp(),
      receive_time(),
      wallclock_frame_duration(),
      hw_protected_validation_id() {}

VideoFrameMetadata::VideoFrameMetadata(
    bool allow_overlay_in,
    absl::optional<::base::TimeTicks> capture_begin_time_in,
    absl::optional<::base::TimeTicks> capture_end_time_in,
    bool has_capture_counter_in,
    int32_t capture_counter_in,
    const absl::optional<::gfx::Rect>& capture_update_rect_in,
    bool has_copy_mode_in,
    ::media::VideoFrameMetadata::CopyMode copy_mode_in,
    bool end_of_stream_in,
    absl::optional<::base::TimeDelta> frame_duration_in,
    bool has_frame_rate_in,
    double frame_rate_in,
    bool interactive_content_in,
    absl::optional<::base::TimeTicks> reference_time_in,
    bool read_lock_fences_enabled_in,
    const absl::optional<::media::VideoTransformation>& transformation_in,
    bool texture_owner_in,
    bool wants_promotion_hint_in,
    bool protected_video_in,
    bool hw_protected_in,
    const absl::optional<::base::UnguessableToken>& overlay_plane_id_in,
    bool power_efficient_in,
    bool texture_origin_is_top_left_in,
    bool has_device_scale_factor_in,
    double device_scale_factor_in,
    bool has_page_scale_factor_in,
    double page_scale_factor_in,
    bool has_root_scroll_offset_x_in,
    double root_scroll_offset_x_in,
    bool has_root_scroll_offset_y_in,
    double root_scroll_offset_y_in,
    bool has_top_controls_visible_height_in,
    double top_controls_visible_height_in,
    absl::optional<::base::TimeTicks> decode_begin_time_in,
    absl::optional<::base::TimeTicks> decode_end_time_in,
    absl::optional<::base::TimeDelta> processing_time_in,
    bool has_rtp_timestamp_in,
    double rtp_timestamp_in,
    absl::optional<::base::TimeTicks> receive_time_in,
    absl::optional<::base::TimeDelta> wallclock_frame_duration_in,
    uint32_t hw_protected_validation_id_in)
    : allow_overlay(std::move(allow_overlay_in)),
      capture_begin_time(std::move(capture_begin_time_in)),
      capture_end_time(std::move(capture_end_time_in)),
      has_capture_counter(std::move(has_capture_counter_in)),
      capture_counter(std::move(capture_counter_in)),
      capture_update_rect(std::move(capture_update_rect_in)),
      has_copy_mode(std::move(has_copy_mode_in)),
      copy_mode(std::move(copy_mode_in)),
      end_of_stream(std::move(end_of_stream_in)),
      frame_duration(std::move(frame_duration_in)),
      has_frame_rate(std::move(has_frame_rate_in)),
      frame_rate(std::move(frame_rate_in)),
      interactive_content(std::move(interactive_content_in)),
      reference_time(std::move(reference_time_in)),
      read_lock_fences_enabled(std::move(read_lock_fences_enabled_in)),
      transformation(std::move(transformation_in)),
      texture_owner(std::move(texture_owner_in)),
      wants_promotion_hint(std::move(wants_promotion_hint_in)),
      protected_video(std::move(protected_video_in)),
      hw_protected(std::move(hw_protected_in)),
      overlay_plane_id(std::move(overlay_plane_id_in)),
      power_efficient(std::move(power_efficient_in)),
      texture_origin_is_top_left(std::move(texture_origin_is_top_left_in)),
      has_device_scale_factor(std::move(has_device_scale_factor_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      has_page_scale_factor(std::move(has_page_scale_factor_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      has_root_scroll_offset_x(std::move(has_root_scroll_offset_x_in)),
      root_scroll_offset_x(std::move(root_scroll_offset_x_in)),
      has_root_scroll_offset_y(std::move(has_root_scroll_offset_y_in)),
      root_scroll_offset_y(std::move(root_scroll_offset_y_in)),
      has_top_controls_visible_height(std::move(has_top_controls_visible_height_in)),
      top_controls_visible_height(std::move(top_controls_visible_height_in)),
      decode_begin_time(std::move(decode_begin_time_in)),
      decode_end_time(std::move(decode_end_time_in)),
      processing_time(std::move(processing_time_in)),
      has_rtp_timestamp(std::move(has_rtp_timestamp_in)),
      rtp_timestamp(std::move(rtp_timestamp_in)),
      receive_time(std::move(receive_time_in)),
      wallclock_frame_duration(std::move(wallclock_frame_duration_in)),
      hw_protected_validation_id(std::move(hw_protected_validation_id_in)) {}

VideoFrameMetadata::~VideoFrameMetadata() = default;

void VideoFrameMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_overlay"), this->allow_overlay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_begin_time"), this->capture_begin_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_end_time"), this->capture_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_capture_counter"), this->has_capture_counter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_counter"), this->capture_counter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_update_rect"), this->capture_update_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_copy_mode"), this->has_copy_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copy_mode"), this->copy_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoFrameMetadata::CopyMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_stream"), this->end_of_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_duration"), this->frame_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_frame_rate"), this->has_frame_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_rate"), this->frame_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interactive_content"), this->interactive_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_time"), this->reference_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_lock_fences_enabled"), this->read_lock_fences_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transformation"), this->transformation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::media::VideoTransformation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_owner"), this->texture_owner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_promotion_hint"), this->wants_promotion_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_video"), this->protected_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_protected"), this->hw_protected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_plane_id"), this->overlay_plane_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "power_efficient"), this->power_efficient,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_origin_is_top_left"), this->texture_origin_is_top_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_device_scale_factor"), this->has_device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_page_scale_factor"), this->has_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_root_scroll_offset_x"), this->has_root_scroll_offset_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset_x"), this->root_scroll_offset_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_root_scroll_offset_y"), this->has_root_scroll_offset_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset_y"), this->root_scroll_offset_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_top_controls_visible_height"), this->has_top_controls_visible_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height"), this->top_controls_visible_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decode_begin_time"), this->decode_begin_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decode_end_time"), this->decode_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "processing_time"), this->processing_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_rtp_timestamp"), this->has_rtp_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtp_timestamp"), this->rtp_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_time"), this->receive_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wallclock_frame_duration"), this->wallclock_frame_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_protected_validation_id"), this->hw_protected_validation_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrame::VideoFrame()
    : format(),
      coded_size(),
      visible_rect(),
      natural_size(),
      timestamp(),
      data(),
      metadata(),
      color_space(),
      hdr_metadata() {}

VideoFrame::VideoFrame(
    ::media::VideoPixelFormat format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    ::base::TimeDelta timestamp_in,
    VideoFrameDataPtr data_in,
    const ::media::VideoFrameMetadata& metadata_in,
    const ::gfx::ColorSpace& color_space_in,
    const absl::optional<::gfx::HDRMetadata>& hdr_metadata_in)
    : format(std::move(format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      timestamp(std::move(timestamp_in)),
      data(std::move(data_in)),
      metadata(std::move(metadata_in)),
      color_space(std::move(color_space_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoFrame::~VideoFrame() = default;

void VideoFrame::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoFrameDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoFrameMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::gfx::HDRMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EosVideoFrameData::EosVideoFrameData() {}

EosVideoFrameData::~EosVideoFrameData() = default;
size_t EosVideoFrameData::Hash(size_t seed) const {
  return seed;
}

void EosVideoFrameData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
}

bool EosVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedBufferVideoFrameData::SharedBufferVideoFrameData()
    : frame_data(),
      frame_data_size(),
      strides(),
      offsets() {}

SharedBufferVideoFrameData::SharedBufferVideoFrameData(
    ::mojo::ScopedSharedBufferHandle frame_data_in,
    uint64_t frame_data_size_in,
    std::vector<int32_t> strides_in,
    std::vector<uint32_t> offsets_in)
    : frame_data(std::move(frame_data_in)),
      frame_data_size(std::move(frame_data_size_in)),
      strides(std::move(strides_in)),
      offsets(std::move(offsets_in)) {}

SharedBufferVideoFrameData::~SharedBufferVideoFrameData() = default;

void SharedBufferVideoFrameData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data"), this->frame_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedSharedBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data_size"), this->frame_data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offsets"), this->offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedBufferVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferVideoFrameData::GpuMemoryBufferVideoFrameData()
    : gpu_memory_buffer_handle(),
      mailbox_holder() {}

GpuMemoryBufferVideoFrameData::GpuMemoryBufferVideoFrameData(
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle_in,
    std::vector<::gpu::MailboxHolder> mailbox_holder_in)
    : gpu_memory_buffer_handle(std::move(gpu_memory_buffer_handle_in)),
      mailbox_holder(std::move(mailbox_holder_in)) {}

GpuMemoryBufferVideoFrameData::~GpuMemoryBufferVideoFrameData() = default;

void GpuMemoryBufferVideoFrameData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_memory_buffer_handle"), this->gpu_memory_buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::MailboxHolder>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuMemoryBufferVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MailboxVideoFrameData::MailboxVideoFrameData()
    : mailbox_holder(),
      ycbcr_data() {}

MailboxVideoFrameData::MailboxVideoFrameData(
    std::vector<::gpu::MailboxHolder> mailbox_holder_in,
    absl::optional<::gpu::VulkanYCbCrInfo> ycbcr_data_in)
    : mailbox_holder(std::move(mailbox_holder_in)),
      ycbcr_data(std::move(ycbcr_data_in)) {}

MailboxVideoFrameData::~MailboxVideoFrameData() = default;

void MailboxVideoFrameData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::MailboxHolder>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ycbcr_data"), this->ycbcr_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::gpu::VulkanYCbCrInfo>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MailboxVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PipelineStatistics::PipelineStatistics()
    : audio_bytes_decoded(),
      video_bytes_decoded(),
      video_frames_decoded(),
      video_frames_dropped(),
      audio_memory_usage(),
      video_memory_usage() {}

PipelineStatistics::PipelineStatistics(
    uint64_t audio_bytes_decoded_in,
    uint64_t video_bytes_decoded_in,
    uint32_t video_frames_decoded_in,
    uint32_t video_frames_dropped_in,
    int64_t audio_memory_usage_in,
    int64_t video_memory_usage_in)
    : audio_bytes_decoded(std::move(audio_bytes_decoded_in)),
      video_bytes_decoded(std::move(video_bytes_decoded_in)),
      video_frames_decoded(std::move(video_frames_decoded_in)),
      video_frames_dropped(std::move(video_frames_dropped_in)),
      audio_memory_usage(std::move(audio_memory_usage_in)),
      video_memory_usage(std::move(video_memory_usage_in)) {}

PipelineStatistics::~PipelineStatistics() = default;

void PipelineStatistics::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_bytes_decoded"), this->audio_bytes_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_bytes_decoded"), this->video_bytes_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_frames_decoded"), this->video_frames_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_frames_dropped"), this->video_frames_dropped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_memory_usage"), this->audio_memory_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_memory_usage"), this->video_memory_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PipelineStatistics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PredictionFeatures::PredictionFeatures()
    : profile(),
      video_size(),
      frames_per_sec(0),
      key_system(),
      use_hw_secure_codecs(false) {}

PredictionFeatures::PredictionFeatures(
    ::media::VideoCodecProfile profile_in,
    const ::gfx::Size& video_size_in,
    double frames_per_sec_in,
    const std::string& key_system_in,
    bool use_hw_secure_codecs_in)
    : profile(std::move(profile_in)),
      video_size(std::move(video_size_in)),
      frames_per_sec(std::move(frames_per_sec_in)),
      key_system(std::move(key_system_in)),
      use_hw_secure_codecs(std::move(use_hw_secure_codecs_in)) {}

PredictionFeatures::~PredictionFeatures() = default;

void PredictionFeatures::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_size"), this->video_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_per_sec"), this->frames_per_sec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_system"), this->key_system,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_hw_secure_codecs"), this->use_hw_secure_codecs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PredictionFeatures::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PredictionTargets::PredictionTargets()
    : frames_decoded(0U),
      frames_dropped(0U),
      frames_power_efficient(0U) {}

PredictionTargets::PredictionTargets(
    uint32_t frames_decoded_in,
    uint32_t frames_dropped_in,
    uint32_t frames_power_efficient_in)
    : frames_decoded(std::move(frames_decoded_in)),
      frames_dropped(std::move(frames_dropped_in)),
      frames_power_efficient(std::move(frames_power_efficient_in)) {}

PredictionTargets::~PredictionTargets() = default;
size_t PredictionTargets::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->frames_decoded);
  seed = mojo::internal::Hash(seed, this->frames_dropped);
  seed = mojo::internal::Hash(seed, this->frames_power_efficient);
  return seed;
}

void PredictionTargets::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_decoded"), this->frames_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_dropped"), this->frames_dropped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_power_efficient"), this->frames_power_efficient,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PredictionTargets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioPipelineInfo::AudioPipelineInfo()
    : decoder_type(),
      is_platform_decoder(false),
      has_decrypting_demuxer_stream(false),
      encryption_type() {}

AudioPipelineInfo::AudioPipelineInfo(
    ::media::AudioDecoderType decoder_type_in,
    bool is_platform_decoder_in,
    bool has_decrypting_demuxer_stream_in,
    EncryptionType encryption_type_in)
    : decoder_type(std::move(decoder_type_in)),
      is_platform_decoder(std::move(is_platform_decoder_in)),
      has_decrypting_demuxer_stream(std::move(has_decrypting_demuxer_stream_in)),
      encryption_type(std::move(encryption_type_in)) {}

AudioPipelineInfo::~AudioPipelineInfo() = default;

void AudioPipelineInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoder_type"), this->decoder_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_decoder"), this->is_platform_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_decrypting_demuxer_stream"), this->has_decrypting_demuxer_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_type"), this->encryption_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EncryptionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioPipelineInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoPipelineInfo::VideoPipelineInfo()
    : decoder_type(),
      is_platform_decoder(false),
      has_decrypting_demuxer_stream(false),
      encryption_type() {}

VideoPipelineInfo::VideoPipelineInfo(
    ::media::VideoDecoderType decoder_type_in,
    bool is_platform_decoder_in,
    bool has_decrypting_demuxer_stream_in,
    EncryptionType encryption_type_in)
    : decoder_type(std::move(decoder_type_in)),
      is_platform_decoder(std::move(is_platform_decoder_in)),
      has_decrypting_demuxer_stream(std::move(has_decrypting_demuxer_stream_in)),
      encryption_type(std::move(encryption_type_in)) {}

VideoPipelineInfo::~VideoPipelineInfo() = default;

void VideoPipelineInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoder_type"), this->decoder_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_decoder"), this->is_platform_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_decrypting_demuxer_stream"), this->has_decrypting_demuxer_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_type"), this->encryption_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EncryptionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoPipelineInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Status::Status()
    : code(),
      message(),
      frames(),
      causes(),
      data() {}

Status::Status(
    ::media::StatusCode code_in,
    const absl::optional<std::string>& message_in,
    std::vector<::base::Value> frames_in,
    std::vector<::media::Status> causes_in,
    absl::optional<::base::Value> data_in)
    : code(std::move(code_in)),
      message(std::move(message_in)),
      frames(std::move(frames_in)),
      causes(std::move(causes_in)),
      data(std::move(data_in)) {}

Status::~Status() = default;

void Status::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::StatusCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames"), this->frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "causes"), this->causes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::Status>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Status::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameData::VideoFrameData() : tag_(Tag::EOS_DATA) {
  data_.eos_data = new EosVideoFrameDataPtr;
}

VideoFrameData::~VideoFrameData() {
  DestroyActive();
}


void VideoFrameData::set_eos_data(
    EosVideoFrameDataPtr eos_data) {
  if (tag_ == Tag::EOS_DATA) {
    *(data_.eos_data) = std::move(eos_data);
  } else {
    DestroyActive();
    tag_ = Tag::EOS_DATA;
    data_.eos_data = new EosVideoFrameDataPtr(
        std::move(eos_data));
  }
}
void VideoFrameData::set_shared_buffer_data(
    SharedBufferVideoFrameDataPtr shared_buffer_data) {
  if (tag_ == Tag::SHARED_BUFFER_DATA) {
    *(data_.shared_buffer_data) = std::move(shared_buffer_data);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_BUFFER_DATA;
    data_.shared_buffer_data = new SharedBufferVideoFrameDataPtr(
        std::move(shared_buffer_data));
  }
}
void VideoFrameData::set_gpu_memory_buffer_data(
    GpuMemoryBufferVideoFrameDataPtr gpu_memory_buffer_data) {
  if (tag_ == Tag::GPU_MEMORY_BUFFER_DATA) {
    *(data_.gpu_memory_buffer_data) = std::move(gpu_memory_buffer_data);
  } else {
    DestroyActive();
    tag_ = Tag::GPU_MEMORY_BUFFER_DATA;
    data_.gpu_memory_buffer_data = new GpuMemoryBufferVideoFrameDataPtr(
        std::move(gpu_memory_buffer_data));
  }
}
void VideoFrameData::set_mailbox_data(
    MailboxVideoFrameDataPtr mailbox_data) {
  if (tag_ == Tag::MAILBOX_DATA) {
    *(data_.mailbox_data) = std::move(mailbox_data);
  } else {
    DestroyActive();
    tag_ = Tag::MAILBOX_DATA;
    data_.mailbox_data = new MailboxVideoFrameDataPtr(
        std::move(mailbox_data));
  }
}

void VideoFrameData::DestroyActive() {
  switch (tag_) {

    case Tag::EOS_DATA:

      delete data_.eos_data;
      break;
    case Tag::SHARED_BUFFER_DATA:

      delete data_.shared_buffer_data;
      break;
    case Tag::GPU_MEMORY_BUFFER_DATA:

      delete data_.gpu_memory_buffer_data;
      break;
    case Tag::MAILBOX_DATA:

      delete data_.mailbox_data;
      break;
  }
}

bool VideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::VideoTransformation::DataView, ::media::mojom::VideoTransformationPtr>::Read(
    ::media::mojom::VideoTransformation::DataView input,
    ::media::mojom::VideoTransformationPtr* output) {
  bool success = true;
  ::media::mojom::VideoTransformationPtr result(::media::mojom::VideoTransformation::New());
  
      if (success && !input.ReadRotation(&result->rotation))
        success = false;
      if (success)
        result->mirrored = input.mirrored();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::EncryptionPattern::DataView, ::media::mojom::EncryptionPatternPtr>::Read(
    ::media::mojom::EncryptionPattern::DataView input,
    ::media::mojom::EncryptionPatternPtr* output) {
  bool success = true;
  ::media::mojom::EncryptionPatternPtr result(::media::mojom::EncryptionPattern::New());
  
      if (success)
        result->crypt_byte_block = input.crypt_byte_block();
      if (success)
        result->skip_byte_block = input.skip_byte_block();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoColorSpace::DataView, ::media::mojom::VideoColorSpacePtr>::Read(
    ::media::mojom::VideoColorSpace::DataView input,
    ::media::mojom::VideoColorSpacePtr* output) {
  bool success = true;
  ::media::mojom::VideoColorSpacePtr result(::media::mojom::VideoColorSpace::New());
  
      if (success && !input.ReadPrimaries(&result->primaries))
        success = false;
      if (success && !input.ReadTransfer(&result->transfer))
        success = false;
      if (success && !input.ReadMatrix(&result->matrix))
        success = false;
      if (success && !input.ReadRange(&result->range))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioDecoderConfig::DataView, ::media::mojom::AudioDecoderConfigPtr>::Read(
    ::media::mojom::AudioDecoderConfig::DataView input,
    ::media::mojom::AudioDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::AudioDecoderConfigPtr result(::media::mojom::AudioDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadSampleFormat(&result->sample_format))
        success = false;
      if (success && !input.ReadChannelLayout(&result->channel_layout))
        success = false;
      if (success)
        result->samples_per_second = input.samples_per_second();
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadSeekPreroll(&result->seek_preroll))
        success = false;
      if (success)
        result->codec_delay = input.codec_delay();
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadTargetOutputChannelLayout(&result->target_output_channel_layout))
        success = false;
      if (success)
        result->should_discard_decoder_delay = input.should_discard_decoder_delay();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoDecoderConfig::DataView, ::media::mojom::VideoDecoderConfigPtr>::Read(
    ::media::mojom::VideoDecoderConfig::DataView input,
    ::media::mojom::VideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::VideoDecoderConfigPtr result(::media::mojom::VideoDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success)
        result->level = input.level();
      if (success)
        result->has_alpha = input.has_alpha();
      if (success && !input.ReadTransformation(&result->transformation))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadColorSpaceInfo(&result->color_space_info))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DecryptConfig::DataView, ::media::mojom::DecryptConfigPtr>::Read(
    ::media::mojom::DecryptConfig::DataView input,
    ::media::mojom::DecryptConfigPtr* output) {
  bool success = true;
  ::media::mojom::DecryptConfigPtr result(::media::mojom::DecryptConfig::New());
  
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadIv(&result->iv))
        success = false;
      if (success && !input.ReadSubsamples(&result->subsamples))
        success = false;
      if (success && !input.ReadEncryptionPattern(&result->encryption_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DecoderBuffer::DataView, ::media::mojom::DecoderBufferPtr>::Read(
    ::media::mojom::DecoderBuffer::DataView input,
    ::media::mojom::DecoderBufferPtr* output) {
  bool success = true;
  ::media::mojom::DecoderBufferPtr result(::media::mojom::DecoderBuffer::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success)
        result->is_end_of_stream = input.is_end_of_stream();
      if (success)
        result->data_size = input.data_size();
      if (success)
        result->is_key_frame = input.is_key_frame();
      if (success && !input.ReadSideData(&result->side_data))
        success = false;
      if (success && !input.ReadDecryptConfig(&result->decrypt_config))
        success = false;
      if (success && !input.ReadFrontDiscard(&result->front_discard))
        success = false;
      if (success && !input.ReadBackDiscard(&result->back_discard))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioBuffer::DataView, ::media::mojom::AudioBufferPtr>::Read(
    ::media::mojom::AudioBuffer::DataView input,
    ::media::mojom::AudioBufferPtr* output) {
  bool success = true;
  ::media::mojom::AudioBufferPtr result(::media::mojom::AudioBuffer::New());
  
      if (success && !input.ReadSampleFormat(&result->sample_format))
        success = false;
      if (success && !input.ReadChannelLayout(&result->channel_layout))
        success = false;
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->frame_count = input.frame_count();
      if (success)
        result->end_of_stream = input.end_of_stream();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioDataS16::DataView, ::media::mojom::AudioDataS16Ptr>::Read(
    ::media::mojom::AudioDataS16::DataView input,
    ::media::mojom::AudioDataS16Ptr* output) {
  bool success = true;
  ::media::mojom::AudioDataS16Ptr result(::media::mojom::AudioDataS16::New());
  
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->frame_count = input.frame_count();
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoFrameMetadata::DataView, ::media::mojom::VideoFrameMetadataPtr>::Read(
    ::media::mojom::VideoFrameMetadata::DataView input,
    ::media::mojom::VideoFrameMetadataPtr* output) {
  bool success = true;
  ::media::mojom::VideoFrameMetadataPtr result(::media::mojom::VideoFrameMetadata::New());
  
      if (success)
        result->allow_overlay = input.allow_overlay();
      if (success && !input.ReadCaptureBeginTime(&result->capture_begin_time))
        success = false;
      if (success && !input.ReadCaptureEndTime(&result->capture_end_time))
        success = false;
      if (success)
        result->has_capture_counter = input.has_capture_counter();
      if (success)
        result->capture_counter = input.capture_counter();
      if (success && !input.ReadCaptureUpdateRect(&result->capture_update_rect))
        success = false;
      if (success)
        result->has_copy_mode = input.has_copy_mode();
      if (success && !input.ReadCopyMode(&result->copy_mode))
        success = false;
      if (success)
        result->end_of_stream = input.end_of_stream();
      if (success && !input.ReadFrameDuration(&result->frame_duration))
        success = false;
      if (success)
        result->has_frame_rate = input.has_frame_rate();
      if (success)
        result->frame_rate = input.frame_rate();
      if (success)
        result->interactive_content = input.interactive_content();
      if (success && !input.ReadReferenceTime(&result->reference_time))
        success = false;
      if (success)
        result->read_lock_fences_enabled = input.read_lock_fences_enabled();
      if (success && !input.ReadTransformation(&result->transformation))
        success = false;
      if (success)
        result->texture_owner = input.texture_owner();
      if (success)
        result->wants_promotion_hint = input.wants_promotion_hint();
      if (success)
        result->protected_video = input.protected_video();
      if (success)
        result->hw_protected = input.hw_protected();
      if (success && !input.ReadOverlayPlaneId(&result->overlay_plane_id))
        success = false;
      if (success)
        result->power_efficient = input.power_efficient();
      if (success)
        result->texture_origin_is_top_left = input.texture_origin_is_top_left();
      if (success)
        result->has_device_scale_factor = input.has_device_scale_factor();
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success)
        result->has_page_scale_factor = input.has_page_scale_factor();
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->has_root_scroll_offset_x = input.has_root_scroll_offset_x();
      if (success)
        result->root_scroll_offset_x = input.root_scroll_offset_x();
      if (success)
        result->has_root_scroll_offset_y = input.has_root_scroll_offset_y();
      if (success)
        result->root_scroll_offset_y = input.root_scroll_offset_y();
      if (success)
        result->has_top_controls_visible_height = input.has_top_controls_visible_height();
      if (success)
        result->top_controls_visible_height = input.top_controls_visible_height();
      if (success && !input.ReadDecodeBeginTime(&result->decode_begin_time))
        success = false;
      if (success && !input.ReadDecodeEndTime(&result->decode_end_time))
        success = false;
      if (success && !input.ReadProcessingTime(&result->processing_time))
        success = false;
      if (success)
        result->has_rtp_timestamp = input.has_rtp_timestamp();
      if (success)
        result->rtp_timestamp = input.rtp_timestamp();
      if (success && !input.ReadReceiveTime(&result->receive_time))
        success = false;
      if (success && !input.ReadWallclockFrameDuration(&result->wallclock_frame_duration))
        success = false;
      if (success)
        result->hw_protected_validation_id = input.hw_protected_validation_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoFrame::DataView, ::media::mojom::VideoFramePtr>::Read(
    ::media::mojom::VideoFrame::DataView input,
    ::media::mojom::VideoFramePtr* output) {
  bool success = true;
  ::media::mojom::VideoFramePtr result(::media::mojom::VideoFrame::New());
  
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::EosVideoFrameData::DataView, ::media::mojom::EosVideoFrameDataPtr>::Read(
    ::media::mojom::EosVideoFrameData::DataView input,
    ::media::mojom::EosVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::EosVideoFrameDataPtr result(::media::mojom::EosVideoFrameData::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SharedBufferVideoFrameData::DataView, ::media::mojom::SharedBufferVideoFrameDataPtr>::Read(
    ::media::mojom::SharedBufferVideoFrameData::DataView input,
    ::media::mojom::SharedBufferVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::SharedBufferVideoFrameDataPtr result(::media::mojom::SharedBufferVideoFrameData::New());
  
      if (success)
        result->frame_data = input.TakeFrameData();
      if (success)
        result->frame_data_size = input.frame_data_size();
      if (success && !input.ReadStrides(&result->strides))
        success = false;
      if (success && !input.ReadOffsets(&result->offsets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::GpuMemoryBufferVideoFrameData::DataView, ::media::mojom::GpuMemoryBufferVideoFrameDataPtr>::Read(
    ::media::mojom::GpuMemoryBufferVideoFrameData::DataView input,
    ::media::mojom::GpuMemoryBufferVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::GpuMemoryBufferVideoFrameDataPtr result(::media::mojom::GpuMemoryBufferVideoFrameData::New());
  
      if (success && !input.ReadGpuMemoryBufferHandle(&result->gpu_memory_buffer_handle))
        success = false;
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::MailboxVideoFrameData::DataView, ::media::mojom::MailboxVideoFrameDataPtr>::Read(
    ::media::mojom::MailboxVideoFrameData::DataView input,
    ::media::mojom::MailboxVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::MailboxVideoFrameDataPtr result(::media::mojom::MailboxVideoFrameData::New());
  
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
      if (success && !input.ReadYcbcrData(&result->ycbcr_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PipelineStatistics::DataView, ::media::mojom::PipelineStatisticsPtr>::Read(
    ::media::mojom::PipelineStatistics::DataView input,
    ::media::mojom::PipelineStatisticsPtr* output) {
  bool success = true;
  ::media::mojom::PipelineStatisticsPtr result(::media::mojom::PipelineStatistics::New());
  
      if (success)
        result->audio_bytes_decoded = input.audio_bytes_decoded();
      if (success)
        result->video_bytes_decoded = input.video_bytes_decoded();
      if (success)
        result->video_frames_decoded = input.video_frames_decoded();
      if (success)
        result->video_frames_dropped = input.video_frames_dropped();
      if (success)
        result->audio_memory_usage = input.audio_memory_usage();
      if (success)
        result->video_memory_usage = input.video_memory_usage();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PredictionFeatures::DataView, ::media::mojom::PredictionFeaturesPtr>::Read(
    ::media::mojom::PredictionFeatures::DataView input,
    ::media::mojom::PredictionFeaturesPtr* output) {
  bool success = true;
  ::media::mojom::PredictionFeaturesPtr result(::media::mojom::PredictionFeatures::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadVideoSize(&result->video_size))
        success = false;
      if (success)
        result->frames_per_sec = input.frames_per_sec();
      if (success && !input.ReadKeySystem(&result->key_system))
        success = false;
      if (success)
        result->use_hw_secure_codecs = input.use_hw_secure_codecs();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PredictionTargets::DataView, ::media::mojom::PredictionTargetsPtr>::Read(
    ::media::mojom::PredictionTargets::DataView input,
    ::media::mojom::PredictionTargetsPtr* output) {
  bool success = true;
  ::media::mojom::PredictionTargetsPtr result(::media::mojom::PredictionTargets::New());
  
      if (success)
        result->frames_decoded = input.frames_decoded();
      if (success)
        result->frames_dropped = input.frames_dropped();
      if (success)
        result->frames_power_efficient = input.frames_power_efficient();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioPipelineInfo::DataView, ::media::mojom::AudioPipelineInfoPtr>::Read(
    ::media::mojom::AudioPipelineInfo::DataView input,
    ::media::mojom::AudioPipelineInfoPtr* output) {
  bool success = true;
  ::media::mojom::AudioPipelineInfoPtr result(::media::mojom::AudioPipelineInfo::New());
  
      if (success && !input.ReadDecoderType(&result->decoder_type))
        success = false;
      if (success)
        result->is_platform_decoder = input.is_platform_decoder();
      if (success)
        result->has_decrypting_demuxer_stream = input.has_decrypting_demuxer_stream();
      if (success && !input.ReadEncryptionType(&result->encryption_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoPipelineInfo::DataView, ::media::mojom::VideoPipelineInfoPtr>::Read(
    ::media::mojom::VideoPipelineInfo::DataView input,
    ::media::mojom::VideoPipelineInfoPtr* output) {
  bool success = true;
  ::media::mojom::VideoPipelineInfoPtr result(::media::mojom::VideoPipelineInfo::New());
  
      if (success && !input.ReadDecoderType(&result->decoder_type))
        success = false;
      if (success)
        result->is_platform_decoder = input.is_platform_decoder();
      if (success)
        result->has_decrypting_demuxer_stream = input.has_decrypting_demuxer_stream();
      if (success && !input.ReadEncryptionType(&result->encryption_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Status::DataView, ::media::mojom::StatusPtr>::Read(
    ::media::mojom::Status::DataView input,
    ::media::mojom::StatusPtr* output) {
  bool success = true;
  ::media::mojom::StatusPtr result(::media::mojom::Status::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadFrames(&result->frames))
        success = false;
      if (success && !input.ReadCauses(&result->causes))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::VideoFrameData::DataView, ::media::mojom::VideoFrameDataPtr>::Read(
    ::media::mojom::VideoFrameData::DataView input,
    ::media::mojom::VideoFrameDataPtr* output) {
  using UnionType = ::media::mojom::VideoFrameData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::EOS_DATA: {
      ::media::mojom::EosVideoFrameDataPtr result_eos_data;
      if (!input.ReadEosData(&result_eos_data))
        return false;

      *output = UnionType::NewEosData(
          std::move(result_eos_data));
      break;
    }
    case Tag::SHARED_BUFFER_DATA: {
      ::media::mojom::SharedBufferVideoFrameDataPtr result_shared_buffer_data;
      if (!input.ReadSharedBufferData(&result_shared_buffer_data))
        return false;

      *output = UnionType::NewSharedBufferData(
          std::move(result_shared_buffer_data));
      break;
    }
    case Tag::GPU_MEMORY_BUFFER_DATA: {
      ::media::mojom::GpuMemoryBufferVideoFrameDataPtr result_gpu_memory_buffer_data;
      if (!input.ReadGpuMemoryBufferData(&result_gpu_memory_buffer_data))
        return false;

      *output = UnionType::NewGpuMemoryBufferData(
          std::move(result_gpu_memory_buffer_data));
      break;
    }
    case Tag::MAILBOX_DATA: {
      ::media::mojom::MailboxVideoFrameDataPtr result_mailbox_data;
      if (!input.ReadMailboxData(&result_mailbox_data))
        return false;

      *output = UnionType::NewMailboxData(
          std::move(result_mailbox_data));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif