// media/mojo/mojom/remoting.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/remoting.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/remoting.mojom-params-data.h"
#include "media/mojo/mojom/remoting.mojom-shared-message-ids.h"

#include "media/mojo/mojom/remoting.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_REMOTING_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_REMOTING_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char RemoterFactory::Name_[] = "media.mojom.RemoterFactory";

RemoterFactoryProxy::RemoterFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoterFactoryProxy::Create(
    ::mojo::PendingRemote<RemotingSource> in_source, ::mojo::PendingReceiver<Remoter> in_remoter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemoterFactory::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::mojo::PendingRemote<RemotingSource>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remoter"), in_remoter,
                        "<value of type ::mojo::PendingReceiver<Remoter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoterFactory_Create_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemoterFactory_Create_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingSourceInterfaceBase>>(
      in_source, &params->source, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->source),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid source in RemoterFactory.Create request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RemoterInterfaceBase>>(
      in_remoter, &params->remoter, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remoter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remoter in RemoterFactory.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoterFactory::Name_);
  message.set_method_name("Create");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoterFactoryStubDispatch::Accept(
    RemoterFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemoterFactory_Create_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemoterFactory::Create",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemoterFactory::Create");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoterFactory_Create_Params_Data* params =
          reinterpret_cast<internal::RemoterFactory_Create_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<RemotingSource> p_source{};
      ::mojo::PendingReceiver<Remoter> p_remoter{};
      RemoterFactory_Create_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_source =
            input_data_view.TakeSource<decltype(p_source)>();
      }
      if (success) {
        p_remoter =
            input_data_view.TakeRemoter<decltype(p_remoter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoterFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(
std::move(p_source), 
std::move(p_remoter));
      return true;
    }
  }
  return false;
}

// static
bool RemoterFactoryStubDispatch::AcceptWithResponder(
    RemoterFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoterFactory_Create_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoterFactoryValidationInfo[] = {
    {internal::kRemoterFactory_Create_Name,
     {&internal::RemoterFactory_Create_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoterFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::RemoterFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoterFactoryValidationInfo);
}

const char RemotingDataStreamSender::Name_[] = "media.mojom.RemotingDataStreamSender";

RemotingDataStreamSenderProxy::RemotingDataStreamSenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingDataStreamSenderProxy::SendFrame(
    uint32_t in_frame_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingDataStreamSender::SendFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_size"), in_frame_size,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingDataStreamSender_SendFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamSender_SendFrame_Params_Data> params(
          message);
  params.Allocate();
  params->frame_size = in_frame_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamSender::Name_);
  message.set_method_name("SendFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingDataStreamSenderProxy::CancelInFlightData(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::RemotingDataStreamSender::CancelInFlightData");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingDataStreamSender_CancelInFlightData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamSender_CancelInFlightData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamSender::Name_);
  message.set_method_name("CancelInFlightData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemotingDataStreamSenderStubDispatch::Accept(
    RemotingDataStreamSender* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemotingDataStreamSender_SendFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingDataStreamSender::SendFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingDataStreamSender::SendFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingDataStreamSender_SendFrame_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamSender_SendFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frame_size{};
      RemotingDataStreamSender_SendFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_size = input_data_view.frame_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamSender::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFrame(
std::move(p_frame_size));
      return true;
    }
    case internal::kRemotingDataStreamSender_CancelInFlightData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingDataStreamSender::CancelInFlightData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingDataStreamSender::CancelInFlightData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingDataStreamSender_CancelInFlightData_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamSender_CancelInFlightData_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemotingDataStreamSender_CancelInFlightData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamSender::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelInFlightData();
      return true;
    }
  }
  return false;
}

// static
bool RemotingDataStreamSenderStubDispatch::AcceptWithResponder(
    RemotingDataStreamSender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemotingDataStreamSender_SendFrame_Name: {
      break;
    }
    case internal::kRemotingDataStreamSender_CancelInFlightData_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemotingDataStreamSenderValidationInfo[] = {
    {internal::kRemotingDataStreamSender_SendFrame_Name,
     {&internal::RemotingDataStreamSender_SendFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingDataStreamSender_CancelInFlightData_Name,
     {&internal::RemotingDataStreamSender_CancelInFlightData_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemotingDataStreamSenderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::RemotingDataStreamSender::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemotingDataStreamSenderValidationInfo);
}

const char Remoter::Name_[] = "media.mojom.Remoter";

class Remoter_EstimateTransmissionCapacity_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Remoter_EstimateTransmissionCapacity_ForwardToCallback(
      Remoter::EstimateTransmissionCapacityCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Remoter::EstimateTransmissionCapacityCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Remoter_EstimateTransmissionCapacity_ForwardToCallback);
};

RemoterProxy::RemoterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoterProxy::Start(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::Remoter::Start");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoter_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_Start_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoterProxy::StartDataStreams(
    ::mojo::ScopedDataPipeConsumerHandle in_audio_pipe, ::mojo::ScopedDataPipeConsumerHandle in_video_pipe, ::mojo::PendingReceiver<RemotingDataStreamSender> in_audio_sender, ::mojo::PendingReceiver<RemotingDataStreamSender> in_video_sender) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remoter::StartDataStreams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_pipe"), in_audio_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_pipe"), in_video_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_sender"), in_audio_sender,
                        "<value of type ::mojo::PendingReceiver<RemotingDataStreamSender>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_sender"), in_video_sender,
                        "<value of type ::mojo::PendingReceiver<RemotingDataStreamSender>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoter_StartDataStreams_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_StartDataStreams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_audio_pipe, &params->audio_pipe, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_video_pipe, &params->video_pipe, &params.message());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingDataStreamSenderInterfaceBase>>(
      in_audio_sender, &params->audio_sender, &params.message());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingDataStreamSenderInterfaceBase>>(
      in_video_sender, &params->video_sender, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("StartDataStreams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoterProxy::Stop(
    ::media::mojom::RemotingStopReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remoter::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::RemotingStopReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoter_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_Stop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::RemotingStopReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoterProxy::SendMessageToSink(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remoter::SendMessageToSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoter_SendMessageToSink_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_SendMessageToSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_message, message_fragment, &message_validate_params);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in Remoter.SendMessageToSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("SendMessageToSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoterProxy::EstimateTransmissionCapacity(
    EstimateTransmissionCapacityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::Remoter::EstimateTransmissionCapacity");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoter_EstimateTransmissionCapacity_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_EstimateTransmissionCapacity_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("EstimateTransmissionCapacity");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Remoter_EstimateTransmissionCapacity_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Remoter_EstimateTransmissionCapacity_ProxyToResponder {
 public:
  static Remoter::EstimateTransmissionCapacityCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Remoter_EstimateTransmissionCapacity_ProxyToResponder> proxy(
        new Remoter_EstimateTransmissionCapacity_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Remoter_EstimateTransmissionCapacity_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Remoter_EstimateTransmissionCapacity_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Remoter_EstimateTransmissionCapacity_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Remoter::EstimateTransmissionCapacityCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      double in_rate);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Remoter_EstimateTransmissionCapacity_ProxyToResponder);
};

bool Remoter_EstimateTransmissionCapacity_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::Remoter::EstimateTransmissionCapacityCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  double p_rate{};
  Remoter_EstimateTransmissionCapacity_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_rate = input_data_view.rate();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Remoter::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_rate));
  return true;
}

void Remoter_EstimateTransmissionCapacity_ProxyToResponder::Run(
    double in_rate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::Remoter::EstimateTransmissionCapacityCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rate"), in_rate,
                        "<value of type double>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemoter_EstimateTransmissionCapacity_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->rate = in_rate;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::Remoter::EstimateTransmissionCapacityCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("EstimateTransmissionCapacity");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RemoterStubDispatch::Accept(
    Remoter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemoter_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remoter::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remoter::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remoter_Start_Params_Data* params =
          reinterpret_cast<internal::Remoter_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Remoter_Start_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start();
      return true;
    }
    case internal::kRemoter_StartDataStreams_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remoter::StartDataStreams",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remoter::StartDataStreams");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remoter_StartDataStreams_Params_Data* params =
          reinterpret_cast<internal::Remoter_StartDataStreams_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_audio_pipe{};
      ::mojo::ScopedDataPipeConsumerHandle p_video_pipe{};
      ::mojo::PendingReceiver<RemotingDataStreamSender> p_audio_sender{};
      ::mojo::PendingReceiver<RemotingDataStreamSender> p_video_sender{};
      Remoter_StartDataStreams_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_audio_pipe = input_data_view.TakeAudioPipe();
      if (success)
        p_video_pipe = input_data_view.TakeVideoPipe();
      if (success) {
        p_audio_sender =
            input_data_view.TakeAudioSender<decltype(p_audio_sender)>();
      }
      if (success) {
        p_video_sender =
            input_data_view.TakeVideoSender<decltype(p_video_sender)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDataStreams(
std::move(p_audio_pipe), 
std::move(p_video_pipe), 
std::move(p_audio_sender), 
std::move(p_video_sender));
      return true;
    }
    case internal::kRemoter_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remoter::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remoter::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remoter_Stop_Params_Data* params =
          reinterpret_cast<internal::Remoter_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::RemotingStopReason p_reason{};
      Remoter_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(
std::move(p_reason));
      return true;
    }
    case internal::kRemoter_SendMessageToSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remoter::SendMessageToSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remoter::SendMessageToSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remoter_SendMessageToSink_Params_Data* params =
          reinterpret_cast<internal::Remoter_SendMessageToSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_message{};
      Remoter_SendMessageToSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessageToSink(
std::move(p_message));
      return true;
    }
    case internal::kRemoter_EstimateTransmissionCapacity_Name: {
      break;
    }
  }
  return false;
}

// static
bool RemoterStubDispatch::AcceptWithResponder(
    Remoter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoter_Start_Name: {
      break;
    }
    case internal::kRemoter_StartDataStreams_Name: {
      break;
    }
    case internal::kRemoter_Stop_Name: {
      break;
    }
    case internal::kRemoter_SendMessageToSink_Name: {
      break;
    }
    case internal::kRemoter_EstimateTransmissionCapacity_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remoter::EstimateTransmissionCapacity",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remoter::EstimateTransmissionCapacity");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Remoter_EstimateTransmissionCapacity_Params_Data* params =
          reinterpret_cast<
              internal::Remoter_EstimateTransmissionCapacity_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Remoter_EstimateTransmissionCapacity_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 4, false);
        return false;
      }
      Remoter::EstimateTransmissionCapacityCallback callback =
          Remoter_EstimateTransmissionCapacity_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstimateTransmissionCapacity(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoterValidationInfo[] = {
    {internal::kRemoter_Start_Name,
     {&internal::Remoter_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoter_StartDataStreams_Name,
     {&internal::Remoter_StartDataStreams_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoter_Stop_Name,
     {&internal::Remoter_Stop_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoter_SendMessageToSink_Name,
     {&internal::Remoter_SendMessageToSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoter_EstimateTransmissionCapacity_Name,
     {&internal::Remoter_EstimateTransmissionCapacity_Params_Data::Validate,
      &internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data::Validate}},
};

bool RemoterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::Remoter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoterValidationInfo);
}

bool RemoterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::Remoter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRemoterValidationInfo);

}
const char RemotingSource::Name_[] = "media.mojom.RemotingSource";

RemotingSourceProxy::RemotingSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingSourceProxy::OnSinkAvailable(
    ::media::mojom::RemotingSinkMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingSource::OnSinkAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type ::media::mojom::RemotingSinkMetadataPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSource_OnSinkAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnSinkAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::RemotingSinkMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in RemotingSource.OnSinkAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnSinkAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingSourceProxy::OnSinkGone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::RemotingSource::OnSinkGone");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSource_OnSinkGone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnSinkGone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnSinkGone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingSourceProxy::OnStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::RemotingSource::OnStarted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSource_OnStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingSourceProxy::OnStartFailed(
    ::media::mojom::RemotingStartFailReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingSource::OnStartFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::RemotingStartFailReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSource_OnStartFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnStartFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::RemotingStartFailReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnStartFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingSourceProxy::OnMessageFromSink(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingSource::OnMessageFromSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSource_OnMessageFromSink_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnMessageFromSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_message, message_fragment, &message_validate_params);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in RemotingSource.OnMessageFromSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnMessageFromSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingSourceProxy::OnStopped(
    ::media::mojom::RemotingStopReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingSource::OnStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::RemotingStopReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSource_OnStopped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnStopped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::RemotingStopReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemotingSourceStubDispatch::Accept(
    RemotingSource* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemotingSource_OnSinkAvailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSource::OnSinkAvailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSource::OnSinkAvailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSource_OnSinkAvailable_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnSinkAvailable_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::RemotingSinkMetadataPtr p_metadata{};
      RemotingSource_OnSinkAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSinkAvailable(
std::move(p_metadata));
      return true;
    }
    case internal::kRemotingSource_OnSinkGone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSource::OnSinkGone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSource::OnSinkGone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSource_OnSinkGone_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnSinkGone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemotingSource_OnSinkGone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSinkGone();
      return true;
    }
    case internal::kRemotingSource_OnStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSource::OnStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSource::OnStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSource_OnStarted_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemotingSource_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted();
      return true;
    }
    case internal::kRemotingSource_OnStartFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSource::OnStartFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSource::OnStartFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSource_OnStartFailed_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnStartFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::RemotingStartFailReason p_reason{};
      RemotingSource_OnStartFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartFailed(
std::move(p_reason));
      return true;
    }
    case internal::kRemotingSource_OnMessageFromSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSource::OnMessageFromSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSource::OnMessageFromSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSource_OnMessageFromSink_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnMessageFromSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_message{};
      RemotingSource_OnMessageFromSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessageFromSink(
std::move(p_message));
      return true;
    }
    case internal::kRemotingSource_OnStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSource::OnStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSource::OnStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSource_OnStopped_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::RemotingStopReason p_reason{};
      RemotingSource_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool RemotingSourceStubDispatch::AcceptWithResponder(
    RemotingSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemotingSource_OnSinkAvailable_Name: {
      break;
    }
    case internal::kRemotingSource_OnSinkGone_Name: {
      break;
    }
    case internal::kRemotingSource_OnStarted_Name: {
      break;
    }
    case internal::kRemotingSource_OnStartFailed_Name: {
      break;
    }
    case internal::kRemotingSource_OnMessageFromSink_Name: {
      break;
    }
    case internal::kRemotingSource_OnStopped_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemotingSourceValidationInfo[] = {
    {internal::kRemotingSource_OnSinkAvailable_Name,
     {&internal::RemotingSource_OnSinkAvailable_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingSource_OnSinkGone_Name,
     {&internal::RemotingSource_OnSinkGone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingSource_OnStarted_Name,
     {&internal::RemotingSource_OnStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingSource_OnStartFailed_Name,
     {&internal::RemotingSource_OnStartFailed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingSource_OnMessageFromSink_Name,
     {&internal::RemotingSource_OnMessageFromSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingSource_OnStopped_Name,
     {&internal::RemotingSource_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemotingSourceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::RemotingSource::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemotingSourceValidationInfo);
}

const char Remotee::Name_[] = "media.mojom.Remotee";

RemoteeProxy::RemoteeProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteeProxy::OnRemotingSinkReady(
    ::mojo::PendingRemote<RemotingSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remotee::OnRemotingSinkReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink,
                        "<value of type ::mojo::PendingRemote<RemotingSink>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotee_OnRemotingSinkReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_OnRemotingSinkReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingSinkInterfaceBase>>(
      in_sink, &params->sink, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->sink),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid sink in Remotee.OnRemotingSinkReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("OnRemotingSinkReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteeProxy::SendMessageToSource(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remotee::SendMessageToSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotee_SendMessageToSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_SendMessageToSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_message, message_fragment, &message_validate_params);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in Remotee.SendMessageToSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("SendMessageToSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteeProxy::StartDataStreams(
    ::mojo::PendingRemote<RemotingDataStreamReceiver> in_audio_stream, ::mojo::PendingRemote<RemotingDataStreamReceiver> in_video_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remotee::StartDataStreams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_stream"), in_audio_stream,
                        "<value of type ::mojo::PendingRemote<RemotingDataStreamReceiver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_stream"), in_video_stream,
                        "<value of type ::mojo::PendingRemote<RemotingDataStreamReceiver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotee_StartDataStreams_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_StartDataStreams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingDataStreamReceiverInterfaceBase>>(
      in_audio_stream, &params->audio_stream, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingDataStreamReceiverInterfaceBase>>(
      in_video_stream, &params->video_stream, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("StartDataStreams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteeProxy::OnFlushUntil(
    uint32_t in_audio_frame_count, uint32_t in_video_frame_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remotee::OnFlushUntil", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_frame_count"), in_audio_frame_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_frame_count"), in_video_frame_count,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotee_OnFlushUntil_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_OnFlushUntil_Params_Data> params(
          message);
  params.Allocate();
  params->audio_frame_count = in_audio_frame_count;
  params->video_frame_count = in_video_frame_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("OnFlushUntil");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteeProxy::OnVideoNaturalSizeChange(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Remotee::OnVideoNaturalSizeChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotee_OnVideoNaturalSizeChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_OnVideoNaturalSizeChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in Remotee.OnVideoNaturalSizeChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("OnVideoNaturalSizeChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteeStubDispatch::Accept(
    Remotee* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemotee_OnRemotingSinkReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remotee::OnRemotingSinkReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remotee::OnRemotingSinkReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remotee_OnRemotingSinkReady_Params_Data* params =
          reinterpret_cast<internal::Remotee_OnRemotingSinkReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<RemotingSink> p_sink{};
      Remotee_OnRemotingSinkReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemotingSinkReady(
std::move(p_sink));
      return true;
    }
    case internal::kRemotee_SendMessageToSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remotee::SendMessageToSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remotee::SendMessageToSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remotee_SendMessageToSource_Params_Data* params =
          reinterpret_cast<internal::Remotee_SendMessageToSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_message{};
      Remotee_SendMessageToSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessageToSource(
std::move(p_message));
      return true;
    }
    case internal::kRemotee_StartDataStreams_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remotee::StartDataStreams",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remotee::StartDataStreams");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remotee_StartDataStreams_Params_Data* params =
          reinterpret_cast<internal::Remotee_StartDataStreams_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<RemotingDataStreamReceiver> p_audio_stream{};
      ::mojo::PendingRemote<RemotingDataStreamReceiver> p_video_stream{};
      Remotee_StartDataStreams_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_audio_stream =
            input_data_view.TakeAudioStream<decltype(p_audio_stream)>();
      }
      if (success) {
        p_video_stream =
            input_data_view.TakeVideoStream<decltype(p_video_stream)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDataStreams(
std::move(p_audio_stream), 
std::move(p_video_stream));
      return true;
    }
    case internal::kRemotee_OnFlushUntil_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remotee::OnFlushUntil",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remotee::OnFlushUntil");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remotee_OnFlushUntil_Params_Data* params =
          reinterpret_cast<internal::Remotee_OnFlushUntil_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_audio_frame_count{};
      uint32_t p_video_frame_count{};
      Remotee_OnFlushUntil_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_audio_frame_count = input_data_view.audio_frame_count();
      if (success)
        p_video_frame_count = input_data_view.video_frame_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFlushUntil(
std::move(p_audio_frame_count), 
std::move(p_video_frame_count));
      return true;
    }
    case internal::kRemotee_OnVideoNaturalSizeChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Remotee::OnVideoNaturalSizeChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Remotee::OnVideoNaturalSizeChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Remotee_OnVideoNaturalSizeChange_Params_Data* params =
          reinterpret_cast<internal::Remotee_OnVideoNaturalSizeChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      Remotee_OnVideoNaturalSizeChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoNaturalSizeChange(
std::move(p_size));
      return true;
    }
  }
  return false;
}

// static
bool RemoteeStubDispatch::AcceptWithResponder(
    Remotee* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemotee_OnRemotingSinkReady_Name: {
      break;
    }
    case internal::kRemotee_SendMessageToSource_Name: {
      break;
    }
    case internal::kRemotee_StartDataStreams_Name: {
      break;
    }
    case internal::kRemotee_OnFlushUntil_Name: {
      break;
    }
    case internal::kRemotee_OnVideoNaturalSizeChange_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteeValidationInfo[] = {
    {internal::kRemotee_OnRemotingSinkReady_Name,
     {&internal::Remotee_OnRemotingSinkReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotee_SendMessageToSource_Name,
     {&internal::Remotee_SendMessageToSource_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotee_StartDataStreams_Name,
     {&internal::Remotee_StartDataStreams_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotee_OnFlushUntil_Name,
     {&internal::Remotee_OnFlushUntil_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotee_OnVideoNaturalSizeChange_Name,
     {&internal::Remotee_OnVideoNaturalSizeChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteeRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::Remotee::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteeValidationInfo);
}

const char RemotingSink::Name_[] = "media.mojom.RemotingSink";

RemotingSinkProxy::RemotingSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingSinkProxy::OnMessageFromSource(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingSink::OnMessageFromSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingSink_OnMessageFromSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSink_OnMessageFromSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_message, message_fragment, &message_validate_params);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in RemotingSink.OnMessageFromSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSink::Name_);
  message.set_method_name("OnMessageFromSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemotingSinkStubDispatch::Accept(
    RemotingSink* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemotingSink_OnMessageFromSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingSink::OnMessageFromSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingSink::OnMessageFromSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingSink_OnMessageFromSource_Params_Data* params =
          reinterpret_cast<internal::RemotingSink_OnMessageFromSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_message{};
      RemotingSink_OnMessageFromSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessageFromSource(
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool RemotingSinkStubDispatch::AcceptWithResponder(
    RemotingSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemotingSink_OnMessageFromSource_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemotingSinkValidationInfo[] = {
    {internal::kRemotingSink_OnMessageFromSource_Name,
     {&internal::RemotingSink_OnMessageFromSource_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemotingSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::RemotingSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemotingSinkValidationInfo);
}

const char RemotingDataStreamReceiver::Name_[] = "media.mojom.RemotingDataStreamReceiver";

RemotingDataStreamReceiverProxy::RemotingDataStreamReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingDataStreamReceiverProxy::InitializeDataPipe(
    ::mojo::ScopedDataPipeConsumerHandle in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingDataStreamReceiver::InitializeDataPipe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingDataStreamReceiver_InitializeDataPipe_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_data_pipe, &params->data_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data_pipe in RemotingDataStreamReceiver.InitializeDataPipe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamReceiver::Name_);
  message.set_method_name("InitializeDataPipe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingDataStreamReceiverProxy::ReceiveFrame(
    uint32_t in_frame_count, ::media::mojom::DecoderBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingDataStreamReceiver::ReceiveFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_count"), in_frame_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingDataStreamReceiver_ReceiveFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data> params(
          message);
  params.Allocate();
  params->frame_count = in_frame_count;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in RemotingDataStreamReceiver.ReceiveFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamReceiver::Name_);
  message.set_method_name("ReceiveFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemotingDataStreamReceiverProxy::FlushUntil(
    uint32_t in_frame_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RemotingDataStreamReceiver::FlushUntil", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_count"), in_frame_count,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRemotingDataStreamReceiver_FlushUntil_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamReceiver_FlushUntil_Params_Data> params(
          message);
  params.Allocate();
  params->frame_count = in_frame_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamReceiver::Name_);
  message.set_method_name("FlushUntil");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemotingDataStreamReceiverStubDispatch::Accept(
    RemotingDataStreamReceiver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRemotingDataStreamReceiver_InitializeDataPipe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingDataStreamReceiver::InitializeDataPipe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingDataStreamReceiver::InitializeDataPipe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_data_pipe{};
      RemotingDataStreamReceiver_InitializeDataPipe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_data_pipe = input_data_view.TakeDataPipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeDataPipe(
std::move(p_data_pipe));
      return true;
    }
    case internal::kRemotingDataStreamReceiver_ReceiveFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingDataStreamReceiver::ReceiveFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingDataStreamReceiver::ReceiveFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frame_count{};
      ::media::mojom::DecoderBufferPtr p_buffer{};
      RemotingDataStreamReceiver_ReceiveFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_count = input_data_view.frame_count();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamReceiver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveFrame(
std::move(p_frame_count), 
std::move(p_buffer));
      return true;
    }
    case internal::kRemotingDataStreamReceiver_FlushUntil_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RemotingDataStreamReceiver::FlushUntil",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RemotingDataStreamReceiver::FlushUntil");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemotingDataStreamReceiver_FlushUntil_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamReceiver_FlushUntil_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frame_count{};
      RemotingDataStreamReceiver_FlushUntil_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_count = input_data_view.frame_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamReceiver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushUntil(
std::move(p_frame_count));
      return true;
    }
  }
  return false;
}

// static
bool RemotingDataStreamReceiverStubDispatch::AcceptWithResponder(
    RemotingDataStreamReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemotingDataStreamReceiver_InitializeDataPipe_Name: {
      break;
    }
    case internal::kRemotingDataStreamReceiver_ReceiveFrame_Name: {
      break;
    }
    case internal::kRemotingDataStreamReceiver_FlushUntil_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemotingDataStreamReceiverValidationInfo[] = {
    {internal::kRemotingDataStreamReceiver_InitializeDataPipe_Name,
     {&internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingDataStreamReceiver_ReceiveFrame_Name,
     {&internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemotingDataStreamReceiver_FlushUntil_Name,
     {&internal::RemotingDataStreamReceiver_FlushUntil_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemotingDataStreamReceiverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::RemotingDataStreamReceiver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemotingDataStreamReceiverValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif