// media/mojo/mojom/remoting_common.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/remoting_common.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/remoting_common.mojom-params-data.h"
#include "media/mojo/mojom/remoting_common.mojom-shared-message-ids.h"

#include "media/mojo/mojom/remoting_common.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
RemotingSinkMetadata::RemotingSinkMetadata()
    : features(),
      audio_capabilities(),
      video_capabilities(),
      friendly_name() {}

RemotingSinkMetadata::RemotingSinkMetadata(
    std::vector<RemotingSinkFeature> features_in,
    std::vector<RemotingSinkAudioCapability> audio_capabilities_in,
    std::vector<RemotingSinkVideoCapability> video_capabilities_in,
    const std::string& friendly_name_in)
    : features(std::move(features_in)),
      audio_capabilities(std::move(audio_capabilities_in)),
      video_capabilities(std::move(video_capabilities_in)),
      friendly_name(std::move(friendly_name_in)) {}

RemotingSinkMetadata::~RemotingSinkMetadata() = default;

void RemotingSinkMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "features"), this->features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<RemotingSinkFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_capabilities"), this->audio_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<RemotingSinkAudioCapability>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_capabilities"), this->video_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<RemotingSinkVideoCapability>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "friendly_name"), this->friendly_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemotingSinkMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::RemotingSinkMetadata::DataView, ::media::mojom::RemotingSinkMetadataPtr>::Read(
    ::media::mojom::RemotingSinkMetadata::DataView input,
    ::media::mojom::RemotingSinkMetadataPtr* output) {
  bool success = true;
  ::media::mojom::RemotingSinkMetadataPtr result(::media::mojom::RemotingSinkMetadata::New());
  
      if (success && !input.ReadFeatures(&result->features))
        success = false;
      if (success && !input.ReadAudioCapabilities(&result->audio_capabilities))
        success = false;
      if (success && !input.ReadVideoCapabilities(&result->video_capabilities))
        success = false;
      if (success && !input.ReadFriendlyName(&result->friendly_name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif