// media/mojo/mojom/speech_recognition_service.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/speech_recognition_service.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/audio_stream_factory.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink.h"


#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif


namespace media {
namespace mojom {
namespace blink {


void SpeechRecognitionContextInterceptorForTesting::BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, BindRecognizerCallback callback) {
  GetForwardingInterface()->BindRecognizer(std::move(receiver), std::move(client), std::move(options), std::move(callback));
}
void SpeechRecognitionContextInterceptorForTesting::BindAudioSourceFetcher(::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, BindAudioSourceFetcherCallback callback) {
  GetForwardingInterface()->BindAudioSourceFetcher(std::move(fetcher_receiver), std::move(client), std::move(options), std::move(callback));
}
SpeechRecognitionContextAsyncWaiter::SpeechRecognitionContextAsyncWaiter(
    SpeechRecognitionContext* proxy) : proxy_(proxy) {}

SpeechRecognitionContextAsyncWaiter::~SpeechRecognitionContextAsyncWaiter() = default;

void SpeechRecognitionContextAsyncWaiter::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, bool* out_is_multichannel_supported) {
  base::RunLoop loop;
  proxy_->BindRecognizer(std::move(receiver),std::move(client),std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_multichannel_supported
,
             bool is_multichannel_supported) {*out_is_multichannel_supported = std::move(is_multichannel_supported);
            loop->Quit();
          },
          &loop,
          out_is_multichannel_supported));
  loop.Run();
}
void SpeechRecognitionContextAsyncWaiter::BindAudioSourceFetcher(
    ::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, bool* out_is_multichannel_supported) {
  base::RunLoop loop;
  proxy_->BindAudioSourceFetcher(std::move(fetcher_receiver),std::move(client),std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_multichannel_supported
,
             bool is_multichannel_supported) {*out_is_multichannel_supported = std::move(is_multichannel_supported);
            loop->Quit();
          },
          &loop,
          out_is_multichannel_supported));
  loop.Run();
}



void SpeechRecognitionServiceInterceptorForTesting::BindContext(::mojo::PendingReceiver<SpeechRecognitionContext> context) {
  GetForwardingInterface()->BindContext(std::move(context));
}
void SpeechRecognitionServiceInterceptorForTesting::SetUrlLoaderFactory(::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> url_loader_factory) {
  GetForwardingInterface()->SetUrlLoaderFactory(std::move(url_loader_factory));
}
void SpeechRecognitionServiceInterceptorForTesting::SetSodaPath(const ::base::FilePath& binary_path, const ::base::FilePath& config_path) {
  GetForwardingInterface()->SetSodaPath(std::move(binary_path), std::move(config_path));
}
void SpeechRecognitionServiceInterceptorForTesting::BindSpeechRecognitionServiceClient(::mojo::PendingRemote<SpeechRecognitionServiceClient> client) {
  GetForwardingInterface()->BindSpeechRecognitionServiceClient(std::move(client));
}
SpeechRecognitionServiceAsyncWaiter::SpeechRecognitionServiceAsyncWaiter(
    SpeechRecognitionService* proxy) : proxy_(proxy) {}

SpeechRecognitionServiceAsyncWaiter::~SpeechRecognitionServiceAsyncWaiter() = default;




void AudioSourceFetcherInterceptorForTesting::Start(::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> factory, const WTF::String& device_id, const ::media::AudioParameters& audio_parameters) {
  GetForwardingInterface()->Start(std::move(factory), std::move(device_id), std::move(audio_parameters));
}
void AudioSourceFetcherInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
AudioSourceFetcherAsyncWaiter::AudioSourceFetcherAsyncWaiter(
    AudioSourceFetcher* proxy) : proxy_(proxy) {}

AudioSourceFetcherAsyncWaiter::~AudioSourceFetcherAsyncWaiter() = default;




void SpeechRecognitionServiceClientInterceptorForTesting::OnNetworkServiceDisconnect() {
  GetForwardingInterface()->OnNetworkServiceDisconnect();
}
SpeechRecognitionServiceClientAsyncWaiter::SpeechRecognitionServiceClientAsyncWaiter(
    SpeechRecognitionServiceClient* proxy) : proxy_(proxy) {}

SpeechRecognitionServiceClientAsyncWaiter::~SpeechRecognitionServiceClientAsyncWaiter() = default;




void SpeechRecognitionRecognizerInterceptorForTesting::SendAudioToSpeechRecognitionService(::media::mojom::blink::AudioDataS16Ptr buffer) {
  GetForwardingInterface()->SendAudioToSpeechRecognitionService(std::move(buffer));
}
void SpeechRecognitionRecognizerInterceptorForTesting::OnLanguageChanged(const WTF::String& language) {
  GetForwardingInterface()->OnLanguageChanged(std::move(language));
}
SpeechRecognitionRecognizerAsyncWaiter::SpeechRecognitionRecognizerAsyncWaiter(
    SpeechRecognitionRecognizer* proxy) : proxy_(proxy) {}

SpeechRecognitionRecognizerAsyncWaiter::~SpeechRecognitionRecognizerAsyncWaiter() = default;




void SpeechRecognitionRecognizerClientInterceptorForTesting::OnSpeechRecognitionRecognitionEvent(SpeechRecognitionResultPtr result, OnSpeechRecognitionRecognitionEventCallback callback) {
  GetForwardingInterface()->OnSpeechRecognitionRecognitionEvent(std::move(result), std::move(callback));
}
void SpeechRecognitionRecognizerClientInterceptorForTesting::OnSpeechRecognitionError() {
  GetForwardingInterface()->OnSpeechRecognitionError();
}
void SpeechRecognitionRecognizerClientInterceptorForTesting::OnLanguageIdentificationEvent(LanguageIdentificationEventPtr event) {
  GetForwardingInterface()->OnLanguageIdentificationEvent(std::move(event));
}
SpeechRecognitionRecognizerClientAsyncWaiter::SpeechRecognitionRecognizerClientAsyncWaiter(
    SpeechRecognitionRecognizerClient* proxy) : proxy_(proxy) {}

SpeechRecognitionRecognizerClientAsyncWaiter::~SpeechRecognitionRecognizerClientAsyncWaiter() = default;

void SpeechRecognitionRecognizerClientAsyncWaiter::OnSpeechRecognitionRecognitionEvent(
    SpeechRecognitionResultPtr result, bool* out_success) {
  base::RunLoop loop;
  proxy_->OnSpeechRecognitionRecognitionEvent(std::move(result),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}



void SpeechRecognitionBrowserObserverInterceptorForTesting::SpeechRecognitionAvailabilityChanged(bool is_speech_recognition_available) {
  GetForwardingInterface()->SpeechRecognitionAvailabilityChanged(std::move(is_speech_recognition_available));
}
void SpeechRecognitionBrowserObserverInterceptorForTesting::SpeechRecognitionLanguageChanged(const WTF::String& language) {
  GetForwardingInterface()->SpeechRecognitionLanguageChanged(std::move(language));
}
SpeechRecognitionBrowserObserverAsyncWaiter::SpeechRecognitionBrowserObserverAsyncWaiter(
    SpeechRecognitionBrowserObserver* proxy) : proxy_(proxy) {}

SpeechRecognitionBrowserObserverAsyncWaiter::~SpeechRecognitionBrowserObserverAsyncWaiter() = default;




void SpeechRecognitionClientBrowserInterfaceInterceptorForTesting::BindSpeechRecognitionBrowserObserver(::mojo::PendingRemote<SpeechRecognitionBrowserObserver> observer) {
  GetForwardingInterface()->BindSpeechRecognitionBrowserObserver(std::move(observer));
}
SpeechRecognitionClientBrowserInterfaceAsyncWaiter::SpeechRecognitionClientBrowserInterfaceAsyncWaiter(
    SpeechRecognitionClientBrowserInterface* proxy) : proxy_(proxy) {}

SpeechRecognitionClientBrowserInterfaceAsyncWaiter::~SpeechRecognitionClientBrowserInterfaceAsyncWaiter() = default;






}  // namespace blink
}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif