// media/mojo/mojom/speech_recognition_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/speech_recognition_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-params-data.h"
namespace media {
namespace mojom {

static NOINLINE const char* ConfidenceLevelToStringHelper(ConfidenceLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConfidenceLevel::kUnknown:
      return "kUnknown";
    case ConfidenceLevel::kNotConfident:
      return "kNotConfident";
    case ConfidenceLevel::kConfident:
      return "kConfident";
    case ConfidenceLevel::kHighlyConfident:
      return "kHighlyConfident";
    default:
      return nullptr;
  }
}

std::string ConfidenceLevelToString(ConfidenceLevel value) {
  const char *str = ConfidenceLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConfidenceLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConfidenceLevel value) {
  return os << ConfidenceLevelToString(value);
}

static NOINLINE const char* SpeechRecognitionModeToStringHelper(SpeechRecognitionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeechRecognitionMode::kUnknown:
      return "kUnknown";
    case SpeechRecognitionMode::kIme:
      return "kIme";
    case SpeechRecognitionMode::kCaption:
      return "kCaption";
    default:
      return nullptr;
  }
}

std::string SpeechRecognitionModeToString(SpeechRecognitionMode value) {
  const char *str = SpeechRecognitionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeechRecognitionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeechRecognitionMode value) {
  return os << SpeechRecognitionModeToString(value);
}

namespace internal {


// static
bool HypothesisParts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HypothesisParts_Data* object = static_cast<const HypothesisParts_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hypothesis_part_offset, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hypothesis_part_offset, validation_context))
    return false;

  return true;
}

HypothesisParts_Data::HypothesisParts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TimingInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TimingInformation_Data* object = static_cast<const TimingInformation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->audio_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->audio_end_time, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams hypothesis_parts_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hypothesis_parts, validation_context,
                                         &hypothesis_parts_validate_params)) {
    return false;
  }

  return true;
}

TimingInformation_Data::TimingInformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionResult_Data* object = static_cast<const SpeechRecognitionResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transcription, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transcription_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->transcription, validation_context,
                                         &transcription_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timing_information, validation_context))
    return false;

  return true;
}

SpeechRecognitionResult_Data::SpeechRecognitionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LanguageIdentificationEvent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LanguageIdentificationEvent_Data* object = static_cast<const LanguageIdentificationEvent_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams language_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::ConfidenceLevel_Data
        ::Validate(object->confidence_level, validation_context))
    return false;

  return true;
}

LanguageIdentificationEvent_Data::LanguageIdentificationEvent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionOptions_Data* object = static_cast<const SpeechRecognitionOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::SpeechRecognitionMode_Data
        ::Validate(object->recognition_mode, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams language_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionOptions_Data::SpeechRecognitionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionContext_BindRecognizer_Params_Data* object = static_cast<const SpeechRecognitionContext_BindRecognizer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SpeechRecognitionContext_BindRecognizer_Params_Data::SpeechRecognitionContext_BindRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionContext_BindRecognizer_ResponseParams_Data* object = static_cast<const SpeechRecognitionContext_BindRecognizer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data* object = static_cast<const SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->fetcher_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->fetcher_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data::SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data* object = static_cast<const SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data::SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_BindContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_BindContext_Params_Data* object = static_cast<const SpeechRecognitionService_BindContext_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->context, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->context,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionService_BindContext_Params_Data::SpeechRecognitionService_BindContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_SetUrlLoaderFactory_Params_Data* object = static_cast<const SpeechRecognitionService_SetUrlLoaderFactory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_SetSodaPath_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_SetSodaPath_Params_Data* object = static_cast<const SpeechRecognitionService_SetSodaPath_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->binary_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->binary_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config_path, validation_context))
    return false;

  return true;
}

SpeechRecognitionService_SetSodaPath_Params_Data::SpeechRecognitionService_SetSodaPath_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data* object = static_cast<const SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioSourceFetcher_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AudioSourceFetcher_Start_Params_Data* object = static_cast<const AudioSourceFetcher_Start_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams device_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_parameters, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->audio_parameters, validation_context))
    return false;

  return true;
}

AudioSourceFetcher_Start_Params_Data::AudioSourceFetcher_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioSourceFetcher_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AudioSourceFetcher_Stop_Params_Data* object = static_cast<const AudioSourceFetcher_Stop_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

AudioSourceFetcher_Stop_Params_Data::AudioSourceFetcher_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data* object = static_cast<const SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data* object = static_cast<const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data* object = static_cast<const SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams language_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data* object = static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data* object = static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data* object = static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data* object = static_cast<const SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data* object = static_cast<const SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data* object = static_cast<const SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams language_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data* object = static_cast<const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::ConfidenceLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::ConfidenceLevel value) {
  return std::move(context).WriteString(::media::mojom::ConfidenceLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::SpeechRecognitionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::SpeechRecognitionMode value) {
  return std::move(context).WriteString(::media::mojom::SpeechRecognitionModeToString(value));
}

} // namespace perfetto
