// media/mojo/mojom/video_decode_stats_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_decode_stats_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_decode_stats_recorder.mojom-params-data.h"
#include "media/mojo/mojom/video_decode_stats_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_decode_stats_recorder.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODE_STATS_RECORDER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODE_STATS_RECORDER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char VideoDecodeStatsRecorder::Name_[] = "media.mojom.VideoDecodeStatsRecorder";

VideoDecodeStatsRecorderProxy::VideoDecodeStatsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoDecodeStatsRecorderProxy::StartNewRecord(
    ::media::mojom::PredictionFeaturesPtr in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecodeStatsRecorder::StartNewRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type ::media::mojom::PredictionFeaturesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecodeStatsRecorder_StartNewRecord_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType> features_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PredictionFeaturesDataView>(
      in_features, features_fragment);
  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in VideoDecodeStatsRecorder.StartNewRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecodeStatsRecorder::Name_);
  message.set_method_name("StartNewRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoDecodeStatsRecorderProxy::UpdateRecord(
    ::media::mojom::PredictionTargetsPtr in_targets) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecodeStatsRecorder::UpdateRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("targets"), in_targets,
                        "<value of type ::media::mojom::PredictionTargetsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecodeStatsRecorder_UpdateRecord_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->targets)::BaseType> targets_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PredictionTargetsDataView>(
      in_targets, targets_fragment);
  params->targets.Set(
      targets_fragment.is_null() ? nullptr : targets_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->targets.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null targets in VideoDecodeStatsRecorder.UpdateRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecodeStatsRecorder::Name_);
  message.set_method_name("UpdateRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoDecodeStatsRecorderStubDispatch::Accept(
    VideoDecodeStatsRecorder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoDecodeStatsRecorder_StartNewRecord_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecodeStatsRecorder::StartNewRecord",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecodeStatsRecorder::StartNewRecord");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data* params =
          reinterpret_cast<internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::PredictionFeaturesPtr p_features{};
      VideoDecodeStatsRecorder_StartNewRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecodeStatsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNewRecord(
std::move(p_features));
      return true;
    }
    case internal::kVideoDecodeStatsRecorder_UpdateRecord_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecodeStatsRecorder::UpdateRecord",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecodeStatsRecorder::UpdateRecord");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data* params =
          reinterpret_cast<internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::PredictionTargetsPtr p_targets{};
      VideoDecodeStatsRecorder_UpdateRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargets(&p_targets))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecodeStatsRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRecord(
std::move(p_targets));
      return true;
    }
  }
  return false;
}

// static
bool VideoDecodeStatsRecorderStubDispatch::AcceptWithResponder(
    VideoDecodeStatsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoDecodeStatsRecorder_StartNewRecord_Name: {
      break;
    }
    case internal::kVideoDecodeStatsRecorder_UpdateRecord_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoDecodeStatsRecorderValidationInfo[] = {
    {internal::kVideoDecodeStatsRecorder_StartNewRecord_Name,
     {&internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoDecodeStatsRecorder_UpdateRecord_Name,
     {&internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoDecodeStatsRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoDecodeStatsRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoDecodeStatsRecorderValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif