// media/mojo/mojom/video_encode_accelerator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/video_encode_accelerator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-params-data.h"
namespace media {
namespace mojom {

static NOINLINE const char* Bitrate_ModeToStringHelper(Bitrate_Mode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Bitrate_Mode::kConstant:
      return "kConstant";
    case Bitrate_Mode::kVariable:
      return "kVariable";
    default:
      return nullptr;
  }
}

std::string Bitrate_ModeToString(Bitrate_Mode value) {
  const char *str = Bitrate_ModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Bitrate_Mode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Bitrate_Mode value) {
  return os << Bitrate_ModeToString(value);
}

static NOINLINE const char* VideoEncodeAcceleratorConfig_ContentTypeToStringHelper(VideoEncodeAcceleratorConfig_ContentType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorConfig_ContentType::kCamera:
      return "kCamera";
    case VideoEncodeAcceleratorConfig_ContentType::kDisplay:
      return "kDisplay";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorConfig_ContentTypeToString(VideoEncodeAcceleratorConfig_ContentType value) {
  const char *str = VideoEncodeAcceleratorConfig_ContentTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorConfig_ContentType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_ContentType value) {
  return os << VideoEncodeAcceleratorConfig_ContentTypeToString(value);
}

static NOINLINE const char* VideoEncodeAcceleratorConfig_InterLayerPredModeToStringHelper(VideoEncodeAcceleratorConfig_InterLayerPredMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorConfig_InterLayerPredMode::kOff:
      return "kOff";
    case VideoEncodeAcceleratorConfig_InterLayerPredMode::kOn:
      return "kOn";
    case VideoEncodeAcceleratorConfig_InterLayerPredMode::kOnKeyPic:
      return "kOnKeyPic";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorConfig_InterLayerPredModeToString(VideoEncodeAcceleratorConfig_InterLayerPredMode value) {
  const char *str = VideoEncodeAcceleratorConfig_InterLayerPredModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorConfig_InterLayerPredMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_InterLayerPredMode value) {
  return os << VideoEncodeAcceleratorConfig_InterLayerPredModeToString(value);
}

static NOINLINE const char* VideoEncodeAcceleratorConfig_StorageTypeToStringHelper(VideoEncodeAcceleratorConfig_StorageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAcceleratorConfig_StorageType::kShmem:
      return "kShmem";
    case VideoEncodeAcceleratorConfig_StorageType::kGpuMemoryBuffer:
      return "kGpuMemoryBuffer";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAcceleratorConfig_StorageTypeToString(VideoEncodeAcceleratorConfig_StorageType value) {
  const char *str = VideoEncodeAcceleratorConfig_StorageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAcceleratorConfig_StorageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_StorageType value) {
  return os << VideoEncodeAcceleratorConfig_StorageTypeToString(value);
}

static NOINLINE const char* VideoEncodeAccelerator_ErrorToStringHelper(VideoEncodeAccelerator_Error value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncodeAccelerator_Error::ILLEGAL_STATE:
      return "ILLEGAL_STATE";
    case VideoEncodeAccelerator_Error::INVALID_ARGUMENT:
      return "INVALID_ARGUMENT";
    case VideoEncodeAccelerator_Error::PLATFORM_FAILURE:
      return "PLATFORM_FAILURE";
    default:
      return nullptr;
  }
}

std::string VideoEncodeAccelerator_ErrorToString(VideoEncodeAccelerator_Error value) {
  const char *str = VideoEncodeAccelerator_ErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncodeAccelerator_Error value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncodeAccelerator_Error value) {
  return os << VideoEncodeAccelerator_ErrorToString(value);
}

namespace internal {
// static
bool CodecMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CodecMetadata_Data* object = static_cast<const CodecMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CodecMetadata_Tag::H264: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_h264, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_h264, validation_context))
        return false;
      return true;
    }
    case CodecMetadata_Tag::VP8: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_vp8, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_vp8, validation_context))
        return false;
      return true;
    }
    case CodecMetadata_Tag::VP9: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_vp9, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_vp9, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CodecMetadata");
      return false;
    }
  }
}


// static
bool VideoEncodeAcceleratorSupportedProfile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorSupportedProfile_Data* object = static_cast<const VideoEncodeAcceleratorSupportedProfile_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_resolution, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_resolution, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_resolution, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_resolution, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorSupportedProfile_Data::VideoEncodeAcceleratorSupportedProfile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoBitrateAllocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoBitrateAllocation_Data* object = static_cast<const VideoBitrateAllocation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitrates, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams bitrates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bitrates, validation_context,
                                         &bitrates_validate_params)) {
    return false;
  }

  return true;
}

VideoBitrateAllocation_Data::VideoBitrateAllocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpatialLayer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpatialLayer_Data* object = static_cast<const SpatialLayer_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpatialLayer_Data::SpatialLayer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Bitrate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Bitrate_Data* object = static_cast<const Bitrate_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::Bitrate_Mode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

Bitrate_Data::Bitrate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorConfig_Data* object = static_cast<const VideoEncodeAcceleratorConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::VideoPixelFormat_Data
        ::Validate(object->input_format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_visible_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_visible_size, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->output_profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitrate, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitrate, validation_context))
    return false;


  if (!::media::mojom::internal::VideoEncodeAcceleratorConfig_StorageType_Data
        ::Validate(object->storage_type, validation_context))
    return false;


  if (!::media::mojom::internal::VideoEncodeAcceleratorConfig_ContentType_Data
        ::Validate(object->content_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spatial_layers, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams spatial_layers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->spatial_layers, validation_context,
                                         &spatial_layers_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::VideoEncodeAcceleratorConfig_InterLayerPredMode_Data
        ::Validate(object->inter_layer_pred, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorConfig_Data::VideoEncodeAcceleratorConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool H264Metadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const H264Metadata_Data* object = static_cast<const H264Metadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

H264Metadata_Data::H264Metadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Vp8Metadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Vp8Metadata_Data* object = static_cast<const Vp8Metadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Vp8Metadata_Data::Vp8Metadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Vp9Metadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Vp9Metadata_Data* object = static_cast<const Vp9Metadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spatial_layer_resolutions, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams spatial_layer_resolutions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->spatial_layer_resolutions, validation_context,
                                         &spatial_layer_resolutions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->p_diffs, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams p_diffs_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->p_diffs, validation_context,
                                         &p_diffs_validate_params)) {
    return false;
  }

  return true;
}

Vp9Metadata_Data::Vp9Metadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BitstreamBufferMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BitstreamBufferMetadata_Data* object = static_cast<const BitstreamBufferMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->codec_metadata, validation_context))
    return false;

  return true;
}

BitstreamBufferMetadata_Data::BitstreamBufferMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data* object = static_cast<const VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data* object = static_cast<const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* object = static_cast<const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profiles, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams profiles_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->profiles, validation_context,
                                         &profiles_validate_params)) {
    return false;
  }

  return true;
}

VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_Initialize_Params_Data* object = static_cast<const VideoEncodeAccelerator_Initialize_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoEncodeAccelerator_Initialize_Params_Data::VideoEncodeAccelerator_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_Initialize_ResponseParams_Data* object = static_cast<const VideoEncodeAccelerator_Initialize_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAccelerator_Initialize_ResponseParams_Data::VideoEncodeAccelerator_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Encode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_Encode_Params_Data* object = static_cast<const VideoEncodeAccelerator_Encode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_Encode_Params_Data::VideoEncodeAccelerator_Encode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Encode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_Encode_ResponseParams_Data* object = static_cast<const VideoEncodeAccelerator_Encode_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAccelerator_Encode_ResponseParams_Data::VideoEncodeAccelerator_Encode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data* object = static_cast<const VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->buffer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->buffer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data* object = static_cast<const VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitrate_allocation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitrate_allocation, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data* object = static_cast<const VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitrate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitrate, validation_context))
    return false;

  return true;
}

VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_IsFlushSupported_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_IsFlushSupported_Params_Data* object = static_cast<const VideoEncodeAccelerator_IsFlushSupported_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAccelerator_IsFlushSupported_Params_Data::VideoEncodeAccelerator_IsFlushSupported_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* object = static_cast<const VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_Flush_Params_Data* object = static_cast<const VideoEncodeAccelerator_Flush_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAccelerator_Flush_Params_Data::VideoEncodeAccelerator_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAccelerator_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAccelerator_Flush_ResponseParams_Data* object = static_cast<const VideoEncodeAccelerator_Flush_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoEncodeAccelerator_Flush_ResponseParams_Data::VideoEncodeAccelerator_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data* object = static_cast<const VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_coded_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_coded_size, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data* object = static_cast<const VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_NotifyError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorClient_NotifyError_Params_Data* object = static_cast<const VideoEncodeAcceleratorClient_NotifyError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::VideoEncodeAccelerator_Error_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_NotifyError_Params_Data::VideoEncodeAcceleratorClient_NotifyError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data* object = static_cast<const VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::Bitrate_Mode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::Bitrate_Mode value) {
  return std::move(context).WriteString(::media::mojom::Bitrate_ModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorConfig_ContentType value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorConfig_ContentTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorConfig_InterLayerPredMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorConfig_InterLayerPredMode value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorConfig_InterLayerPredModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAcceleratorConfig_StorageType value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAcceleratorConfig_StorageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncodeAccelerator_Error>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncodeAccelerator_Error value) {
  return std::move(context).WriteString(::media::mojom::VideoEncodeAccelerator_ErrorToString(value));
}

} // namespace perfetto
