// media/mojo/mojom/video_encode_accelerator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_encode_accelerator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-params-data.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile()
    : profile(),
      min_resolution(),
      max_resolution(),
      max_framerate_numerator(),
      max_framerate_denominator() {}

VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile(
    ::media::VideoCodecProfile profile_in,
    const ::gfx::Size& min_resolution_in,
    const ::gfx::Size& max_resolution_in,
    uint32_t max_framerate_numerator_in,
    uint32_t max_framerate_denominator_in)
    : profile(std::move(profile_in)),
      min_resolution(std::move(min_resolution_in)),
      max_resolution(std::move(max_resolution_in)),
      max_framerate_numerator(std::move(max_framerate_numerator_in)),
      max_framerate_denominator(std::move(max_framerate_denominator_in)) {}

VideoEncodeAcceleratorSupportedProfile::~VideoEncodeAcceleratorSupportedProfile() = default;

void VideoEncodeAcceleratorSupportedProfile::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_resolution"), this->min_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_resolution"), this->max_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_numerator"), this->max_framerate_numerator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_denominator"), this->max_framerate_denominator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoBitrateAllocation::VideoBitrateAllocation()
    : bitrates() {}

VideoBitrateAllocation::VideoBitrateAllocation(
    std::vector<int32_t> bitrates_in)
    : bitrates(std::move(bitrates_in)) {}

VideoBitrateAllocation::~VideoBitrateAllocation() = default;

void VideoBitrateAllocation::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrates"), this->bitrates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoBitrateAllocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpatialLayer::SpatialLayer()
    : width(),
      height(),
      bitrate_bps(),
      framerate(),
      max_qp(),
      num_of_temporal_layers() {}

SpatialLayer::SpatialLayer(
    int32_t width_in,
    int32_t height_in,
    uint32_t bitrate_bps_in,
    uint32_t framerate_in,
    uint8_t max_qp_in,
    uint8_t num_of_temporal_layers_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      bitrate_bps(std::move(bitrate_bps_in)),
      framerate(std::move(framerate_in)),
      max_qp(std::move(max_qp_in)),
      num_of_temporal_layers(std::move(num_of_temporal_layers_in)) {}

SpatialLayer::~SpatialLayer() = default;

void SpatialLayer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate_bps"), this->bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framerate"), this->framerate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_qp"), this->max_qp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_of_temporal_layers"), this->num_of_temporal_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpatialLayer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Bitrate::Bitrate()
    : mode(Bitrate_Mode::kConstant),
      target(),
      peak(0U) {}

Bitrate::Bitrate(
    Bitrate::Mode mode_in,
    uint32_t target_in,
    uint32_t peak_in)
    : mode(std::move(mode_in)),
      target(std::move(target_in)),
      peak(std::move(peak_in)) {}

Bitrate::~Bitrate() = default;

void Bitrate::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Bitrate::Mode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target"), this->target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "peak"), this->peak,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Bitrate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncodeAcceleratorConfig::VideoEncodeAcceleratorConfig()
    : input_format(),
      input_visible_size(),
      output_profile(),
      bitrate(),
      initial_framerate(),
      has_initial_framerate(),
      gop_length(),
      has_gop_length(),
      h264_output_level(),
      has_h264_output_level(),
      is_constrained_h264(),
      storage_type(),
      has_storage_type(),
      content_type(),
      spatial_layers(),
      inter_layer_pred(),
      require_low_delay() {}

VideoEncodeAcceleratorConfig::VideoEncodeAcceleratorConfig(
    ::media::VideoPixelFormat input_format_in,
    const ::gfx::Size& input_visible_size_in,
    ::media::VideoCodecProfile output_profile_in,
    const ::media::Bitrate& bitrate_in,
    uint32_t initial_framerate_in,
    bool has_initial_framerate_in,
    uint32_t gop_length_in,
    bool has_gop_length_in,
    uint8_t h264_output_level_in,
    bool has_h264_output_level_in,
    bool is_constrained_h264_in,
    VideoEncodeAcceleratorConfig::StorageType storage_type_in,
    bool has_storage_type_in,
    VideoEncodeAcceleratorConfig::ContentType content_type_in,
    std::vector<::media::VideoEncodeAccelerator::Config::SpatialLayer> spatial_layers_in,
    VideoEncodeAcceleratorConfig::InterLayerPredMode inter_layer_pred_in,
    bool require_low_delay_in)
    : input_format(std::move(input_format_in)),
      input_visible_size(std::move(input_visible_size_in)),
      output_profile(std::move(output_profile_in)),
      bitrate(std::move(bitrate_in)),
      initial_framerate(std::move(initial_framerate_in)),
      has_initial_framerate(std::move(has_initial_framerate_in)),
      gop_length(std::move(gop_length_in)),
      has_gop_length(std::move(has_gop_length_in)),
      h264_output_level(std::move(h264_output_level_in)),
      has_h264_output_level(std::move(has_h264_output_level_in)),
      is_constrained_h264(std::move(is_constrained_h264_in)),
      storage_type(std::move(storage_type_in)),
      has_storage_type(std::move(has_storage_type_in)),
      content_type(std::move(content_type_in)),
      spatial_layers(std::move(spatial_layers_in)),
      inter_layer_pred(std::move(inter_layer_pred_in)),
      require_low_delay(std::move(require_low_delay_in)) {}

VideoEncodeAcceleratorConfig::~VideoEncodeAcceleratorConfig() = default;

void VideoEncodeAcceleratorConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_format"), this->input_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_visible_size"), this->input_visible_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_profile"), this->output_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate"), this->bitrate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::Bitrate&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_framerate"), this->initial_framerate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_initial_framerate"), this->has_initial_framerate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gop_length"), this->gop_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_gop_length"), this->has_gop_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "h264_output_level"), this->h264_output_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_h264_output_level"), this->has_h264_output_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_constrained_h264"), this->is_constrained_h264,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_type"), this->storage_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoEncodeAcceleratorConfig::StorageType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_storage_type"), this->has_storage_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_type"), this->content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoEncodeAcceleratorConfig::ContentType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_layers"), this->spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::VideoEncodeAccelerator::Config::SpatialLayer>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inter_layer_pred"), this->inter_layer_pred,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoEncodeAcceleratorConfig::InterLayerPredMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_low_delay"), this->require_low_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncodeAcceleratorConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
H264Metadata::H264Metadata()
    : temporal_idx(),
      layer_sync() {}

H264Metadata::H264Metadata(
    uint8_t temporal_idx_in,
    bool layer_sync_in)
    : temporal_idx(std::move(temporal_idx_in)),
      layer_sync(std::move(layer_sync_in)) {}

H264Metadata::~H264Metadata() = default;
size_t H264Metadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->temporal_idx);
  seed = mojo::internal::Hash(seed, this->layer_sync);
  return seed;
}

void H264Metadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_sync"), this->layer_sync,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool H264Metadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Vp8Metadata::Vp8Metadata()
    : non_reference(),
      temporal_idx(),
      layer_sync() {}

Vp8Metadata::Vp8Metadata(
    bool non_reference_in,
    uint8_t temporal_idx_in,
    bool layer_sync_in)
    : non_reference(std::move(non_reference_in)),
      temporal_idx(std::move(temporal_idx_in)),
      layer_sync(std::move(layer_sync_in)) {}

Vp8Metadata::~Vp8Metadata() = default;

void Vp8Metadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "non_reference"), this->non_reference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_sync"), this->layer_sync,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Vp8Metadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Vp9Metadata::Vp9Metadata()
    : inter_pic_predicted(),
      temporal_up_switch(),
      referenced_by_upper_spatial_layers(),
      reference_lower_spatial_layers(),
      end_of_picture(),
      temporal_idx(),
      spatial_idx(),
      spatial_layer_resolutions(),
      p_diffs() {}

Vp9Metadata::Vp9Metadata(
    bool inter_pic_predicted_in,
    bool temporal_up_switch_in,
    bool referenced_by_upper_spatial_layers_in,
    bool reference_lower_spatial_layers_in,
    bool end_of_picture_in,
    uint8_t temporal_idx_in,
    uint8_t spatial_idx_in,
    std::vector<::gfx::Size> spatial_layer_resolutions_in,
    std::vector<uint8_t> p_diffs_in)
    : inter_pic_predicted(std::move(inter_pic_predicted_in)),
      temporal_up_switch(std::move(temporal_up_switch_in)),
      referenced_by_upper_spatial_layers(std::move(referenced_by_upper_spatial_layers_in)),
      reference_lower_spatial_layers(std::move(reference_lower_spatial_layers_in)),
      end_of_picture(std::move(end_of_picture_in)),
      temporal_idx(std::move(temporal_idx_in)),
      spatial_idx(std::move(spatial_idx_in)),
      spatial_layer_resolutions(std::move(spatial_layer_resolutions_in)),
      p_diffs(std::move(p_diffs_in)) {}

Vp9Metadata::~Vp9Metadata() = default;

void Vp9Metadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inter_pic_predicted"), this->inter_pic_predicted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_up_switch"), this->temporal_up_switch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referenced_by_upper_spatial_layers"), this->referenced_by_upper_spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_lower_spatial_layers"), this->reference_lower_spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_picture"), this->end_of_picture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_idx"), this->spatial_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_layer_resolutions"), this->spatial_layer_resolutions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "p_diffs"), this->p_diffs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Vp9Metadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BitstreamBufferMetadata::BitstreamBufferMetadata()
    : payload_size_bytes(),
      key_frame(),
      timestamp(),
      codec_metadata() {}

BitstreamBufferMetadata::BitstreamBufferMetadata(
    uint32_t payload_size_bytes_in,
    bool key_frame_in,
    ::base::TimeDelta timestamp_in,
    CodecMetadataPtr codec_metadata_in)
    : payload_size_bytes(std::move(payload_size_bytes_in)),
      key_frame(std::move(key_frame_in)),
      timestamp(std::move(timestamp_in)),
      codec_metadata(std::move(codec_metadata_in)) {}

BitstreamBufferMetadata::~BitstreamBufferMetadata() = default;

void BitstreamBufferMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_size_bytes"), this->payload_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_frame"), this->key_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec_metadata"), this->codec_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CodecMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BitstreamBufferMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CodecMetadata::CodecMetadata() : tag_(Tag::H264) {
  data_.h264 = new H264MetadataPtr;
}

CodecMetadata::~CodecMetadata() {
  DestroyActive();
}


void CodecMetadata::set_h264(
    H264MetadataPtr h264) {
  if (tag_ == Tag::H264) {
    *(data_.h264) = std::move(h264);
  } else {
    DestroyActive();
    tag_ = Tag::H264;
    data_.h264 = new H264MetadataPtr(
        std::move(h264));
  }
}
void CodecMetadata::set_vp8(
    const ::media::Vp8Metadata& vp8) {
  if (tag_ == Tag::VP8) {
    *(data_.vp8) = std::move(vp8);
  } else {
    DestroyActive();
    tag_ = Tag::VP8;
    data_.vp8 = new ::media::Vp8Metadata(
        std::move(vp8));
  }
}
void CodecMetadata::set_vp9(
    const ::media::Vp9Metadata& vp9) {
  if (tag_ == Tag::VP9) {
    *(data_.vp9) = std::move(vp9);
  } else {
    DestroyActive();
    tag_ = Tag::VP9;
    data_.vp9 = new ::media::Vp9Metadata(
        std::move(vp9));
  }
}

void CodecMetadata::DestroyActive() {
  switch (tag_) {

    case Tag::H264:

      delete data_.h264;
      break;
    case Tag::VP8:

      delete data_.vp8;
      break;
    case Tag::VP9:

      delete data_.vp9;
      break;
  }
}

bool CodecMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char VideoEncodeAcceleratorProvider::Name_[] = "media.mojom.VideoEncodeAcceleratorProvider";

class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback(
      VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback);
};

VideoEncodeAcceleratorProviderProxy::VideoEncodeAcceleratorProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEncodeAcceleratorProviderProxy::CreateVideoEncodeAccelerator(
    ::mojo::PendingReceiver<VideoEncodeAccelerator> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<VideoEncodeAccelerator>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in VideoEncodeAcceleratorProvider.CreateVideoEncodeAccelerator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("CreateVideoEncodeAccelerator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoEncodeAcceleratorProviderProxy::GetVideoEncodeAcceleratorSupportedProfiles(
    GetVideoEncodeAcceleratorSupportedProfilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("GetVideoEncodeAcceleratorSupportedProfiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder {
 public:
  static VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder> proxy(
        new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>& in_profiles);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder);
};

bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::media::VideoEncodeAccelerator::SupportedProfile> p_profiles{};
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProfiles(&p_profiles))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAcceleratorProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_profiles));
  return true;
}

void VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder::Run(
    const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>& in_profiles) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profiles"), in_profiles,
                        "<value of type const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profiles)::BaseType>
      profiles_fragment(params.message());
  const mojo::internal::ContainerValidateParams profiles_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView>>(
      in_profiles, profiles_fragment, &profiles_validate_params);
  params->profiles.Set(
      profiles_fragment.is_null() ? nullptr : profiles_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->profiles.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null profiles in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("GetVideoEncodeAcceleratorSupportedProfiles");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoEncodeAcceleratorProviderStubDispatch::Accept(
    VideoEncodeAcceleratorProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<VideoEncodeAccelerator> p_receiver{};
      VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAccelerator(
std::move(p_receiver));
      return true;
    }
    case internal::kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name: {
      break;
    }
  }
  return false;
}

// static
bool VideoEncodeAcceleratorProviderStubDispatch::AcceptWithResponder(
    VideoEncodeAcceleratorProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name: {
      break;
    }
    case internal::kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorProvider::Name_, 1, false);
        return false;
      }
      VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback callback =
          VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoEncodeAcceleratorSupportedProfiles(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoEncodeAcceleratorProviderValidationInfo[] = {
    {internal::kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name,
     {&internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name,
     {&internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data::Validate,
      &internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data::Validate}},
};

bool VideoEncodeAcceleratorProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoEncodeAcceleratorProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoEncodeAcceleratorProviderValidationInfo);
}

bool VideoEncodeAcceleratorProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoEncodeAcceleratorProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoEncodeAcceleratorProviderValidationInfo);

}
const char VideoEncodeAccelerator::Name_[] = "media.mojom.VideoEncodeAccelerator";
bool VideoEncodeAccelerator::Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> client, bool* out_result) {
  NOTREACHED();
  return false;
}
bool VideoEncodeAccelerator::IsFlushSupported(bool* out_result) {
  NOTREACHED();
  return false;
}
class VideoEncodeAccelerator_Initialize_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Initialize_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Initialize_HandleSyncResponse);
};

class VideoEncodeAccelerator_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Initialize_ForwardToCallback(
      VideoEncodeAccelerator::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::InitializeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Initialize_ForwardToCallback);
};

class VideoEncodeAccelerator_Encode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Encode_ForwardToCallback(
      VideoEncodeAccelerator::EncodeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::EncodeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Encode_ForwardToCallback);
};
class VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse);
};

class VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback(
      VideoEncodeAccelerator::IsFlushSupportedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::IsFlushSupportedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback);
};

class VideoEncodeAccelerator_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Flush_ForwardToCallback(
      VideoEncodeAccelerator::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Flush_ForwardToCallback);
};

VideoEncodeAcceleratorProxy::VideoEncodeAcceleratorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool VideoEncodeAcceleratorProxy::Initialize(
    const ::media::VideoEncodeAccelerator::Config& param_config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> param_client, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "media::mojom::VideoEncodeAccelerator::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), param_config,
                        "<value of type const ::media::VideoEncodeAccelerator::Config&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), param_client,
                        "<value of type ::mojo::PendingRemote<VideoEncodeAcceleratorClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfigDataView>(
      param_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in VideoEncodeAccelerator.Initialize request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::VideoEncodeAcceleratorClientInterfaceBase>>(
      param_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in VideoEncodeAccelerator.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Initialize");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Initialize_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "media::mojom::VideoEncodeAccelerator::Initialize", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void VideoEncodeAcceleratorProxy::Initialize(
    const ::media::VideoEncodeAccelerator::Config& in_config, ::mojo::PendingRemote<VideoEncodeAcceleratorClient> in_client, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAccelerator::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::VideoEncodeAccelerator::Config&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<VideoEncodeAcceleratorClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in VideoEncodeAccelerator.Initialize request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::VideoEncodeAcceleratorClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in VideoEncodeAccelerator.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Initialize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoEncodeAcceleratorProxy::Encode(
    const ::scoped_refptr<::media::VideoFrame>& in_frame, bool in_force_keyframe, EncodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAccelerator::Encode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type const ::scoped_refptr<::media::VideoFrame>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_keyframe"), in_force_keyframe,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Encode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Encode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in VideoEncodeAccelerator.Encode request");
  params->force_keyframe = in_force_keyframe;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Encode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Encode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoEncodeAcceleratorProxy::UseOutputBitstreamBuffer(
    int32_t in_bitstream_buffer_id, ::mojo::ScopedSharedBufferHandle in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitstream_buffer_id"), in_bitstream_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::mojo::ScopedSharedBufferHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->bitstream_buffer_id = in_bitstream_buffer_id;
  mojo::internal::Serialize<mojo::ScopedSharedBufferHandle>(
      in_buffer, &params->buffer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->buffer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid buffer in VideoEncodeAccelerator.UseOutputBitstreamBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("UseOutputBitstreamBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoEncodeAcceleratorProxy::RequestEncodingParametersChangeWithLayers(
    const ::media::VideoBitrateAllocation& in_bitrate_allocation, uint32_t in_framerate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitrate_allocation"), in_bitrate_allocation,
                        "<value of type const ::media::VideoBitrateAllocation&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("framerate"), in_framerate,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitrate_allocation)::BaseType> bitrate_allocation_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoBitrateAllocationDataView>(
      in_bitrate_allocation, bitrate_allocation_fragment);
  params->bitrate_allocation.Set(
      bitrate_allocation_fragment.is_null() ? nullptr : bitrate_allocation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bitrate_allocation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitrate_allocation in VideoEncodeAccelerator.RequestEncodingParametersChangeWithLayers request");
  params->framerate = in_framerate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("RequestEncodingParametersChangeWithLayers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoEncodeAcceleratorProxy::RequestEncodingParametersChangeWithBitrate(
    const ::media::Bitrate& in_bitrate, uint32_t in_framerate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitrate"), in_bitrate,
                        "<value of type const ::media::Bitrate&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("framerate"), in_framerate,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitrate)::BaseType> bitrate_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::BitrateDataView>(
      in_bitrate, bitrate_fragment);
  params->bitrate.Set(
      bitrate_fragment.is_null() ? nullptr : bitrate_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bitrate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitrate in VideoEncodeAccelerator.RequestEncodingParametersChangeWithBitrate request");
  params->framerate = in_framerate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("RequestEncodingParametersChangeWithBitrate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool VideoEncodeAcceleratorProxy::IsFlushSupported(
    bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "media::mojom::VideoEncodeAccelerator::IsFlushSupported");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_IsFlushSupported_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("IsFlushSupported");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "media::mojom::VideoEncodeAccelerator::IsFlushSupported", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void VideoEncodeAcceleratorProxy::IsFlushSupported(
    IsFlushSupportedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::VideoEncodeAccelerator::IsFlushSupported");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_IsFlushSupported_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("IsFlushSupported");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoEncodeAcceleratorProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::VideoEncodeAccelerator::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VideoEncodeAccelerator_Initialize_ProxyToResponder {
 public:
  static VideoEncodeAccelerator::InitializeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoEncodeAccelerator_Initialize_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_Initialize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoEncodeAccelerator_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoEncodeAccelerator_Initialize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoEncodeAccelerator::InitializeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Initialize_ProxyToResponder);
};

bool VideoEncodeAccelerator_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoEncodeAccelerator::InitializeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void VideoEncodeAccelerator_Initialize_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoEncodeAccelerator::InitializeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoEncodeAccelerator::InitializeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VideoEncodeAccelerator_Initialize_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data* params =
      reinterpret_cast<internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class VideoEncodeAccelerator_Encode_ProxyToResponder {
 public:
  static VideoEncodeAccelerator::EncodeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoEncodeAccelerator_Encode_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_Encode_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoEncodeAccelerator_Encode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_Encode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoEncodeAccelerator_Encode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoEncodeAccelerator::EncodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Encode_ProxyToResponder);
};

bool VideoEncodeAccelerator_Encode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoEncodeAccelerator::EncodeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Encode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_Encode_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VideoEncodeAccelerator_Encode_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VideoEncodeAccelerator_Encode_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media::mojom::VideoEncodeAccelerator::EncodeCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Encode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Encode_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoEncodeAccelerator::EncodeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Encode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder {
 public:
  static VideoEncodeAccelerator::IsFlushSupportedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoEncodeAccelerator::IsFlushSupportedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder);
};

bool VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoEncodeAccelerator::IsFlushSupportedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoEncodeAccelerator::IsFlushSupportedCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_IsFlushSupported_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoEncodeAccelerator::IsFlushSupportedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("IsFlushSupported");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* params =
      reinterpret_cast<internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 5, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class VideoEncodeAccelerator_Flush_ProxyToResponder {
 public:
  static VideoEncodeAccelerator::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoEncodeAccelerator_Flush_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoEncodeAccelerator_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoEncodeAccelerator_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoEncodeAccelerator::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoEncodeAccelerator_Flush_ProxyToResponder);
};

bool VideoEncodeAccelerator_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoEncodeAccelerator::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void VideoEncodeAccelerator_Flush_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoEncodeAccelerator::FlushCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAccelerator_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoEncodeAccelerator::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoEncodeAcceleratorStubDispatch::Accept(
    VideoEncodeAccelerator* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoEncodeAccelerator_Initialize_Name: {
      break;
    }
    case internal::kVideoEncodeAccelerator_Encode_Name: {
      break;
    }
    case internal::kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_bitstream_buffer_id{};
      ::mojo::ScopedSharedBufferHandle p_buffer{};
      VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bitstream_buffer_id = input_data_view.bitstream_buffer_id();
      if (success)
        p_buffer = input_data_view.TakeBuffer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UseOutputBitstreamBuffer(
std::move(p_bitstream_buffer_id), 
std::move(p_buffer));
      return true;
    }
    case internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoBitrateAllocation p_bitrate_allocation{};
      uint32_t p_framerate{};
      VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBitrateAllocation(&p_bitrate_allocation))
        success = false;
      if (success)
        p_framerate = input_data_view.framerate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestEncodingParametersChangeWithLayers(
std::move(p_bitrate_allocation), 
std::move(p_framerate));
      return true;
    }
    case internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::Bitrate p_bitrate{};
      uint32_t p_framerate{};
      VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBitrate(&p_bitrate))
        success = false;
      if (success)
        p_framerate = input_data_view.framerate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestEncodingParametersChangeWithBitrate(
std::move(p_bitrate), 
std::move(p_framerate));
      return true;
    }
    case internal::kVideoEncodeAccelerator_IsFlushSupported_Name: {
      break;
    }
    case internal::kVideoEncodeAccelerator_Flush_Name: {
      break;
    }
  }
  return false;
}

// static
bool VideoEncodeAcceleratorStubDispatch::AcceptWithResponder(
    VideoEncodeAccelerator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoEncodeAccelerator_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoEncodeAccelerator_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_Initialize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::VideoEncodeAccelerator::Config p_config{};
      ::mojo::PendingRemote<VideoEncodeAcceleratorClient> p_client{};
      VideoEncodeAccelerator_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 0, false);
        return false;
      }
      VideoEncodeAccelerator::InitializeCallback callback =
          VideoEncodeAccelerator_Initialize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_config), 
std::move(p_client), std::move(callback));
      return true;
    }
    case internal::kVideoEncodeAccelerator_Encode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::Encode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::Encode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoEncodeAccelerator_Encode_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_Encode_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<::media::VideoFrame> p_frame{};
      bool p_force_keyframe{};
      VideoEncodeAccelerator_Encode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success)
        p_force_keyframe = input_data_view.force_keyframe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 1, false);
        return false;
      }
      VideoEncodeAccelerator::EncodeCallback callback =
          VideoEncodeAccelerator_Encode_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Encode(
std::move(p_frame), 
std::move(p_force_keyframe), std::move(callback));
      return true;
    }
    case internal::kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name: {
      break;
    }
    case internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name: {
      break;
    }
    case internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name: {
      break;
    }
    case internal::kVideoEncodeAccelerator_IsFlushSupported_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::IsFlushSupported",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::IsFlushSupported");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoEncodeAccelerator_IsFlushSupported_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 5, false);
        return false;
      }
      VideoEncodeAccelerator::IsFlushSupportedCallback callback =
          VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsFlushSupported(std::move(callback));
      return true;
    }
    case internal::kVideoEncodeAccelerator_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAccelerator::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAccelerator::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoEncodeAccelerator_Flush_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoEncodeAccelerator_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 6, false);
        return false;
      }
      VideoEncodeAccelerator::FlushCallback callback =
          VideoEncodeAccelerator_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoEncodeAcceleratorValidationInfo[] = {
    {internal::kVideoEncodeAccelerator_Initialize_Name,
     {&internal::VideoEncodeAccelerator_Initialize_Params_Data::Validate,
      &internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data::Validate}},
    {internal::kVideoEncodeAccelerator_Encode_Name,
     {&internal::VideoEncodeAccelerator_Encode_Params_Data::Validate,
      &internal::VideoEncodeAccelerator_Encode_ResponseParams_Data::Validate}},
    {internal::kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name,
     {&internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name,
     {&internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name,
     {&internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAccelerator_IsFlushSupported_Name,
     {&internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data::Validate,
      &internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data::Validate}},
    {internal::kVideoEncodeAccelerator_Flush_Name,
     {&internal::VideoEncodeAccelerator_Flush_Params_Data::Validate,
      &internal::VideoEncodeAccelerator_Flush_ResponseParams_Data::Validate}},
};

bool VideoEncodeAcceleratorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoEncodeAccelerator::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoEncodeAcceleratorValidationInfo);
}

bool VideoEncodeAcceleratorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoEncodeAccelerator::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoEncodeAcceleratorValidationInfo);

}
const char VideoEncodeAcceleratorClient::Name_[] = "media.mojom.VideoEncodeAcceleratorClient";

VideoEncodeAcceleratorClientProxy::VideoEncodeAcceleratorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEncodeAcceleratorClientProxy::RequireBitstreamBuffers(
    uint32_t in_input_count, const ::gfx::Size& in_input_coded_size, uint32_t in_output_buffer_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_count"), in_input_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_coded_size"), in_input_coded_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_buffer_size"), in_output_buffer_size,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data> params(
          message);
  params.Allocate();
  params->input_count = in_input_count;
  mojo::internal::MessageFragment<
      typename decltype(params->input_coded_size)::BaseType> input_coded_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_input_coded_size, input_coded_size_fragment);
  params->input_coded_size.Set(
      input_coded_size_fragment.is_null() ? nullptr : input_coded_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input_coded_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_coded_size in VideoEncodeAcceleratorClient.RequireBitstreamBuffers request");
  params->output_buffer_size = in_output_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("RequireBitstreamBuffers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoEncodeAcceleratorClientProxy::BitstreamBufferReady(
    int32_t in_bitstream_buffer_id, const ::media::BitstreamBufferMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitstream_buffer_id"), in_bitstream_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::media::BitstreamBufferMetadata&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data> params(
          message);
  params.Allocate();
  params->bitstream_buffer_id = in_bitstream_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::BitstreamBufferMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in VideoEncodeAcceleratorClient.BitstreamBufferReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("BitstreamBufferReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoEncodeAcceleratorClientProxy::NotifyError(
    ::media::VideoEncodeAccelerator::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAcceleratorClient::NotifyError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::media::VideoEncodeAccelerator::Error>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorClient_NotifyError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_NotifyError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoEncodeAccelerator_Error>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("NotifyError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoEncodeAcceleratorClientProxy::NotifyEncoderInfoChange(
    const ::media::VideoEncoderInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::media::VideoEncoderInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoEncoderInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in VideoEncodeAcceleratorClient.NotifyEncoderInfoChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("NotifyEncoderInfoChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoEncodeAcceleratorClientStubDispatch::Accept(
    VideoEncodeAcceleratorClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_input_count{};
      ::gfx::Size p_input_coded_size{};
      uint32_t p_output_buffer_size{};
      VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_input_count = input_data_view.input_count();
      if (success && !input_data_view.ReadInputCodedSize(&p_input_coded_size))
        success = false;
      if (success)
        p_output_buffer_size = input_data_view.output_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequireBitstreamBuffers(
std::move(p_input_count), 
std::move(p_input_coded_size), 
std::move(p_output_buffer_size));
      return true;
    }
    case internal::kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_bitstream_buffer_id{};
      ::media::BitstreamBufferMetadata p_metadata{};
      VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bitstream_buffer_id = input_data_view.bitstream_buffer_id();
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BitstreamBufferReady(
std::move(p_bitstream_buffer_id), 
std::move(p_metadata));
      return true;
    }
    case internal::kVideoEncodeAcceleratorClient_NotifyError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAcceleratorClient::NotifyError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAcceleratorClient::NotifyError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_NotifyError_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_NotifyError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoEncodeAccelerator::Error p_error{};
      VideoEncodeAcceleratorClient_NotifyError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyError(
std::move(p_error));
      return true;
    }
    case internal::kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoEncoderInfo p_info{};
      VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyEncoderInfoChange(
std::move(p_info));
      return true;
    }
  }
  return false;
}

// static
bool VideoEncodeAcceleratorClientStubDispatch::AcceptWithResponder(
    VideoEncodeAcceleratorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name: {
      break;
    }
    case internal::kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name: {
      break;
    }
    case internal::kVideoEncodeAcceleratorClient_NotifyError_Name: {
      break;
    }
    case internal::kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoEncodeAcceleratorClientValidationInfo[] = {
    {internal::kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name,
     {&internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name,
     {&internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAcceleratorClient_NotifyError_Name,
     {&internal::VideoEncodeAcceleratorClient_NotifyError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name,
     {&internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoEncodeAcceleratorClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoEncodeAcceleratorClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoEncodeAcceleratorClientValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfile::DataView, ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr>::Read(
    ::media::mojom::VideoEncodeAcceleratorSupportedProfile::DataView input,
    ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr result(::media::mojom::VideoEncodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadMinResolution(&result->min_resolution))
        success = false;
      if (success && !input.ReadMaxResolution(&result->max_resolution))
        success = false;
      if (success)
        result->max_framerate_numerator = input.max_framerate_numerator();
      if (success)
        result->max_framerate_denominator = input.max_framerate_denominator();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoBitrateAllocation::DataView, ::media::mojom::VideoBitrateAllocationPtr>::Read(
    ::media::mojom::VideoBitrateAllocation::DataView input,
    ::media::mojom::VideoBitrateAllocationPtr* output) {
  bool success = true;
  ::media::mojom::VideoBitrateAllocationPtr result(::media::mojom::VideoBitrateAllocation::New());
  
      if (success && !input.ReadBitrates(&result->bitrates))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SpatialLayer::DataView, ::media::mojom::SpatialLayerPtr>::Read(
    ::media::mojom::SpatialLayer::DataView input,
    ::media::mojom::SpatialLayerPtr* output) {
  bool success = true;
  ::media::mojom::SpatialLayerPtr result(::media::mojom::SpatialLayer::New());
  
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success)
        result->bitrate_bps = input.bitrate_bps();
      if (success)
        result->framerate = input.framerate();
      if (success)
        result->max_qp = input.max_qp();
      if (success)
        result->num_of_temporal_layers = input.num_of_temporal_layers();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Bitrate::DataView, ::media::mojom::BitratePtr>::Read(
    ::media::mojom::Bitrate::DataView input,
    ::media::mojom::BitratePtr* output) {
  bool success = true;
  ::media::mojom::BitratePtr result(::media::mojom::Bitrate::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->target = input.target();
      if (success)
        result->peak = input.peak();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoEncodeAcceleratorConfig::DataView, ::media::mojom::VideoEncodeAcceleratorConfigPtr>::Read(
    ::media::mojom::VideoEncodeAcceleratorConfig::DataView input,
    ::media::mojom::VideoEncodeAcceleratorConfigPtr* output) {
  bool success = true;
  ::media::mojom::VideoEncodeAcceleratorConfigPtr result(::media::mojom::VideoEncodeAcceleratorConfig::New());
  
      if (success && !input.ReadInputFormat(&result->input_format))
        success = false;
      if (success && !input.ReadInputVisibleSize(&result->input_visible_size))
        success = false;
      if (success && !input.ReadOutputProfile(&result->output_profile))
        success = false;
      if (success && !input.ReadBitrate(&result->bitrate))
        success = false;
      if (success)
        result->initial_framerate = input.initial_framerate();
      if (success)
        result->has_initial_framerate = input.has_initial_framerate();
      if (success)
        result->gop_length = input.gop_length();
      if (success)
        result->has_gop_length = input.has_gop_length();
      if (success)
        result->h264_output_level = input.h264_output_level();
      if (success)
        result->has_h264_output_level = input.has_h264_output_level();
      if (success)
        result->is_constrained_h264 = input.is_constrained_h264();
      if (success && !input.ReadStorageType(&result->storage_type))
        success = false;
      if (success)
        result->has_storage_type = input.has_storage_type();
      if (success && !input.ReadContentType(&result->content_type))
        success = false;
      if (success && !input.ReadSpatialLayers(&result->spatial_layers))
        success = false;
      if (success && !input.ReadInterLayerPred(&result->inter_layer_pred))
        success = false;
      if (success)
        result->require_low_delay = input.require_low_delay();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::H264Metadata::DataView, ::media::mojom::H264MetadataPtr>::Read(
    ::media::mojom::H264Metadata::DataView input,
    ::media::mojom::H264MetadataPtr* output) {
  bool success = true;
  ::media::mojom::H264MetadataPtr result(::media::mojom::H264Metadata::New());
  
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->layer_sync = input.layer_sync();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Vp8Metadata::DataView, ::media::mojom::Vp8MetadataPtr>::Read(
    ::media::mojom::Vp8Metadata::DataView input,
    ::media::mojom::Vp8MetadataPtr* output) {
  bool success = true;
  ::media::mojom::Vp8MetadataPtr result(::media::mojom::Vp8Metadata::New());
  
      if (success)
        result->non_reference = input.non_reference();
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->layer_sync = input.layer_sync();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Vp9Metadata::DataView, ::media::mojom::Vp9MetadataPtr>::Read(
    ::media::mojom::Vp9Metadata::DataView input,
    ::media::mojom::Vp9MetadataPtr* output) {
  bool success = true;
  ::media::mojom::Vp9MetadataPtr result(::media::mojom::Vp9Metadata::New());
  
      if (success)
        result->inter_pic_predicted = input.inter_pic_predicted();
      if (success)
        result->temporal_up_switch = input.temporal_up_switch();
      if (success)
        result->referenced_by_upper_spatial_layers = input.referenced_by_upper_spatial_layers();
      if (success)
        result->reference_lower_spatial_layers = input.reference_lower_spatial_layers();
      if (success)
        result->end_of_picture = input.end_of_picture();
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->spatial_idx = input.spatial_idx();
      if (success && !input.ReadSpatialLayerResolutions(&result->spatial_layer_resolutions))
        success = false;
      if (success && !input.ReadPDiffs(&result->p_diffs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::BitstreamBufferMetadata::DataView, ::media::mojom::BitstreamBufferMetadataPtr>::Read(
    ::media::mojom::BitstreamBufferMetadata::DataView input,
    ::media::mojom::BitstreamBufferMetadataPtr* output) {
  bool success = true;
  ::media::mojom::BitstreamBufferMetadataPtr result(::media::mojom::BitstreamBufferMetadata::New());
  
      if (success)
        result->payload_size_bytes = input.payload_size_bytes();
      if (success)
        result->key_frame = input.key_frame();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadCodecMetadata(&result->codec_metadata))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::CodecMetadata::DataView, ::media::mojom::CodecMetadataPtr>::Read(
    ::media::mojom::CodecMetadata::DataView input,
    ::media::mojom::CodecMetadataPtr* output) {
  using UnionType = ::media::mojom::CodecMetadata;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::H264: {
      ::media::mojom::H264MetadataPtr result_h264;
      if (!input.ReadH264(&result_h264))
        return false;

      *output = UnionType::NewH264(
          std::move(result_h264));
      break;
    }
    case Tag::VP8: {
      ::media::Vp8Metadata result_vp8;
      if (!input.ReadVp8(&result_vp8))
        return false;

      *output = UnionType::NewVp8(
          std::move(result_vp8));
      break;
    }
    case Tag::VP9: {
      ::media::Vp9Metadata result_vp9;
      if (!input.ReadVp9(&result_vp9))
        return false;

      *output = UnionType::NewVp9(
          std::move(result_vp9));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif