// mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-params-data.h"
namespace mojo {
namespace pipe_control {

namespace internal {
// static
bool RunOrClosePipeInput_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RunOrClosePipeInput_Data* object = static_cast<const RunOrClosePipeInput_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RunOrClosePipeInput_Tag::PEER_ASSOCIATED_ENDPOINT_CLOSED_EVENT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_peer_associated_endpoint_closed_event, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_peer_associated_endpoint_closed_event, validation_context))
        return false;
      return true;
    }
    case RunOrClosePipeInput_Tag::PAUSE_UNTIL_FLUSH_COMPLETES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pause_until_flush_completes, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pause_until_flush_completes, validation_context))
        return false;
      return true;
    }
    case RunOrClosePipeInput_Tag::FLUSH_ASYNC: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_flush_async, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_flush_async, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RunOrClosePipeInput");
      return false;
    }
  }
}


// static
bool RunOrClosePipeMessageParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RunOrClosePipeMessageParams_Data* object = static_cast<const RunOrClosePipeMessageParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->input, validation_context))
    return false;

  return true;
}

RunOrClosePipeMessageParams_Data::RunOrClosePipeMessageParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DisconnectReason_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DisconnectReason_Data* object = static_cast<const DisconnectReason_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

DisconnectReason_Data::DisconnectReason_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PeerAssociatedEndpointClosedEvent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PeerAssociatedEndpointClosedEvent_Data* object = static_cast<const PeerAssociatedEndpointClosedEvent_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->disconnect_reason, validation_context))
    return false;

  return true;
}

PeerAssociatedEndpointClosedEvent_Data::PeerAssociatedEndpointClosedEvent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PauseUntilFlushCompletes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PauseUntilFlushCompletes_Data* object = static_cast<const PauseUntilFlushCompletes_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->flush_pipe, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->flush_pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PauseUntilFlushCompletes_Data::PauseUntilFlushCompletes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FlushAsync_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FlushAsync_Data* object = static_cast<const FlushAsync_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->flusher_pipe, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->flusher_pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FlushAsync_Data::FlushAsync_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace pipe_control
}  // namespace mojo
