// mojo/public/mojom/base/thread_priority.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/thread_priority.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/thread_priority.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

static NOINLINE const char* ThreadPriorityToStringHelper(ThreadPriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ThreadPriority::BACKGROUND:
      return "BACKGROUND";
    case ThreadPriority::NORMAL:
      return "NORMAL";
    case ThreadPriority::DISPLAY:
      return "DISPLAY";
    case ThreadPriority::REALTIME_AUDIO:
      return "REALTIME_AUDIO";
    default:
      return nullptr;
  }
}

std::string ThreadPriorityToString(ThreadPriority value) {
  const char *str = ThreadPriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ThreadPriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ThreadPriority value) {
  return os << ThreadPriorityToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base

namespace perfetto {

// static
void TraceFormatTraits<::mojo_base::mojom::ThreadPriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojo_base::mojom::ThreadPriority value) {
  return std::move(context).WriteString(::mojo_base::mojom::ThreadPriorityToString(value));
}

} // namespace perfetto
