// services/data_decoder/public/mojom/image_decoder.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/data_decoder/public/mojom/image_decoder.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_JUMBO_H_
#endif


namespace data_decoder {
namespace mojom {


void ImageDecoderInterceptorForTesting::DecodeImage(::mojo_base::BigBuffer encoded_data, ImageCodec codec, bool shrink_to_fit, int64_t max_size_in_bytes, const ::gfx::Size& desired_image_frame_size, DecodeImageCallback callback) {
  GetForwardingInterface()->DecodeImage(std::move(encoded_data), std::move(codec), std::move(shrink_to_fit), std::move(max_size_in_bytes), std::move(desired_image_frame_size), std::move(callback));
}
void ImageDecoderInterceptorForTesting::DecodeAnimation(::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes, DecodeAnimationCallback callback) {
  GetForwardingInterface()->DecodeAnimation(std::move(encoded_data), std::move(shrink_to_fit), std::move(max_size_in_bytes), std::move(callback));
}
ImageDecoderAsyncWaiter::ImageDecoderAsyncWaiter(
    ImageDecoder* proxy) : proxy_(proxy) {}

ImageDecoderAsyncWaiter::~ImageDecoderAsyncWaiter() = default;

void ImageDecoderAsyncWaiter::DecodeImage(
    ::mojo_base::BigBuffer encoded_data, ImageCodec codec, bool shrink_to_fit, int64_t max_size_in_bytes, const ::gfx::Size& desired_image_frame_size, ::SkBitmap* out_decoded_image) {
  base::RunLoop loop;
  proxy_->DecodeImage(std::move(encoded_data),std::move(codec),std::move(shrink_to_fit),std::move(max_size_in_bytes),std::move(desired_image_frame_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::SkBitmap* out_decoded_image
,
             const ::SkBitmap& decoded_image) {*out_decoded_image = std::move(decoded_image);
            loop->Quit();
          },
          &loop,
          out_decoded_image));
  loop.Run();
}
void ImageDecoderAsyncWaiter::DecodeAnimation(
    ::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes, std::vector<AnimationFramePtr>* out_decoded_image) {
  base::RunLoop loop;
  proxy_->DecodeAnimation(std::move(encoded_data),std::move(shrink_to_fit),std::move(max_size_in_bytes),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AnimationFramePtr>* out_decoded_image
,
             std::vector<AnimationFramePtr> decoded_image) {*out_decoded_image = std::move(decoded_image);
            loop->Quit();
          },
          &loop,
          out_decoded_image));
  loop.Run();
}





}  // namespace mojom
}  // namespace data_decoder

#if defined(__clang__)
#pragma clang diagnostic pop
#endif