// services/data_decoder/public/mojom/image_decoder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/image_decoder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-params-data.h"
#include "services/data_decoder/public/mojom/image_decoder.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-import-headers.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_JUMBO_H_
#endif
namespace data_decoder {
namespace mojom {
AnimationFrame::AnimationFrame()
    : bitmap(),
      duration() {}

AnimationFrame::AnimationFrame(
    const ::SkBitmap& bitmap_in,
    ::base::TimeDelta duration_in)
    : bitmap(std::move(bitmap_in)),
      duration(std::move(duration_in)) {}

AnimationFrame::~AnimationFrame() = default;

void AnimationFrame::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitmap"), this->bitmap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkBitmap&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ImageDecoder::Name_[] = "data_decoder.mojom.ImageDecoder";

class ImageDecoder_DecodeImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDecoder_DecodeImage_ForwardToCallback(
      ImageDecoder::DecodeImageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ImageDecoder::DecodeImageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ImageDecoder_DecodeImage_ForwardToCallback);
};

class ImageDecoder_DecodeAnimation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDecoder_DecodeAnimation_ForwardToCallback(
      ImageDecoder::DecodeAnimationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ImageDecoder::DecodeAnimationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ImageDecoder_DecodeAnimation_ForwardToCallback);
};

ImageDecoderProxy::ImageDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageDecoderProxy::DecodeImage(
    ::mojo_base::BigBuffer in_encoded_data, ImageCodec in_codec, bool in_shrink_to_fit, int64_t in_max_size_in_bytes, const ::gfx::Size& in_desired_image_frame_size, DecodeImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::ImageDecoder::DecodeImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoded_data"), in_encoded_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("codec"), in_codec,
                        "<value of type ImageCodec>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shrink_to_fit"), in_shrink_to_fit,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size_in_bytes"), in_max_size_in_bytes,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_image_frame_size"), in_desired_image_frame_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kImageDecoder_DecodeImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->encoded_data)>
      encoded_data_fragment(params.message());
  encoded_data_fragment.Claim(&params->encoded_data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_encoded_data, encoded_data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encoded_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encoded_data in ImageDecoder.DecodeImage request");
  mojo::internal::Serialize<::data_decoder::mojom::ImageCodec>(
      in_codec, &params->codec);
  params->shrink_to_fit = in_shrink_to_fit;
  params->max_size_in_bytes = in_max_size_in_bytes;
  mojo::internal::MessageFragment<
      typename decltype(params->desired_image_frame_size)::BaseType> desired_image_frame_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_desired_image_frame_size, desired_image_frame_size_fragment);
  params->desired_image_frame_size.Set(
      desired_image_frame_size_fragment.is_null() ? nullptr : desired_image_frame_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->desired_image_frame_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null desired_image_frame_size in ImageDecoder.DecodeImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDecoder_DecodeImage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ImageDecoderProxy::DecodeAnimation(
    ::mojo_base::BigBuffer in_encoded_data, bool in_shrink_to_fit, int64_t in_max_size_in_bytes, DecodeAnimationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::ImageDecoder::DecodeAnimation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoded_data"), in_encoded_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shrink_to_fit"), in_shrink_to_fit,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size_in_bytes"), in_max_size_in_bytes,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kImageDecoder_DecodeAnimation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeAnimation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->encoded_data)>
      encoded_data_fragment(params.message());
  encoded_data_fragment.Claim(&params->encoded_data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_encoded_data, encoded_data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encoded_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encoded_data in ImageDecoder.DecodeAnimation request");
  params->shrink_to_fit = in_shrink_to_fit;
  params->max_size_in_bytes = in_max_size_in_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeAnimation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDecoder_DecodeAnimation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ImageDecoder_DecodeImage_ProxyToResponder {
 public:
  static ImageDecoder::DecodeImageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ImageDecoder_DecodeImage_ProxyToResponder> proxy(
        new ImageDecoder_DecodeImage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ImageDecoder_DecodeImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDecoder_DecodeImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ImageDecoder_DecodeImage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ImageDecoder::DecodeImageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_decoded_image);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ImageDecoder_DecodeImage_ProxyToResponder);
};

bool ImageDecoder_DecodeImage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::ImageDecoder::DecodeImageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ImageDecoder_DecodeImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDecoder_DecodeImage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::SkBitmap p_decoded_image{};
  ImageDecoder_DecodeImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDecodedImage(&p_decoded_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_decoded_image));
  return true;
}

void ImageDecoder_DecodeImage_ProxyToResponder::Run(
    const ::SkBitmap& in_decoded_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::ImageDecoder::DecodeImageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoded_image"), in_decoded_image,
                        "<value of type const ::SkBitmap&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kImageDecoder_DecodeImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeImage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decoded_image)::BaseType> decoded_image_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_decoded_image, decoded_image_fragment);
  params->decoded_image.Set(
      decoded_image_fragment.is_null() ? nullptr : decoded_image_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::ImageDecoder::DecodeImageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeImage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImageDecoder_DecodeAnimation_ProxyToResponder {
 public:
  static ImageDecoder::DecodeAnimationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ImageDecoder_DecodeAnimation_ProxyToResponder> proxy(
        new ImageDecoder_DecodeAnimation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ImageDecoder_DecodeAnimation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDecoder_DecodeAnimation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ImageDecoder_DecodeAnimation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ImageDecoder::DecodeAnimationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AnimationFramePtr> in_decoded_image);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ImageDecoder_DecodeAnimation_ProxyToResponder);
};

bool ImageDecoder_DecodeAnimation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::ImageDecoder::DecodeAnimationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ImageDecoder_DecodeAnimation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDecoder_DecodeAnimation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<AnimationFramePtr> p_decoded_image{};
  ImageDecoder_DecodeAnimation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDecodedImage(&p_decoded_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDecoder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_decoded_image));
  return true;
}

void ImageDecoder_DecodeAnimation_ProxyToResponder::Run(
    std::vector<AnimationFramePtr> in_decoded_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::ImageDecoder::DecodeAnimationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoded_image"), in_decoded_image,
                        "<value of type std::vector<AnimationFramePtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kImageDecoder_DecodeAnimation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeAnimation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decoded_image)::BaseType>
      decoded_image_fragment(params.message());
  const mojo::internal::ContainerValidateParams decoded_image_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::data_decoder::mojom::AnimationFrameDataView>>(
      in_decoded_image, decoded_image_fragment, &decoded_image_validate_params);
  params->decoded_image.Set(
      decoded_image_fragment.is_null() ? nullptr : decoded_image_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->decoded_image.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null decoded_image in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::ImageDecoder::DecodeAnimationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeAnimation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImageDecoderStubDispatch::Accept(
    ImageDecoder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kImageDecoder_DecodeImage_Name: {
      break;
    }
    case internal::kImageDecoder_DecodeAnimation_Name: {
      break;
    }
  }
  return false;
}

// static
bool ImageDecoderStubDispatch::AcceptWithResponder(
    ImageDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kImageDecoder_DecodeImage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::ImageDecoder::DecodeImage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::ImageDecoder::DecodeImage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ImageDecoder_DecodeImage_Params_Data* params =
          reinterpret_cast<
              internal::ImageDecoder_DecodeImage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_encoded_data{};
      ImageCodec p_codec{};
      bool p_shrink_to_fit{};
      int64_t p_max_size_in_bytes{};
      ::gfx::Size p_desired_image_frame_size{};
      ImageDecoder_DecodeImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncodedData(&p_encoded_data))
        success = false;
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (success)
        p_shrink_to_fit = input_data_view.shrink_to_fit();
      if (success)
        p_max_size_in_bytes = input_data_view.max_size_in_bytes();
      if (success && !input_data_view.ReadDesiredImageFrameSize(&p_desired_image_frame_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDecoder::Name_, 0, false);
        return false;
      }
      ImageDecoder::DecodeImageCallback callback =
          ImageDecoder_DecodeImage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecodeImage(
std::move(p_encoded_data), 
std::move(p_codec), 
std::move(p_shrink_to_fit), 
std::move(p_max_size_in_bytes), 
std::move(p_desired_image_frame_size), std::move(callback));
      return true;
    }
    case internal::kImageDecoder_DecodeAnimation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::ImageDecoder::DecodeAnimation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::ImageDecoder::DecodeAnimation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ImageDecoder_DecodeAnimation_Params_Data* params =
          reinterpret_cast<
              internal::ImageDecoder_DecodeAnimation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_encoded_data{};
      bool p_shrink_to_fit{};
      int64_t p_max_size_in_bytes{};
      ImageDecoder_DecodeAnimation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncodedData(&p_encoded_data))
        success = false;
      if (success)
        p_shrink_to_fit = input_data_view.shrink_to_fit();
      if (success)
        p_max_size_in_bytes = input_data_view.max_size_in_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDecoder::Name_, 1, false);
        return false;
      }
      ImageDecoder::DecodeAnimationCallback callback =
          ImageDecoder_DecodeAnimation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecodeAnimation(
std::move(p_encoded_data), 
std::move(p_shrink_to_fit), 
std::move(p_max_size_in_bytes), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kImageDecoderValidationInfo[] = {
    {internal::kImageDecoder_DecodeImage_Name,
     {&internal::ImageDecoder_DecodeImage_Params_Data::Validate,
      &internal::ImageDecoder_DecodeImage_ResponseParams_Data::Validate}},
    {internal::kImageDecoder_DecodeAnimation_Name,
     {&internal::ImageDecoder_DecodeAnimation_Params_Data::Validate,
      &internal::ImageDecoder_DecodeAnimation_ResponseParams_Data::Validate}},
};

bool ImageDecoderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::ImageDecoder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kImageDecoderValidationInfo);
}

bool ImageDecoderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::ImageDecoder::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kImageDecoderValidationInfo);

}
}  // namespace mojom
}  // namespace data_decoder

namespace mojo {


// static
bool StructTraits<::data_decoder::mojom::AnimationFrame::DataView, ::data_decoder::mojom::AnimationFramePtr>::Read(
    ::data_decoder::mojom::AnimationFrame::DataView input,
    ::data_decoder::mojom::AnimationFramePtr* output) {
  bool success = true;
  ::data_decoder::mojom::AnimationFramePtr result(::data_decoder::mojom::AnimationFrame::New());
  
      if (success && !input.ReadBitmap(&result->bitmap))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif