// services/device/public/mojom/device_posture_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/device_posture_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/device_posture_provider.mojom-params-data.h"
#include "services/device/public/mojom/device_posture_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/device_posture_provider.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_DEVICE_POSTURE_PROVIDER_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_DEVICE_POSTURE_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
const char DevicePostureProvider::Name_[] = "device.mojom.DevicePostureProvider";

class DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback(
      DevicePostureProvider::AddListenerAndGetCurrentPostureCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DevicePostureProvider::AddListenerAndGetCurrentPostureCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback);
};

DevicePostureProviderProxy::DevicePostureProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevicePostureProviderProxy::AddListenerAndGetCurrentPosture(
    ::mojo::PendingRemote<DevicePostureProviderClient> in_client, AddListenerAndGetCurrentPostureCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DevicePostureProviderClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevicePostureProvider_AddListenerAndGetCurrentPosture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::DevicePostureProviderClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in DevicePostureProvider.AddListenerAndGetCurrentPosture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProvider::Name_);
  message.set_method_name("AddListenerAndGetCurrentPosture");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder {
 public:
  static DevicePostureProvider::AddListenerAndGetCurrentPostureCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder> proxy(
        new DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DevicePostureProvider::AddListenerAndGetCurrentPostureCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DevicePostureType in_posture);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder);
};

bool DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::DevicePostureProvider::AddListenerAndGetCurrentPostureCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DevicePostureType p_posture{};
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPosture(&p_posture))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DevicePostureProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_posture));
  return true;
}

void DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder::Run(
    DevicePostureType in_posture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::DevicePostureProvider::AddListenerAndGetCurrentPostureCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("posture"), in_posture,
                        "<value of type DevicePostureType>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevicePostureProvider_AddListenerAndGetCurrentPosture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::DevicePostureType>(
      in_posture, &params->posture);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::DevicePostureProvider::AddListenerAndGetCurrentPostureCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProvider::Name_);
  message.set_method_name("AddListenerAndGetCurrentPosture");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DevicePostureProviderStubDispatch::Accept(
    DevicePostureProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDevicePostureProvider_AddListenerAndGetCurrentPosture_Name: {
      break;
    }
  }
  return false;
}

// static
bool DevicePostureProviderStubDispatch::AcceptWithResponder(
    DevicePostureProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDevicePostureProvider_AddListenerAndGetCurrentPosture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data* params =
          reinterpret_cast<
              internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<DevicePostureProviderClient> p_client{};
      DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePostureProvider::Name_, 0, false);
        return false;
      }
      DevicePostureProvider::AddListenerAndGetCurrentPostureCallback callback =
          DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListenerAndGetCurrentPosture(
std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDevicePostureProviderValidationInfo[] = {
    {internal::kDevicePostureProvider_AddListenerAndGetCurrentPosture_Name,
     {&internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data::Validate,
      &internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data::Validate}},
};

bool DevicePostureProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::DevicePostureProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDevicePostureProviderValidationInfo);
}

bool DevicePostureProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::DevicePostureProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDevicePostureProviderValidationInfo);

}
const char DevicePostureProviderClient::Name_[] = "device.mojom.DevicePostureProviderClient";

DevicePostureProviderClientProxy::DevicePostureProviderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevicePostureProviderClientProxy::OnPostureChanged(
    DevicePostureType in_posture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DevicePostureProviderClient::OnPostureChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("posture"), in_posture,
                        "<value of type DevicePostureType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevicePostureProviderClient_OnPostureChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DevicePostureProviderClient_OnPostureChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::DevicePostureType>(
      in_posture, &params->posture);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProviderClient::Name_);
  message.set_method_name("OnPostureChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DevicePostureProviderClientStubDispatch::Accept(
    DevicePostureProviderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDevicePostureProviderClient_OnPostureChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DevicePostureProviderClient::OnPostureChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DevicePostureProviderClient::OnPostureChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevicePostureProviderClient_OnPostureChanged_Params_Data* params =
          reinterpret_cast<internal::DevicePostureProviderClient_OnPostureChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DevicePostureType p_posture{};
      DevicePostureProviderClient_OnPostureChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosture(&p_posture))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePostureProviderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPostureChanged(
std::move(p_posture));
      return true;
    }
  }
  return false;
}

// static
bool DevicePostureProviderClientStubDispatch::AcceptWithResponder(
    DevicePostureProviderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDevicePostureProviderClient_OnPostureChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDevicePostureProviderClientValidationInfo[] = {
    {internal::kDevicePostureProviderClient_OnPostureChanged_Name,
     {&internal::DevicePostureProviderClient_OnPostureChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DevicePostureProviderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::DevicePostureProviderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDevicePostureProviderClientValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif