// services/device/public/mojom/fingerprint.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/fingerprint.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/fingerprint.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* ScanResultToStringHelper(ScanResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScanResult::SUCCESS:
      return "SUCCESS";
    case ScanResult::PARTIAL:
      return "PARTIAL";
    case ScanResult::INSUFFICIENT:
      return "INSUFFICIENT";
    case ScanResult::SENSOR_DIRTY:
      return "SENSOR_DIRTY";
    case ScanResult::TOO_SLOW:
      return "TOO_SLOW";
    case ScanResult::TOO_FAST:
      return "TOO_FAST";
    case ScanResult::IMMOBILE:
      return "IMMOBILE";
    default:
      return nullptr;
  }
}

std::string ScanResultToString(ScanResult value) {
  const char *str = ScanResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScanResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScanResult value) {
  return os << ScanResultToString(value);
}

static NOINLINE const char* BiometricTypeToStringHelper(BiometricType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BiometricType::UNKNOWN:
      return "UNKNOWN";
    case BiometricType::FINGERPRINT:
      return "FINGERPRINT";
    default:
      return nullptr;
  }
}

std::string BiometricTypeToString(BiometricType value) {
  const char *str = BiometricTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BiometricType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BiometricType value) {
  return os << BiometricTypeToString(value);
}

namespace internal {


// static
bool FingerprintObserver_OnRestarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FingerprintObserver_OnRestarted_Params_Data* object = static_cast<const FingerprintObserver_OnRestarted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FingerprintObserver_OnRestarted_Params_Data::FingerprintObserver_OnRestarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnEnrollScanDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FingerprintObserver_OnEnrollScanDone_Params_Data* object = static_cast<const FingerprintObserver_OnEnrollScanDone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::ScanResult_Data
        ::Validate(object->scan_result, validation_context))
    return false;

  return true;
}

FingerprintObserver_OnEnrollScanDone_Params_Data::FingerprintObserver_OnEnrollScanDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnAuthScanDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FingerprintObserver_OnAuthScanDone_Params_Data* object = static_cast<const FingerprintObserver_OnAuthScanDone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::ScanResult_Data
        ::Validate(object->scan_result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matches, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams matches_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr))));
  if (!mojo::internal::ValidateContainer(object->matches, validation_context,
                                         &matches_validate_params)) {
    return false;
  }

  return true;
}

FingerprintObserver_OnAuthScanDone_Params_Data::FingerprintObserver_OnAuthScanDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnSessionFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FingerprintObserver_OnSessionFailed_Params_Data* object = static_cast<const FingerprintObserver_OnSessionFailed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FingerprintObserver_OnSessionFailed_Params_Data::FingerprintObserver_OnSessionFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_GetRecordsForUser_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_GetRecordsForUser_Params_Data* object = static_cast<const Fingerprint_GetRecordsForUser_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams user_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_GetRecordsForUser_Params_Data::Fingerprint_GetRecordsForUser_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_GetRecordsForUser_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_GetRecordsForUser_ResponseParams_Data* object = static_cast<const Fingerprint_GetRecordsForUser_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->records, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams records_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->records, validation_context,
                                         &records_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_GetRecordsForUser_ResponseParams_Data::Fingerprint_GetRecordsForUser_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_StartEnrollSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_StartEnrollSession_Params_Data* object = static_cast<const Fingerprint_StartEnrollSession_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams user_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_StartEnrollSession_Params_Data::Fingerprint_StartEnrollSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_CancelCurrentEnrollSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_CancelCurrentEnrollSession_Params_Data* object = static_cast<const Fingerprint_CancelCurrentEnrollSession_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_CancelCurrentEnrollSession_Params_Data::Fingerprint_CancelCurrentEnrollSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data* object = static_cast<const Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data::Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestRecordLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_RequestRecordLabel_Params_Data* object = static_cast<const Fingerprint_RequestRecordLabel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->record_path, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams record_path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->record_path, validation_context,
                                         &record_path_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_RequestRecordLabel_Params_Data::Fingerprint_RequestRecordLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestRecordLabel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_RequestRecordLabel_ResponseParams_Data* object = static_cast<const Fingerprint_RequestRecordLabel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_RequestRecordLabel_ResponseParams_Data::Fingerprint_RequestRecordLabel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_SetRecordLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_SetRecordLabel_Params_Data* object = static_cast<const Fingerprint_SetRecordLabel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->record_path, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams record_path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->record_path, validation_context,
                                         &record_path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_label, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams new_label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->new_label, validation_context,
                                         &new_label_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_SetRecordLabel_Params_Data::Fingerprint_SetRecordLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_SetRecordLabel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_SetRecordLabel_ResponseParams_Data* object = static_cast<const Fingerprint_SetRecordLabel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_SetRecordLabel_ResponseParams_Data::Fingerprint_SetRecordLabel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RemoveRecord_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_RemoveRecord_Params_Data* object = static_cast<const Fingerprint_RemoveRecord_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->record_path, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams record_path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->record_path, validation_context,
                                         &record_path_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_RemoveRecord_Params_Data::Fingerprint_RemoveRecord_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RemoveRecord_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_RemoveRecord_ResponseParams_Data* object = static_cast<const Fingerprint_RemoveRecord_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_RemoveRecord_ResponseParams_Data::Fingerprint_RemoveRecord_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_StartAuthSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_StartAuthSession_Params_Data* object = static_cast<const Fingerprint_StartAuthSession_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_StartAuthSession_Params_Data::Fingerprint_StartAuthSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_EndCurrentAuthSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_EndCurrentAuthSession_Params_Data* object = static_cast<const Fingerprint_EndCurrentAuthSession_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_EndCurrentAuthSession_Params_Data::Fingerprint_EndCurrentAuthSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_EndCurrentAuthSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_EndCurrentAuthSession_ResponseParams_Data* object = static_cast<const Fingerprint_EndCurrentAuthSession_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_EndCurrentAuthSession_ResponseParams_Data::Fingerprint_EndCurrentAuthSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_DestroyAllRecords_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_DestroyAllRecords_Params_Data* object = static_cast<const Fingerprint_DestroyAllRecords_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_DestroyAllRecords_Params_Data::Fingerprint_DestroyAllRecords_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_DestroyAllRecords_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_DestroyAllRecords_ResponseParams_Data* object = static_cast<const Fingerprint_DestroyAllRecords_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_DestroyAllRecords_ResponseParams_Data::Fingerprint_DestroyAllRecords_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_AddFingerprintObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_AddFingerprintObserver_Params_Data* object = static_cast<const Fingerprint_AddFingerprintObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Fingerprint_AddFingerprintObserver_Params_Data::Fingerprint_AddFingerprintObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_RequestType_Params_Data* object = static_cast<const Fingerprint_RequestType_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Fingerprint_RequestType_Params_Data::Fingerprint_RequestType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestType_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Fingerprint_RequestType_ResponseParams_Data* object = static_cast<const Fingerprint_RequestType_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BiometricType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

Fingerprint_RequestType_ResponseParams_Data::Fingerprint_RequestType_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::ScanResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::ScanResult value) {
  return std::move(context).WriteString(::device::mojom::ScanResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BiometricType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BiometricType value) {
  return std::move(context).WriteString(::device::mojom::BiometricTypeToString(value));
}

} // namespace perfetto
