// services/device/public/mojom/nfc_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/nfc_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/nfc_provider.mojom-params-data.h"
#include "services/device/public/mojom/nfc_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/nfc_provider.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_PROVIDER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_PROVIDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char NFCProvider::Name_[] = "device.mojom.NFCProvider";

NFCProviderProxy::NFCProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NFCProviderProxy::GetNFCForHost(
    int32_t in_host_id, ::mojo::PendingReceiver<::device::mojom::blink::NFC> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFCProvider::GetNFCForHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_id"), in_host_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::NFC>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFCProvider_GetNFCForHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCProvider_GetNFCForHost_Params_Data> params(
          message);
  params.Allocate();
  params->host_id = in_host_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::NFCInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NFCProvider.GetNFCForHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCProvider::Name_);
  message.set_method_name("GetNFCForHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NFCProviderProxy::SuspendNFCOperations(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::NFCProvider::SuspendNFCOperations");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFCProvider_SuspendNFCOperations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCProvider_SuspendNFCOperations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCProvider::Name_);
  message.set_method_name("SuspendNFCOperations");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NFCProviderProxy::ResumeNFCOperations(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::NFCProvider::ResumeNFCOperations");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFCProvider_ResumeNFCOperations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCProvider_ResumeNFCOperations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCProvider::Name_);
  message.set_method_name("ResumeNFCOperations");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NFCProviderStubDispatch::Accept(
    NFCProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNFCProvider_GetNFCForHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFCProvider::GetNFCForHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFCProvider::GetNFCForHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFCProvider_GetNFCForHost_Params_Data* params =
          reinterpret_cast<internal::NFCProvider_GetNFCForHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_host_id{};
      ::mojo::PendingReceiver<::device::mojom::blink::NFC> p_receiver{};
      NFCProvider_GetNFCForHost_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_host_id = input_data_view.host_id();
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNFCForHost(
std::move(p_host_id), 
std::move(p_receiver));
      return true;
    }
    case internal::kNFCProvider_SuspendNFCOperations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFCProvider::SuspendNFCOperations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFCProvider::SuspendNFCOperations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFCProvider_SuspendNFCOperations_Params_Data* params =
          reinterpret_cast<internal::NFCProvider_SuspendNFCOperations_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NFCProvider_SuspendNFCOperations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendNFCOperations();
      return true;
    }
    case internal::kNFCProvider_ResumeNFCOperations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFCProvider::ResumeNFCOperations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFCProvider::ResumeNFCOperations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFCProvider_ResumeNFCOperations_Params_Data* params =
          reinterpret_cast<internal::NFCProvider_ResumeNFCOperations_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NFCProvider_ResumeNFCOperations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeNFCOperations();
      return true;
    }
  }
  return false;
}

// static
bool NFCProviderStubDispatch::AcceptWithResponder(
    NFCProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNFCProvider_GetNFCForHost_Name: {
      break;
    }
    case internal::kNFCProvider_SuspendNFCOperations_Name: {
      break;
    }
    case internal::kNFCProvider_ResumeNFCOperations_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNFCProviderValidationInfo[] = {
    {internal::kNFCProvider_GetNFCForHost_Name,
     {&internal::NFCProvider_GetNFCForHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNFCProvider_SuspendNFCOperations_Name,
     {&internal::NFCProvider_SuspendNFCOperations_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNFCProvider_ResumeNFCOperations_Name,
     {&internal::NFCProvider_ResumeNFCOperations_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NFCProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::NFCProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNFCProviderValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif