// services/network/public/mojom/cookie_access_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cookie_access_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-params-data.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
CookieAccessDetails::CookieAccessDetails()
    : type(),
      url(),
      site_for_cookies(),
      cookie_list(),
      devtools_request_id() {}

CookieAccessDetails::CookieAccessDetails(
    CookieAccessDetails::Type type_in,
    const ::GURL& url_in,
    const ::net::SiteForCookies& site_for_cookies_in,
    std::vector<::network::mojom::CookieOrLineWithAccessResultPtr> cookie_list_in,
    const absl::optional<std::string>& devtools_request_id_in)
    : type(std::move(type_in)),
      url(std::move(url_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      cookie_list(std::move(cookie_list_in)),
      devtools_request_id(std::move(devtools_request_id_in)) {}

CookieAccessDetails::~CookieAccessDetails() = default;

void CookieAccessDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessDetails::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_for_cookies"), this->site_for_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SiteForCookies&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_list"), this->cookie_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::network::mojom::CookieOrLineWithAccessResultPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_request_id"), this->devtools_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieAccessDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CookieAccessObserver::Name_[] = "network.mojom.CookieAccessObserver";

CookieAccessObserverProxy::CookieAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieAccessObserverProxy::OnCookiesAccessed(
    CookieAccessDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieAccessObserver::OnCookiesAccessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type CookieAccessDetailsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCookieAccessObserver_OnCookiesAccessed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieAccessObserver_OnCookiesAccessed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieAccessDetailsDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in CookieAccessObserver.OnCookiesAccessed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieAccessObserver::Name_);
  message.set_method_name("OnCookiesAccessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieAccessObserverProxy::Clone(
    ::mojo::PendingReceiver<CookieAccessObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieAccessObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<CookieAccessObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCookieAccessObserver_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieAccessObserver_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in CookieAccessObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieAccessObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CookieAccessObserverStubDispatch::Accept(
    CookieAccessObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCookieAccessObserver_OnCookiesAccessed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieAccessObserver::OnCookiesAccessed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieAccessObserver::OnCookiesAccessed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieAccessObserver_OnCookiesAccessed_Params_Data* params =
          reinterpret_cast<internal::CookieAccessObserver_OnCookiesAccessed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CookieAccessDetailsPtr p_details{};
      CookieAccessObserver_OnCookiesAccessed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieAccessObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCookiesAccessed(
std::move(p_details));
      return true;
    }
    case internal::kCookieAccessObserver_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieAccessObserver::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieAccessObserver::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieAccessObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::CookieAccessObserver_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<CookieAccessObserver> p_listener{};
      CookieAccessObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieAccessObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool CookieAccessObserverStubDispatch::AcceptWithResponder(
    CookieAccessObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieAccessObserver_OnCookiesAccessed_Name: {
      break;
    }
    case internal::kCookieAccessObserver_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieAccessObserverValidationInfo[] = {
    {internal::kCookieAccessObserver_OnCookiesAccessed_Name,
     {&internal::CookieAccessObserver_OnCookiesAccessed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieAccessObserver_Clone_Name,
     {&internal::CookieAccessObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CookieAccessObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::CookieAccessObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieAccessObserverValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::CookieAccessDetails::DataView, ::network::mojom::CookieAccessDetailsPtr>::Read(
    ::network::mojom::CookieAccessDetails::DataView input,
    ::network::mojom::CookieAccessDetailsPtr* output) {
  bool success = true;
  ::network::mojom::CookieAccessDetailsPtr result(::network::mojom::CookieAccessDetails::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success && !input.ReadCookieList(&result->cookie_list))
        success = false;
      if (success && !input.ReadDevtoolsRequestId(&result->devtools_request_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif