// services/network/public/mojom/cors_origin_pattern.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cors_origin_pattern.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* CorsPortMatchModeToStringHelper(CorsPortMatchMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsPortMatchMode::kAllowAnyPort:
      return "kAllowAnyPort";
    case CorsPortMatchMode::kAllowOnlySpecifiedPort:
      return "kAllowOnlySpecifiedPort";
    default:
      return nullptr;
  }
}

std::string CorsPortMatchModeToString(CorsPortMatchMode value) {
  const char *str = CorsPortMatchModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsPortMatchMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsPortMatchMode value) {
  return os << CorsPortMatchModeToString(value);
}

static NOINLINE const char* CorsDomainMatchModeToStringHelper(CorsDomainMatchMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsDomainMatchMode::kAllowSubdomains:
      return "kAllowSubdomains";
    case CorsDomainMatchMode::kAllowRegistrableDomains:
      return "kAllowRegistrableDomains";
    case CorsDomainMatchMode::kDisallowSubdomains:
      return "kDisallowSubdomains";
    default:
      return nullptr;
  }
}

std::string CorsDomainMatchModeToString(CorsDomainMatchMode value) {
  const char *str = CorsDomainMatchModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsDomainMatchMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsDomainMatchMode value) {
  return os << CorsDomainMatchModeToString(value);
}

static NOINLINE const char* CorsOriginAccessMatchPriorityToStringHelper(CorsOriginAccessMatchPriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsOriginAccessMatchPriority::kNoMatchingOrigin:
      return "kNoMatchingOrigin";
    case CorsOriginAccessMatchPriority::kDefaultPriority:
      return "kDefaultPriority";
    case CorsOriginAccessMatchPriority::kLowPriority:
      return "kLowPriority";
    case CorsOriginAccessMatchPriority::kMediumPriority:
      return "kMediumPriority";
    case CorsOriginAccessMatchPriority::kHighPriority:
      return "kHighPriority";
    case CorsOriginAccessMatchPriority::kMaxPriority:
      return "kMaxPriority";
    default:
      return nullptr;
  }
}

std::string CorsOriginAccessMatchPriorityToString(CorsOriginAccessMatchPriority value) {
  const char *str = CorsOriginAccessMatchPriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsOriginAccessMatchPriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsOriginAccessMatchPriority value) {
  return os << CorsOriginAccessMatchPriorityToString(value);
}

namespace internal {


// static
bool CorsOriginPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CorsOriginPattern_Data* object = static_cast<const CorsOriginPattern_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams protocol_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams domain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CorsDomainMatchMode_Data
        ::Validate(object->domain_match_mode, validation_context))
    return false;


  if (!::network::mojom::internal::CorsPortMatchMode_Data
        ::Validate(object->port_match_mode, validation_context))
    return false;


  if (!::network::mojom::internal::CorsOriginAccessMatchPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

CorsOriginPattern_Data::CorsOriginPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CorsOriginAccessPatterns_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CorsOriginAccessPatterns_Data* object = static_cast<const CorsOriginAccessPatterns_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allow_patterns, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams allow_patterns_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->allow_patterns, validation_context,
                                         &allow_patterns_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->block_patterns, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams block_patterns_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->block_patterns, validation_context,
                                         &block_patterns_validate_params)) {
    return false;
  }

  return true;
}

CorsOriginAccessPatterns_Data::CorsOriginAccessPatterns_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsPortMatchMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsPortMatchMode value) {
  return std::move(context).WriteString(::network::mojom::CorsPortMatchModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsDomainMatchMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsDomainMatchMode value) {
  return std::move(context).WriteString(::network::mojom::CorsDomainMatchModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsOriginAccessMatchPriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsOriginAccessMatchPriority value) {
  return std::move(context).WriteString(::network::mojom::CorsOriginAccessMatchPriorityToString(value));
}

} // namespace perfetto
