// services/network/public/mojom/cross_origin_opener_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* CoopAccessReportTypeToStringHelper(CoopAccessReportType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CoopAccessReportType::kAccessFromCoopPageToOpener:
      return "kAccessFromCoopPageToOpener";
    case CoopAccessReportType::kAccessFromCoopPageToOpenee:
      return "kAccessFromCoopPageToOpenee";
    case CoopAccessReportType::kAccessFromCoopPageToOther:
      return "kAccessFromCoopPageToOther";
    case CoopAccessReportType::kAccessToCoopPageFromOpener:
      return "kAccessToCoopPageFromOpener";
    case CoopAccessReportType::kAccessToCoopPageFromOpenee:
      return "kAccessToCoopPageFromOpenee";
    case CoopAccessReportType::kAccessToCoopPageFromOther:
      return "kAccessToCoopPageFromOther";
    default:
      return nullptr;
  }
}

std::string CoopAccessReportTypeToString(CoopAccessReportType value) {
  const char *str = CoopAccessReportTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CoopAccessReportType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CoopAccessReportType value) {
  return os << CoopAccessReportTypeToString(value);
}

static NOINLINE const char* CrossOriginOpenerPolicyValueToStringHelper(CrossOriginOpenerPolicyValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CrossOriginOpenerPolicyValue::kSameOrigin:
      return "kSameOrigin";
    case CrossOriginOpenerPolicyValue::kSameOriginAllowPopups:
      return "kSameOriginAllowPopups";
    case CrossOriginOpenerPolicyValue::kUnsafeNone:
      return "kUnsafeNone";
    case CrossOriginOpenerPolicyValue::kSameOriginPlusCoep:
      return "kSameOriginPlusCoep";
    default:
      return nullptr;
  }
}

std::string CrossOriginOpenerPolicyValueToString(CrossOriginOpenerPolicyValue value) {
  const char *str = CrossOriginOpenerPolicyValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CrossOriginOpenerPolicyValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CrossOriginOpenerPolicyValue value) {
  return os << CrossOriginOpenerPolicyValueToString(value);
}

namespace internal {


// static
bool CrossOriginOpenerPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginOpenerPolicy_Data* object = static_cast<const CrossOriginOpenerPolicy_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CrossOriginOpenerPolicyValue_Data
        ::Validate(object->value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CrossOriginOpenerPolicyValue_Data
        ::Validate(object->report_only_value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams report_only_reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->report_only_reporting_endpoint, validation_context,
                                         &report_only_reporting_endpoint_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginOpenerPolicy_Data::CrossOriginOpenerPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* object = static_cast<const CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CoopAccessReportType_Data
        ::Validate(object->report_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->property, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams property_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->property, validation_context,
                                         &property_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reported_window_url, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reported_window_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reported_window_url, validation_context,
                                         &reported_window_url_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CoopAccessReportType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CoopAccessReportType value) {
  return std::move(context).WriteString(::network::mojom::CoopAccessReportTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CrossOriginOpenerPolicyValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CrossOriginOpenerPolicyValue value) {
  return std::move(context).WriteString(::network::mojom::CrossOriginOpenerPolicyValueToString(value));
}

} // namespace perfetto
