// services/network/public/mojom/devtools_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/devtools_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/devtools_observer.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool URLRequestDevToolsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLRequestDevToolsInfo_Data* object = static_cast<const URLRequestDevToolsInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->priority, validation_context))
    return false;


  if (!::network::mojom::internal::URLRequestReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;

  return true;
}

URLRequestDevToolsInfo_Data::URLRequestDevToolsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnRawRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnRawRequest_Params_Data* object = static_cast<const DevToolsObserver_OnRawRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_with_access_result, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies_with_access_result, validation_context,
                                         &cookies_with_access_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnRawRequest_Params_Data::DevToolsObserver_OnRawRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnRawResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnRawResponse_Params_Data* object = static_cast<const DevToolsObserver_OnRawResponse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_with_access_result, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies_with_access_result, validation_context,
                                         &cookies_with_access_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams raw_response_headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->raw_response_headers, validation_context,
                                         &raw_response_headers_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnRawResponse_Params_Data::DevToolsObserver_OnRawResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnPrivateNetworkRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnPrivateNetworkRequest_Params_Data* object = static_cast<const DevToolsObserver_OnPrivateNetworkRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_security_state, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnPrivateNetworkRequest_Params_Data::DevToolsObserver_OnPrivateNetworkRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsPreflightRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnCorsPreflightRequest_Params_Data* object = static_cast<const DevToolsObserver_OnCorsPreflightRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_devtool_request_id, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams initiator_devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->initiator_devtool_request_id, validation_context,
                                         &initiator_devtool_request_id_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnCorsPreflightRequest_Params_Data::DevToolsObserver_OnCorsPreflightRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsPreflightResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnCorsPreflightResponse_Params_Data* object = static_cast<const DevToolsObserver_OnCorsPreflightResponse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnCorsPreflightResponse_Params_Data::DevToolsObserver_OnCorsPreflightResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data* object = static_cast<const DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnTrustTokenOperationDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnTrustTokenOperationDone_Params_Data* object = static_cast<const DevToolsObserver_OnTrustTokenOperationDone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnTrustTokenOperationDone_Params_Data::DevToolsObserver_OnTrustTokenOperationDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnCorsError_Params_Data* object = static_cast<const DevToolsObserver_OnCorsError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnCorsError_Params_Data::DevToolsObserver_OnCorsError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data* object = static_cast<const DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams urls_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data* object = static_cast<const DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data* object = static_cast<const DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inner_request_devtools_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams inner_request_devtools_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->inner_request_devtools_id, validation_context,
                                         &inner_request_devtools_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams bundle_request_devtools_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bundle_request_devtools_id, validation_context,
                                         &bundle_request_devtools_id_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data* object = static_cast<const DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inner_request_devtools_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams inner_request_devtools_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->inner_request_devtools_id, validation_context,
                                         &inner_request_devtools_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams bundle_request_devtools_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bundle_request_devtools_id, validation_context,
                                         &bundle_request_devtools_id_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevToolsObserver_Clone_Params_Data* object = static_cast<const DevToolsObserver_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DevToolsObserver_Clone_Params_Data::DevToolsObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
