// services/network/public/mojom/devtools_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/devtools_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/devtools_observer.mojom-params-data.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/devtools_observer.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
URLRequestDevToolsInfo::URLRequestDevToolsInfo()
    : method(),
      url(),
      priority(),
      referrer_policy(),
      trust_token_params(),
      has_user_gesture() {}

URLRequestDevToolsInfo::URLRequestDevToolsInfo(
    const std::string& method_in,
    const ::GURL& url_in,
    ::net::RequestPriority priority_in,
    ::net::ReferrerPolicy referrer_policy_in,
    ::network::mojom::TrustTokenParamsPtr trust_token_params_in,
    bool has_user_gesture_in)
    : method(std::move(method_in)),
      url(std::move(url_in)),
      priority(std::move(priority_in)),
      referrer_policy(std::move(referrer_policy_in)),
      trust_token_params(std::move(trust_token_params_in)),
      has_user_gesture(std::move(has_user_gesture_in)) {}

URLRequestDevToolsInfo::~URLRequestDevToolsInfo() = default;

void URLRequestDevToolsInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::TrustTokenParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLRequestDevToolsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DevToolsObserver::Name_[] = "network.mojom.DevToolsObserver";

DevToolsObserverProxy::DevToolsObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsObserverProxy::OnRawRequest(
    const std::string& in_devtool_request_id, const std::vector<::net::CookieWithAccessResult>& in_cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> in_headers, ::network::mojom::ClientSecurityStatePtr in_client_security_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnRawRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_with_access_result"), in_cookies_with_access_result,
                        "<value of type const std::vector<::net::CookieWithAccessResult>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type std::vector<::network::mojom::HttpRawHeaderPairPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state,
                        "<value of type ::network::mojom::ClientSecurityStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnRawRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnRawRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookies_with_access_result)::BaseType>
      cookies_with_access_result_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_cookies_with_access_result, cookies_with_access_result_fragment, &cookies_with_access_result_validate_params);
  params->cookies_with_access_result.Set(
      cookies_with_access_result_fragment.is_null() ? nullptr : cookies_with_access_result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies_with_access_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies_with_access_result in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
      in_headers, headers_fragment, &headers_validate_params);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in DevToolsObserver.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
      in_client_security_state, client_security_state_fragment);
  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnRawRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnRawResponse(
    const std::string& in_devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& in_cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> in_headers, const absl::optional<std::string>& in_raw_response_headers, ::network::mojom::IPAddressSpace in_resource_address_space, int32_t in_http_status_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnRawResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_with_access_result"), in_cookies_with_access_result,
                        "<value of type const std::vector<::net::CookieAndLineWithAccessResult>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type std::vector<::network::mojom::HttpRawHeaderPairPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_response_headers"), in_raw_response_headers,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_address_space"), in_resource_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_status_code"), in_http_status_code,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnRawResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnRawResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookies_with_access_result)::BaseType>
      cookies_with_access_result_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>>(
      in_cookies_with_access_result, cookies_with_access_result_fragment, &cookies_with_access_result_validate_params);
  params->cookies_with_access_result.Set(
      cookies_with_access_result_fragment.is_null() ? nullptr : cookies_with_access_result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies_with_access_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies_with_access_result in DevToolsObserver.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
      in_headers, headers_fragment, &headers_validate_params);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in DevToolsObserver.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->raw_response_headers)::BaseType> raw_response_headers_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_response_headers, raw_response_headers_fragment);
  params->raw_response_headers.Set(
      raw_response_headers_fragment.is_null() ? nullptr : raw_response_headers_fragment.data());
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      in_resource_address_space, &params->resource_address_space);
  params->http_status_code = in_http_status_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnRawResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnPrivateNetworkRequest(
    const absl::optional<std::string>& in_devtool_request_id, const ::GURL& in_url, bool in_is_warning, ::network::mojom::IPAddressSpace in_resource_address_space, ::network::mojom::ClientSecurityStatePtr in_client_security_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnPrivateNetworkRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_warning"), in_is_warning,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_address_space"), in_resource_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state,
                        "<value of type ::network::mojom::ClientSecurityStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnPrivateNetworkRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DevToolsObserver.OnPrivateNetworkRequest request");
  params->is_warning = in_is_warning;
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      in_resource_address_space, &params->resource_address_space);
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
      in_client_security_state, client_security_state_fragment);
  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_security_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_security_state in DevToolsObserver.OnPrivateNetworkRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnPrivateNetworkRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnCorsPreflightRequest(
    const ::base::UnguessableToken& in_devtool_request_id, const ::net::HttpRequestHeaders& in_request_headers, URLRequestDevToolsInfoPtr in_request_info, const ::GURL& in_initiator_url, const std::string& in_initiator_devtool_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnCorsPreflightRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_headers"), in_request_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_info"), in_request_info,
                        "<value of type URLRequestDevToolsInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_url"), in_initiator_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_devtool_request_id"), in_initiator_devtool_request_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnCorsPreflightRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_headers)::BaseType> request_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_request_headers, request_headers_fragment);
  params->request_headers.Set(
      request_headers_fragment.is_null() ? nullptr : request_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_headers in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_info)::BaseType> request_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLRequestDevToolsInfoDataView>(
      in_request_info, request_info_fragment);
  params->request_info.Set(
      request_info_fragment.is_null() ? nullptr : request_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_info in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_url)::BaseType> initiator_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_initiator_url, initiator_url_fragment);
  params->initiator_url.Set(
      initiator_url_fragment.is_null() ? nullptr : initiator_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initiator_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_url in DevToolsObserver.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_devtool_request_id)::BaseType> initiator_devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_initiator_devtool_request_id, initiator_devtool_request_id_fragment);
  params->initiator_devtool_request_id.Set(
      initiator_devtool_request_id_fragment.is_null() ? nullptr : initiator_devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initiator_devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_devtool_request_id in DevToolsObserver.OnCorsPreflightRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsPreflightRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnCorsPreflightResponse(
    const ::base::UnguessableToken& in_devtool_request_id, const ::GURL& in_url, ::network::mojom::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnCorsPreflightResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnCorsPreflightResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnCorsPreflightResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DevToolsObserver.OnCorsPreflightResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in DevToolsObserver.OnCorsPreflightResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsPreflightResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnCorsPreflightRequestCompleted(
    const ::base::UnguessableToken& in_devtool_request_id, const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnCorsPreflightRequestCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnCorsPreflightRequestCompleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in DevToolsObserver.OnCorsPreflightRequestCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsPreflightRequestCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnTrustTokenOperationDone(
    const std::string& in_devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnTrustTokenOperationDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::network::mojom::TrustTokenOperationResultPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnTrustTokenOperationDone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnTrustTokenOperationDone request");
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::TrustTokenOperationResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in DevToolsObserver.OnTrustTokenOperationDone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnTrustTokenOperationDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnCorsError(
    const absl::optional<std::string>& in_devtool_request_id, const absl::optional<::url::Origin>& in_initiator_origin, const ::GURL& in_url, const ::network::CorsErrorStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnCorsError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_origin"), in_initiator_origin,
                        "<value of type const absl::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::CorsErrorStatus&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnCorsError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnCorsError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_origin)::BaseType> initiator_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_initiator_origin, initiator_origin_fragment);
  params->initiator_origin.Set(
      initiator_origin_fragment.is_null() ? nullptr : initiator_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DevToolsObserver.OnCorsError request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CorsErrorStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in DevToolsObserver.OnCorsError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnCorsError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnSubresourceWebBundleMetadata(
    const std::string& in_devtool_request_id, const std::vector<::GURL>& in_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnSubresourceWebBundleMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnSubresourceWebBundleMetadata request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  const mojo::internal::ContainerValidateParams urls_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_urls, urls_fragment, &urls_validate_params);
  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->urls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null urls in DevToolsObserver.OnSubresourceWebBundleMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnSubresourceWebBundleMetadataError(
    const std::string& in_devtool_request_id, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnSubresourceWebBundleMetadataError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in DevToolsObserver.OnSubresourceWebBundleMetadataError request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in DevToolsObserver.OnSubresourceWebBundleMetadataError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleMetadataError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnSubresourceWebBundleInnerResponse(
    const std::string& in_inner_request_devtools_id, const ::GURL& in_url, const absl::optional<std::string>& in_bundle_request_devtools_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inner_request_devtools_id"), in_inner_request_devtools_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_request_devtools_id"), in_bundle_request_devtools_id,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->inner_request_devtools_id)::BaseType> inner_request_devtools_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_inner_request_devtools_id, inner_request_devtools_id_fragment);
  params->inner_request_devtools_id.Set(
      inner_request_devtools_id_fragment.is_null() ? nullptr : inner_request_devtools_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->inner_request_devtools_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inner_request_devtools_id in DevToolsObserver.OnSubresourceWebBundleInnerResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DevToolsObserver.OnSubresourceWebBundleInnerResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_request_devtools_id)::BaseType> bundle_request_devtools_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_bundle_request_devtools_id, bundle_request_devtools_id_fragment);
  params->bundle_request_devtools_id.Set(
      bundle_request_devtools_id_fragment.is_null() ? nullptr : bundle_request_devtools_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleInnerResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::OnSubresourceWebBundleInnerResponseError(
    const std::string& in_inner_request_devtools_id, const ::GURL& in_url, const std::string& in_error_message, const absl::optional<std::string>& in_bundle_request_devtools_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inner_request_devtools_id"), in_inner_request_devtools_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_request_devtools_id"), in_bundle_request_devtools_id,
                        "<value of type const absl::optional<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponseError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->inner_request_devtools_id)::BaseType> inner_request_devtools_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_inner_request_devtools_id, inner_request_devtools_id_fragment);
  params->inner_request_devtools_id.Set(
      inner_request_devtools_id_fragment.is_null() ? nullptr : inner_request_devtools_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->inner_request_devtools_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inner_request_devtools_id in DevToolsObserver.OnSubresourceWebBundleInnerResponseError request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DevToolsObserver.OnSubresourceWebBundleInnerResponseError request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in DevToolsObserver.OnSubresourceWebBundleInnerResponseError request");
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_request_devtools_id)::BaseType> bundle_request_devtools_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_bundle_request_devtools_id, bundle_request_devtools_id_fragment);
  params->bundle_request_devtools_id.Set(
      bundle_request_devtools_id_fragment.is_null() ? nullptr : bundle_request_devtools_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("OnSubresourceWebBundleInnerResponseError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsObserverProxy::Clone(
    ::mojo::PendingReceiver<DevToolsObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DevToolsObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<DevToolsObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsObserver_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DevToolsObserver_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in DevToolsObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DevToolsObserverStubDispatch::Accept(
    DevToolsObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDevToolsObserver_OnRawRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnRawRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnRawRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnRawRequest_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnRawRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::net::CookieWithAccessResult> p_cookies_with_access_result{};
      std::vector<::network::mojom::HttpRawHeaderPairPtr> p_headers{};
      ::network::mojom::ClientSecurityStatePtr p_client_security_state{};
      DevToolsObserver_OnRawRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadCookiesWithAccessResult(&p_cookies_with_access_result))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRawRequest(
std::move(p_devtool_request_id), 
std::move(p_cookies_with_access_result), 
std::move(p_headers), 
std::move(p_client_security_state));
      return true;
    }
    case internal::kDevToolsObserver_OnRawResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnRawResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnRawResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnRawResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnRawResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::net::CookieAndLineWithAccessResult> p_cookies_with_access_result{};
      std::vector<::network::mojom::HttpRawHeaderPairPtr> p_headers{};
      absl::optional<std::string> p_raw_response_headers{};
      ::network::mojom::IPAddressSpace p_resource_address_space{};
      int32_t p_http_status_code{};
      DevToolsObserver_OnRawResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadCookiesWithAccessResult(&p_cookies_with_access_result))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRawResponseHeaders(&p_raw_response_headers))
        success = false;
      if (success && !input_data_view.ReadResourceAddressSpace(&p_resource_address_space))
        success = false;
      if (success)
        p_http_status_code = input_data_view.http_status_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRawResponse(
std::move(p_devtool_request_id), 
std::move(p_cookies_with_access_result), 
std::move(p_headers), 
std::move(p_raw_response_headers), 
std::move(p_resource_address_space), 
std::move(p_http_status_code));
      return true;
    }
    case internal::kDevToolsObserver_OnPrivateNetworkRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnPrivateNetworkRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnPrivateNetworkRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<std::string> p_devtool_request_id{};
      ::GURL p_url{};
      bool p_is_warning{};
      ::network::mojom::IPAddressSpace p_resource_address_space{};
      ::network::mojom::ClientSecurityStatePtr p_client_security_state{};
      DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_is_warning = input_data_view.is_warning();
      if (success && !input_data_view.ReadResourceAddressSpace(&p_resource_address_space))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrivateNetworkRequest(
std::move(p_devtool_request_id), 
std::move(p_url), 
std::move(p_is_warning), 
std::move(p_resource_address_space), 
std::move(p_client_security_state));
      return true;
    }
    case internal::kDevToolsObserver_OnCorsPreflightRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnCorsPreflightRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnCorsPreflightRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_devtool_request_id{};
      ::net::HttpRequestHeaders p_request_headers{};
      URLRequestDevToolsInfoPtr p_request_info{};
      ::GURL p_initiator_url{};
      std::string p_initiator_devtool_request_id{};
      DevToolsObserver_OnCorsPreflightRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadRequestHeaders(&p_request_headers))
        success = false;
      if (success && !input_data_view.ReadRequestInfo(&p_request_info))
        success = false;
      if (success && !input_data_view.ReadInitiatorUrl(&p_initiator_url))
        success = false;
      if (success && !input_data_view.ReadInitiatorDevtoolRequestId(&p_initiator_devtool_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightRequest(
std::move(p_devtool_request_id), 
std::move(p_request_headers), 
std::move(p_request_info), 
std::move(p_initiator_url), 
std::move(p_initiator_devtool_request_id));
      return true;
    }
    case internal::kDevToolsObserver_OnCorsPreflightResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnCorsPreflightResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnCorsPreflightResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_devtool_request_id{};
      ::GURL p_url{};
      ::network::mojom::URLResponseHeadPtr p_head{};
      DevToolsObserver_OnCorsPreflightResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightResponse(
std::move(p_devtool_request_id), 
std::move(p_url), 
std::move(p_head));
      return true;
    }
    case internal::kDevToolsObserver_OnCorsPreflightRequestCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnCorsPreflightRequestCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_devtool_request_id{};
      ::network::URLLoaderCompletionStatus p_status{};
      DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightRequestCompleted(
std::move(p_devtool_request_id), 
std::move(p_status));
      return true;
    }
    case internal::kDevToolsObserver_OnTrustTokenOperationDone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnTrustTokenOperationDone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnTrustTokenOperationDone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_devtool_request_id{};
      ::network::mojom::TrustTokenOperationResultPtr p_result{};
      DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTrustTokenOperationDone(
std::move(p_devtool_request_id), 
std::move(p_result));
      return true;
    }
    case internal::kDevToolsObserver_OnCorsError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnCorsError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnCorsError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnCorsError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnCorsError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<std::string> p_devtool_request_id{};
      absl::optional<::url::Origin> p_initiator_origin{};
      ::GURL p_url{};
      ::network::CorsErrorStatus p_status{};
      DevToolsObserver_OnCorsError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadInitiatorOrigin(&p_initiator_origin))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsError(
std::move(p_devtool_request_id), 
std::move(p_initiator_origin), 
std::move(p_url), 
std::move(p_status));
      return true;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_devtool_request_id{};
      std::vector<::GURL> p_urls{};
      DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleMetadata(
std::move(p_devtool_request_id), 
std::move(p_urls));
      return true;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleMetadataError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleMetadataError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_devtool_request_id{};
      std::string p_error_message{};
      DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleMetadataError(
std::move(p_devtool_request_id), 
std::move(p_error_message));
      return true;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_inner_request_devtools_id{};
      ::GURL p_url{};
      absl::optional<std::string> p_bundle_request_devtools_id{};
      DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInnerRequestDevtoolsId(&p_inner_request_devtools_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadBundleRequestDevtoolsId(&p_bundle_request_devtools_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleInnerResponse(
std::move(p_inner_request_devtools_id), 
std::move(p_url), 
std::move(p_bundle_request_devtools_id));
      return true;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponseError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::OnSubresourceWebBundleInnerResponseError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_inner_request_devtools_id{};
      ::GURL p_url{};
      std::string p_error_message{};
      absl::optional<std::string> p_bundle_request_devtools_id{};
      DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInnerRequestDevtoolsId(&p_inner_request_devtools_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (success && !input_data_view.ReadBundleRequestDevtoolsId(&p_bundle_request_devtools_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubresourceWebBundleInnerResponseError(
std::move(p_inner_request_devtools_id), 
std::move(p_url), 
std::move(p_error_message), 
std::move(p_bundle_request_devtools_id));
      return true;
    }
    case internal::kDevToolsObserver_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DevToolsObserver::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DevToolsObserver::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::DevToolsObserver_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<DevToolsObserver> p_listener{};
      DevToolsObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsObserver::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsObserverStubDispatch::AcceptWithResponder(
    DevToolsObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDevToolsObserver_OnRawRequest_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnRawResponse_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnPrivateNetworkRequest_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnCorsPreflightRequest_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnCorsPreflightResponse_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnCorsPreflightRequestCompleted_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnTrustTokenOperationDone_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnCorsError_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleMetadata_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleMetadataError_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponse_Name: {
      break;
    }
    case internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponseError_Name: {
      break;
    }
    case internal::kDevToolsObserver_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDevToolsObserverValidationInfo[] = {
    {internal::kDevToolsObserver_OnRawRequest_Name,
     {&internal::DevToolsObserver_OnRawRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnRawResponse_Name,
     {&internal::DevToolsObserver_OnRawResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnPrivateNetworkRequest_Name,
     {&internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnCorsPreflightRequest_Name,
     {&internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnCorsPreflightResponse_Name,
     {&internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnCorsPreflightRequestCompleted_Name,
     {&internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnTrustTokenOperationDone_Name,
     {&internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnCorsError_Name,
     {&internal::DevToolsObserver_OnCorsError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnSubresourceWebBundleMetadata_Name,
     {&internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnSubresourceWebBundleMetadataError_Name,
     {&internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponse_Name,
     {&internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_OnSubresourceWebBundleInnerResponseError_Name,
     {&internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevToolsObserver_Clone_Name,
     {&internal::DevToolsObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DevToolsObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::DevToolsObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDevToolsObserverValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::URLRequestDevToolsInfo::DataView, ::network::mojom::URLRequestDevToolsInfoPtr>::Read(
    ::network::mojom::URLRequestDevToolsInfo::DataView input,
    ::network::mojom::URLRequestDevToolsInfoPtr* output) {
  bool success = true;
  ::network::mojom::URLRequestDevToolsInfoPtr result(::network::mojom::URLRequestDevToolsInfo::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success)
        result->has_user_gesture = input.has_user_gesture();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif