// services/network/public/mojom/network_context.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/network_context.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/read_only_file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/address_list.mojom.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom.h"
#include "services/network/public/mojom/cert_verifier_service.mojom.h"
#include "services/network/public/mojom/client_security_state.mojom.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/default_credentials.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom.h"
#include "services/network/public/mojom/mdns_responder.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom.h"
#include "services/network/public/mojom/network_isolation_key.mojom.h"
#include "services/network/public/mojom/isolation_info.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/origin_policy_manager.mojom.h"
#include "services/network/public/mojom/parsed_headers.mojom.h"
#include "services/network/public/mojom/p2p.mojom.h"
#include "services/network/public/mojom/p2p_trusted.mojom.h"
#include "services/network/public/mojom/proxy_config.mojom.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "services/network/public/mojom/ssl_config.mojom.h"
#include "services/network/public/mojom/tcp_socket.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/udp_socket.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/websocket.mojom.h"
#include "services/network/public/mojom/web_transport.mojom.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_JUMBO_H_
#include "components/content_settings/core/common/content_settings_param_traits.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#endif


namespace network {
namespace mojom {


void CustomProxyConnectionObserverInterceptorForTesting::OnFallback(const ::net::ProxyServer& bad_proxy, int32_t net_error) {
  GetForwardingInterface()->OnFallback(std::move(bad_proxy), std::move(net_error));
}
void CustomProxyConnectionObserverInterceptorForTesting::OnTunnelHeadersReceived(const ::net::ProxyServer& proxy_server, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) {
  GetForwardingInterface()->OnTunnelHeadersReceived(std::move(proxy_server), std::move(response_headers));
}
CustomProxyConnectionObserverAsyncWaiter::CustomProxyConnectionObserverAsyncWaiter(
    CustomProxyConnectionObserver* proxy) : proxy_(proxy) {}

CustomProxyConnectionObserverAsyncWaiter::~CustomProxyConnectionObserverAsyncWaiter() = default;




void CustomProxyConfigClientInterceptorForTesting::OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config) {
  GetForwardingInterface()->OnCustomProxyConfigUpdated(std::move(proxy_config));
}
void CustomProxyConfigClientInterceptorForTesting::MarkProxiesAsBad(::base::TimeDelta bypass_duration, const ::net::ProxyList& bad_proxies, MarkProxiesAsBadCallback callback) {
  GetForwardingInterface()->MarkProxiesAsBad(std::move(bypass_duration), std::move(bad_proxies), std::move(callback));
}
void CustomProxyConfigClientInterceptorForTesting::ClearBadProxiesCache() {
  GetForwardingInterface()->ClearBadProxiesCache();
}
CustomProxyConfigClientAsyncWaiter::CustomProxyConfigClientAsyncWaiter(
    CustomProxyConfigClient* proxy) : proxy_(proxy) {}

CustomProxyConfigClientAsyncWaiter::~CustomProxyConfigClientAsyncWaiter() = default;

void CustomProxyConfigClientAsyncWaiter::MarkProxiesAsBad(
    ::base::TimeDelta bypass_duration, const ::net::ProxyList& bad_proxies) {
  base::RunLoop loop;
  proxy_->MarkProxiesAsBad(std::move(bypass_duration),std::move(bad_proxies),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void TrustedHeaderClientInterceptorForTesting::OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) {
  GetForwardingInterface()->OnBeforeSendHeaders(std::move(headers), std::move(callback));
}
void TrustedHeaderClientInterceptorForTesting::OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) {
  GetForwardingInterface()->OnHeadersReceived(std::move(headers), std::move(remote_endpoint), std::move(callback));
}
TrustedHeaderClientAsyncWaiter::TrustedHeaderClientAsyncWaiter(
    TrustedHeaderClient* proxy) : proxy_(proxy) {}

TrustedHeaderClientAsyncWaiter::~TrustedHeaderClientAsyncWaiter() = default;

void TrustedHeaderClientAsyncWaiter::OnBeforeSendHeaders(
    const ::net::HttpRequestHeaders& headers, int32_t* out_result, absl::optional<::net::HttpRequestHeaders>* out_headers) {
  base::RunLoop loop;
  proxy_->OnBeforeSendHeaders(std::move(headers),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             absl::optional<::net::HttpRequestHeaders>* out_headers
,
             int32_t result,
             const absl::optional<::net::HttpRequestHeaders>& headers) {*out_result = std::move(result);*out_headers = std::move(headers);
            loop->Quit();
          },
          &loop,
          out_result,
          out_headers));
  loop.Run();
}
void TrustedHeaderClientAsyncWaiter::OnHeadersReceived(
    const std::string& headers, const ::net::IPEndPoint& remote_endpoint, int32_t* out_result, absl::optional<std::string>* out_headers, absl::optional<::GURL>* out_preserve_fragment_on_redirect_url) {
  base::RunLoop loop;
  proxy_->OnHeadersReceived(std::move(headers),std::move(remote_endpoint),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             absl::optional<std::string>* out_headers
,
             absl::optional<::GURL>* out_preserve_fragment_on_redirect_url
,
             int32_t result,
             const absl::optional<std::string>& headers,
             const absl::optional<::GURL>& preserve_fragment_on_redirect_url) {*out_result = std::move(result);*out_headers = std::move(headers);*out_preserve_fragment_on_redirect_url = std::move(preserve_fragment_on_redirect_url);
            loop->Quit();
          },
          &loop,
          out_result,
          out_headers,
          out_preserve_fragment_on_redirect_url));
  loop.Run();
}



void TrustedURLLoaderHeaderClientInterceptorForTesting::OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) {
  GetForwardingInterface()->OnLoaderCreated(std::move(request_id), std::move(header_client));
}
void TrustedURLLoaderHeaderClientInterceptorForTesting::OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) {
  GetForwardingInterface()->OnLoaderForCorsPreflightCreated(std::move(request), std::move(header_client));
}
TrustedURLLoaderHeaderClientAsyncWaiter::TrustedURLLoaderHeaderClientAsyncWaiter(
    TrustedURLLoaderHeaderClient* proxy) : proxy_(proxy) {}

TrustedURLLoaderHeaderClientAsyncWaiter::~TrustedURLLoaderHeaderClientAsyncWaiter() = default;




void NetworkContextClientInterceptorForTesting::OnFileUploadRequested(int32_t process_id, bool async, const std::vector<::base::FilePath>& file_paths, OnFileUploadRequestedCallback callback) {
  GetForwardingInterface()->OnFileUploadRequested(std::move(process_id), std::move(async), std::move(file_paths), std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnCanSendReportingReports(const std::vector<::url::Origin>& origins, OnCanSendReportingReportsCallback callback) {
  GetForwardingInterface()->OnCanSendReportingReports(std::move(origins), std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnCanSendDomainReliabilityUpload(const ::GURL& origin, OnCanSendDomainReliabilityUploadCallback callback) {
  GetForwardingInterface()->OnCanSendDomainReliabilityUpload(std::move(origin), std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnTrustTokenIssuanceDivertedToSystem(::network::mojom::FulfillTrustTokenIssuanceRequestPtr request, OnTrustTokenIssuanceDivertedToSystemCallback callback) {
  GetForwardingInterface()->OnTrustTokenIssuanceDivertedToSystem(std::move(request), std::move(callback));
}
NetworkContextClientAsyncWaiter::NetworkContextClientAsyncWaiter(
    NetworkContextClient* proxy) : proxy_(proxy) {}

NetworkContextClientAsyncWaiter::~NetworkContextClientAsyncWaiter() = default;

void NetworkContextClientAsyncWaiter::OnFileUploadRequested(
    int32_t process_id, bool async, const std::vector<::base::FilePath>& file_paths, int32_t* out_net_error, std::vector<::base::File>* out_files) {
  base::RunLoop loop;
  proxy_->OnFileUploadRequested(std::move(process_id),std::move(async),std::move(file_paths),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             std::vector<::base::File>* out_files
,
             int32_t net_error,
             std::vector<::base::File> files) {*out_net_error = std::move(net_error);*out_files = std::move(files);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_files));
  loop.Run();
}
void NetworkContextClientAsyncWaiter::OnCanSendReportingReports(
    const std::vector<::url::Origin>& origins, std::vector<::url::Origin>* out_origins) {
  base::RunLoop loop;
  proxy_->OnCanSendReportingReports(std::move(origins),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::url::Origin>* out_origins
,
             const std::vector<::url::Origin>& origins) {*out_origins = std::move(origins);
            loop->Quit();
          },
          &loop,
          out_origins));
  loop.Run();
}
void NetworkContextClientAsyncWaiter::OnCanSendDomainReliabilityUpload(
    const ::GURL& origin, bool* out_allowed) {
  base::RunLoop loop;
  proxy_->OnCanSendDomainReliabilityUpload(std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}
void NetworkContextClientAsyncWaiter::OnTrustTokenIssuanceDivertedToSystem(
    ::network::mojom::FulfillTrustTokenIssuanceRequestPtr request, ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr* out_response) {
  base::RunLoop loop;
  proxy_->OnTrustTokenIssuanceDivertedToSystem(std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr* out_response
,
             ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}



void NetworkContextInterceptorForTesting::SetClient(::mojo::PendingRemote<NetworkContextClient> client) {
  GetForwardingInterface()->SetClient(std::move(client));
}
void NetworkContextInterceptorForTesting::CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) {
  GetForwardingInterface()->CreateURLLoaderFactory(std::move(url_loader_factory), std::move(params));
}
void NetworkContextInterceptorForTesting::ResetURLLoaderFactories() {
  GetForwardingInterface()->ResetURLLoaderFactories();
}
void NetworkContextInterceptorForTesting::GetCookieManager(::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager) {
  GetForwardingInterface()->GetCookieManager(std::move(cookie_manager));
}
void NetworkContextInterceptorForTesting::GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole role, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer) {
  GetForwardingInterface()->GetRestrictedCookieManager(std::move(restricted_cookie_manager), std::move(role), std::move(origin), std::move(isolation_info), std::move(cookie_observer));
}
void NetworkContextInterceptorForTesting::GetHasTrustTokensAnswerer(::mojo::PendingReceiver<::network::mojom::HasTrustTokensAnswerer> has_trust_tokens_answerer, const ::url::Origin& top_frame_origin) {
  GetForwardingInterface()->GetHasTrustTokensAnswerer(std::move(has_trust_tokens_answerer), std::move(top_frame_origin));
}
void NetworkContextInterceptorForTesting::ClearTrustTokenData(ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) {
  GetForwardingInterface()->ClearTrustTokenData(std::move(filter), std::move(callback));
}
void NetworkContextInterceptorForTesting::GetStoredTrustTokenCounts(GetStoredTrustTokenCountsCallback callback) {
  GetForwardingInterface()->GetStoredTrustTokenCounts(std::move(callback));
}
void NetworkContextInterceptorForTesting::DeleteStoredTrustTokens(const ::url::Origin& issuer, DeleteStoredTrustTokensCallback callback) {
  GetForwardingInterface()->DeleteStoredTrustTokens(std::move(issuer), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) {
  GetForwardingInterface()->ClearNetworkingHistoryBetween(std::move(start_time), std::move(end_time), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearHttpCache(::base::Time start_time, ::base::Time end_time, ClearDataFilterPtr filter, ClearHttpCacheCallback callback) {
  GetForwardingInterface()->ClearHttpCache(std::move(start_time), std::move(end_time), std::move(filter), std::move(callback));
}
void NetworkContextInterceptorForTesting::ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) {
  GetForwardingInterface()->ComputeHttpCacheSize(std::move(start_time), std::move(end_time), std::move(callback));
}
void NetworkContextInterceptorForTesting::NotifyExternalCacheHit(const ::GURL& url, const std::string& http_method, const ::net::NetworkIsolationKey& key, bool is_subframe_document_resource) {
  GetForwardingInterface()->NotifyExternalCacheHit(std::move(url), std::move(http_method), std::move(key), std::move(is_subframe_document_resource));
}
void NetworkContextInterceptorForTesting::ClearHostCache(ClearDataFilterPtr filter, ClearHostCacheCallback callback) {
  GetForwardingInterface()->ClearHostCache(std::move(filter), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ClearHttpAuthCacheCallback callback) {
  GetForwardingInterface()->ClearHttpAuthCache(std::move(start_time), std::move(end_time), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearReportingCacheReports(ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) {
  GetForwardingInterface()->ClearReportingCacheReports(std::move(filter), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearReportingCacheClients(ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) {
  GetForwardingInterface()->ClearReportingCacheClients(std::move(filter), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearNetworkErrorLogging(ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) {
  GetForwardingInterface()->ClearNetworkErrorLogging(std::move(filter), std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearDomainReliability(ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) {
  GetForwardingInterface()->ClearDomainReliability(std::move(filter), std::move(mode), std::move(callback));
}
void NetworkContextInterceptorForTesting::GetDomainReliabilityJSON(GetDomainReliabilityJSONCallback callback) {
  GetForwardingInterface()->GetDomainReliabilityJSON(std::move(callback));
}
void NetworkContextInterceptorForTesting::SetDocumentReportingEndpoints(const ::url::Origin& origin, const ::net::NetworkIsolationKey& network_isolation_key, const base::flat_map<std::string, std::string>& endpoints) {
  GetForwardingInterface()->SetDocumentReportingEndpoints(std::move(origin), std::move(network_isolation_key), std::move(endpoints));
}
void NetworkContextInterceptorForTesting::QueueReport(const std::string& type, const std::string& group, const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, const absl::optional<std::string>& user_agent, ::base::Value body) {
  GetForwardingInterface()->QueueReport(std::move(type), std::move(group), std::move(url), std::move(network_isolation_key), std::move(user_agent), std::move(body));
}
void NetworkContextInterceptorForTesting::QueueSignedExchangeReport(SignedExchangeReportPtr report, const ::net::NetworkIsolationKey& network_isolation_key) {
  GetForwardingInterface()->QueueSignedExchangeReport(std::move(report), std::move(network_isolation_key));
}
void NetworkContextInterceptorForTesting::CloseAllConnections(CloseAllConnectionsCallback callback) {
  GetForwardingInterface()->CloseAllConnections(std::move(callback));
}
void NetworkContextInterceptorForTesting::CloseIdleConnections(CloseIdleConnectionsCallback callback) {
  GetForwardingInterface()->CloseIdleConnections(std::move(callback));
}
void NetworkContextInterceptorForTesting::SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, NetworkConditionsPtr conditions) {
  GetForwardingInterface()->SetNetworkConditions(std::move(throttling_profile_id), std::move(conditions));
}
void NetworkContextInterceptorForTesting::SetAcceptLanguage(const std::string& new_accept_language) {
  GetForwardingInterface()->SetAcceptLanguage(std::move(new_accept_language));
}
void NetworkContextInterceptorForTesting::SetUserAgent(const std::string& new_user_agent) {
  GetForwardingInterface()->SetUserAgent(std::move(new_user_agent));
}
void NetworkContextInterceptorForTesting::SetEnableReferrers(bool enable_referrers) {
  GetForwardingInterface()->SetEnableReferrers(std::move(enable_referrers));
}
void NetworkContextInterceptorForTesting::SetCTPolicy(CTPolicyPtr ct_policy) {
  GetForwardingInterface()->SetCTPolicy(std::move(ct_policy));
}
void NetworkContextInterceptorForTesting::AddExpectCT(const std::string& host, ::base::Time expiry, bool enforce, const ::GURL& report_uri, const ::net::NetworkIsolationKey& network_isolation_key, AddExpectCTCallback callback) {
  GetForwardingInterface()->AddExpectCT(std::move(host), std::move(expiry), std::move(enforce), std::move(report_uri), std::move(network_isolation_key), std::move(callback));
}
void NetworkContextInterceptorForTesting::SetExpectCTTestReport(const ::GURL& report_uri, SetExpectCTTestReportCallback callback) {
  GetForwardingInterface()->SetExpectCTTestReport(std::move(report_uri), std::move(callback));
}
void NetworkContextInterceptorForTesting::GetExpectCTState(const std::string& domain, const ::net::NetworkIsolationKey& network_isolation_key, GetExpectCTStateCallback callback) {
  GetForwardingInterface()->GetExpectCTState(std::move(domain), std::move(network_isolation_key), std::move(callback));
}
void NetworkContextInterceptorForTesting::CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener) {
  GetForwardingInterface()->CreateUDPSocket(std::move(receiver), std::move(listener));
}
void NetworkContextInterceptorForTesting::CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, uint32_t backlog, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) {
  GetForwardingInterface()->CreateTCPServerSocket(std::move(local_addr), std::move(backlog), std::move(traffic_annotation), std::move(socket), std::move(callback));
}
void NetworkContextInterceptorForTesting::CreateTCPConnectedSocket(const absl::optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) {
  GetForwardingInterface()->CreateTCPConnectedSocket(std::move(local_addr), std::move(remote_addr_list), std::move(tcp_connected_socket_options), std::move(traffic_annotation), std::move(socket), std::move(observer), std::move(callback));
}
void NetworkContextInterceptorForTesting::CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) {
  GetForwardingInterface()->CreateTCPBoundSocket(std::move(local_addr), std::move(traffic_annotation), std::move(socket), std::move(callback));
}
void NetworkContextInterceptorForTesting::CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> factory) {
  GetForwardingInterface()->CreateProxyResolvingSocketFactory(std::move(factory));
}
void NetworkContextInterceptorForTesting::LookUpProxyForURL(const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> proxy_lookup_client) {
  GetForwardingInterface()->LookUpProxyForURL(std::move(url), std::move(network_isolation_key), std::move(proxy_lookup_client));
}
void NetworkContextInterceptorForTesting::ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) {
  GetForwardingInterface()->ForceReloadProxyConfig(std::move(callback));
}
void NetworkContextInterceptorForTesting::ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) {
  GetForwardingInterface()->ClearBadProxiesCache(std::move(callback));
}
void NetworkContextInterceptorForTesting::CreateWebSocket(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, const ::net::IsolationInfo& isolation_info, std::vector<::network::mojom::HttpHeaderPtr> additional_headers, int32_t process_id, const ::url::Origin& origin, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client, const absl::optional<::base::UnguessableToken>& throttling_profile_id) {
  GetForwardingInterface()->CreateWebSocket(std::move(url), std::move(requested_protocols), std::move(site_for_cookies), std::move(isolation_info), std::move(additional_headers), std::move(process_id), std::move(origin), std::move(options), std::move(traffic_annotation), std::move(handshake_client), std::move(url_loader_network_observer), std::move(auth_handler), std::move(header_client), std::move(throttling_profile_id));
}
void NetworkContextInterceptorForTesting::CreateWebTransport(const ::GURL& url, const ::url::Origin& origin, const ::net::NetworkIsolationKey& network_isolation_key, std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> fingerprints, ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> handshake_client) {
  GetForwardingInterface()->CreateWebTransport(std::move(url), std::move(origin), std::move(network_isolation_key), std::move(fingerprints), std::move(handshake_client));
}
void NetworkContextInterceptorForTesting::CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::NetLogExporter> receiver) {
  GetForwardingInterface()->CreateNetLogExporter(std::move(receiver));
}
void NetworkContextInterceptorForTesting::PreconnectSockets(uint32_t num_streams, const ::GURL& url, bool allow_credentials, const ::net::NetworkIsolationKey& network_isolation_key) {
  GetForwardingInterface()->PreconnectSockets(std::move(num_streams), std::move(url), std::move(allow_credentials), std::move(network_isolation_key));
}
void NetworkContextInterceptorForTesting::CreateP2PSocketManager(const ::net::NetworkIsolationKey& network_isolation_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> socket_manager) {
  GetForwardingInterface()->CreateP2PSocketManager(std::move(network_isolation_key), std::move(client), std::move(trusted_socket_manager), std::move(socket_manager));
}
void NetworkContextInterceptorForTesting::CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::MdnsResponder> responder_receiver) {
  GetForwardingInterface()->CreateMdnsResponder(std::move(responder_receiver));
}
void NetworkContextInterceptorForTesting::ResolveHost(const ::net::HostPortPair& host, const ::net::NetworkIsolationKey& network_isolation_key, ::network::mojom::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> response_client) {
  GetForwardingInterface()->ResolveHost(std::move(host), std::move(network_isolation_key), std::move(optional_parameters), std::move(response_client));
}
void NetworkContextInterceptorForTesting::CreateHostResolver(const absl::optional<::net::DnsConfigOverrides>& config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> host_resolver) {
  GetForwardingInterface()->CreateHostResolver(std::move(config_overrides), std::move(host_resolver));
}
void NetworkContextInterceptorForTesting::VerifyCertForSignedExchange(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, const std::string& ocsp_response, const std::string& sct_list, VerifyCertForSignedExchangeCallback callback) {
  GetForwardingInterface()->VerifyCertForSignedExchange(std::move(certificate), std::move(url), std::move(network_isolation_key), std::move(ocsp_response), std::move(sct_list), std::move(callback));
}
void NetworkContextInterceptorForTesting::AddHSTS(const std::string& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) {
  GetForwardingInterface()->AddHSTS(std::move(host), std::move(expiry), std::move(include_subdomains), std::move(callback));
}
void NetworkContextInterceptorForTesting::IsHSTSActiveForHost(const std::string& host, IsHSTSActiveForHostCallback callback) {
  GetForwardingInterface()->IsHSTSActiveForHost(std::move(host), std::move(callback));
}
void NetworkContextInterceptorForTesting::GetHSTSState(const std::string& domain, GetHSTSStateCallback callback) {
  GetForwardingInterface()->GetHSTSState(std::move(domain), std::move(callback));
}
void NetworkContextInterceptorForTesting::SetCorsOriginAccessListsForOrigin(const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) {
  GetForwardingInterface()->SetCorsOriginAccessListsForOrigin(std::move(source_origin), std::move(allow_patterns), std::move(block_patterns), std::move(callback));
}
void NetworkContextInterceptorForTesting::DeleteDynamicDataForHost(const std::string& host, DeleteDynamicDataForHostCallback callback) {
  GetForwardingInterface()->DeleteDynamicDataForHost(std::move(host), std::move(callback));
}
void NetworkContextInterceptorForTesting::SetSplitAuthCacheByNetworkIsolationKey(bool split_auth_cache_by_network_isolation_key) {
  GetForwardingInterface()->SetSplitAuthCacheByNetworkIsolationKey(std::move(split_auth_cache_by_network_isolation_key));
}
void NetworkContextInterceptorForTesting::SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) {
  GetForwardingInterface()->SaveHttpAuthCacheProxyEntries(std::move(callback));
}
void NetworkContextInterceptorForTesting::LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) {
  GetForwardingInterface()->LoadHttpAuthCacheProxyEntries(std::move(cache_key), std::move(callback));
}
void NetworkContextInterceptorForTesting::AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, const ::net::NetworkIsolationKey& network_isolation_key, const ::net::AuthCredentials& credentials, AddAuthCacheEntryCallback callback) {
  GetForwardingInterface()->AddAuthCacheEntry(std::move(challenge), std::move(network_isolation_key), std::move(credentials), std::move(callback));
}
void NetworkContextInterceptorForTesting::LookupServerBasicAuthCredentials(const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, LookupServerBasicAuthCredentialsCallback callback) {
  GetForwardingInterface()->LookupServerBasicAuthCredentials(std::move(url), std::move(network_isolation_key), std::move(callback));
}
void NetworkContextInterceptorForTesting::EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) {
  GetForwardingInterface()->EnableStaticKeyPinningForTesting(std::move(callback));
}
void NetworkContextInterceptorForTesting::VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, VerifyCertificateForTestingCallback callback) {
  GetForwardingInterface()->VerifyCertificateForTesting(std::move(certificate), std::move(hostname), std::move(ocsp_response), std::move(sct_list), std::move(callback));
}
void NetworkContextInterceptorForTesting::AddDomainReliabilityContextForTesting(const ::GURL& origin, const ::GURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) {
  GetForwardingInterface()->AddDomainReliabilityContextForTesting(std::move(origin), std::move(upload_url), std::move(callback));
}
void NetworkContextInterceptorForTesting::ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) {
  GetForwardingInterface()->ForceDomainReliabilityUploadsForTesting(std::move(callback));
}
void NetworkContextInterceptorForTesting::GetOriginPolicyManager(::mojo::PendingReceiver<::network::mojom::OriginPolicyManager> origin_policy_manager) {
  GetForwardingInterface()->GetOriginPolicyManager(std::move(origin_policy_manager));
}
void NetworkContextInterceptorForTesting::SetSCTAuditingEnabled(bool enabled) {
  GetForwardingInterface()->SetSCTAuditingEnabled(std::move(enabled));
}
NetworkContextAsyncWaiter::NetworkContextAsyncWaiter(
    NetworkContext* proxy) : proxy_(proxy) {}

NetworkContextAsyncWaiter::~NetworkContextAsyncWaiter() = default;

void NetworkContextAsyncWaiter::ClearTrustTokenData(
    ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->ClearTrustTokenData(std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::GetStoredTrustTokenCounts(
    std::vector<::network::mojom::StoredTrustTokensForIssuerPtr>* out_tokens) {
  base::RunLoop loop;
  proxy_->GetStoredTrustTokenCounts(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::network::mojom::StoredTrustTokensForIssuerPtr>* out_tokens
,
             std::vector<::network::mojom::StoredTrustTokensForIssuerPtr> tokens) {*out_tokens = std::move(tokens);
            loop->Quit();
          },
          &loop,
          out_tokens));
  loop.Run();
}
void NetworkContextAsyncWaiter::DeleteStoredTrustTokens(
    const ::url::Origin& issuer, ::network::mojom::DeleteStoredTrustTokensStatus* out_status) {
  base::RunLoop loop;
  proxy_->DeleteStoredTrustTokens(std::move(issuer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::DeleteStoredTrustTokensStatus* out_status
,
             ::network::mojom::DeleteStoredTrustTokensStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearNetworkingHistoryBetween(
    ::base::Time start_time, ::base::Time end_time) {
  base::RunLoop loop;
  proxy_->ClearNetworkingHistoryBetween(std::move(start_time),std::move(end_time),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearHttpCache(
    ::base::Time start_time, ::base::Time end_time, ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->ClearHttpCache(std::move(start_time),std::move(end_time),std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ComputeHttpCacheSize(
    ::base::Time start_time, ::base::Time end_time, bool* out_is_upper_bound, int64_t* out_size_or_error) {
  base::RunLoop loop;
  proxy_->ComputeHttpCacheSize(std::move(start_time),std::move(end_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_upper_bound
,
             int64_t* out_size_or_error
,
             bool is_upper_bound,
             int64_t size_or_error) {*out_is_upper_bound = std::move(is_upper_bound);*out_size_or_error = std::move(size_or_error);
            loop->Quit();
          },
          &loop,
          out_is_upper_bound,
          out_size_or_error));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearHostCache(
    ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->ClearHostCache(std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearHttpAuthCache(
    ::base::Time start_time, ::base::Time end_time) {
  base::RunLoop loop;
  proxy_->ClearHttpAuthCache(std::move(start_time),std::move(end_time),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearReportingCacheReports(
    ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->ClearReportingCacheReports(std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearReportingCacheClients(
    ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->ClearReportingCacheClients(std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearNetworkErrorLogging(
    ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->ClearNetworkErrorLogging(std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearDomainReliability(
    ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode) {
  base::RunLoop loop;
  proxy_->ClearDomainReliability(std::move(filter),std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::GetDomainReliabilityJSON(
    ::base::Value* out_data) {
  base::RunLoop loop;
  proxy_->GetDomainReliabilityJSON(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_data
,
             ::base::Value data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}
void NetworkContextAsyncWaiter::CloseAllConnections(
    ) {
  base::RunLoop loop;
  proxy_->CloseAllConnections(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::CloseIdleConnections(
    ) {
  base::RunLoop loop;
  proxy_->CloseIdleConnections(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::AddExpectCT(
    const std::string& host, ::base::Time expiry, bool enforce, const ::GURL& report_uri, const ::net::NetworkIsolationKey& network_isolation_key, bool* out_success) {
  base::RunLoop loop;
  proxy_->AddExpectCT(std::move(host),std::move(expiry),std::move(enforce),std::move(report_uri),std::move(network_isolation_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void NetworkContextAsyncWaiter::SetExpectCTTestReport(
    const ::GURL& report_uri, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetExpectCTTestReport(std::move(report_uri),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void NetworkContextAsyncWaiter::GetExpectCTState(
    const std::string& domain, const ::net::NetworkIsolationKey& network_isolation_key, ::base::Value* out_state) {
  base::RunLoop loop;
  proxy_->GetExpectCTState(std::move(domain),std::move(network_isolation_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_state
,
             ::base::Value state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}
void NetworkContextAsyncWaiter::CreateTCPServerSocket(
    const ::net::IPEndPoint& local_addr, uint32_t backlog, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, int32_t* out_result, absl::optional<::net::IPEndPoint>* out_local_addr_out) {
  base::RunLoop loop;
  proxy_->CreateTCPServerSocket(std::move(local_addr),std::move(backlog),std::move(traffic_annotation),std::move(socket),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             absl::optional<::net::IPEndPoint>* out_local_addr_out
,
             int32_t result,
             const absl::optional<::net::IPEndPoint>& local_addr_out) {*out_result = std::move(result);*out_local_addr_out = std::move(local_addr_out);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr_out));
  loop.Run();
}
void NetworkContextAsyncWaiter::CreateTCPConnectedSocket(
    const absl::optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, int32_t* out_result, absl::optional<::net::IPEndPoint>* out_local_addr, absl::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream) {
  base::RunLoop loop;
  proxy_->CreateTCPConnectedSocket(std::move(local_addr),std::move(remote_addr_list),std::move(tcp_connected_socket_options),std::move(traffic_annotation),std::move(socket),std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             absl::optional<::net::IPEndPoint>* out_local_addr
,
             absl::optional<::net::IPEndPoint>* out_peer_addr
,
             ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_send_stream
,
             int32_t result,
             const absl::optional<::net::IPEndPoint>& local_addr,
             const absl::optional<::net::IPEndPoint>& peer_addr,
             ::mojo::ScopedDataPipeConsumerHandle receive_stream,
             ::mojo::ScopedDataPipeProducerHandle send_stream) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);*out_peer_addr = std::move(peer_addr);*out_receive_stream = std::move(receive_stream);*out_send_stream = std::move(send_stream);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr,
          out_peer_addr,
          out_receive_stream,
          out_send_stream));
  loop.Run();
}
void NetworkContextAsyncWaiter::CreateTCPBoundSocket(
    const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, int32_t* out_result, absl::optional<::net::IPEndPoint>* out_local_addr) {
  base::RunLoop loop;
  proxy_->CreateTCPBoundSocket(std::move(local_addr),std::move(traffic_annotation),std::move(socket),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             absl::optional<::net::IPEndPoint>* out_local_addr
,
             int32_t result,
             const absl::optional<::net::IPEndPoint>& local_addr) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr));
  loop.Run();
}
void NetworkContextAsyncWaiter::ForceReloadProxyConfig(
    ) {
  base::RunLoop loop;
  proxy_->ForceReloadProxyConfig(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ClearBadProxiesCache(
    ) {
  base::RunLoop loop;
  proxy_->ClearBadProxiesCache(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::VerifyCertForSignedExchange(
    const ::scoped_refptr<::net::X509Certificate>& certificate, const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code, ::net::CertVerifyResult* out_cv_result) {
  base::RunLoop loop;
  proxy_->VerifyCertForSignedExchange(std::move(certificate),std::move(url),std::move(network_isolation_key),std::move(ocsp_response),std::move(sct_list),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_error_code
,
             ::net::CertVerifyResult* out_cv_result
,
             int32_t error_code,
             const ::net::CertVerifyResult& cv_result) {*out_error_code = std::move(error_code);*out_cv_result = std::move(cv_result);
            loop->Quit();
          },
          &loop,
          out_error_code,
          out_cv_result));
  loop.Run();
}
void NetworkContextAsyncWaiter::AddHSTS(
    const std::string& host, ::base::Time expiry, bool include_subdomains) {
  base::RunLoop loop;
  proxy_->AddHSTS(std::move(host),std::move(expiry),std::move(include_subdomains),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::IsHSTSActiveForHost(
    const std::string& host, bool* out_result) {
  base::RunLoop loop;
  proxy_->IsHSTSActiveForHost(std::move(host),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void NetworkContextAsyncWaiter::GetHSTSState(
    const std::string& domain, ::base::Value* out_state) {
  base::RunLoop loop;
  proxy_->GetHSTSState(std::move(domain),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_state
,
             ::base::Value state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}
void NetworkContextAsyncWaiter::SetCorsOriginAccessListsForOrigin(
    const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns) {
  base::RunLoop loop;
  proxy_->SetCorsOriginAccessListsForOrigin(std::move(source_origin),std::move(allow_patterns),std::move(block_patterns),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::DeleteDynamicDataForHost(
    const std::string& host, bool* out_result) {
  base::RunLoop loop;
  proxy_->DeleteDynamicDataForHost(std::move(host),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void NetworkContextAsyncWaiter::SaveHttpAuthCacheProxyEntries(
    ::base::UnguessableToken* out_cache_key) {
  base::RunLoop loop;
  proxy_->SaveHttpAuthCacheProxyEntries(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_cache_key
,
             const ::base::UnguessableToken& cache_key) {*out_cache_key = std::move(cache_key);
            loop->Quit();
          },
          &loop,
          out_cache_key));
  loop.Run();
}
void NetworkContextAsyncWaiter::LoadHttpAuthCacheProxyEntries(
    const ::base::UnguessableToken& cache_key) {
  base::RunLoop loop;
  proxy_->LoadHttpAuthCacheProxyEntries(std::move(cache_key),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::AddAuthCacheEntry(
    const ::net::AuthChallengeInfo& challenge, const ::net::NetworkIsolationKey& network_isolation_key, const ::net::AuthCredentials& credentials) {
  base::RunLoop loop;
  proxy_->AddAuthCacheEntry(std::move(challenge),std::move(network_isolation_key),std::move(credentials),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::LookupServerBasicAuthCredentials(
    const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, absl::optional<::net::AuthCredentials>* out_credentials) {
  base::RunLoop loop;
  proxy_->LookupServerBasicAuthCredentials(std::move(url),std::move(network_isolation_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::net::AuthCredentials>* out_credentials
,
             const absl::optional<::net::AuthCredentials>& credentials) {*out_credentials = std::move(credentials);
            loop->Quit();
          },
          &loop,
          out_credentials));
  loop.Run();
}
void NetworkContextAsyncWaiter::EnableStaticKeyPinningForTesting(
    ) {
  base::RunLoop loop;
  proxy_->EnableStaticKeyPinningForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::VerifyCertificateForTesting(
    const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code) {
  base::RunLoop loop;
  proxy_->VerifyCertificateForTesting(std::move(certificate),std::move(hostname),std::move(ocsp_response),std::move(sct_list),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_error_code
,
             int32_t error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}
void NetworkContextAsyncWaiter::AddDomainReliabilityContextForTesting(
    const ::GURL& origin, const ::GURL& upload_url) {
  base::RunLoop loop;
  proxy_->AddDomainReliabilityContextForTesting(std::move(origin),std::move(upload_url),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkContextAsyncWaiter::ForceDomainReliabilityUploadsForTesting(
    ) {
  base::RunLoop loop;
  proxy_->ForceDomainReliabilityUploadsForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif