// services/network/public/mojom/network_service_test.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_service_test.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_service_test.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* ResolverTypeToStringHelper(ResolverType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResolverType::kResolverTypeFail:
      return "kResolverTypeFail";
    case ResolverType::kResolverTypeFailTimeout:
      return "kResolverTypeFailTimeout";
    case ResolverType::kResolverTypeSystem:
      return "kResolverTypeSystem";
    case ResolverType::kResolverTypeIPLiteral:
      return "kResolverTypeIPLiteral";
    case ResolverType::kResolverTypeDirectLookup:
      return "kResolverTypeDirectLookup";
    default:
      return nullptr;
  }
}

std::string ResolverTypeToString(ResolverType value) {
  const char *str = ResolverTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResolverType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResolverType value) {
  return os << ResolverTypeToString(value);
}

static NOINLINE const char* NetworkServiceTest_RequireCTToStringHelper(NetworkServiceTest_RequireCT value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetworkServiceTest_RequireCT::DEFAULT:
      return "DEFAULT";
    case NetworkServiceTest_RequireCT::REQUIRE:
      return "REQUIRE";
    default:
      return nullptr;
  }
}

std::string NetworkServiceTest_RequireCTToString(NetworkServiceTest_RequireCT value) {
  const char *str = NetworkServiceTest_RequireCTToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetworkServiceTest_RequireCT value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetworkServiceTest_RequireCT value) {
  return os << NetworkServiceTest_RequireCTToString(value);
}

namespace internal {


// static
bool Rule_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Rule_Data* object = static_cast<const Rule_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ResolverType_Data
        ::Validate(object->resolver_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_pattern, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_pattern_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host_pattern, validation_context,
                                         &host_pattern_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams replacement_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->replacement, validation_context,
                                         &replacement_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dns_aliases, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams dns_aliases_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->dns_aliases, validation_context,
                                         &dns_aliases_validate_params)) {
    return false;
  }

  return true;
}

Rule_Data::Rule_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_AddRules_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_AddRules_Params_Data* object = static_cast<const NetworkServiceTest_AddRules_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rules, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams rules_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->rules, validation_context,
                                         &rules_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_AddRules_Params_Data::NetworkServiceTest_AddRules_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_AddRules_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_AddRules_ResponseParams_Data* object = static_cast<const NetworkServiceTest_AddRules_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_AddRules_ResponseParams_Data::NetworkServiceTest_AddRules_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SimulateNetworkChange_Params_Data* object = static_cast<const NetworkServiceTest_SimulateNetworkChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SimulateNetworkChange_Params_Data::NetworkServiceTest_SimulateNetworkChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SimulateNetworkQualityChange_Params_Data* object = static_cast<const NetworkServiceTest_SimulateNetworkQualityChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateCrash_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SimulateCrash_Params_Data* object = static_cast<const NetworkServiceTest_SimulateCrash_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SimulateCrash_Params_Data::NetworkServiceTest_SimulateCrash_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data* object = static_cast<const NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data* object = static_cast<const NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data* object = static_cast<const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cert, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_pattern, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_pattern_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host_pattern, validation_context,
                                         &host_pattern_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->verify_result, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->verify_result, validation_context))
    return false;

  return true;
}

NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data* object = static_cast<const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetRequireCT_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetRequireCT_Params_Data* object = static_cast<const NetworkServiceTest_SetRequireCT_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::NetworkServiceTest_RequireCT_Data
        ::Validate(object->required, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SetRequireCT_Params_Data::NetworkServiceTest_SetRequireCT_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetRequireCT_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetRequireCT_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SetRequireCT_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetRequireCT_ResponseParams_Data::NetworkServiceTest_SetRequireCT_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetTransportSecurityStateSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetTransportSecurityStateSource_Params_Data* object = static_cast<const NetworkServiceTest_SetTransportSecurityStateSource_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetTransportSecurityStateSource_Params_Data::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data* object = static_cast<const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_CrashOnResolveHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_CrashOnResolveHost_Params_Data* object = static_cast<const NetworkServiceTest_CrashOnResolveHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_CrashOnResolveHost_Params_Data::NetworkServiceTest_CrashOnResolveHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_CrashOnGetCookieList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_CrashOnGetCookieList_Params_Data* object = static_cast<const NetworkServiceTest_CrashOnGetCookieList_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_CrashOnGetCookieList_Params_Data::NetworkServiceTest_CrashOnGetCookieList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data* object = static_cast<const NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data* object = static_cast<const NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::MemoryPressureLevel_Data
        ::Validate(object->memory_pressure_level, validation_context))
    return false;

  return true;
}

NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data* object = static_cast<const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data* object = static_cast<const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetEnvironmentVariableValue_Params_Data* object = static_cast<const NetworkServiceTest_GetEnvironmentVariableValue_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data* object = static_cast<const NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_Log_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_Log_Params_Data* object = static_cast<const NetworkServiceTest_Log_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_Log_Params_Data::NetworkServiceTest_Log_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_Log_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_Log_ResponseParams_Data* object = static_cast<const NetworkServiceTest_Log_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_Log_ResponseParams_Data::NetworkServiceTest_Log_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ActivateFieldTrial_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_ActivateFieldTrial_Params_Data* object = static_cast<const NetworkServiceTest_ActivateFieldTrial_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_trial_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams field_trial_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->field_trial_name, validation_context,
                                         &field_trial_name_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_ActivateFieldTrial_Params_Data::NetworkServiceTest_ActivateFieldTrial_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetFirstPartySetEntriesCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetFirstPartySetEntriesCount_Params_Data* object = static_cast<const NetworkServiceTest_GetFirstPartySetEntriesCount_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetFirstPartySetEntriesCount_Params_Data::NetworkServiceTest_GetFirstPartySetEntriesCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetFirstPartySetEntriesCount_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetFirstPartySetEntriesCount_ResponseParams_Data* object = static_cast<const NetworkServiceTest_GetFirstPartySetEntriesCount_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetFirstPartySetEntriesCount_ResponseParams_Data::NetworkServiceTest_GetFirstPartySetEntriesCount_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data* object = static_cast<const NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->delay, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetSCTAuditingPendingReportsCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetSCTAuditingPendingReportsCount_Params_Data* object = static_cast<const NetworkServiceTest_GetSCTAuditingPendingReportsCount_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetSCTAuditingPendingReportsCount_Params_Data::NetworkServiceTest_GetSCTAuditingPendingReportsCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetSCTAuditingPendingReportsCount_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_GetSCTAuditingPendingReportsCount_ResponseParams_Data* object = static_cast<const NetworkServiceTest_GetSCTAuditingPendingReportsCount_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_GetSCTAuditingPendingReportsCount_ResponseParams_Data::NetworkServiceTest_GetSCTAuditingPendingReportsCount_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetSCTAuditingReportCompletionCallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetSCTAuditingReportCompletionCallback_Params_Data* object = static_cast<const NetworkServiceTest_SetSCTAuditingReportCompletionCallback_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetSCTAuditingReportCompletionCallback_Params_Data::NetworkServiceTest_SetSCTAuditingReportCompletionCallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetSCTAuditingReportCompletionCallback_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceTest_SetSCTAuditingReportCompletionCallback_ResponseParams_Data* object = static_cast<const NetworkServiceTest_SetSCTAuditingReportCompletionCallback_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceTest_SetSCTAuditingReportCompletionCallback_ResponseParams_Data::NetworkServiceTest_SetSCTAuditingReportCompletionCallback_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolverType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ResolverType value) {
  return std::move(context).WriteString(::network::mojom::ResolverTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetworkServiceTest_RequireCT>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NetworkServiceTest_RequireCT value) {
  return std::move(context).WriteString(::network::mojom::NetworkServiceTest_RequireCTToString(value));
}

} // namespace perfetto
