// services/network/public/mojom/p2p.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/p2p.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/p2p.mojom-params-data.h"
#include "services/network/public/mojom/p2p.mojom-shared-message-ids.h"

#include "services/network/public/mojom/p2p.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char P2PNetworkNotificationClient::Name_[] = "network.mojom.P2PNetworkNotificationClient";

P2PNetworkNotificationClientProxy::P2PNetworkNotificationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PNetworkNotificationClientProxy::NetworkListChanged(
    const std::vector<::net::NetworkInterface>& in_networks, const ::net::IPAddress& in_default_ipv4_local_address, const ::net::IPAddress& in_default_ipv6_local_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PNetworkNotificationClient::NetworkListChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("networks"), in_networks,
                        "<value of type const std::vector<::net::NetworkInterface>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_ipv4_local_address"), in_default_ipv4_local_address,
                        "<value of type const ::net::IPAddress&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_ipv6_local_address"), in_default_ipv6_local_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PNetworkNotificationClient_NetworkListChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->networks)::BaseType>
      networks_fragment(params.message());
  const mojo::internal::ContainerValidateParams networks_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>>(
      in_networks, networks_fragment, &networks_validate_params);
  params->networks.Set(
      networks_fragment.is_null() ? nullptr : networks_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->networks.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null networks in P2PNetworkNotificationClient.NetworkListChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_ipv4_local_address)::BaseType> default_ipv4_local_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_default_ipv4_local_address, default_ipv4_local_address_fragment);
  params->default_ipv4_local_address.Set(
      default_ipv4_local_address_fragment.is_null() ? nullptr : default_ipv4_local_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_ipv4_local_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_ipv4_local_address in P2PNetworkNotificationClient.NetworkListChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_ipv6_local_address)::BaseType> default_ipv6_local_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_default_ipv6_local_address, default_ipv6_local_address_fragment);
  params->default_ipv6_local_address.Set(
      default_ipv6_local_address_fragment.is_null() ? nullptr : default_ipv6_local_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_ipv6_local_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_ipv6_local_address in P2PNetworkNotificationClient.NetworkListChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PNetworkNotificationClient::Name_);
  message.set_method_name("NetworkListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool P2PNetworkNotificationClientStubDispatch::Accept(
    P2PNetworkNotificationClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kP2PNetworkNotificationClient_NetworkListChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PNetworkNotificationClient::NetworkListChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PNetworkNotificationClient::NetworkListChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data* params =
          reinterpret_cast<internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::net::NetworkInterface> p_networks{};
      ::net::IPAddress p_default_ipv4_local_address{};
      ::net::IPAddress p_default_ipv6_local_address{};
      P2PNetworkNotificationClient_NetworkListChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNetworks(&p_networks))
        success = false;
      if (success && !input_data_view.ReadDefaultIpv4LocalAddress(&p_default_ipv4_local_address))
        success = false;
      if (success && !input_data_view.ReadDefaultIpv6LocalAddress(&p_default_ipv6_local_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PNetworkNotificationClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NetworkListChanged(
std::move(p_networks), 
std::move(p_default_ipv4_local_address), 
std::move(p_default_ipv6_local_address));
      return true;
    }
  }
  return false;
}

// static
bool P2PNetworkNotificationClientStubDispatch::AcceptWithResponder(
    P2PNetworkNotificationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kP2PNetworkNotificationClient_NetworkListChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PNetworkNotificationClientValidationInfo[] = {
    {internal::kP2PNetworkNotificationClient_NetworkListChanged_Name,
     {&internal::P2PNetworkNotificationClient_NetworkListChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PNetworkNotificationClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::P2PNetworkNotificationClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kP2PNetworkNotificationClientValidationInfo);
}

const char P2PSocketManager::Name_[] = "network.mojom.P2PSocketManager";

class P2PSocketManager_GetHostAddress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  P2PSocketManager_GetHostAddress_ForwardToCallback(
      P2PSocketManager::GetHostAddressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  P2PSocketManager::GetHostAddressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(P2PSocketManager_GetHostAddress_ForwardToCallback);
};

P2PSocketManagerProxy::P2PSocketManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PSocketManagerProxy::StartNetworkNotifications(
    ::mojo::PendingRemote<P2PNetworkNotificationClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketManager::StartNetworkNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<P2PNetworkNotificationClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketManager_StartNetworkNotifications_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_StartNetworkNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PNetworkNotificationClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in P2PSocketManager.StartNetworkNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("StartNetworkNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void P2PSocketManagerProxy::GetHostAddress(
    const std::string& in_host_name, bool in_enable_mdns, GetHostAddressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketManager::GetHostAddress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_name"), in_host_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_mdns"), in_enable_mdns,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketManager_GetHostAddress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_GetHostAddress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_name)::BaseType> host_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host_name, host_name_fragment);
  params->host_name.Set(
      host_name_fragment.is_null() ? nullptr : host_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_name in P2PSocketManager.GetHostAddress request");
  params->enable_mdns = in_enable_mdns;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("GetHostAddress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new P2PSocketManager_GetHostAddress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void P2PSocketManagerProxy::CreateSocket(
    ::network::P2PSocketType in_type, const ::net::IPEndPoint& in_local_address, const ::network::P2PPortRange& in_port_range, const ::network::P2PHostAndIPEndPoint& in_remote_address, ::mojo::PendingRemote<P2PSocketClient> in_client, ::mojo::PendingReceiver<P2PSocket> in_socket) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketManager::CreateSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::network::P2PSocketType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_address"), in_local_address,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_range"), in_port_range,
                        "<value of type const ::network::P2PPortRange&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_address"), in_remote_address,
                        "<value of type const ::network::P2PHostAndIPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<P2PSocketClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<P2PSocket>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketManager_CreateSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_CreateSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::P2PSocketType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->local_address)::BaseType> local_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_address, local_address_fragment);
  params->local_address.Set(
      local_address_fragment.is_null() ? nullptr : local_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_address in P2PSocketManager.CreateSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_range)::BaseType> port_range_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::P2PPortRangeDataView>(
      in_port_range, port_range_fragment);
  params->port_range.Set(
      port_range_fragment.is_null() ? nullptr : port_range_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->port_range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null port_range in P2PSocketManager.CreateSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_address)::BaseType> remote_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::P2PHostAndIPEndPointDataView>(
      in_remote_address, remote_address_fragment);
  params->remote_address.Set(
      remote_address_fragment.is_null() ? nullptr : remote_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_address in P2PSocketManager.CreateSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PSocketClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in P2PSocketManager.CreateSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in P2PSocketManager.CreateSocket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("CreateSocket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class P2PSocketManager_GetHostAddress_ProxyToResponder {
 public:
  static P2PSocketManager::GetHostAddressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<P2PSocketManager_GetHostAddress_ProxyToResponder> proxy(
        new P2PSocketManager_GetHostAddress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&P2PSocketManager_GetHostAddress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~P2PSocketManager_GetHostAddress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  P2PSocketManager_GetHostAddress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "P2PSocketManager::GetHostAddressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::net::IPAddress>& in_addresses);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(P2PSocketManager_GetHostAddress_ProxyToResponder);
};

bool P2PSocketManager_GetHostAddress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::P2PSocketManager::GetHostAddressCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::P2PSocketManager_GetHostAddress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::P2PSocketManager_GetHostAddress_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::net::IPAddress> p_addresses{};
  P2PSocketManager_GetHostAddress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddresses(&p_addresses))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        P2PSocketManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_addresses));
  return true;
}

void P2PSocketManager_GetHostAddress_ProxyToResponder::Run(
    const std::vector<::net::IPAddress>& in_addresses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::P2PSocketManager::GetHostAddressCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addresses"), in_addresses,
                        "<value of type const std::vector<::net::IPAddress>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketManager_GetHostAddress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketManager_GetHostAddress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addresses)::BaseType>
      addresses_fragment(params.message());
  const mojo::internal::ContainerValidateParams addresses_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(
      in_addresses, addresses_fragment, &addresses_validate_params);
  params->addresses.Set(
      addresses_fragment.is_null() ? nullptr : addresses_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->addresses.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null addresses in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::P2PSocketManager::GetHostAddressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketManager::Name_);
  message.set_method_name("GetHostAddress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool P2PSocketManagerStubDispatch::Accept(
    P2PSocketManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kP2PSocketManager_StartNetworkNotifications_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketManager::StartNetworkNotifications",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketManager::StartNetworkNotifications");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocketManager_StartNetworkNotifications_Params_Data* params =
          reinterpret_cast<internal::P2PSocketManager_StartNetworkNotifications_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<P2PNetworkNotificationClient> p_client{};
      P2PSocketManager_StartNetworkNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNetworkNotifications(
std::move(p_client));
      return true;
    }
    case internal::kP2PSocketManager_GetHostAddress_Name: {
      break;
    }
    case internal::kP2PSocketManager_CreateSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketManager::CreateSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketManager::CreateSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocketManager_CreateSocket_Params_Data* params =
          reinterpret_cast<internal::P2PSocketManager_CreateSocket_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::P2PSocketType p_type{};
      ::net::IPEndPoint p_local_address{};
      ::network::P2PPortRange p_port_range{};
      ::network::P2PHostAndIPEndPoint p_remote_address{};
      ::mojo::PendingRemote<P2PSocketClient> p_client{};
      ::mojo::PendingReceiver<P2PSocket> p_socket{};
      P2PSocketManager_CreateSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadLocalAddress(&p_local_address))
        success = false;
      if (success && !input_data_view.ReadPortRange(&p_port_range))
        success = false;
      if (success && !input_data_view.ReadRemoteAddress(&p_remote_address))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSocket(
std::move(p_type), 
std::move(p_local_address), 
std::move(p_port_range), 
std::move(p_remote_address), 
std::move(p_client), 
std::move(p_socket));
      return true;
    }
  }
  return false;
}

// static
bool P2PSocketManagerStubDispatch::AcceptWithResponder(
    P2PSocketManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kP2PSocketManager_StartNetworkNotifications_Name: {
      break;
    }
    case internal::kP2PSocketManager_GetHostAddress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketManager::GetHostAddress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketManager::GetHostAddress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::P2PSocketManager_GetHostAddress_Params_Data* params =
          reinterpret_cast<
              internal::P2PSocketManager_GetHostAddress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_host_name{};
      bool p_enable_mdns{};
      P2PSocketManager_GetHostAddress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostName(&p_host_name))
        success = false;
      if (success)
        p_enable_mdns = input_data_view.enable_mdns();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketManager::Name_, 1, false);
        return false;
      }
      P2PSocketManager::GetHostAddressCallback callback =
          P2PSocketManager_GetHostAddress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHostAddress(
std::move(p_host_name), 
std::move(p_enable_mdns), std::move(callback));
      return true;
    }
    case internal::kP2PSocketManager_CreateSocket_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PSocketManagerValidationInfo[] = {
    {internal::kP2PSocketManager_StartNetworkNotifications_Name,
     {&internal::P2PSocketManager_StartNetworkNotifications_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kP2PSocketManager_GetHostAddress_Name,
     {&internal::P2PSocketManager_GetHostAddress_Params_Data::Validate,
      &internal::P2PSocketManager_GetHostAddress_ResponseParams_Data::Validate}},
    {internal::kP2PSocketManager_CreateSocket_Name,
     {&internal::P2PSocketManager_CreateSocket_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PSocketManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::P2PSocketManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kP2PSocketManagerValidationInfo);
}

bool P2PSocketManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::P2PSocketManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kP2PSocketManagerValidationInfo);

}
const char P2PSocket::Name_[] = "network.mojom.P2PSocket";

P2PSocketProxy::P2PSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PSocketProxy::Send(
    const std::vector<int8_t>& in_data, const ::network::P2PPacketInfo& in_packet_info, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocket::Send", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<int8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("packet_info"), in_packet_info,
                        "<value of type const ::network::P2PPacketInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocket_Send_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocket_Send_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in P2PSocket.Send request");
  mojo::internal::MessageFragment<
      typename decltype(params->packet_info)::BaseType> packet_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::P2PPacketInfoDataView>(
      in_packet_info, packet_info_fragment);
  params->packet_info.Set(
      packet_info_fragment.is_null() ? nullptr : packet_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->packet_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null packet_info in P2PSocket.Send request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in P2PSocket.Send request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocket::Name_);
  message.set_method_name("Send");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void P2PSocketProxy::SetOption(
    ::network::P2PSocketOption in_option, int32_t in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocket::SetOption", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("option"), in_option,
                        "<value of type ::network::P2PSocketOption>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocket_SetOption_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocket_SetOption_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::P2PSocketOption>(
      in_option, &params->option);
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocket::Name_);
  message.set_method_name("SetOption");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool P2PSocketStubDispatch::Accept(
    P2PSocket* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kP2PSocket_Send_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocket::Send",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocket::Send");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocket_Send_Params_Data* params =
          reinterpret_cast<internal::P2PSocket_Send_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<int8_t> p_data{};
      ::network::P2PPacketInfo p_packet_info{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      P2PSocket_Send_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadPacketInfo(&p_packet_info))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocket::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Send(
std::move(p_data), 
std::move(p_packet_info), 
std::move(p_traffic_annotation));
      return true;
    }
    case internal::kP2PSocket_SetOption_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocket::SetOption",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocket::SetOption");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocket_SetOption_Params_Data* params =
          reinterpret_cast<internal::P2PSocket_SetOption_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::P2PSocketOption p_option{};
      int32_t p_value{};
      P2PSocket_SetOption_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOption(&p_option))
        success = false;
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocket::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOption(
std::move(p_option), 
std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool P2PSocketStubDispatch::AcceptWithResponder(
    P2PSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kP2PSocket_Send_Name: {
      break;
    }
    case internal::kP2PSocket_SetOption_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PSocketValidationInfo[] = {
    {internal::kP2PSocket_Send_Name,
     {&internal::P2PSocket_Send_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kP2PSocket_SetOption_Name,
     {&internal::P2PSocket_SetOption_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::P2PSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kP2PSocketValidationInfo);
}

const char P2PSocketClient::Name_[] = "network.mojom.P2PSocketClient";

P2PSocketClientProxy::P2PSocketClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void P2PSocketClientProxy::SocketCreated(
    const ::net::IPEndPoint& in_local_address, const ::net::IPEndPoint& in_remote_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketClient::SocketCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_address"), in_local_address,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_address"), in_remote_address,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketClient_SocketCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_SocketCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_address)::BaseType> local_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_address, local_address_fragment);
  params->local_address.Set(
      local_address_fragment.is_null() ? nullptr : local_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_address in P2PSocketClient.SocketCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_address)::BaseType> remote_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_address, remote_address_fragment);
  params->remote_address.Set(
      remote_address_fragment.is_null() ? nullptr : remote_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_address in P2PSocketClient.SocketCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("SocketCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void P2PSocketClientProxy::SendComplete(
    const ::network::P2PSendPacketMetrics& in_send_metrics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketClient::SendComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_metrics"), in_send_metrics,
                        "<value of type const ::network::P2PSendPacketMetrics&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketClient_SendComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_SendComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->send_metrics)::BaseType> send_metrics_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::P2PSendPacketMetricsDataView>(
      in_send_metrics, send_metrics_fragment);
  params->send_metrics.Set(
      send_metrics_fragment.is_null() ? nullptr : send_metrics_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->send_metrics.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null send_metrics in P2PSocketClient.SendComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("SendComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void P2PSocketClientProxy::IncomingTcpConnection(
    const ::net::IPEndPoint& in_socket_address, ::mojo::PendingRemote<P2PSocket> in_socket, ::mojo::PendingReceiver<P2PSocketClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketClient::IncomingTcpConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket_address"), in_socket_address,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingRemote<P2PSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingReceiver<P2PSocketClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketClient_IncomingTcpConnection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_IncomingTcpConnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->socket_address)::BaseType> socket_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_socket_address, socket_address_fragment);
  params->socket_address.Set(
      socket_address_fragment.is_null() ? nullptr : socket_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->socket_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null socket_address in P2PSocketClient.IncomingTcpConnection request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in P2PSocketClient.IncomingTcpConnection request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PSocketClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in P2PSocketClient.IncomingTcpConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("IncomingTcpConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void P2PSocketClientProxy::DataReceived(
    const ::net::IPEndPoint& in_socket_address, const std::vector<int8_t>& in_data, ::base::TimeTicks in_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::P2PSocketClient::DataReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket_address"), in_socket_address,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<int8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kP2PSocketClient_DataReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::P2PSocketClient_DataReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->socket_address)::BaseType> socket_address_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_socket_address, socket_address_fragment);
  params->socket_address.Set(
      socket_address_fragment.is_null() ? nullptr : socket_address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->socket_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null socket_address in P2PSocketClient.DataReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in P2PSocketClient.DataReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp, timestamp_fragment);
  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in P2PSocketClient.DataReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(P2PSocketClient::Name_);
  message.set_method_name("DataReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool P2PSocketClientStubDispatch::Accept(
    P2PSocketClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kP2PSocketClient_SocketCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketClient::SocketCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketClient::SocketCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocketClient_SocketCreated_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_SocketCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::IPEndPoint p_local_address{};
      ::net::IPEndPoint p_remote_address{};
      P2PSocketClient_SocketCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalAddress(&p_local_address))
        success = false;
      if (success && !input_data_view.ReadRemoteAddress(&p_remote_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SocketCreated(
std::move(p_local_address), 
std::move(p_remote_address));
      return true;
    }
    case internal::kP2PSocketClient_SendComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketClient::SendComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketClient::SendComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocketClient_SendComplete_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_SendComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::P2PSendPacketMetrics p_send_metrics{};
      P2PSocketClient_SendComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSendMetrics(&p_send_metrics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendComplete(
std::move(p_send_metrics));
      return true;
    }
    case internal::kP2PSocketClient_IncomingTcpConnection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketClient::IncomingTcpConnection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketClient::IncomingTcpConnection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocketClient_IncomingTcpConnection_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_IncomingTcpConnection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::IPEndPoint p_socket_address{};
      ::mojo::PendingRemote<P2PSocket> p_socket{};
      ::mojo::PendingReceiver<P2PSocketClient> p_client{};
      P2PSocketClient_IncomingTcpConnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSocketAddress(&p_socket_address))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IncomingTcpConnection(
std::move(p_socket_address), 
std::move(p_socket), 
std::move(p_client));
      return true;
    }
    case internal::kP2PSocketClient_DataReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::P2PSocketClient::DataReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::P2PSocketClient::DataReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::P2PSocketClient_DataReceived_Params_Data* params =
          reinterpret_cast<internal::P2PSocketClient_DataReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::IPEndPoint p_socket_address{};
      std::vector<int8_t> p_data{};
      ::base::TimeTicks p_timestamp{};
      P2PSocketClient_DataReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSocketAddress(&p_socket_address))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            P2PSocketClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DataReceived(
std::move(p_socket_address), 
std::move(p_data), 
std::move(p_timestamp));
      return true;
    }
  }
  return false;
}

// static
bool P2PSocketClientStubDispatch::AcceptWithResponder(
    P2PSocketClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kP2PSocketClient_SocketCreated_Name: {
      break;
    }
    case internal::kP2PSocketClient_SendComplete_Name: {
      break;
    }
    case internal::kP2PSocketClient_IncomingTcpConnection_Name: {
      break;
    }
    case internal::kP2PSocketClient_DataReceived_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kP2PSocketClientValidationInfo[] = {
    {internal::kP2PSocketClient_SocketCreated_Name,
     {&internal::P2PSocketClient_SocketCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kP2PSocketClient_SendComplete_Name,
     {&internal::P2PSocketClient_SendComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kP2PSocketClient_IncomingTcpConnection_Name,
     {&internal::P2PSocketClient_IncomingTcpConnection_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kP2PSocketClient_DataReceived_Name,
     {&internal::P2PSocketClient_DataReceived_Params_Data::Validate,
      nullptr /* no response */}},
};

bool P2PSocketClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::P2PSocketClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kP2PSocketClientValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif